/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.media.MediaPlayer;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.player.Player;
import xyz.luan.audioplayers.player.WrappedPlayer;
import xyz.luan.audioplayers.source.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\r\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lxyz/luan/audioplayers/player/MediaPlayerPlayer;", "Lxyz/luan/audioplayers/player/Player;", "wrappedPlayer", "Lxyz/luan/audioplayers/player/WrappedPlayer;", "(Lxyz/luan/audioplayers/player/WrappedPlayer;)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "createMediaPlayer", "getCurrentPosition", "", "()Ljava/lang/Integer;", "getDuration", "isActuallyPlaying", "", "isLiveStream", "pause", "", "prepare", "release", "reset", "seekTo", "position", "setLooping", "looping", "setRate", "rate", "", "setSource", "source", "Lxyz/luan/audioplayers/source/Source;", "setVolume", "leftVolume", "rightVolume", "start", "stop", "updateContext", "context", "Lxyz/luan/audioplayers/AudioContextAndroid;", "audioplayers_android_debug"})
@SourceDebugExtension(value={"SMAP\nMediaPlayerPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPlayerPlayer.kt\nxyz/luan/audioplayers/player/MediaPlayerPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class MediaPlayerPlayer
implements Player {
    @NotNull
    private final WrappedPlayer wrappedPlayer;
    @NotNull
    private final MediaPlayer mediaPlayer;

    public MediaPlayerPlayer(@NotNull WrappedPlayer wrappedPlayer) {
        Intrinsics.checkNotNullParameter((Object)wrappedPlayer, (String)"wrappedPlayer");
        this.wrappedPlayer = wrappedPlayer;
        this.mediaPlayer = this.createMediaPlayer(this.wrappedPlayer);
    }

    private final MediaPlayer createMediaPlayer(WrappedPlayer wrappedPlayer) {
        MediaPlayer mediaPlayer;
        MediaPlayer $this$createMediaPlayer_u24lambda_u245 = mediaPlayer = new MediaPlayer();
        boolean bl = false;
        $this$createMediaPlayer_u24lambda_u245.setOnPreparedListener(arg_0 -> MediaPlayerPlayer.createMediaPlayer$lambda$5$lambda$0(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u245.setOnCompletionListener(arg_0 -> MediaPlayerPlayer.createMediaPlayer$lambda$5$lambda$1(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u245.setOnSeekCompleteListener(arg_0 -> MediaPlayerPlayer.createMediaPlayer$lambda$5$lambda$2(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u245.setOnErrorListener((arg_0, arg_1, arg_2) -> MediaPlayerPlayer.createMediaPlayer$lambda$5$lambda$3(wrappedPlayer, arg_0, arg_1, arg_2));
        $this$createMediaPlayer_u24lambda_u245.setOnBufferingUpdateListener((arg_0, arg_1) -> MediaPlayerPlayer.createMediaPlayer$lambda$5$lambda$4(wrappedPlayer, arg_0, arg_1));
        MediaPlayer mediaPlayer2 = mediaPlayer;
        wrappedPlayer.getContext().setAttributesOnPlayer(mediaPlayer2);
        return mediaPlayer2;
    }

    @Override
    @Nullable
    public Integer getDuration() {
        Integer n = this.mediaPlayer.getDuration();
        int it = ((Number)n).intValue();
        boolean bl = false;
        return !(it == -1) ? n : null;
    }

    @Override
    @NotNull
    public Integer getCurrentPosition() {
        return this.mediaPlayer.getCurrentPosition();
    }

    @Override
    public boolean isActuallyPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this.mediaPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    public void setRate(float rate) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mediaPlayer.setPlaybackParams(this.mediaPlayer.getPlaybackParams().setSpeed(rate));
        } else if (rate == 1.0f) {
            this.mediaPlayer.start();
        } else {
            throw new IllegalStateException("Changing the playback rate is only available for Android M/23+ or using LOW_LATENCY mode.".toString());
        }
    }

    @Override
    public void setSource(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.reset();
        source.setForMediaPlayer(this.mediaPlayer);
    }

    @Override
    public void setLooping(boolean looping) {
        this.mediaPlayer.setLooping(looping);
    }

    @Override
    public void start() {
        this.setRate(this.wrappedPlayer.getRate());
    }

    @Override
    public void pause() {
        this.mediaPlayer.pause();
    }

    @Override
    public void stop() {
        this.mediaPlayer.stop();
    }

    @Override
    public void release() {
        this.mediaPlayer.reset();
        this.mediaPlayer.release();
    }

    @Override
    public void seekTo(int position) {
        this.mediaPlayer.seekTo(position);
    }

    @Override
    public void updateContext(@NotNull AudioContextAndroid context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setAttributesOnPlayer(this.mediaPlayer);
        if (context.getStayAwake()) {
            this.mediaPlayer.setWakeMode(this.wrappedPlayer.getApplicationContext(), 1);
        }
    }

    @Override
    public void prepare() {
        this.mediaPlayer.prepareAsync();
    }

    @Override
    public void reset() {
        this.mediaPlayer.reset();
    }

    @Override
    public boolean isLiveStream() {
        Integer duration = this.getDuration();
        return duration == null || duration == 0;
    }

    private static final void createMediaPlayer$lambda$5$lambda$0(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$wrappedPlayer, (String)"$wrappedPlayer");
        $wrappedPlayer.onPrepared();
    }

    private static final void createMediaPlayer$lambda$5$lambda$1(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$wrappedPlayer, (String)"$wrappedPlayer");
        $wrappedPlayer.onCompletion();
    }

    private static final void createMediaPlayer$lambda$5$lambda$2(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$wrappedPlayer, (String)"$wrappedPlayer");
        $wrappedPlayer.onSeekComplete();
    }

    private static final boolean createMediaPlayer$lambda$5$lambda$3(WrappedPlayer $wrappedPlayer, MediaPlayer mediaPlayer, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)$wrappedPlayer, (String)"$wrappedPlayer");
        return $wrappedPlayer.onError(what, extra);
    }

    private static final void createMediaPlayer$lambda$5$lambda$4(WrappedPlayer $wrappedPlayer, MediaPlayer mediaPlayer, int percent) {
        Intrinsics.checkNotNullParameter((Object)$wrappedPlayer, (String)"$wrappedPlayer");
        $wrappedPlayer.onBuffering(percent);
    }
}

