/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.connectivity;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;

public class Connectivity {
    static final String CONNECTIVITY_NONE = "none";
    static final String CONNECTIVITY_WIFI = "wifi";
    static final String CONNECTIVITY_MOBILE = "mobile";
    static final String CONNECTIVITY_ETHERNET = "ethernet";
    static final String CONNECTIVITY_BLUETOOTH = "bluetooth";
    static final String CONNECTIVITY_VPN = "vpn";
    static final String CONNECTIVITY_OTHER = "other";
    private final ConnectivityManager connectivityManager;

    public Connectivity(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    List<String> getNetworkTypes() {
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = this.connectivityManager.getActiveNetwork();
            return this.getCapabilitiesFromNetwork(network);
        }
        return this.getNetworkTypesLegacy();
    }

    @RequiresApi(api=21)
    List<String> getCapabilitiesFromNetwork(Network network) {
        NetworkCapabilities capabilities = this.connectivityManager.getNetworkCapabilities(network);
        return this.getCapabilitiesList(capabilities);
    }

    @NonNull
    @RequiresApi(api=21)
    List<String> getCapabilitiesList(NetworkCapabilities capabilities) {
        ArrayList<String> types = new ArrayList<String>();
        if (capabilities == null || !capabilities.hasCapability(12)) {
            types.add(CONNECTIVITY_NONE);
            return types;
        }
        if (capabilities.hasTransport(1) || capabilities.hasTransport(5)) {
            types.add(CONNECTIVITY_WIFI);
        }
        if (capabilities.hasTransport(3)) {
            types.add(CONNECTIVITY_ETHERNET);
        }
        if (capabilities.hasTransport(4)) {
            types.add(CONNECTIVITY_VPN);
        }
        if (capabilities.hasTransport(0)) {
            types.add(CONNECTIVITY_MOBILE);
        }
        if (capabilities.hasTransport(2)) {
            types.add(CONNECTIVITY_BLUETOOTH);
        }
        if (types.isEmpty() && capabilities.hasCapability(12)) {
            types.add(CONNECTIVITY_OTHER);
        }
        if (types.isEmpty()) {
            types.add(CONNECTIVITY_NONE);
        }
        return types;
    }

    private List<String> getNetworkTypesLegacy() {
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        ArrayList<String> types = new ArrayList<String>();
        if (info == null || !info.isConnected()) {
            types.add(CONNECTIVITY_NONE);
            return types;
        }
        int type = info.getType();
        switch (type) {
            case 7: {
                types.add(CONNECTIVITY_BLUETOOTH);
                break;
            }
            case 9: {
                types.add(CONNECTIVITY_ETHERNET);
                break;
            }
            case 1: 
            case 6: {
                types.add(CONNECTIVITY_WIFI);
                break;
            }
            case 17: {
                types.add(CONNECTIVITY_VPN);
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                types.add(CONNECTIVITY_MOBILE);
                break;
            }
            default: {
                types.add(CONNECTIVITY_OTHER);
            }
        }
        return types;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }
}

