/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import dev.fluttercommunity.plus.connectivity.Connectivity;
import io.flutter.plugin.common.EventChannel;
import java.util.List;

public class ConnectivityBroadcastReceiver
extends BroadcastReceiver
implements EventChannel.StreamHandler {
    private final Context context;
    private final Connectivity connectivity;
    private EventChannel.EventSink events;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private ConnectivityManager.NetworkCallback networkCallback;
    public static final String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";

    public ConnectivityBroadcastReceiver(Context context, Connectivity connectivity) {
        this.context = context;
        this.connectivity = connectivity;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        this.events = events;
        if (Build.VERSION.SDK_INT >= 24) {
            this.networkCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    ConnectivityBroadcastReceiver.this.sendEvent(ConnectivityBroadcastReceiver.this.connectivity.getCapabilitiesFromNetwork(network));
                }

                public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                    ConnectivityBroadcastReceiver.this.sendEvent(ConnectivityBroadcastReceiver.this.connectivity.getCapabilitiesList(networkCapabilities));
                }

                public void onLost(Network network) {
                    ConnectivityBroadcastReceiver.this.sendCurrentStatusWithDelay();
                }
            };
            this.connectivity.getConnectivityManager().registerDefaultNetworkCallback(this.networkCallback);
        } else {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter(CONNECTIVITY_ACTION));
        }
        this.sendEvent(this.connectivity.getNetworkTypes());
    }

    public void onCancel(Object arguments) {
        if (Build.VERSION.SDK_INT >= 24) {
            if (this.networkCallback != null) {
                this.connectivity.getConnectivityManager().unregisterNetworkCallback(this.networkCallback);
                this.networkCallback = null;
            }
        } else {
            try {
                this.context.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (this.events != null) {
            this.events.success(this.connectivity.getNetworkTypes());
        }
    }

    private void sendEvent(List<String> networkTypes) {
        Runnable runnable = () -> this.events.success((Object)networkTypes);
        this.mainHandler.post(runnable);
    }

    private void sendCurrentStatusWithDelay() {
        Runnable runnable = () -> this.events.success(this.connectivity.getNetworkTypes());
        this.mainHandler.postDelayed(runnable, 500L);
    }
}

