/*
 * Decompiled with CFR 0.152.
 */
package io.github.ponnamkarthik.toast.fluttertoast;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import io.flutter.FlutterInjector;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.github.ponnamkarthik.toast.fluttertoast.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/ponnamkarthik/toast/fluttertoast/MethodCallHandlerImpl;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mToast", "Landroid/widget/Toast;", "onMethodCall", "", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "Lio/flutter/plugin/common/MethodChannel$Result;", "fluttertoast_debug"})
public final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    @NotNull
    private Context context;
    @Nullable
    private Toast mToast;

    public MethodCallHandlerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = call.method;
        if (Intrinsics.areEqual((Object)string, (Object)"showToast")) {
            int mDuration;
            String mMessage = String.valueOf(call.argument("msg"));
            String length = String.valueOf(call.argument("length"));
            String gravity = String.valueOf(call.argument("gravity"));
            Number bgcolor = (Number)call.argument("bgcolor");
            Number textcolor = (Number)call.argument("textcolor");
            Number fontSize = (Number)call.argument("fontSize");
            String fontAsset = (String)call.argument("fontAsset");
            String string2 = gravity;
            int mGravity = Intrinsics.areEqual((Object)string2, (Object)"top") ? 48 : (Intrinsics.areEqual((Object)string2, (Object)"center") ? 17 : 80);
            int n = mDuration = Intrinsics.areEqual((Object)length, (Object)"long") ? 1 : 0;
            if (bgcolor != null) {
                Drawable gradientDrawable;
                Drawable drawable2;
                Object object = this.context.getSystemService("layout_inflater");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
                View layout2 = ((LayoutInflater)object).inflate(R.layout.toast_custom, null);
                TextView text = (TextView)layout2.findViewById(R.id.text);
                text.setText((CharSequence)mMessage);
                if (Build.VERSION.SDK_INT >= 21) {
                    Drawable drawable3 = this.context.getDrawable(R.drawable.corner);
                    drawable2 = drawable3;
                    Intrinsics.checkNotNull((Object)drawable3);
                } else {
                    drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.corner);
                }
                Drawable drawable4 = gradientDrawable = drawable2;
                Intrinsics.checkNotNull((Object)drawable4);
                drawable4.setColorFilter(bgcolor.intValue(), PorterDuff.Mode.SRC_IN);
                text.setBackground(gradientDrawable);
                if (fontSize != null) {
                    text.setTextSize(fontSize.floatValue());
                }
                if (textcolor != null) {
                    text.setTextColor(textcolor.intValue());
                }
                Toast toast = this.mToast = new Toast(this.context);
                if (toast != null) {
                    toast.setDuration(mDuration);
                }
                if (fontAsset != null) {
                    AssetManager assetManager = this.context.getAssets();
                    Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"context.assets");
                    AssetManager assetManager2 = assetManager;
                    String string3 = FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(fontAsset);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"instance().flutterLoader\u2026kupKeyForAsset(fontAsset)");
                    String key = string3;
                    text.setTypeface(Typeface.createFromAsset((AssetManager)assetManager2, (String)key));
                }
                Toast toast2 = this.mToast;
                if (toast2 != null) {
                    toast2.setView(layout2);
                }
            } else {
                Log.d((String)"KARTHIK", (String)("showToast: " + bgcolor + " " + textcolor + " " + fontSize + " " + fontAsset));
                this.mToast = Toast.makeText((Context)this.context, (CharSequence)mMessage, (int)mDuration);
                if (Build.VERSION.SDK_INT < 30) {
                    Toast toast = this.mToast;
                    Object object = toast != null ? toast.getView() : null;
                    Intrinsics.checkNotNull((Object)object);
                    View view = object.findViewById(16908299);
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mToast?.view!!.findViewById(android.R.id.message)");
                    TextView textView = (TextView)view;
                    if (fontSize != null) {
                        textView.setTextSize(fontSize.floatValue());
                    }
                    if (textcolor != null) {
                        textView.setTextColor(textcolor.intValue());
                    }
                    if (fontAsset != null) {
                        AssetManager assetManager = this.context.getAssets();
                        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"context.assets");
                        AssetManager assetManager3 = assetManager;
                        String string4 = FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(fontAsset);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"instance().flutterLoader\u2026kupKeyForAsset(fontAsset)");
                        String key = string4;
                        textView.setTypeface(Typeface.createFromAsset((AssetManager)assetManager3, (String)key));
                    }
                }
            }
            try {
                int n2 = mGravity;
                switch (n2) {
                    case 17: {
                        Toast toast = this.mToast;
                        if (toast != null) {
                            toast.setGravity(mGravity, 0, 0);
                        }
                        break;
                    }
                    case 48: {
                        Toast toast = this.mToast;
                        if (toast != null) {
                            toast.setGravity(mGravity, 0, 100);
                        }
                        break;
                    }
                    default: {
                        Toast toast = this.mToast;
                        if (toast != null) {
                            toast.setGravity(mGravity, 0, 100);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.context instanceof Activity) {
                Context context = this.context;
                Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
                ((Activity)context).runOnUiThread(() -> MethodCallHandlerImpl.onMethodCall$lambda$0(this));
            } else {
                Toast toast = this.mToast;
                if (toast != null) {
                    toast.show();
                }
            }
            if (Build.VERSION.SDK_INT >= 30) {
                Toast toast = this.mToast;
                if (toast != null) {
                    toast.addCallback(new Toast.Callback(this){
                        final /* synthetic */ MethodCallHandlerImpl this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onToastHidden() {
                            super.onToastHidden();
                            MethodCallHandlerImpl.access$setMToast$p(this.this$0, null);
                        }
                    });
                }
            }
            result.success((Object)true);
        } else if (Intrinsics.areEqual((Object)string, (Object)"cancel")) {
            if (this.mToast != null) {
                Toast toast = this.mToast;
                if (toast != null) {
                    toast.cancel();
                }
                this.mToast = null;
            }
            result.success((Object)true);
        } else {
            result.notImplemented();
        }
    }

    private static final void onMethodCall$lambda$0(MethodCallHandlerImpl this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Toast toast = this$0.mToast;
            if (toast == null) break block0;
            toast.show();
        }
    }

    public static final /* synthetic */ void access$setMToast$p(MethodCallHandlerImpl $this, Toast toast) {
        $this.mToast = toast;
    }
}

