/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapsSdkInitializedCallback;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;

final class GoogleMapInitializer
implements OnMapsSdkInitializedCallback,
Messages.MapsInitializerApi {
    private final Context context;
    private static Messages.Result<Messages.PlatformRendererType> initializationResult;
    private boolean rendererInitialized = false;

    GoogleMapInitializer(Context context, BinaryMessenger binaryMessenger) {
        this.context = context;
        Messages.MapsInitializerApi.setUp(binaryMessenger, this);
    }

    @Override
    public void initializeWithPreferredRenderer(@Nullable Messages.PlatformRendererType type, @NonNull Messages.Result<Messages.PlatformRendererType> result) {
        if (this.rendererInitialized || initializationResult != null) {
            result.error(new Messages.FlutterError("Renderer already initialized", "Renderer initialization called multiple times", null));
        } else {
            initializationResult = result;
            this.initializeWithRendererRequest(Convert.toMapRendererType(type));
        }
    }

    @VisibleForTesting
    public void initializeWithRendererRequest(@Nullable MapsInitializer.Renderer renderer) {
        MapsInitializer.initialize((Context)this.context, (MapsInitializer.Renderer)renderer, (OnMapsSdkInitializedCallback)this);
    }

    public void onMapsSdkInitialized(@NonNull MapsInitializer.Renderer renderer) {
        this.rendererInitialized = true;
        if (initializationResult != null) {
            switch (renderer) {
                case LATEST: {
                    initializationResult.success(Messages.PlatformRendererType.LATEST);
                    break;
                }
                case LEGACY: {
                    initializationResult.success(Messages.PlatformRendererType.LEGACY);
                    break;
                }
                default: {
                    initializationResult.error(new Messages.FlutterError("Unknown renderer type", "Initialized with unknown renderer type", renderer.name()));
                }
            }
            initializationResult = null;
        }
    }
}

