/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import io.flutter.plugins.googlemaps.CircleBuilder;
import io.flutter.plugins.googlemaps.CircleController;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CirclesController {
    @VisibleForTesting
    final Map<String, CircleController> circleIdToController = new HashMap<String, CircleController>();
    private final Map<String, String> googleMapsCircleIdToDartCircleId = new HashMap<String, String>();
    @NonNull
    private final Messages.MapsCallbackApi flutterApi;
    private final float density;
    private GoogleMap googleMap;

    CirclesController(@NonNull Messages.MapsCallbackApi flutterApi, float density) {
        this.flutterApi = flutterApi;
        this.density = density;
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addCircles(@NonNull List<Messages.PlatformCircle> circlesToAdd) {
        for (Messages.PlatformCircle circleToAdd : circlesToAdd) {
            this.addCircle(circleToAdd);
        }
    }

    void changeCircles(@NonNull List<Messages.PlatformCircle> circlesToChange) {
        for (Messages.PlatformCircle circleToChange : circlesToChange) {
            this.changeCircle(circleToChange);
        }
    }

    void removeCircles(@NonNull List<String> circleIdsToRemove) {
        for (String circleId : circleIdsToRemove) {
            CircleController circleController = this.circleIdToController.remove(circleId);
            if (circleController == null) continue;
            circleController.remove();
            this.googleMapsCircleIdToDartCircleId.remove(circleController.getGoogleMapsCircleId());
        }
    }

    boolean onCircleTap(String googleCircleId) {
        String circleId = this.googleMapsCircleIdToDartCircleId.get(googleCircleId);
        if (circleId == null) {
            return false;
        }
        this.flutterApi.onCircleTap(circleId, new NoOpVoidResult());
        CircleController circleController = this.circleIdToController.get(circleId);
        if (circleController != null) {
            return circleController.consumeTapEvents();
        }
        return false;
    }

    void addCircle(@NonNull Messages.PlatformCircle circle) {
        CircleBuilder circleBuilder = new CircleBuilder(this.density);
        String circleId = Convert.interpretCircleOptions(circle, circleBuilder);
        CircleOptions options = circleBuilder.build();
        this.addCircle(circleId, options, circleBuilder.consumeTapEvents());
    }

    private void addCircle(String circleId, CircleOptions circleOptions, boolean consumeTapEvents) {
        Circle circle = this.googleMap.addCircle(circleOptions);
        CircleController controller = new CircleController(circle, consumeTapEvents, this.density);
        this.circleIdToController.put(circleId, controller);
        this.googleMapsCircleIdToDartCircleId.put(circle.getId(), circleId);
    }

    private void changeCircle(@NonNull Messages.PlatformCircle circle) {
        String circleId = circle.getCircleId();
        CircleController circleController = this.circleIdToController.get(circleId);
        if (circleController != null) {
            Convert.interpretCircleOptions(circle, circleController);
        }
    }
}

