/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.maps.android.heatmaps.Gradient;
import com.google.maps.android.heatmaps.HeatmapTileProvider;
import com.google.maps.android.heatmaps.WeightedLatLng;
import io.flutter.plugins.googlemaps.HeatmapOptionsSink;
import java.util.List;

public class HeatmapController
implements HeatmapOptionsSink {
    @NonNull
    private final HeatmapTileProvider heatmap;
    @NonNull
    private final TileOverlay heatmapTileOverlay;

    HeatmapController(@NonNull HeatmapTileProvider heatmap, @NonNull TileOverlay heatmapTileOverlay) {
        this.heatmap = heatmap;
        this.heatmapTileOverlay = heatmapTileOverlay;
    }

    void remove() {
        this.heatmapTileOverlay.remove();
    }

    void clearTileCache() {
        this.heatmapTileOverlay.clearTileCache();
    }

    @Override
    public void setWeightedData(@NonNull List<WeightedLatLng> weightedData) {
        this.heatmap.setWeightedData(weightedData);
    }

    @Override
    public void setGradient(@NonNull Gradient gradient) {
        this.heatmap.setGradient(gradient);
    }

    @Override
    public void setMaxIntensity(double maxIntensity) {
        this.heatmap.setMaxIntensity(maxIntensity);
    }

    @Override
    public void setOpacity(double opacity) {
        this.heatmap.setOpacity(opacity);
    }

    @Override
    public void setRadius(int radius) {
        this.heatmap.setRadius(radius);
    }
}

