/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.Tile;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.heatmaps.Gradient;
import com.google.maps.android.heatmaps.WeightedLatLng;
import io.flutter.FlutterInjector;
import io.flutter.plugins.googlemaps.CircleOptionsSink;
import io.flutter.plugins.googlemaps.GoogleMapOptionsSink;
import io.flutter.plugins.googlemaps.GroundOverlaySink;
import io.flutter.plugins.googlemaps.HeatmapOptionsSink;
import io.flutter.plugins.googlemaps.MarkerBuilder;
import io.flutter.plugins.googlemaps.MarkerOptionsSink;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.PolygonOptionsSink;
import io.flutter.plugins.googlemaps.PolylineOptionsSink;
import io.flutter.plugins.googlemaps.TileOverlaySink;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class Convert {
    public static final String HEATMAP_ID_KEY = "heatmapId";
    public static final String HEATMAP_DATA_KEY = "data";
    public static final String HEATMAP_GRADIENT_KEY = "gradient";
    public static final String HEATMAP_MAX_INTENSITY_KEY = "maxIntensity";
    public static final String HEATMAP_OPACITY_KEY = "opacity";
    public static final String HEATMAP_RADIUS_KEY = "radius";
    public static final String HEATMAP_GRADIENT_COLORS_KEY = "colors";
    public static final String HEATMAP_GRADIENT_START_POINTS_KEY = "startPoints";
    public static final String HEATMAP_GRADIENT_COLOR_MAP_SIZE_KEY = "colorMapSize";

    Convert() {
    }

    private static BitmapDescriptor toBitmapDescriptor(Messages.PlatformBitmap platformBitmap, AssetManager assetManager, float density) {
        return Convert.toBitmapDescriptor(platformBitmap, assetManager, density, new BitmapDescriptorFactoryWrapper());
    }

    private static BitmapDescriptor toBitmapDescriptor(Messages.PlatformBitmap platformBitmap, AssetManager assetManager, float density, BitmapDescriptorFactoryWrapper wrapper) {
        Object bitmap = platformBitmap.getBitmap();
        if (bitmap instanceof Messages.PlatformBitmapDefaultMarker) {
            Messages.PlatformBitmapDefaultMarker typedBitmap = (Messages.PlatformBitmapDefaultMarker)bitmap;
            if (typedBitmap.getHue() == null) {
                return BitmapDescriptorFactory.defaultMarker();
            }
            float hue = typedBitmap.getHue().floatValue();
            return BitmapDescriptorFactory.defaultMarker((float)hue);
        }
        if (bitmap instanceof Messages.PlatformBitmapAsset) {
            Messages.PlatformBitmapAsset typedBitmap = (Messages.PlatformBitmapAsset)bitmap;
            String assetPath = typedBitmap.getName();
            String assetPackage = typedBitmap.getPkg();
            if (assetPackage == null) {
                return BitmapDescriptorFactory.fromAsset((String)FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(assetPath));
            }
            return BitmapDescriptorFactory.fromAsset((String)FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(assetPath, assetPackage));
        }
        if (bitmap instanceof Messages.PlatformBitmapAssetImage) {
            Messages.PlatformBitmapAssetImage typedBitmap = (Messages.PlatformBitmapAssetImage)bitmap;
            String assetImagePath = typedBitmap.getName();
            return BitmapDescriptorFactory.fromAsset((String)FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(assetImagePath));
        }
        if (bitmap instanceof Messages.PlatformBitmapBytes) {
            Messages.PlatformBitmapBytes typedBitmap = (Messages.PlatformBitmapBytes)bitmap;
            return Convert.getBitmapFromBytesLegacy(typedBitmap);
        }
        if (bitmap instanceof Messages.PlatformBitmapAssetMap) {
            Messages.PlatformBitmapAssetMap typedBitmap = (Messages.PlatformBitmapAssetMap)bitmap;
            return Convert.getBitmapFromAsset(typedBitmap, assetManager, density, wrapper, new FlutterInjectorWrapper());
        }
        if (bitmap instanceof Messages.PlatformBitmapBytesMap) {
            Messages.PlatformBitmapBytesMap typedBitmap = (Messages.PlatformBitmapBytesMap)bitmap;
            return Convert.getBitmapFromBytes(typedBitmap, density, wrapper);
        }
        throw new IllegalArgumentException("PlatformBitmap did not contain a supported subtype.");
    }

    private static BitmapDescriptor getBitmapFromBytesLegacy(Messages.PlatformBitmapBytes bitmapBytes) {
        try {
            Bitmap bitmap = Convert.toBitmap(bitmapBytes.getByteData());
            return BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to interpret bytes as a valid image.", e);
        }
    }

    @VisibleForTesting
    public static BitmapDescriptor getBitmapFromBytes(Messages.PlatformBitmapBytesMap bytesMap, float density, BitmapDescriptorFactoryWrapper bitmapDescriptorFactory) {
        try {
            Bitmap bitmap = Convert.toBitmap(bytesMap.getByteData());
            Messages.PlatformMapBitmapScaling scalingMode = bytesMap.getBitmapScaling();
            switch (scalingMode) {
                case AUTO: {
                    Double width = bytesMap.getWidth();
                    Double height = bytesMap.getHeight();
                    if (width != null || height != null) {
                        int targetHeight;
                        int targetWidth = width != null ? Convert.toInt(width * (double)density) : bitmap.getWidth();
                        int n = targetHeight = height != null ? Convert.toInt(height * (double)density) : bitmap.getHeight();
                        if (width != null && height == null) {
                            double aspectRatio = (double)bitmap.getHeight() / (double)bitmap.getWidth();
                            targetHeight = (int)((double)targetWidth * aspectRatio);
                        } else if (height != null && width == null) {
                            double aspectRatio = (double)bitmap.getWidth() / (double)bitmap.getHeight();
                            targetWidth = (int)((double)targetHeight * aspectRatio);
                        }
                        return bitmapDescriptorFactory.fromBitmap(Convert.toScaledBitmap(bitmap, targetWidth, targetHeight));
                    }
                    float scale = density / bytesMap.getImagePixelRatio().floatValue();
                    return bitmapDescriptorFactory.fromBitmap(Convert.toScaledBitmap(bitmap, scale));
                }
            }
            return bitmapDescriptorFactory.fromBitmap(bitmap);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to interpret bytes as a valid image.", e);
        }
    }

    @VisibleForTesting
    public static BitmapDescriptor getBitmapFromAsset(Messages.PlatformBitmapAssetMap assetMap, AssetManager assetManager, float density, BitmapDescriptorFactoryWrapper bitmapDescriptorFactory, FlutterInjectorWrapper flutterInjector) {
        String assetName = assetMap.getAssetName();
        String assetKey = flutterInjector.getLookupKeyForAsset(assetName);
        Messages.PlatformMapBitmapScaling scalingMode = assetMap.getBitmapScaling();
        switch (scalingMode) {
            case AUTO: {
                Double width = assetMap.getWidth();
                Double height = assetMap.getHeight();
                InputStream inputStream = null;
                try {
                    inputStream = assetManager.open(assetKey);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                    if (width != null || height != null) {
                        double aspectRatio;
                        int targetHeight;
                        int targetWidth = width != null ? Convert.toInt(width * (double)density) : bitmap.getWidth();
                        int n = targetHeight = height != null ? Convert.toInt(height * (double)density) : bitmap.getHeight();
                        if (width != null && height == null) {
                            aspectRatio = (double)bitmap.getHeight() / (double)bitmap.getWidth();
                            targetHeight = (int)((double)targetWidth * aspectRatio);
                        } else if (height != null && width == null) {
                            aspectRatio = (double)bitmap.getWidth() / (double)bitmap.getHeight();
                            targetWidth = (int)((double)targetHeight * aspectRatio);
                        }
                        BitmapDescriptor aspectRatio2 = bitmapDescriptorFactory.fromBitmap(Convert.toScaledBitmap(bitmap, targetWidth, targetHeight));
                        return aspectRatio2;
                    }
                    float scale = density / assetMap.getImagePixelRatio().floatValue();
                    BitmapDescriptor bitmapDescriptor = bitmapDescriptorFactory.fromBitmap(Convert.toScaledBitmap(bitmap, scale));
                    return bitmapDescriptor;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("'asset' cannot open asset: " + assetName, e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return bitmapDescriptorFactory.fromAsset(assetKey);
    }

    @NonNull
    static CameraPosition cameraPositionFromPigeon(@NonNull Messages.PlatformCameraPosition position) {
        CameraPosition.Builder builder = CameraPosition.builder();
        builder.bearing(position.getBearing().floatValue());
        builder.target(Convert.latLngFromPigeon(position.getTarget()));
        builder.tilt(position.getTilt().floatValue());
        builder.zoom(position.getZoom().floatValue());
        return builder.build();
    }

    static CameraUpdate cameraUpdateFromPigeon(Messages.PlatformCameraUpdate update, float density) {
        Object cameraUpdate = update.getCameraUpdate();
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateNewCameraPosition) {
            Messages.PlatformCameraUpdateNewCameraPosition newCameraPosition = (Messages.PlatformCameraUpdateNewCameraPosition)cameraUpdate;
            return CameraUpdateFactory.newCameraPosition((CameraPosition)Convert.cameraPositionFromPigeon(newCameraPosition.getCameraPosition()));
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateNewLatLng) {
            Messages.PlatformCameraUpdateNewLatLng newLatLng = (Messages.PlatformCameraUpdateNewLatLng)cameraUpdate;
            return CameraUpdateFactory.newLatLng((LatLng)Convert.latLngFromPigeon(newLatLng.getLatLng()));
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateNewLatLngZoom) {
            Messages.PlatformCameraUpdateNewLatLngZoom newLatLngZoom = (Messages.PlatformCameraUpdateNewLatLngZoom)cameraUpdate;
            return CameraUpdateFactory.newLatLngZoom((LatLng)Convert.latLngFromPigeon(newLatLngZoom.getLatLng()), (float)newLatLngZoom.getZoom().floatValue());
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateNewLatLngBounds) {
            Messages.PlatformCameraUpdateNewLatLngBounds newLatLngBounds = (Messages.PlatformCameraUpdateNewLatLngBounds)cameraUpdate;
            return CameraUpdateFactory.newLatLngBounds((LatLngBounds)Convert.latLngBoundsFromPigeon(newLatLngBounds.getBounds()), (int)((int)(newLatLngBounds.getPadding() * (double)density)));
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateScrollBy) {
            Messages.PlatformCameraUpdateScrollBy scrollBy = (Messages.PlatformCameraUpdateScrollBy)cameraUpdate;
            return CameraUpdateFactory.scrollBy((float)(scrollBy.getDx().floatValue() * density), (float)(scrollBy.getDy().floatValue() * density));
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateZoomBy) {
            Messages.PlatformCameraUpdateZoomBy zoomBy = (Messages.PlatformCameraUpdateZoomBy)cameraUpdate;
            Point focus = Convert.pointFromPigeon(zoomBy.getFocus(), density);
            return focus != null ? CameraUpdateFactory.zoomBy((float)zoomBy.getAmount().floatValue(), (Point)focus) : CameraUpdateFactory.zoomBy((float)zoomBy.getAmount().floatValue());
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateZoomTo) {
            Messages.PlatformCameraUpdateZoomTo zoomTo = (Messages.PlatformCameraUpdateZoomTo)cameraUpdate;
            return CameraUpdateFactory.zoomTo((float)zoomTo.getZoom().floatValue());
        }
        if (cameraUpdate instanceof Messages.PlatformCameraUpdateZoom) {
            Messages.PlatformCameraUpdateZoom zoom = (Messages.PlatformCameraUpdateZoom)cameraUpdate;
            return zoom.getOut() != false ? CameraUpdateFactory.zoomOut() : CameraUpdateFactory.zoomIn();
        }
        throw new IllegalArgumentException("PlatformCameraUpdate's cameraUpdate field must be one of the PlatformCameraUpdate... case classes.");
    }

    private static double toDouble(Object o) {
        return ((Number)o).doubleValue();
    }

    private static float toFloat(Object o) {
        return ((Number)o).floatValue();
    }

    @Nullable
    private static Float nullableDoubleToFloat(@Nullable Double d) {
        return d == null ? null : Float.valueOf(d.floatValue());
    }

    private static int toInt(Object o) {
        return ((Number)o).intValue();
    }

    static int toMapType(@NonNull Messages.PlatformMapType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case NORMAL: {
                return 1;
            }
            case SATELLITE: {
                return 2;
            }
            case TERRAIN: {
                return 3;
            }
            case HYBRID: {
                return 4;
            }
        }
        return 1;
    }

    @Nullable
    static MapsInitializer.Renderer toMapRendererType(@Nullable Messages.PlatformRendererType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case LATEST: {
                return MapsInitializer.Renderer.LATEST;
            }
            case LEGACY: {
                return MapsInitializer.Renderer.LEGACY;
            }
        }
        return null;
    }

    @NonNull
    static Messages.PlatformCameraPosition cameraPositionToPigeon(@NonNull CameraPosition position) {
        return new Messages.PlatformCameraPosition.Builder().setBearing(Double.valueOf(position.bearing)).setTarget(Convert.latLngToPigeon(position.target)).setTilt(Double.valueOf(position.tilt)).setZoom(Double.valueOf(position.zoom)).build();
    }

    static Messages.PlatformLatLngBounds latLngBoundsToPigeon(LatLngBounds latLngBounds) {
        return new Messages.PlatformLatLngBounds.Builder().setNortheast(Convert.latLngToPigeon(latLngBounds.northeast)).setSouthwest(Convert.latLngToPigeon(latLngBounds.southwest)).build();
    }

    @NonNull
    static LatLngBounds latLngBoundsFromPigeon(@NonNull Messages.PlatformLatLngBounds bounds) {
        return new LatLngBounds(Convert.latLngFromPigeon(bounds.getSouthwest()), Convert.latLngFromPigeon(bounds.getNortheast()));
    }

    static Messages.PlatformLatLng latLngToPigeon(LatLng latLng) {
        return new Messages.PlatformLatLng.Builder().setLatitude(latLng.latitude).setLongitude(latLng.longitude).build();
    }

    static LatLng latLngFromPigeon(Messages.PlatformLatLng latLng) {
        return new LatLng(latLng.getLatitude().doubleValue(), latLng.getLongitude().doubleValue());
    }

    static Messages.PlatformCluster clusterToPigeon(String clusterManagerId, Cluster<MarkerBuilder> cluster) {
        int clusterSize = cluster.getSize();
        String[] markerIds = new String[clusterSize];
        MarkerBuilder[] markerBuilders = cluster.getItems().toArray(new MarkerBuilder[clusterSize]);
        LatLngBounds.Builder latLngBoundsBuilder = LatLngBounds.builder();
        for (int i = 0; i < clusterSize; ++i) {
            MarkerBuilder markerBuilder = markerBuilders[i];
            latLngBoundsBuilder.include(markerBuilder.getPosition());
            markerIds[i] = markerBuilder.markerId();
        }
        return new Messages.PlatformCluster.Builder().setClusterManagerId(clusterManagerId).setPosition(Convert.latLngToPigeon(cluster.getPosition())).setBounds(Convert.latLngBoundsToPigeon(latLngBoundsBuilder.build())).setMarkerIds(Arrays.asList(markerIds)).build();
    }

    static LatLng toLatLng(Object o) {
        List<?> data = Convert.toList(o);
        return new LatLng(Convert.toDouble(data.get(0)), Convert.toDouble(data.get(1)));
    }

    static WeightedLatLng toWeightedLatLng(Object o) {
        List<?> data = Convert.toList(o);
        return new WeightedLatLng(Convert.toLatLng(data.get(0)), Convert.toDouble(data.get(1)));
    }

    static Point pointFromPigeon(Messages.PlatformPoint point) {
        return new Point(point.getX().intValue(), point.getY().intValue());
    }

    @Nullable
    static Point pointFromPigeon(@Nullable Messages.PlatformDoublePair point, float density) {
        if (point == null) {
            return null;
        }
        return new Point((int)(point.getX() * (double)density), (int)(point.getY() * (double)density));
    }

    static Messages.PlatformPoint pointToPigeon(Point point) {
        return new Messages.PlatformPoint.Builder().setX(Long.valueOf(point.x)).setY(Long.valueOf(point.y)).build();
    }

    private static List<?> toList(Object o) {
        return (List)o;
    }

    private static Map<?, ?> toMap(Object o) {
        return (Map)o;
    }

    private static Bitmap toBitmap(byte[] bmpData) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bmpData, (int)0, (int)bmpData.length);
        if (bitmap == null) {
            throw new IllegalArgumentException("Unable to decode bytes as a valid bitmap.");
        }
        return bitmap;
    }

    private static Bitmap toScaledBitmap(Bitmap bitmap, float scale) {
        float scalingThreshold = 0.001f;
        if (Math.abs(scale - 1.0f) > 0.001f && scale > 0.0f) {
            int newWidth = (int)((float)bitmap.getWidth() * scale);
            int newHeight = (int)((float)bitmap.getHeight() * scale);
            return Convert.toScaledBitmap(bitmap, newWidth, newHeight);
        }
        return bitmap;
    }

    private static Bitmap toScaledBitmap(Bitmap bitmap, int width, int height) {
        if (width > 0 && height > 0 && (bitmap.getWidth() != width || bitmap.getHeight() != height)) {
            return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        return bitmap;
    }

    static void interpretMapConfiguration(@NonNull Messages.PlatformMapConfiguration config, @NonNull GoogleMapOptionsSink sink) {
        String style;
        Boolean buildingsEnabled;
        Boolean trafficEnabled;
        Boolean indoorEnabled;
        Boolean myLocationButtonEnabled;
        Boolean zoomControlsEnabled;
        Boolean myLocationEnabled;
        Boolean liteModeEnabled;
        Boolean zoomGesturesEnabled;
        Boolean trackCameraPosition;
        Boolean tiltGesturesEnabled;
        Boolean scrollGesturesEnabled;
        Boolean rotateGesturesEnabled;
        Messages.PlatformEdgeInsets padding;
        Messages.PlatformZoomRange minMaxZoomPreference;
        Messages.PlatformMapType mapType;
        Boolean mapToolbarEnabled;
        Boolean compassEnabled;
        Messages.PlatformCameraTargetBounds cameraTargetBounds = config.getCameraTargetBounds();
        if (cameraTargetBounds != null) {
            Messages.PlatformLatLngBounds bounds = cameraTargetBounds.getBounds();
            sink.setCameraTargetBounds(bounds == null ? null : Convert.latLngBoundsFromPigeon(bounds));
        }
        if ((compassEnabled = config.getCompassEnabled()) != null) {
            sink.setCompassEnabled(compassEnabled);
        }
        if ((mapToolbarEnabled = config.getMapToolbarEnabled()) != null) {
            sink.setMapToolbarEnabled(mapToolbarEnabled);
        }
        if ((mapType = config.getMapType()) != null) {
            sink.setMapType(Convert.toMapType(mapType));
        }
        if ((minMaxZoomPreference = config.getMinMaxZoomPreference()) != null) {
            sink.setMinMaxZoomPreference(Convert.nullableDoubleToFloat(minMaxZoomPreference.getMin()), Convert.nullableDoubleToFloat(minMaxZoomPreference.getMax()));
        }
        if ((padding = config.getPadding()) != null) {
            sink.setPadding(padding.getTop().floatValue(), padding.getLeft().floatValue(), padding.getBottom().floatValue(), padding.getRight().floatValue());
        }
        if ((rotateGesturesEnabled = config.getRotateGesturesEnabled()) != null) {
            sink.setRotateGesturesEnabled(rotateGesturesEnabled);
        }
        if ((scrollGesturesEnabled = config.getScrollGesturesEnabled()) != null) {
            sink.setScrollGesturesEnabled(scrollGesturesEnabled);
        }
        if ((tiltGesturesEnabled = config.getTiltGesturesEnabled()) != null) {
            sink.setTiltGesturesEnabled(tiltGesturesEnabled);
        }
        if ((trackCameraPosition = config.getTrackCameraPosition()) != null) {
            sink.setTrackCameraPosition(trackCameraPosition);
        }
        if ((zoomGesturesEnabled = config.getZoomGesturesEnabled()) != null) {
            sink.setZoomGesturesEnabled(zoomGesturesEnabled);
        }
        if ((liteModeEnabled = config.getLiteModeEnabled()) != null) {
            sink.setLiteModeEnabled(liteModeEnabled);
        }
        if ((myLocationEnabled = config.getMyLocationEnabled()) != null) {
            sink.setMyLocationEnabled(myLocationEnabled);
        }
        if ((zoomControlsEnabled = config.getZoomControlsEnabled()) != null) {
            sink.setZoomControlsEnabled(zoomControlsEnabled);
        }
        if ((myLocationButtonEnabled = config.getMyLocationButtonEnabled()) != null) {
            sink.setMyLocationButtonEnabled(myLocationButtonEnabled);
        }
        if ((indoorEnabled = config.getIndoorViewEnabled()) != null) {
            sink.setIndoorEnabled(indoorEnabled);
        }
        if ((trafficEnabled = config.getTrafficEnabled()) != null) {
            sink.setTrafficEnabled(trafficEnabled);
        }
        if ((buildingsEnabled = config.getBuildingsEnabled()) != null) {
            sink.setBuildingsEnabled(buildingsEnabled);
        }
        if ((style = config.getStyle()) != null) {
            sink.setMapStyle(style);
        }
    }

    static void interpretMarkerOptions(Messages.PlatformMarker marker, MarkerOptionsSink sink, AssetManager assetManager, float density, BitmapDescriptorFactoryWrapper wrapper) {
        sink.setAlpha(marker.getAlpha().floatValue());
        sink.setAnchor(marker.getAnchor().getX().floatValue(), marker.getAnchor().getY().floatValue());
        sink.setConsumeTapEvents(marker.getConsumeTapEvents());
        sink.setDraggable(marker.getDraggable());
        sink.setFlat(marker.getFlat());
        sink.setIcon(Convert.toBitmapDescriptor(marker.getIcon(), assetManager, density, wrapper));
        Convert.interpretInfoWindowOptions(sink, marker.getInfoWindow());
        sink.setPosition(Convert.toLatLng(marker.getPosition().toList()));
        sink.setRotation(marker.getRotation().floatValue());
        sink.setVisible(marker.getVisible());
        sink.setZIndex(marker.getZIndex().floatValue());
    }

    private static void interpretInfoWindowOptions(MarkerOptionsSink sink, Messages.PlatformInfoWindow infoWindow) {
        String title = infoWindow.getTitle();
        if (title != null) {
            sink.setInfoWindowText(title, infoWindow.getSnippet());
        }
        Messages.PlatformDoublePair infoWindowAnchor = infoWindow.getAnchor();
        sink.setInfoWindowAnchor(infoWindowAnchor.getX().floatValue(), infoWindowAnchor.getY().floatValue());
    }

    static String interpretPolygonOptions(Messages.PlatformPolygon polygon, PolygonOptionsSink sink) {
        sink.setConsumeTapEvents(polygon.getConsumesTapEvents());
        sink.setGeodesic(polygon.getGeodesic());
        sink.setVisible(polygon.getVisible());
        sink.setFillColor(polygon.getFillColor().intValue());
        sink.setStrokeColor(polygon.getStrokeColor().intValue());
        sink.setStrokeWidth(polygon.getStrokeWidth().longValue());
        sink.setZIndex(polygon.getZIndex().longValue());
        sink.setPoints(Convert.pointsFromPigeon(polygon.getPoints()));
        sink.setHoles(Convert.toHoles(polygon.getHoles()));
        return polygon.getPolygonId();
    }

    static int jointTypeFromPigeon(Messages.PlatformJointType jointType) {
        switch (jointType) {
            case MITERED: {
                return 0;
            }
            case BEVEL: {
                return 1;
            }
            case ROUND: {
                return 2;
            }
        }
        return 0;
    }

    static String interpretPolylineOptions(Messages.PlatformPolyline polyline, PolylineOptionsSink sink, AssetManager assetManager, float density) {
        sink.setConsumeTapEvents(polyline.getConsumesTapEvents());
        sink.setColor(polyline.getColor().intValue());
        sink.setEndCap(Convert.capFromPigeon(polyline.getEndCap(), assetManager, density));
        sink.setStartCap(Convert.capFromPigeon(polyline.getStartCap(), assetManager, density));
        sink.setGeodesic(polyline.getGeodesic());
        sink.setJointType(Convert.jointTypeFromPigeon(polyline.getJointType()));
        sink.setVisible(polyline.getVisible());
        sink.setWidth(polyline.getWidth().longValue());
        sink.setZIndex(polyline.getZIndex().longValue());
        sink.setPoints(Convert.pointsFromPigeon(polyline.getPoints()));
        sink.setPattern(Convert.patternFromPigeon(polyline.getPatterns()));
        return polyline.getPolylineId();
    }

    static String interpretCircleOptions(Messages.PlatformCircle circle, CircleOptionsSink sink) {
        sink.setConsumeTapEvents(circle.getConsumeTapEvents());
        sink.setFillColor(circle.getFillColor().intValue());
        sink.setStrokeColor(circle.getStrokeColor().intValue());
        sink.setStrokeWidth(circle.getStrokeWidth().longValue());
        sink.setZIndex(circle.getZIndex().floatValue());
        sink.setCenter(Convert.toLatLng(circle.getCenter().toList()));
        sink.setRadius(circle.getRadius());
        sink.setVisible(circle.getVisible());
        return circle.getCircleId();
    }

    static String interpretHeatmapOptions(Map<String, ?> data, HeatmapOptionsSink sink) {
        String heatmapId;
        Object radius;
        Object opacity;
        Object maxIntensity;
        Object gradient;
        Object rawWeightedData = data.get(HEATMAP_DATA_KEY);
        if (rawWeightedData != null) {
            sink.setWeightedData(Convert.toWeightedData(rawWeightedData));
        }
        if ((gradient = data.get(HEATMAP_GRADIENT_KEY)) != null) {
            sink.setGradient(Convert.toGradient(gradient));
        }
        if ((maxIntensity = data.get(HEATMAP_MAX_INTENSITY_KEY)) != null) {
            sink.setMaxIntensity(Convert.toDouble(maxIntensity));
        }
        if ((opacity = data.get(HEATMAP_OPACITY_KEY)) != null) {
            sink.setOpacity(Convert.toDouble(opacity));
        }
        if ((radius = data.get(HEATMAP_RADIUS_KEY)) != null) {
            sink.setRadius(Convert.toInt(radius));
        }
        if ((heatmapId = (String)data.get(HEATMAP_ID_KEY)) == null) {
            throw new IllegalArgumentException("heatmapId was null");
        }
        return heatmapId;
    }

    static List<LatLng> pointsFromPigeon(List<Messages.PlatformLatLng> data) {
        ArrayList<LatLng> points = new ArrayList<LatLng>(data.size());
        for (Messages.PlatformLatLng rawPoint : data) {
            points.add(new LatLng(rawPoint.getLatitude().doubleValue(), rawPoint.getLongitude().doubleValue()));
        }
        return points;
    }

    @VisibleForTesting
    static List<WeightedLatLng> toWeightedData(Object o) {
        List<?> data = Convert.toList(o);
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>(data.size());
        for (Object rawWeightedPoint : data) {
            weightedData.add(Convert.toWeightedLatLng(rawWeightedPoint));
        }
        return weightedData;
    }

    @VisibleForTesting
    static Gradient toGradient(Object o) {
        Map<?, ?> data = Convert.toMap(o);
        List<?> colorData = Convert.toList(data.get(HEATMAP_GRADIENT_COLORS_KEY));
        assert (colorData != null);
        int[] colors = new int[colorData.size()];
        for (int i = 0; i < colorData.size(); ++i) {
            colors[i] = Convert.toInt(colorData.get(i));
        }
        List<?> startPointData = Convert.toList(data.get(HEATMAP_GRADIENT_START_POINTS_KEY));
        assert (startPointData != null);
        float[] startPoints = new float[startPointData.size()];
        for (int i = 0; i < startPointData.size(); ++i) {
            startPoints[i] = Convert.toFloat(startPointData.get(i));
        }
        int colorMapSize = Convert.toInt(data.get(HEATMAP_GRADIENT_COLOR_MAP_SIZE_KEY));
        return new Gradient(colors, startPoints, colorMapSize);
    }

    private static List<List<LatLng>> toHoles(List<List<Messages.PlatformLatLng>> data) {
        ArrayList<List<LatLng>> holes = new ArrayList<List<LatLng>>(data.size());
        for (List<Messages.PlatformLatLng> hole : data) {
            holes.add(Convert.pointsFromPigeon(hole));
        }
        return holes;
    }

    private static List<PatternItem> patternFromPigeon(List<Messages.PlatformPatternItem> patternItems) {
        if (patternItems.isEmpty()) {
            return null;
        }
        ArrayList<PatternItem> pattern = new ArrayList<PatternItem>();
        for (Messages.PlatformPatternItem patternItem : patternItems) {
            switch (patternItem.getType()) {
                case DOT: {
                    pattern.add((PatternItem)new Dot());
                    break;
                }
                case DASH: {
                    assert (patternItem.getLength() != null);
                    pattern.add((PatternItem)new Dash(patternItem.getLength().floatValue()));
                    break;
                }
                case GAP: {
                    assert (patternItem.getLength() != null);
                    pattern.add((PatternItem)new Gap(patternItem.getLength().floatValue()));
                }
            }
        }
        return pattern;
    }

    private static Cap capFromPigeon(Messages.PlatformCap cap, AssetManager assetManager, float density) {
        switch (cap.getType()) {
            case BUTT_CAP: {
                return new ButtCap();
            }
            case ROUND_CAP: {
                return new RoundCap();
            }
            case SQUARE_CAP: {
                return new SquareCap();
            }
            case CUSTOM_CAP: {
                if (cap.getRefWidth() == null) {
                    throw new IllegalArgumentException("A Custom Cap must specify a refWidth value.");
                }
                return new CustomCap(Convert.toBitmapDescriptor(cap.getBitmapDescriptor(), assetManager, density), cap.getRefWidth().floatValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized PlatformCap type: " + (Object)((Object)cap.getType()));
    }

    static String interpretTileOverlayOptions(Messages.PlatformTileOverlay tileOverlay, TileOverlaySink sink) {
        sink.setFadeIn(tileOverlay.getFadeIn());
        sink.setTransparency(tileOverlay.getTransparency().floatValue());
        sink.setZIndex(tileOverlay.getZIndex().longValue());
        sink.setVisible(tileOverlay.getVisible());
        return tileOverlay.getTileOverlayId();
    }

    static Tile tileFromPigeon(Messages.PlatformTile tile) {
        return new Tile(tile.getWidth().intValue(), tile.getHeight().intValue(), tile.getData());
    }

    @NonNull
    static String interpretGroundOverlayOptions(@NonNull Messages.PlatformGroundOverlay groundOverlay, @NonNull GroundOverlaySink sink, @NonNull AssetManager assetManager, float density, @NonNull BitmapDescriptorFactoryWrapper wrapper) {
        sink.setTransparency(groundOverlay.getTransparency().floatValue());
        sink.setZIndex(groundOverlay.getZIndex().floatValue());
        sink.setVisible(groundOverlay.getVisible());
        if (groundOverlay.getAnchor() != null) {
            sink.setAnchor(groundOverlay.getAnchor().getX().floatValue(), groundOverlay.getAnchor().getY().floatValue());
        }
        sink.setBearing(groundOverlay.getBearing().floatValue());
        sink.setClickable(groundOverlay.getClickable());
        sink.setImage(Convert.toBitmapDescriptor(groundOverlay.getImage(), assetManager, density, wrapper));
        if (groundOverlay.getPosition() != null) {
            if (groundOverlay.getWidth() == null) {
                throw new Messages.FlutterError("Invalid GroundOverlay", "Width is required when using a ground overlay with a position.", null);
            }
            sink.setPosition(Convert.latLngFromPigeon(groundOverlay.getPosition()), Float.valueOf(groundOverlay.getWidth().floatValue()), groundOverlay.getHeight() != null ? Float.valueOf(groundOverlay.getHeight().floatValue()) : null);
        } else if (groundOverlay.getBounds() != null) {
            sink.setPositionFromBounds(Convert.latLngBoundsFromPigeon(groundOverlay.getBounds()));
        }
        return groundOverlay.getGroundOverlayId();
    }

    @NonNull
    static Messages.PlatformGroundOverlay groundOverlayToPigeon(@NonNull GroundOverlay groundOverlay, @NonNull String groundOverlayId, boolean isCreatedWithBounds) {
        Messages.PlatformBitmap dummyImage = new Messages.PlatformBitmap.Builder().setBitmap(new Messages.PlatformBitmapBytesMap.Builder().setByteData(new byte[]{0}).setImagePixelRatio(1.0).setBitmapScaling(Messages.PlatformMapBitmapScaling.NONE).build()).build();
        Messages.PlatformGroundOverlay.Builder builder = new Messages.PlatformGroundOverlay.Builder().setGroundOverlayId(groundOverlayId).setImage(dummyImage).setWidth(Double.valueOf(groundOverlay.getWidth())).setHeight(Double.valueOf(groundOverlay.getHeight())).setBearing(Double.valueOf(groundOverlay.getBearing())).setTransparency(Double.valueOf(groundOverlay.getTransparency())).setZIndex((long)groundOverlay.getZIndex()).setVisible(groundOverlay.isVisible()).setClickable(groundOverlay.isClickable());
        if (isCreatedWithBounds) {
            builder.setBounds(Convert.latLngBoundsToPigeon(groundOverlay.getBounds()));
        } else {
            builder.setPosition(Convert.latLngToPigeon(groundOverlay.getPosition()));
        }
        builder.setAnchor(Convert.buildGroundOverlayAnchorForPigeon(groundOverlay));
        return builder.build();
    }

    @VisibleForTesting
    @NonNull
    public static Messages.PlatformDoublePair buildGroundOverlayAnchorForPigeon(@NonNull GroundOverlay groundOverlay) {
        Messages.PlatformDoublePair.Builder anchorBuilder = new Messages.PlatformDoublePair.Builder();
        LatLng position = groundOverlay.getPosition();
        LatLngBounds bounds = groundOverlay.getBounds();
        double height = bounds.northeast.latitude - bounds.southwest.latitude;
        double normalizedLatitude = 1.0 - (position.latitude - bounds.southwest.latitude) / height;
        double FULL_CIRCLE_DEGREES = 360.0;
        double west = bounds.southwest.longitude;
        double east = bounds.northeast.longitude;
        double width = west <= east ? east - west : 360.0 - (west - east);
        double normalizedLongitude = ((position.longitude < west ? position.longitude + 360.0 : position.longitude) - west) / width;
        anchorBuilder.setX(normalizedLongitude);
        anchorBuilder.setY(normalizedLatitude);
        return anchorBuilder.build();
    }

    static class BitmapDescriptorFactoryWrapper {
        BitmapDescriptorFactoryWrapper() {
        }

        @VisibleForTesting
        public BitmapDescriptor fromAsset(String assetKey) {
            return BitmapDescriptorFactory.fromAsset((String)assetKey);
        }

        @VisibleForTesting
        public BitmapDescriptor fromBitmap(Bitmap bitmap) {
            return BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
        }
    }

    @VisibleForTesting
    static class FlutterInjectorWrapper {
        FlutterInjectorWrapper() {
        }

        @VisibleForTesting
        public String getLookupKeyForAsset(@NonNull String assetName) {
            return FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(assetName);
        }
    }
}

