/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.Context;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.googlemaps.GoogleMapController;
import io.flutter.plugins.googlemaps.GoogleMapOptionsSink;
import io.flutter.plugins.googlemaps.LifecycleProvider;
import io.flutter.plugins.googlemaps.Messages;
import java.util.List;

class GoogleMapBuilder
implements GoogleMapOptionsSink {
    private final GoogleMapOptions options = new GoogleMapOptions();
    private boolean trackCameraPosition = false;
    private boolean myLocationEnabled = false;
    private boolean myLocationButtonEnabled = false;
    private boolean indoorEnabled = true;
    private boolean trafficEnabled = false;
    private boolean buildingsEnabled = true;
    private List<Messages.PlatformMarker> initialMarkers;
    private List<Messages.PlatformClusterManager> initialClusterManagers;
    private List<Messages.PlatformPolygon> initialPolygons;
    private List<Messages.PlatformPolyline> initialPolylines;
    private List<Messages.PlatformCircle> initialCircles;
    private List<Messages.PlatformHeatmap> initialHeatmaps;
    private List<Messages.PlatformTileOverlay> initialTileOverlays;
    private List<Messages.PlatformGroundOverlay> initialGroundOverlays;
    private Rect padding = new Rect(0, 0, 0, 0);
    @Nullable
    private String style;

    GoogleMapBuilder() {
    }

    GoogleMapController build(int id, Context context, BinaryMessenger binaryMessenger, LifecycleProvider lifecycleProvider) {
        GoogleMapController controller = new GoogleMapController(id, context, binaryMessenger, lifecycleProvider, this.options);
        controller.init();
        controller.setMyLocationEnabled(this.myLocationEnabled);
        controller.setMyLocationButtonEnabled(this.myLocationButtonEnabled);
        controller.setIndoorEnabled(this.indoorEnabled);
        controller.setTrafficEnabled(this.trafficEnabled);
        controller.setBuildingsEnabled(this.buildingsEnabled);
        controller.setTrackCameraPosition(this.trackCameraPosition);
        controller.setInitialClusterManagers(this.initialClusterManagers);
        controller.setInitialMarkers(this.initialMarkers);
        controller.setInitialPolygons(this.initialPolygons);
        controller.setInitialPolylines(this.initialPolylines);
        controller.setInitialCircles(this.initialCircles);
        controller.setInitialHeatmaps(this.initialHeatmaps);
        controller.setPadding(this.padding.top, this.padding.left, this.padding.bottom, this.padding.right);
        controller.setInitialTileOverlays(this.initialTileOverlays);
        controller.setInitialGroundOverlays(this.initialGroundOverlays);
        controller.setMapStyle(this.style);
        return controller;
    }

    void setInitialCameraPosition(CameraPosition position) {
        this.options.camera(position);
    }

    public void setMapId(String mapId) {
        this.options.mapId(mapId);
    }

    @Override
    public void setCompassEnabled(boolean compassEnabled) {
        this.options.compassEnabled(compassEnabled);
    }

    @Override
    public void setMapToolbarEnabled(boolean setMapToolbarEnabled) {
        this.options.mapToolbarEnabled(setMapToolbarEnabled);
    }

    @Override
    public void setCameraTargetBounds(LatLngBounds bounds) {
        this.options.latLngBoundsForCameraTarget(bounds);
    }

    @Override
    public void setMapType(int mapType) {
        this.options.mapType(mapType);
    }

    @Override
    public void setMinMaxZoomPreference(Float min, Float max) {
        if (min != null) {
            this.options.minZoomPreference(min.floatValue());
        }
        if (max != null) {
            this.options.maxZoomPreference(max.floatValue());
        }
    }

    @Override
    public void setPadding(float top, float left, float bottom, float right) {
        this.padding = new Rect((int)left, (int)top, (int)right, (int)bottom);
    }

    @Override
    public void setTrackCameraPosition(boolean trackCameraPosition) {
        this.trackCameraPosition = trackCameraPosition;
    }

    @Override
    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.options.rotateGesturesEnabled(rotateGesturesEnabled);
    }

    @Override
    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.options.scrollGesturesEnabled(scrollGesturesEnabled);
    }

    @Override
    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.options.tiltGesturesEnabled(tiltGesturesEnabled);
    }

    @Override
    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.options.zoomGesturesEnabled(zoomGesturesEnabled);
    }

    @Override
    public void setLiteModeEnabled(boolean liteModeEnabled) {
        this.options.liteMode(liteModeEnabled);
    }

    @Override
    public void setIndoorEnabled(boolean indoorEnabled) {
        this.indoorEnabled = indoorEnabled;
    }

    @Override
    public void setTrafficEnabled(boolean trafficEnabled) {
        this.trafficEnabled = trafficEnabled;
    }

    @Override
    public void setBuildingsEnabled(boolean buildingsEnabled) {
        this.buildingsEnabled = buildingsEnabled;
    }

    @Override
    public void setMyLocationEnabled(boolean myLocationEnabled) {
        this.myLocationEnabled = myLocationEnabled;
    }

    @Override
    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        this.options.zoomControlsEnabled(zoomControlsEnabled);
    }

    @Override
    public void setMyLocationButtonEnabled(boolean myLocationButtonEnabled) {
        this.myLocationButtonEnabled = myLocationButtonEnabled;
    }

    @Override
    public void setInitialMarkers(@NonNull List<Messages.PlatformMarker> initialMarkers) {
        this.initialMarkers = initialMarkers;
    }

    @Override
    public void setInitialClusterManagers(@NonNull List<Messages.PlatformClusterManager> initialClusterManagers) {
        this.initialClusterManagers = initialClusterManagers;
    }

    @Override
    public void setInitialPolygons(@NonNull List<Messages.PlatformPolygon> initialPolygons) {
        this.initialPolygons = initialPolygons;
    }

    @Override
    public void setInitialPolylines(@NonNull List<Messages.PlatformPolyline> initialPolylines) {
        this.initialPolylines = initialPolylines;
    }

    @Override
    public void setInitialCircles(@NonNull List<Messages.PlatformCircle> initialCircles) {
        this.initialCircles = initialCircles;
    }

    @Override
    public void setInitialHeatmaps(@NonNull List<Messages.PlatformHeatmap> initialHeatmaps) {
        this.initialHeatmaps = initialHeatmaps;
    }

    @Override
    public void setInitialTileOverlays(@NonNull List<Messages.PlatformTileOverlay> initialTileOverlays) {
        this.initialTileOverlays = initialTileOverlays;
    }

    @Override
    public void setInitialGroundOverlays(@NonNull List<Messages.PlatformGroundOverlay> initialGroundOverlays) {
        this.initialGroundOverlays = initialGroundOverlays;
    }

    @Override
    public void setMapStyle(@Nullable String style) {
        this.style = style;
    }
}

