/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import io.flutter.plugins.googlemaps.GroundOverlaySink;

class GroundOverlayController
implements GroundOverlaySink {
    private final GroundOverlay groundOverlay;
    private final String googleMapsGroundOverlayId;
    private final boolean isCreatedWithBounds;

    GroundOverlayController(@NonNull GroundOverlay groundOverlay, boolean isCreatedWithBounds) {
        this.groundOverlay = groundOverlay;
        this.googleMapsGroundOverlayId = groundOverlay.getId();
        this.isCreatedWithBounds = isCreatedWithBounds;
    }

    void remove() {
        this.groundOverlay.remove();
    }

    GroundOverlay getGroundOverlay() {
        return this.groundOverlay;
    }

    @Override
    public void setTransparency(float transparency) {
        this.groundOverlay.setTransparency(transparency);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.groundOverlay.setZIndex(zIndex);
    }

    @Override
    public void setVisible(boolean visible) {
        this.groundOverlay.setVisible(visible);
    }

    @Override
    public void setAnchor(float u, float v) {
    }

    @Override
    public void setBearing(float bearing) {
        this.groundOverlay.setBearing(bearing);
    }

    @Override
    public void setClickable(boolean clickable) {
        this.groundOverlay.setClickable(clickable);
    }

    @Override
    public void setImage(@NonNull BitmapDescriptor imageDescriptor) {
        this.groundOverlay.setImage(imageDescriptor);
    }

    @Override
    public void setPosition(@NonNull LatLng location, @NonNull Float width, @Nullable Float height) {
        this.groundOverlay.setPosition(location);
        if (height == null) {
            this.groundOverlay.setDimensions(width.floatValue());
        } else {
            this.groundOverlay.setDimensions(width.floatValue(), height.floatValue());
        }
    }

    @Override
    public void setPositionFromBounds(@NonNull LatLngBounds bounds) {
        this.groundOverlay.setPositionFromBounds(bounds);
    }

    String getGoogleMapsGroundOverlayId() {
        return this.googleMapsGroundOverlayId;
    }

    public boolean isCreatedWithBounds() {
        return this.isCreatedWithBounds;
    }
}

