/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.clustering.ClusterItem;
import io.flutter.plugins.googlemaps.MarkerOptionsSink;

class MarkerBuilder
implements MarkerOptionsSink,
ClusterItem {
    private final MarkerOptions markerOptions = new MarkerOptions();
    private String clusterManagerId;
    private String markerId;
    private boolean consumeTapEvents;

    MarkerBuilder(String markerId, String clusterManagerId) {
        this.markerId = markerId;
        this.clusterManagerId = clusterManagerId;
    }

    MarkerOptions build() {
        return this.markerOptions;
    }

    void update(MarkerOptions markerOptionsToUpdate) {
        markerOptionsToUpdate.alpha(this.markerOptions.getAlpha());
        markerOptionsToUpdate.anchor(this.markerOptions.getAnchorU(), this.markerOptions.getAnchorV());
        markerOptionsToUpdate.draggable(this.markerOptions.isDraggable());
        markerOptionsToUpdate.flat(this.markerOptions.isFlat());
        markerOptionsToUpdate.icon(this.markerOptions.getIcon());
        markerOptionsToUpdate.infoWindowAnchor(this.markerOptions.getInfoWindowAnchorU(), this.markerOptions.getInfoWindowAnchorV());
        markerOptionsToUpdate.title(this.markerOptions.getTitle());
        markerOptionsToUpdate.snippet(this.markerOptions.getSnippet());
        markerOptionsToUpdate.position(this.markerOptions.getPosition());
        markerOptionsToUpdate.rotation(this.markerOptions.getRotation());
        markerOptionsToUpdate.visible(this.markerOptions.isVisible());
        markerOptionsToUpdate.zIndex(this.markerOptions.getZIndex());
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }

    String clusterManagerId() {
        return this.clusterManagerId;
    }

    String markerId() {
        return this.markerId;
    }

    @Override
    public void setAlpha(float alpha) {
        this.markerOptions.alpha(alpha);
    }

    @Override
    public void setAnchor(float u, float v) {
        this.markerOptions.anchor(u, v);
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
    }

    @Override
    public void setDraggable(boolean draggable) {
        this.markerOptions.draggable(draggable);
    }

    @Override
    public void setFlat(boolean flat) {
        this.markerOptions.flat(flat);
    }

    @Override
    public void setIcon(BitmapDescriptor bitmapDescriptor) {
        this.markerOptions.icon(bitmapDescriptor);
    }

    @Override
    public void setInfoWindowAnchor(float u, float v) {
        this.markerOptions.infoWindowAnchor(u, v);
    }

    @Override
    public void setInfoWindowText(String title, String snippet) {
        this.markerOptions.title(title);
        this.markerOptions.snippet(snippet);
    }

    @Override
    public void setPosition(LatLng position) {
        this.markerOptions.position(position);
    }

    @Override
    public void setRotation(float rotation) {
        this.markerOptions.rotation(rotation);
    }

    @Override
    public void setVisible(boolean visible) {
        this.markerOptions.visible(visible);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.markerOptions.zIndex(zIndex);
    }

    public LatLng getPosition() {
        return this.markerOptions.getPosition();
    }

    public String getTitle() {
        return this.markerOptions.getTitle();
    }

    public String getSnippet() {
        return this.markerOptions.getSnippet();
    }

    public Float getZIndex() {
        return Float.valueOf(this.markerOptions.getZIndex());
    }
}

