/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.collections.MarkerManager;
import io.flutter.plugins.googlemaps.ClusterManagersController;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.MarkerBuilder;
import io.flutter.plugins.googlemaps.MarkerController;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

class MarkersController {
    private final HashMap<String, MarkerBuilder> markerIdToMarkerBuilder = new HashMap();
    private final HashMap<String, MarkerController> markerIdToController = new HashMap();
    private final HashMap<String, String> googleMapsMarkerIdToDartMarkerId = new HashMap();
    @NonNull
    private final Messages.MapsCallbackApi flutterApi;
    private MarkerManager.Collection markerCollection;
    private final ClusterManagersController clusterManagersController;
    private final AssetManager assetManager;
    private final float density;
    private final Convert.BitmapDescriptorFactoryWrapper bitmapDescriptorFactoryWrapper;

    MarkersController(@NonNull Messages.MapsCallbackApi flutterApi, ClusterManagersController clusterManagersController, AssetManager assetManager, float density, Convert.BitmapDescriptorFactoryWrapper bitmapDescriptorFactoryWrapper) {
        this.flutterApi = flutterApi;
        this.clusterManagersController = clusterManagersController;
        this.assetManager = assetManager;
        this.density = density;
        this.bitmapDescriptorFactoryWrapper = bitmapDescriptorFactoryWrapper;
    }

    void setCollection(MarkerManager.Collection markerCollection) {
        this.markerCollection = markerCollection;
    }

    void addMarkers(@NonNull List<Messages.PlatformMarker> markersToAdd) {
        for (Messages.PlatformMarker markerToAdd : markersToAdd) {
            this.addMarker(markerToAdd);
        }
    }

    void changeMarkers(@NonNull List<Messages.PlatformMarker> markersToChange) {
        for (Messages.PlatformMarker markerToChange : markersToChange) {
            this.changeMarker(markerToChange);
        }
    }

    void removeMarkers(@NonNull List<String> markerIdsToRemove) {
        for (String markerId : markerIdsToRemove) {
            this.removeMarker(markerId);
        }
    }

    private void removeMarker(String markerId) {
        MarkerBuilder markerBuilder = this.markerIdToMarkerBuilder.remove(markerId);
        if (markerBuilder == null) {
            return;
        }
        MarkerController markerController = this.markerIdToController.remove(markerId);
        String clusterManagerId = markerBuilder.clusterManagerId();
        if (clusterManagerId != null) {
            this.clusterManagersController.removeItem(markerBuilder);
        } else if (markerController != null && this.markerCollection != null) {
            markerController.removeFromCollection(this.markerCollection);
        }
        if (markerController != null) {
            this.googleMapsMarkerIdToDartMarkerId.remove(markerController.getGoogleMapsMarkerId());
        }
    }

    void showMarkerInfoWindow(String markerId) {
        MarkerController markerController = this.markerIdToController.get(markerId);
        if (markerController == null) {
            throw new Messages.FlutterError("Invalid markerId", "showInfoWindow called with invalid markerId", null);
        }
        markerController.showInfoWindow();
    }

    void hideMarkerInfoWindow(String markerId) {
        MarkerController markerController = this.markerIdToController.get(markerId);
        if (markerController == null) {
            throw new Messages.FlutterError("Invalid markerId", "hideInfoWindow called with invalid markerId", null);
        }
        markerController.hideInfoWindow();
    }

    boolean isInfoWindowShown(String markerId) {
        MarkerController markerController = this.markerIdToController.get(markerId);
        if (markerController == null) {
            throw new Messages.FlutterError("Invalid markerId", "isInfoWindowShown called with invalid markerId", null);
        }
        return markerController.isInfoWindowShown();
    }

    boolean onMapsMarkerTap(String googleMarkerId) {
        String markerId = this.googleMapsMarkerIdToDartMarkerId.get(googleMarkerId);
        if (markerId == null) {
            return false;
        }
        return this.onMarkerTap(markerId);
    }

    boolean onMarkerTap(String markerId) {
        this.flutterApi.onMarkerTap(markerId, new NoOpVoidResult());
        MarkerController markerController = this.markerIdToController.get(markerId);
        if (markerController != null) {
            return markerController.consumeTapEvents();
        }
        return false;
    }

    void onMarkerDragStart(String googleMarkerId, LatLng latLng) {
        String markerId = this.googleMapsMarkerIdToDartMarkerId.get(googleMarkerId);
        if (markerId == null) {
            return;
        }
        this.flutterApi.onMarkerDragStart(markerId, Convert.latLngToPigeon(latLng), new NoOpVoidResult());
    }

    void onMarkerDrag(String googleMarkerId, LatLng latLng) {
        String markerId = this.googleMapsMarkerIdToDartMarkerId.get(googleMarkerId);
        if (markerId == null) {
            return;
        }
        this.flutterApi.onMarkerDrag(markerId, Convert.latLngToPigeon(latLng), new NoOpVoidResult());
    }

    void onMarkerDragEnd(String googleMarkerId, LatLng latLng) {
        String markerId = this.googleMapsMarkerIdToDartMarkerId.get(googleMarkerId);
        if (markerId == null) {
            return;
        }
        this.flutterApi.onMarkerDragEnd(markerId, Convert.latLngToPigeon(latLng), new NoOpVoidResult());
    }

    void onInfoWindowTap(String googleMarkerId) {
        String markerId = this.googleMapsMarkerIdToDartMarkerId.get(googleMarkerId);
        if (markerId == null) {
            return;
        }
        this.flutterApi.onInfoWindowTap(markerId, new NoOpVoidResult());
    }

    public void onClusterItemRendered(MarkerBuilder markerBuilder, Marker marker) {
        String markerId = markerBuilder.markerId();
        if (this.markerIdToMarkerBuilder.get(markerId) == markerBuilder) {
            this.createControllerForMarker(markerBuilder.markerId(), marker, markerBuilder.consumeTapEvents());
        }
    }

    private void addMarker(@NonNull Messages.PlatformMarker marker) {
        String markerId = marker.getMarkerId();
        String clusterManagerId = marker.getClusterManagerId();
        MarkerBuilder markerBuilder = new MarkerBuilder(markerId, clusterManagerId);
        Convert.interpretMarkerOptions(marker, markerBuilder, this.assetManager, this.density, this.bitmapDescriptorFactoryWrapper);
        this.addMarker(markerBuilder);
    }

    private void addMarker(MarkerBuilder markerBuilder) {
        if (markerBuilder == null) {
            return;
        }
        String markerId = markerBuilder.markerId();
        this.markerIdToMarkerBuilder.put(markerId, markerBuilder);
        if (markerBuilder.clusterManagerId() == null) {
            this.addMarkerToCollection(markerId, markerBuilder);
        } else {
            this.addMarkerBuilderForCluster(markerBuilder);
        }
    }

    private void addMarkerToCollection(String markerId, MarkerBuilder markerBuilder) {
        MarkerOptions options = markerBuilder.build();
        Marker marker = this.markerCollection.addMarker(options);
        this.createControllerForMarker(markerId, marker, markerBuilder.consumeTapEvents());
    }

    private void addMarkerBuilderForCluster(MarkerBuilder markerBuilder) {
        this.clusterManagersController.addItem(markerBuilder);
    }

    private void createControllerForMarker(String markerId, Marker marker, boolean consumeTapEvents) {
        MarkerController controller = new MarkerController(marker, consumeTapEvents);
        this.markerIdToController.put(markerId, controller);
        this.googleMapsMarkerIdToDartMarkerId.put(marker.getId(), markerId);
    }

    private void changeMarker(@NonNull Messages.PlatformMarker marker) {
        String oldClusterManagerId;
        String markerId = marker.getMarkerId();
        MarkerBuilder markerBuilder = this.markerIdToMarkerBuilder.get(markerId);
        if (markerBuilder == null) {
            return;
        }
        String clusterManagerId = marker.getClusterManagerId();
        if (!Objects.equals(clusterManagerId, oldClusterManagerId = markerBuilder.clusterManagerId())) {
            this.removeMarker(markerId);
            this.addMarker(marker);
            return;
        }
        Convert.interpretMarkerOptions(marker, markerBuilder, this.assetManager, this.density, this.bitmapDescriptorFactoryWrapper);
        MarkerController markerController = this.markerIdToController.get(markerId);
        if (markerController != null) {
            Convert.interpretMarkerOptions(marker, markerController, this.assetManager, this.density, this.bitmapDescriptorFactoryWrapper);
        }
    }
}

