/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.PolylineOptions;
import io.flutter.plugins.googlemaps.PolylineOptionsSink;
import java.util.List;

class PolylineBuilder
implements PolylineOptionsSink {
    private final PolylineOptions polylineOptions = new PolylineOptions();
    private boolean consumeTapEvents;
    private final float density;

    PolylineBuilder(float density) {
        this.density = density;
    }

    PolylineOptions build() {
        return this.polylineOptions;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }

    @Override
    public void setColor(int color) {
        this.polylineOptions.color(color);
    }

    @Override
    public void setEndCap(Cap endCap) {
        this.polylineOptions.endCap(endCap);
    }

    @Override
    public void setJointType(int jointType) {
        this.polylineOptions.jointType(jointType);
    }

    @Override
    public void setPattern(List<PatternItem> pattern) {
        this.polylineOptions.pattern(pattern);
    }

    @Override
    public void setPoints(List<LatLng> points) {
        this.polylineOptions.addAll(points);
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.polylineOptions.clickable(consumeTapEvents);
    }

    @Override
    public void setGeodesic(boolean geodisc) {
        this.polylineOptions.geodesic(geodisc);
    }

    @Override
    public void setStartCap(Cap startCap) {
        this.polylineOptions.startCap(startCap);
    }

    @Override
    public void setVisible(boolean visible) {
        this.polylineOptions.visible(visible);
    }

    @Override
    public void setWidth(float width) {
        this.polylineOptions.width(width * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.polylineOptions.zIndex(zIndex);
    }
}

