/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import io.flutter.plugins.googlemaps.PolylineBuilder;
import io.flutter.plugins.googlemaps.PolylineController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PolylinesController {
    private final Map<String, PolylineController> polylineIdToController;
    private final Map<String, String> googleMapsPolylineIdToDartPolylineId;
    @NonNull
    private final Messages.MapsCallbackApi flutterApi;
    private GoogleMap googleMap;
    private final float density;
    private final AssetManager assetManager;

    PolylinesController(@NonNull Messages.MapsCallbackApi flutterApi, AssetManager assetManager, float density) {
        this.assetManager = assetManager;
        this.polylineIdToController = new HashMap<String, PolylineController>();
        this.googleMapsPolylineIdToDartPolylineId = new HashMap<String, String>();
        this.flutterApi = flutterApi;
        this.density = density;
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addPolylines(@NonNull List<Messages.PlatformPolyline> polylinesToAdd) {
        for (Messages.PlatformPolyline polylineToAdd : polylinesToAdd) {
            this.addPolyline(polylineToAdd);
        }
    }

    void changePolylines(@NonNull List<Messages.PlatformPolyline> polylinesToChange) {
        for (Messages.PlatformPolyline polylineToChange : polylinesToChange) {
            this.changePolyline(polylineToChange);
        }
    }

    void removePolylines(@NonNull List<String> polylineIdsToRemove) {
        for (String polylineId : polylineIdsToRemove) {
            PolylineController polylineController = this.polylineIdToController.remove(polylineId);
            if (polylineController == null) continue;
            polylineController.remove();
            this.googleMapsPolylineIdToDartPolylineId.remove(polylineController.getGoogleMapsPolylineId());
        }
    }

    boolean onPolylineTap(String googlePolylineId) {
        String polylineId = this.googleMapsPolylineIdToDartPolylineId.get(googlePolylineId);
        if (polylineId == null) {
            return false;
        }
        this.flutterApi.onPolylineTap(polylineId, new NoOpVoidResult());
        PolylineController polylineController = this.polylineIdToController.get(polylineId);
        if (polylineController != null) {
            return polylineController.consumeTapEvents();
        }
        return false;
    }

    private void addPolyline(@NonNull Messages.PlatformPolyline polyline) {
        PolylineBuilder polylineBuilder = new PolylineBuilder(this.density);
        String polylineId = Convert.interpretPolylineOptions(polyline, polylineBuilder, this.assetManager, this.density);
        PolylineOptions options = polylineBuilder.build();
        this.addPolyline(polylineId, options, polylineBuilder.consumeTapEvents());
    }

    private void addPolyline(String polylineId, PolylineOptions polylineOptions, boolean consumeTapEvents) {
        Polyline polyline = this.googleMap.addPolyline(polylineOptions);
        PolylineController controller = new PolylineController(polyline, consumeTapEvents, this.density);
        this.polylineIdToController.put(polylineId, controller);
        this.googleMapsPolylineIdToDartPolylineId.put(polyline.getId(), polylineId);
    }

    private void changePolyline(@NonNull Messages.PlatformPolyline polyline) {
        String polylineId = polyline.getPolylineId();
        PolylineController polylineController = this.polylineIdToController.get(polylineId);
        if (polylineController != null) {
            Convert.interpretPolylineOptions(polyline, polylineController, this.assetManager, this.density);
        }
    }

    private static String getPolylineId(Map<String, ?> polyline) {
        return (String)polyline.get("polylineId");
    }
}

