/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.model.Tile;
import com.google.android.gms.maps.model.TileProvider;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;
import java.util.concurrent.CountDownLatch;

class TileProviderController
implements TileProvider {
    private static final String TAG = "TileProviderController";
    protected final String tileOverlayId;
    @NonNull
    protected final Messages.MapsCallbackApi flutterApi;
    protected final Handler handler = new Handler(Looper.getMainLooper());

    TileProviderController(@NonNull Messages.MapsCallbackApi flutterApi, String tileOverlayId) {
        this.tileOverlayId = tileOverlayId;
        this.flutterApi = flutterApi;
    }

    public Tile getTile(int x, int y, int zoom) {
        Worker worker = new Worker(x, y, zoom);
        return worker.getTile();
    }

    private final class Worker
    implements Messages.Result<Messages.PlatformTile> {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private final int x;
        private final int y;
        private final int zoom;
        @Nullable
        private Messages.PlatformTile result;

        Worker(int x, int y, int zoom) {
            this.x = x;
            this.y = y;
            this.zoom = zoom;
        }

        @NonNull
        Tile getTile() {
            Messages.PlatformPoint location = new Messages.PlatformPoint.Builder().setX(Long.valueOf(this.x)).setY(Long.valueOf(this.y)).build();
            TileProviderController.this.handler.post(() -> TileProviderController.this.flutterApi.getTileOverlayTile(TileProviderController.this.tileOverlayId, location, Long.valueOf(this.zoom), this));
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                Log.e((String)TileProviderController.TAG, (String)String.format("countDownLatch: can't get tile: x = %d, y= %d, zoom = %d", this.x, this.y, this.zoom), (Throwable)e);
                return TileProvider.NO_TILE;
            }
            try {
                if (this.result == null) {
                    Log.e((String)TileProviderController.TAG, (String)String.format("Did not receive tile data for tile: x = %d, y= %d, zoom = %d", this.x, this.y, this.zoom));
                    return TileProvider.NO_TILE;
                }
                return Convert.tileFromPigeon(this.result);
            }
            catch (Exception e) {
                Log.e((String)TileProviderController.TAG, (String)"Can't parse tile data", (Throwable)e);
                return TileProvider.NO_TILE;
            }
        }

        @Override
        public void success(@NonNull Messages.PlatformTile result) {
            this.result = result;
            this.countDownLatch.countDown();
        }

        @Override
        public void error(@NonNull Throwable error) {
            if (error instanceof Messages.FlutterError) {
                Messages.FlutterError flutterError = (Messages.FlutterError)error;
                Log.e((String)TileProviderController.TAG, (String)("Can't get tile: errorCode = " + flutterError.code + ", errorMessage = " + flutterError.getMessage() + ", date = " + flutterError.details));
            } else {
                Log.e((String)TileProviderController.TAG, (String)("Can't get tile: " + error));
            }
            this.result = null;
            this.countDownLatch.countDown();
        }
    }
}

