/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.model.CameraPosition;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.GoogleMapBuilder;
import io.flutter.plugins.googlemaps.GoogleMapInitializer;
import io.flutter.plugins.googlemaps.LifecycleProvider;
import io.flutter.plugins.googlemaps.Messages;
import java.util.Objects;

public class GoogleMapFactory
extends PlatformViewFactory {
    private final BinaryMessenger binaryMessenger;
    private final LifecycleProvider lifecycleProvider;
    private final GoogleMapInitializer googleMapInitializer;

    GoogleMapFactory(BinaryMessenger binaryMessenger, Context context, LifecycleProvider lifecycleProvider) {
        super(Messages.MapsApi.getCodec());
        this.binaryMessenger = binaryMessenger;
        this.lifecycleProvider = lifecycleProvider;
        this.googleMapInitializer = new GoogleMapInitializer(context, binaryMessenger);
    }

    @NonNull
    public PlatformView create(@NonNull Context context, int id, @Nullable Object args) {
        Messages.PlatformMapViewCreationParams params = Objects.requireNonNull((Messages.PlatformMapViewCreationParams)args);
        GoogleMapBuilder builder = new GoogleMapBuilder();
        Messages.PlatformMapConfiguration mapConfig = params.getMapConfiguration();
        Convert.interpretMapConfiguration(mapConfig, builder);
        CameraPosition position = Convert.cameraPositionFromPigeon(params.getInitialCameraPosition());
        builder.setInitialCameraPosition(position);
        builder.setInitialClusterManagers(params.getInitialClusterManagers());
        builder.setInitialMarkers(params.getInitialMarkers());
        builder.setInitialPolygons(params.getInitialPolygons());
        builder.setInitialPolylines(params.getInitialPolylines());
        builder.setInitialCircles(params.getInitialCircles());
        builder.setInitialHeatmaps(params.getInitialHeatmaps());
        builder.setInitialTileOverlays(params.getInitialTileOverlays());
        builder.setInitialGroundOverlays(params.getInitialGroundOverlays());
        String cloudMapId = mapConfig.getCloudMapId();
        if (cloudMapId != null) {
            builder.setMapId(cloudMapId);
        }
        return builder.build(id, context, this.binaryMessenger, this.lifecycleProvider);
    }
}

