/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.lifecycle.FlutterLifecycleAdapter;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugins.googlemaps.GoogleMapFactory;
import io.flutter.plugins.googlemaps.LifecycleProvider;

public class GoogleMapsPlugin
implements FlutterPlugin,
ActivityAware {
    @Nullable
    Lifecycle lifecycle;
    private static final String VIEW_TYPE = "plugins.flutter.dev/google_maps_android";

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        binding.getPlatformViewRegistry().registerViewFactory(VIEW_TYPE, (PlatformViewFactory)new GoogleMapFactory(binding.getBinaryMessenger(), binding.getApplicationContext(), new LifecycleProvider(){

            @Override
            @Nullable
            public Lifecycle getLifecycle() {
                return GoogleMapsPlugin.this.lifecycle;
            }
        }));
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        this.lifecycle = FlutterLifecycleAdapter.getActivityLifecycle((ActivityPluginBinding)binding);
    }

    public void onDetachedFromActivity() {
        this.lifecycle = null;
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    private static final class ProxyLifecycleProvider
    implements Application.ActivityLifecycleCallbacks,
    LifecycleOwner,
    LifecycleProvider {
        private final LifecycleRegistry lifecycle = new LifecycleRegistry((LifecycleOwner)this);
        private final int registrarActivityHashCode;

        ProxyLifecycleProvider(Activity activity) {
            this.registrarActivityHashCode = activity.hashCode();
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        }

        public void onActivityStarted(Activity activity) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_START);
        }

        public void onActivityResumed(Activity activity) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        }

        public void onActivityPaused(Activity activity) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
        }

        public void onActivityStopped(Activity activity) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity.hashCode() != this.registrarActivityHashCode) {
                return;
            }
            activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        }

        @Override
        @NonNull
        public Lifecycle getLifecycle() {
            return this.lifecycle;
        }
    }
}

