/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.util.Log;
import com.lyokone.location.FlutterLocation;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;

class StreamHandlerImpl
implements EventChannel.StreamHandler {
    private static final String TAG = "StreamHandlerImpl";
    private FlutterLocation location;
    private EventChannel channel;
    private static final String STREAM_CHANNEL_NAME = "lyokone/locationstream";

    StreamHandlerImpl() {
    }

    void setLocation(FlutterLocation location) {
        this.location = location;
    }

    void startListening(BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.wtf((String)TAG, (String)"Setting a method call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new EventChannel(messenger, STREAM_CHANNEL_NAME);
        this.channel.setStreamHandler((EventChannel.StreamHandler)this);
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.channel.setStreamHandler(null);
        this.channel = null;
    }

    public void onListen(Object arguments, EventChannel.EventSink eventsSink) {
        this.location.events = eventsSink;
        if (this.location.activity == null) {
            eventsSink.error("NO_ACTIVITY", null, null);
            return;
        }
        if (!this.location.checkPermissions()) {
            this.location.requestPermissions();
            return;
        }
        this.location.startRequestingLocation();
    }

    public void onCancel(Object arguments) {
        this.location.mFusedLocationClient.removeLocationUpdates(this.location.mLocationCallback);
        this.location.events = null;
    }
}

