/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.location.OnNmeaMessageListener;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.SettingsClient;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class FlutterLocation
implements PluginRegistry.RequestPermissionsResultListener,
PluginRegistry.ActivityResultListener {
    private static final String TAG = "FlutterLocation";
    @Nullable
    public Activity activity;
    private static final int REQUEST_PERMISSIONS_REQUEST_CODE = 34;
    private static final int REQUEST_CHECK_SETTINGS = 1;
    private static final int GPS_ENABLE_REQUEST = 4097;
    public FusedLocationProviderClient mFusedLocationClient;
    private SettingsClient mSettingsClient;
    private LocationRequest mLocationRequest;
    private LocationSettingsRequest mLocationSettingsRequest;
    public LocationCallback mLocationCallback;
    @TargetApi(value=24)
    private OnNmeaMessageListener mMessageListener;
    private Double mLastMslAltitude;
    private long updateIntervalMilliseconds = 5000L;
    private long fastestUpdateIntervalMilliseconds = this.updateIntervalMilliseconds / 2L;
    private Integer locationAccuracy = 100;
    private float distanceFilter = 0.0f;
    public EventChannel.EventSink events;
    public MethodChannel.Result result;
    private MethodChannel.Result requestServiceResult;
    public MethodChannel.Result getLocationResult;
    private final LocationManager locationManager;
    public SparseArray<Integer> mapFlutterAccuracy = new SparseArray<Integer>(){
        {
            this.put(0, 105);
            this.put(1, 104);
            this.put(2, 102);
            this.put(3, 100);
            this.put(4, 100);
            this.put(5, 104);
        }
    };

    FlutterLocation(Context applicationContext, @Nullable Activity activity) {
        this.activity = activity;
        this.locationManager = (LocationManager)applicationContext.getSystemService("location");
    }

    void setActivity(@Nullable Activity activity) {
        this.activity = activity;
        if (this.activity != null) {
            this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)activity);
            this.mSettingsClient = LocationServices.getSettingsClient((Activity)activity);
            this.createLocationCallback();
            this.createLocationRequest();
            this.buildLocationSettingsRequest();
        } else {
            if (this.mFusedLocationClient != null) {
                this.mFusedLocationClient.removeLocationUpdates(this.mLocationCallback);
            }
            this.mFusedLocationClient = null;
            this.mSettingsClient = null;
            if (Build.VERSION.SDK_INT >= 24 && this.locationManager != null) {
                this.locationManager.removeNmeaListener(this.mMessageListener);
                this.mMessageListener = null;
            }
        }
    }

    public boolean onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        return this.onRequestPermissionsResultHandler(requestCode, permissions, grantResults);
    }

    public boolean onRequestPermissionsResultHandler(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 34 && permissions.length == 1 && permissions[0].equals("android.permission.ACCESS_FINE_LOCATION")) {
            if (grantResults[0] == 0) {
                if (this.getLocationResult != null || this.events != null) {
                    this.startRequestingLocation();
                }
                if (this.result != null) {
                    this.result.success((Object)1);
                    this.result = null;
                }
            } else if (!this.shouldShowRequestPermissionRationale()) {
                this.sendError("PERMISSION_DENIED_NEVER_ASK", "Location permission denied forever - please open app settings", null);
                if (this.result != null) {
                    this.result.success((Object)2);
                    this.result = null;
                }
            } else {
                this.sendError("PERMISSION_DENIED", "Location permission denied", null);
                if (this.result != null) {
                    this.result.success((Object)0);
                    this.result = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 4097: {
                if (this.requestServiceResult == null) {
                    return false;
                }
                if (resultCode == -1) {
                    this.requestServiceResult.success((Object)1);
                } else {
                    this.requestServiceResult.success((Object)0);
                }
                this.requestServiceResult = null;
                return true;
            }
            case 1: {
                if (this.result == null) {
                    return false;
                }
                if (resultCode == -1) {
                    this.startRequestingLocation();
                    return true;
                }
                this.result.error("SERVICE_STATUS_DISABLED", "Failed to get location. Location services disabled", null);
                this.result = null;
                return true;
            }
        }
        return false;
    }

    public void changeSettings(Integer newLocationAccuracy, Long updateIntervalMilliseconds, Long fastestUpdateIntervalMilliseconds, Float distanceFilter) {
        this.locationAccuracy = newLocationAccuracy;
        this.updateIntervalMilliseconds = updateIntervalMilliseconds;
        this.fastestUpdateIntervalMilliseconds = fastestUpdateIntervalMilliseconds;
        this.distanceFilter = distanceFilter.floatValue();
        this.createLocationCallback();
        this.createLocationRequest();
        this.buildLocationSettingsRequest();
        this.startRequestingLocation();
    }

    private void sendError(String errorCode, String errorMessage, Object errorDetails) {
        if (this.getLocationResult != null) {
            this.getLocationResult.error(errorCode, errorMessage, errorDetails);
            this.getLocationResult = null;
        }
        if (this.events != null) {
            this.events.error(errorCode, errorMessage, errorDetails);
            this.events = null;
        }
    }

    private void createLocationCallback() {
        if (this.mLocationCallback != null) {
            this.mFusedLocationClient.removeLocationUpdates(this.mLocationCallback);
            this.mLocationCallback = null;
        }
        this.mLocationCallback = new LocationCallback(){

            public void onLocationResult(LocationResult locationResult) {
                super.onLocationResult(locationResult);
                Location location = locationResult.getLastLocation();
                HashMap<String, Object> loc = new HashMap<String, Object>();
                loc.put("latitude", location.getLatitude());
                loc.put("longitude", location.getLongitude());
                loc.put("accuracy", Double.valueOf(location.getAccuracy()));
                if (Build.VERSION.SDK_INT >= 26) {
                    loc.put("verticalAccuracy", Double.valueOf(location.getVerticalAccuracyMeters()));
                    loc.put("headingAccuracy", Double.valueOf(location.getBearingAccuracyDegrees()));
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    loc.put("elapsedRealtimeUncertaintyNanos", location.getElapsedRealtimeUncertaintyNanos());
                }
                loc.put("provider", location.getProvider());
                Bundle extras = location.getExtras();
                if (extras != null) {
                    loc.put("satelliteNumber", location.getExtras().getInt("satellites"));
                }
                if (Build.VERSION.SDK_INT >= 18) {
                    loc.put("elapsedRealtimeNanos", Double.valueOf(location.getElapsedRealtimeNanos()));
                    if (location.isFromMockProvider()) {
                        loc.put("isMock", 1.0);
                    }
                } else {
                    loc.put("isMock", 0.0);
                }
                if (FlutterLocation.this.mLastMslAltitude == null || Build.VERSION.SDK_INT < 24) {
                    loc.put("altitude", location.getAltitude());
                } else {
                    loc.put("altitude", FlutterLocation.this.mLastMslAltitude);
                }
                loc.put("speed", Double.valueOf(location.getSpeed()));
                if (Build.VERSION.SDK_INT >= 26) {
                    loc.put("speed_accuracy", Double.valueOf(location.getSpeedAccuracyMetersPerSecond()));
                }
                loc.put("heading", Double.valueOf(location.getBearing()));
                loc.put("time", Double.valueOf(location.getTime()));
                if (FlutterLocation.this.getLocationResult != null) {
                    FlutterLocation.this.getLocationResult.success(loc);
                    FlutterLocation.this.getLocationResult = null;
                }
                if (FlutterLocation.this.events != null) {
                    FlutterLocation.this.events.success(loc);
                } else if (FlutterLocation.this.mFusedLocationClient != null) {
                    FlutterLocation.this.mFusedLocationClient.removeLocationUpdates(FlutterLocation.this.mLocationCallback);
                }
            }
        };
        if (Build.VERSION.SDK_INT >= 24) {
            this.mMessageListener = (message, timestamp) -> {
                String[] tokens;
                String type;
                if (message.startsWith("$") && (type = (tokens = message.split(","))[0]).startsWith("$GPGGA") && tokens.length > 9 && !tokens[9].isEmpty()) {
                    this.mLastMslAltitude = Double.parseDouble(tokens[9]);
                }
            };
        }
    }

    private void createLocationRequest() {
        this.mLocationRequest = LocationRequest.create();
        this.mLocationRequest.setInterval(this.updateIntervalMilliseconds);
        this.mLocationRequest.setFastestInterval(this.fastestUpdateIntervalMilliseconds);
        this.mLocationRequest.setPriority(this.locationAccuracy.intValue());
        this.mLocationRequest.setSmallestDisplacement(this.distanceFilter);
    }

    private void buildLocationSettingsRequest() {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
        builder.addLocationRequest(this.mLocationRequest);
        this.mLocationSettingsRequest = builder.build();
    }

    public boolean checkPermissions() {
        if (this.activity == null) {
            this.result.error("MISSING_ACTIVITY", "You should not checkPermissions activation outside of an activity.", null);
            throw new ActivityNotFoundException();
        }
        int locationPermissionState = ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION");
        return locationPermissionState == 0;
    }

    public void requestPermissions() {
        if (this.activity == null) {
            this.result.error("MISSING_ACTIVITY", "You should not requestPermissions activation outside of an activity.", null);
            throw new ActivityNotFoundException();
        }
        if (this.checkPermissions()) {
            this.result.success((Object)1);
            return;
        }
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)34);
    }

    public boolean shouldShowRequestPermissionRationale() {
        if (this.activity == null) {
            return false;
        }
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION");
    }

    public boolean checkServiceEnabled() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.locationManager.isLocationEnabled();
        }
        boolean gps_enabled = this.locationManager.isProviderEnabled("gps");
        boolean network_enabled = this.locationManager.isProviderEnabled("network");
        return gps_enabled || network_enabled;
    }

    public void requestService(MethodChannel.Result requestServiceResult) {
        if (this.activity == null) {
            requestServiceResult.error("MISSING_ACTIVITY", "You should not requestService activation outside of an activity.", null);
            throw new ActivityNotFoundException();
        }
        try {
            if (this.checkServiceEnabled()) {
                requestServiceResult.success((Object)1);
                return;
            }
        }
        catch (Exception e2) {
            requestServiceResult.error("SERVICE_STATUS_ERROR", "Location service status couldn't be determined", null);
            return;
        }
        this.requestServiceResult = requestServiceResult;
        this.mSettingsClient.checkLocationSettings(this.mLocationSettingsRequest).addOnFailureListener(this.activity, e -> {
            if (e instanceof ResolvableApiException) {
                ResolvableApiException rae = (ResolvableApiException)e;
                int statusCode = rae.getStatusCode();
                switch (statusCode) {
                    case 6: {
                        try {
                            rae.startResolutionForResult(this.activity, 4097);
                        }
                        catch (IntentSender.SendIntentException sie) {
                            requestServiceResult.error("SERVICE_STATUS_ERROR", "Could not resolve location request", null);
                        }
                        break;
                    }
                    case 8502: {
                        requestServiceResult.error("SERVICE_STATUS_DISABLED", "Failed to get location. Location services disabled", null);
                    }
                }
            } else {
                requestServiceResult.error("SERVICE_STATUS_ERROR", "Unexpected error type received", null);
            }
        });
    }

    public void startRequestingLocation() {
        if (this.activity == null) {
            this.result.error("MISSING_ACTIVITY", "You should not requestLocation activation outside of an activity.", null);
            throw new ActivityNotFoundException();
        }
        this.mSettingsClient.checkLocationSettings(this.mLocationSettingsRequest).addOnSuccessListener(this.activity, locationSettingsResponse -> {
            if (Build.VERSION.SDK_INT >= 24) {
                this.locationManager.addNmeaListener(this.mMessageListener, null);
            }
            if (this.mFusedLocationClient != null) {
                this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, this.mLocationCallback, Looper.myLooper());
            }
        }).addOnFailureListener(this.activity, e -> {
            if (e instanceof ResolvableApiException) {
                ResolvableApiException rae = (ResolvableApiException)e;
                int statusCode = rae.getStatusCode();
                if (statusCode == 6) {
                    try {
                        rae.startResolutionForResult(this.activity, 1);
                    }
                    catch (IntentSender.SendIntentException sie) {
                        Log.i((String)TAG, (String)"PendingIntent unable to execute request.");
                    }
                }
            } else {
                ApiException ae = (ApiException)e;
                int statusCode = ae.getStatusCode();
                if (statusCode == 8502) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        this.locationManager.addNmeaListener(this.mMessageListener, null);
                    }
                    this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, this.mLocationCallback, Looper.myLooper());
                } else {
                    this.sendError("UNEXPECTED_ERROR", e.getMessage(), null);
                }
            }
        });
    }
}

