/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import com.lyokone.location.FlutterLocation;
import com.lyokone.location.FlutterLocationService;
import com.lyokone.location.NotificationOptions;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.Map;

final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "MethodCallHandlerImpl";
    private FlutterLocation location;
    private FlutterLocationService locationService;
    @Nullable
    private MethodChannel channel;
    private static final String METHOD_CHANNEL_NAME = "lyokone/location";

    MethodCallHandlerImpl() {
    }

    void setLocation(FlutterLocation location) {
        this.location = location;
    }

    void setLocationService(FlutterLocationService locationService) {
        this.locationService = locationService;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "changeSettings": {
                this.onChangeSettings(call, result);
                break;
            }
            case "getLocation": {
                this.onGetLocation(result);
                break;
            }
            case "hasPermission": {
                this.onHasPermission(result);
                break;
            }
            case "requestPermission": {
                this.onRequestPermission(result);
                break;
            }
            case "serviceEnabled": {
                this.onServiceEnabled(result);
                break;
            }
            case "requestService": {
                this.location.requestService(result);
                break;
            }
            case "isBackgroundModeEnabled": {
                this.isBackgroundModeEnabled(result);
                break;
            }
            case "enableBackgroundMode": {
                this.enableBackgroundMode(call, result);
                break;
            }
            case "changeNotificationOptions": {
                this.onChangeNotificationOptions(call, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void startListening(BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.wtf((String)TAG, (String)"Setting a method call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new MethodChannel(messenger, METHOD_CHANNEL_NAME);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    private void onChangeSettings(MethodCall call, MethodChannel.Result result) {
        try {
            Integer locationAccuracy = (Integer)this.location.mapFlutterAccuracy.get(((Integer)call.argument("accuracy")).intValue());
            Long updateIntervalMilliseconds = new Long(((Integer)call.argument("interval")).intValue());
            Long fastestUpdateIntervalMilliseconds = updateIntervalMilliseconds / 2L;
            Float distanceFilter = new Float((Double)call.argument("distanceFilter"));
            this.location.changeSettings(locationAccuracy, updateIntervalMilliseconds, fastestUpdateIntervalMilliseconds, distanceFilter);
            result.success((Object)1);
        }
        catch (Exception e) {
            result.error("CHANGE_SETTINGS_ERROR", "An unexcepted error happened during location settings change:" + e.getMessage(), null);
        }
    }

    private void onGetLocation(MethodChannel.Result result) {
        this.location.getLocationResult = result;
        if (!this.location.checkPermissions()) {
            this.location.requestPermissions();
        } else {
            this.location.startRequestingLocation();
        }
    }

    private void onHasPermission(MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 23) {
            result.success((Object)1);
            return;
        }
        if (this.location.checkPermissions()) {
            result.success((Object)1);
        } else {
            result.success((Object)0);
        }
    }

    private void onServiceEnabled(MethodChannel.Result result) {
        try {
            result.success((Object)(this.location.checkServiceEnabled() ? 1 : 0));
        }
        catch (Exception e) {
            result.error("SERVICE_STATUS_ERROR", "Location service status couldn't be determined", null);
        }
    }

    private void onRequestPermission(MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 23) {
            result.success((Object)1);
            return;
        }
        this.location.result = result;
        this.location.requestPermissions();
    }

    private void isBackgroundModeEnabled(MethodChannel.Result result) {
        if (this.locationService != null) {
            result.success((Object)(this.locationService.isInForegroundMode() ? 1 : 0));
        } else {
            result.success((Object)0);
        }
    }

    private void enableBackgroundMode(MethodCall call, MethodChannel.Result result) {
        Boolean enable = (Boolean)call.argument("enable");
        if (this.locationService != null && enable != null) {
            if (this.locationService.checkBackgroundPermissions()) {
                if (enable.booleanValue()) {
                    this.locationService.enableBackgroundMode();
                    result.success((Object)1);
                } else {
                    this.locationService.disableBackgroundMode();
                    result.success((Object)0);
                }
            } else if (enable.booleanValue()) {
                this.locationService.setResult(result);
                this.locationService.requestBackgroundPermissions();
            } else {
                this.locationService.disableBackgroundMode();
                result.success((Object)0);
            }
        } else {
            result.success((Object)0);
        }
    }

    private void onChangeNotificationOptions(MethodCall call, MethodChannel.Result result) {
        try {
            String passedChannelName = (String)call.argument("channelName");
            String channelName = passedChannelName != null ? passedChannelName : "Location background service";
            String passedTitle = (String)call.argument("title");
            String title = passedTitle != null ? passedTitle : "Location background service running";
            String passedIconName = (String)call.argument("iconName");
            String iconName = passedIconName != null ? passedIconName : "navigation_empty_icon";
            String subtitle = (String)call.argument("subtitle");
            String description = (String)call.argument("description");
            Boolean onTapBringToFront = (Boolean)call.argument("onTapBringToFront");
            if (onTapBringToFront == null) {
                onTapBringToFront = false;
            }
            String hexColor = (String)call.argument("color");
            Integer color = null;
            if (hexColor != null) {
                color = Color.parseColor((String)hexColor);
            }
            NotificationOptions options = new NotificationOptions(channelName, title, iconName, subtitle, description, color, onTapBringToFront);
            Map<String, Object> notificationMeta = this.locationService.changeNotificationOptions(options);
            result.success(notificationMeta);
        }
        catch (Exception e) {
            result.error("CHANGE_NOTIFICATION_OPTIONS_ERROR", "An unexpected error happened during notification options change:" + e.getMessage(), null);
        }
    }
}

