/*
 * Decompiled with CFR 0.152.
 */
package dev.steenbakker.mobile_scanner;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.display.DisplayManager;
import android.media.Image;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Size;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import dev.steenbakker.mobile_scanner.AlreadyStarted;
import dev.steenbakker.mobile_scanner.AlreadyStopped;
import dev.steenbakker.mobile_scanner.CameraError;
import dev.steenbakker.mobile_scanner.MobileScannerUtilitiesKt;
import dev.steenbakker.mobile_scanner.NoCamera;
import dev.steenbakker.mobile_scanner.ZoomNotInRange;
import dev.steenbakker.mobile_scanner.ZoomWhenStopped;
import dev.steenbakker.mobile_scanner.objects.DetectionSpeed;
import dev.steenbakker.mobile_scanner.objects.MobileScannerStartParameters;
import dev.steenbakker.mobile_scanner.utils.YuvToRgbConverter;
import io.flutter.view.TextureRegistry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u00bc\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012~\u0010\u0006\u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u0007j\u0002`\u0014\u0012%\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`\u0018\u00a2\u0006\u0002\u0010\u0019JK\u0010:\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020;2;\u0010<\u001a7\u0012)\u0012'\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t\u0018\u00010\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`=J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0002J&\u0010A\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\b2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020.H\u0002J\u0006\u0010G\u001a\u00020\u0013J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u000200H\u0002J\u000e\u0010L\u001a\u00020\u00132\u0006\u0010M\u001a\u00020NJ\u00e8\u0001\u0010O\u001a\u00020\u00132\b\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010-\u001a\u00020.2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020.2\u0006\u0010$\u001a\u00020%2%\u0010U\u001a!\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(V\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`W2%\u0010X\u001a!\u0012\u0013\u0012\u00110N\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(Y\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`Z2%\u0010[\u001a!\u0012\u0013\u0012\u00110\\\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(]\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`^2%\u0010\u0015\u001a!\u0012\u0017\u0012\u00150_j\u0002``\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(a\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010&\u001a\u00020'2\b\u0010@\u001a\u0004\u0018\u00010?2\u0006\u0010b\u001a\u00020.H\u0007J\u0006\u0010c\u001a\u00020\u0013J\u000e\u0010d\u001a\u00020\u00132\u0006\u0010e\u001a\u00020.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u00020\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010\u0006\u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u0007j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Ldev/steenbakker/mobile_scanner/MobileScanner;", "", "activity", "Landroid/app/Activity;", "textureRegistry", "Lio/flutter/view/TextureRegistry;", "mobileScannerCallback", "Lkotlin/Function4;", "", "", "", "Lkotlin/ParameterName;", "name", "barcodes", "", "image", "", "width", "height", "", "Ldev/steenbakker/mobile_scanner/MobileScannerCallback;", "mobileScannerErrorCallback", "Lkotlin/Function1;", "error", "Ldev/steenbakker/mobile_scanner/MobileScannerErrorCallback;", "(Landroid/app/Activity;Lio/flutter/view/TextureRegistry;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function1;)V", "camera", "Landroidx/camera/core/Camera;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "captureOutput", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "getCaptureOutput$annotations", "()V", "getCaptureOutput", "()Landroidx/camera/core/ImageAnalysis$Analyzer;", "detectionSpeed", "Ldev/steenbakker/mobile_scanner/objects/DetectionSpeed;", "detectionTimeout", "", "displayListener", "Landroid/hardware/display/DisplayManager$DisplayListener;", "lastScanned", "preview", "Landroidx/camera/core/Preview;", "returnImage", "", "scanWindow", "", "getScanWindow", "()Ljava/util/List;", "setScanWindow", "(Ljava/util/List;)V", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "scannerTimeout", "textureEntry", "Lio/flutter/view/TextureRegistry$SurfaceTextureEntry;", "analyzeImage", "Landroid/net/Uri;", "analyzerCallback", "Ldev/steenbakker/mobile_scanner/AnalyzerCallback;", "getResolution", "Landroid/util/Size;", "cameraResolution", "isBarcodeInScanWindow", "barcode", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "inputImage", "Landroidx/camera/core/ImageProxy;", "isStopped", "resetScale", "rotateBitmap", "Landroid/graphics/Bitmap;", "bitmap", "degrees", "setScale", "scale", "", "start", "barcodeScannerOptions", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "cameraPosition", "Landroidx/camera/core/CameraSelector;", "torch", "torchStateCallback", "state", "Ldev/steenbakker/mobile_scanner/TorchStateCallback;", "zoomScaleStateCallback", "zoomScale", "Ldev/steenbakker/mobile_scanner/ZoomScaleStateCallback;", "mobileScannerStartedCallback", "Ldev/steenbakker/mobile_scanner/objects/MobileScannerStartParameters;", "parameters", "Ldev/steenbakker/mobile_scanner/MobileScannerStartedCallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "newCameraResolutionSelector", "stop", "toggleTorch", "enableTorch", "mobile_scanner_release"})
@SourceDebugExtension(value={"SMAP\nMobileScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileScanner.kt\ndev/steenbakker/mobile_scanner/MobileScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,465:1\n1#2:466\n*E\n"})
public final class MobileScanner {
    @NotNull
    private final Activity activity;
    @NotNull
    private final TextureRegistry textureRegistry;
    @NotNull
    private final Function4<List<? extends Map<String, ? extends Object>>, byte[], Integer, Integer, Unit> mobileScannerCallback;
    @NotNull
    private final Function1<String, Unit> mobileScannerErrorCallback;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    @Nullable
    private Camera camera;
    @Nullable
    private Preview preview;
    @Nullable
    private TextureRegistry.SurfaceTextureEntry textureEntry;
    @NotNull
    private BarcodeScanner scanner;
    @Nullable
    private List<String> lastScanned;
    private boolean scannerTimeout;
    @Nullable
    private DisplayManager.DisplayListener displayListener;
    @Nullable
    private List<Float> scanWindow;
    @NotNull
    private DetectionSpeed detectionSpeed;
    private long detectionTimeout;
    private boolean returnImage;
    @NotNull
    private final ImageAnalysis.Analyzer captureOutput;

    public MobileScanner(@NotNull Activity activity, @NotNull TextureRegistry textureRegistry, @NotNull Function4<? super List<? extends Map<String, ? extends Object>>, ? super byte[], ? super Integer, ? super Integer, Unit> mobileScannerCallback, @NotNull Function1<? super String, Unit> mobileScannerErrorCallback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)textureRegistry, (String)"textureRegistry");
        Intrinsics.checkNotNullParameter(mobileScannerCallback, (String)"mobileScannerCallback");
        Intrinsics.checkNotNullParameter(mobileScannerErrorCallback, (String)"mobileScannerErrorCallback");
        this.activity = activity;
        this.textureRegistry = textureRegistry;
        this.mobileScannerCallback = mobileScannerCallback;
        this.mobileScannerErrorCallback = mobileScannerErrorCallback;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient()");
        this.scanner = barcodeScanner;
        this.detectionSpeed = DetectionSpeed.NO_DUPLICATES;
        this.detectionTimeout = 250L;
        this.captureOutput = arg_0 -> MobileScanner.captureOutput$lambda$4(this, arg_0);
    }

    @Nullable
    public final List<Float> getScanWindow() {
        return this.scanWindow;
    }

    public final void setScanWindow(@Nullable List<Float> list) {
        this.scanWindow = list;
    }

    @NotNull
    public final ImageAnalysis.Analyzer getCaptureOutput() {
        return this.captureOutput;
    }

    @ExperimentalGetImage
    public static /* synthetic */ void getCaptureOutput$annotations() {
    }

    private final Bitmap rotateBitmap(Bitmap bitmap, float degrees) {
        Matrix matrix = new Matrix();
        matrix.postRotate(degrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(bitmap, 0, \u2026map.height, matrix, true)");
        return bitmap2;
    }

    private final boolean isBarcodeInScanWindow(List<Float> scanWindow, Barcode barcode, ImageProxy inputImage) {
        Rect rect = barcode.getBoundingBox();
        if (rect == null) {
            return false;
        }
        Rect barcodeBoundingBox = rect;
        int imageWidth = inputImage.getHeight();
        int imageHeight = inputImage.getWidth();
        int left = MathKt.roundToInt((float)(((Number)scanWindow.get(0)).floatValue() * (float)imageWidth));
        int top = MathKt.roundToInt((float)(((Number)scanWindow.get(1)).floatValue() * (float)imageHeight));
        int right = MathKt.roundToInt((float)(((Number)scanWindow.get(2)).floatValue() * (float)imageWidth));
        int bottom = MathKt.roundToInt((float)(((Number)scanWindow.get(3)).floatValue() * (float)imageHeight));
        Rect scaledScanWindow = new Rect(left, top, right, bottom);
        return scaledScanWindow.contains(barcodeBoundingBox);
    }

    private final Size getResolution(Size cameraResolution) {
        Size size;
        int n;
        if (Build.VERSION.SDK_INT >= 30) {
            Display display = this.activity.getDisplay();
            Intrinsics.checkNotNull((Object)display);
            n = display.getRotation();
        } else {
            Object object = this.activity.getApplicationContext().getSystemService("window");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
            WindowManager windowManager = (WindowManager)object;
            n = windowManager.getDefaultDisplay().getRotation();
        }
        int rotation = n;
        int widthMaxRes = cameraResolution.getWidth();
        int heightMaxRes = cameraResolution.getHeight();
        switch (rotation) {
            case 0: 
            case 2: {
                size = new Size(widthMaxRes, heightMaxRes);
                break;
            }
            default: {
                size = new Size(heightMaxRes, widthMaxRes);
            }
        }
        Size targetResolution = size;
        return targetResolution;
    }

    @ExperimentalGetImage
    public final void start(@Nullable BarcodeScannerOptions barcodeScannerOptions, boolean returnImage, @NotNull CameraSelector cameraPosition, boolean torch, @NotNull DetectionSpeed detectionSpeed, @NotNull Function1<? super Integer, Unit> torchStateCallback2, @NotNull Function1<? super Double, Unit> zoomScaleStateCallback2, @NotNull Function1<? super MobileScannerStartParameters, Unit> mobileScannerStartedCallback, @NotNull Function1<? super Exception, Unit> mobileScannerErrorCallback, long detectionTimeout, @Nullable Size cameraResolution, boolean newCameraResolutionSelector) {
        BarcodeScanner barcodeScanner;
        Intrinsics.checkNotNullParameter((Object)cameraPosition, (String)"cameraPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)detectionSpeed), (String)"detectionSpeed");
        Intrinsics.checkNotNullParameter(torchStateCallback2, (String)"torchStateCallback");
        Intrinsics.checkNotNullParameter(zoomScaleStateCallback2, (String)"zoomScaleStateCallback");
        Intrinsics.checkNotNullParameter(mobileScannerStartedCallback, (String)"mobileScannerStartedCallback");
        Intrinsics.checkNotNullParameter(mobileScannerErrorCallback, (String)"mobileScannerErrorCallback");
        this.detectionSpeed = detectionSpeed;
        this.detectionTimeout = detectionTimeout;
        this.returnImage = returnImage;
        Camera camera = this.camera;
        if ((camera != null ? camera.getCameraInfo() : null) != null && this.preview != null && this.textureEntry != null) {
            mobileScannerErrorCallback.invoke((Object)new AlreadyStarted());
            return;
        }
        this.lastScanned = null;
        if (barcodeScannerOptions != null) {
            BarcodeScanner barcodeScanner2 = BarcodeScanning.getClient((BarcodeScannerOptions)barcodeScannerOptions);
            barcodeScanner = barcodeScanner2;
            Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner2, (String)"{\n            BarcodeSca\u2026ScannerOptions)\n        }");
        } else {
            BarcodeScanner barcodeScanner3 = BarcodeScanning.getClient();
            barcodeScanner = barcodeScanner3;
            Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner3, (String)"{\n            BarcodeSca\u2026ing.getClient()\n        }");
        }
        this.scanner = barcodeScanner;
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)((Context)this.activity));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getInstance(activity)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        Executor executor = ContextCompat.getMainExecutor((Context)((Context)this.activity));
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getMainExecutor(activity)");
        Executor executor2 = executor;
        cameraProviderFuture.addListener(() -> MobileScanner.start$lambda$10(this, cameraProviderFuture, mobileScannerErrorCallback, cameraResolution, newCameraResolutionSelector, cameraPosition, mobileScannerStartedCallback, executor2, torch, torchStateCallback2, zoomScaleStateCallback2), executor2);
    }

    public final void stop() {
        if (this.isStopped()) {
            throw new AlreadyStopped();
        }
        if (this.displayListener != null) {
            Object object = this.activity.getApplicationContext().getSystemService("display");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
            DisplayManager displayManager = (DisplayManager)object;
            displayManager.unregisterDisplayListener(this.displayListener);
            this.displayListener = null;
        }
        Activity activity = this.activity;
        Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
        LifecycleOwner owner = (LifecycleOwner)activity;
        Camera camera = this.camera;
        if (camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getTorchState()) != null) {
            camera.removeObservers(owner);
        }
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        TextureRegistry.SurfaceTextureEntry surfaceTextureEntry = this.textureEntry;
        if (surfaceTextureEntry != null) {
            surfaceTextureEntry.release();
        }
        this.camera = null;
        this.preview = null;
        this.textureEntry = null;
        this.cameraProvider = null;
    }

    private final boolean isStopped() {
        return this.camera == null && this.preview == null;
    }

    public final void toggleTorch(boolean enableTorch) {
        block1: {
            Camera camera;
            if (this.camera == null) {
                return;
            }
            Camera camera2 = this.camera;
            boolean bl = camera2 != null && (camera2 = camera2.getCameraInfo()) != null ? camera2.hasFlashUnit() : false;
            if (!bl || (camera = this.camera) == null || (camera = camera.getCameraControl()) == null) break block1;
            camera.enableTorch(enableTorch);
        }
    }

    public final void analyzeImage(@NotNull Uri image, @NotNull Function1<? super List<? extends Map<String, ? extends Object>>, Unit> analyzerCallback2) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(analyzerCallback2, (String)"analyzerCallback");
        InputImage inputImage = InputImage.fromFilePath((Context)((Context)this.activity), (Uri)image);
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromFilePath(activity, image)");
        InputImage inputImage2 = inputImage;
        this.scanner.process(inputImage2).addOnSuccessListener(arg_0 -> MobileScanner.analyzeImage$lambda$11((Function1)new Function1<List<Barcode>, Unit>(analyzerCallback2){
            final /* synthetic */ Function1<List<? extends Map<String, ? extends Object>>, Unit> $analyzerCallback;
            {
                this.$analyzerCallback = $analyzerCallback;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<Barcode> barcodes) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullExpressionValue(barcodes, (String)"barcodes");
                Iterable $this$map$iv = barcodes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void barcode;
                    Barcode barcode2 = (Barcode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)barcode, (String)"barcode");
                    collection.add(MobileScannerUtilitiesKt.getData((Barcode)barcode));
                }
                List barcodeMap = (List)destination$iv$iv;
                if (!((Collection)barcodeMap).isEmpty()) {
                    this.$analyzerCallback.invoke((Object)barcodeMap);
                } else {
                    this.$analyzerCallback.invoke(null);
                }
            }
        }, arg_0)).addOnFailureListener(arg_0 -> MobileScanner.analyzeImage$lambda$12(this, arg_0));
    }

    public final void setScale(double scale) {
        block2: {
            if (scale > 1.0 || scale < 0.0) {
                throw new ZoomNotInRange();
            }
            if (this.camera == null) {
                throw new ZoomWhenStopped();
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block2;
            camera.setLinearZoom((float)scale);
        }
    }

    public final void resetScale() {
        block1: {
            if (this.camera == null) {
                throw new ZoomWhenStopped();
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block1;
            camera.setZoomRatio(1.0f);
        }
    }

    private static final void captureOutput$lambda$4$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void captureOutput$lambda$4$lambda$1(MobileScanner this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Function1<String, Unit> function1 = this$0.mobileScannerErrorCallback;
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.toString();
        }
        function1.invoke((Object)string);
    }

    private static final void captureOutput$lambda$4$lambda$2(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)$imageProxy, (String)"$imageProxy");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    private static final void captureOutput$lambda$4$lambda$3(MobileScanner this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scannerTimeout = false;
    }

    private static final void captureOutput$lambda$4(MobileScanner this$0, ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Image image = imageProxy.getImage();
        if (image == null) {
            return;
        }
        Image mediaImage = image;
        InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(mediaImag\u2026mageInfo.rotationDegrees)");
        InputImage inputImage2 = inputImage;
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL && this$0.scannerTimeout) {
            imageProxy.close();
            return;
        }
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL) {
            this$0.scannerTimeout = true;
        }
        this$0.scanner.process(inputImage2).addOnSuccessListener(arg_0 -> MobileScanner.captureOutput$lambda$4$lambda$0((Function1)new Function1<List<Barcode>, Unit>(this$0, imageProxy, mediaImage){
            final /* synthetic */ MobileScanner this$0;
            final /* synthetic */ ImageProxy $imageProxy;
            final /* synthetic */ Image $mediaImage;
            {
                this.this$0 = $receiver;
                this.$imageProxy = $imageProxy;
                this.$mediaImage = $mediaImage;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<Barcode> barcodes) {
                if (MobileScanner.access$getDetectionSpeed$p(this.this$0) == DetectionSpeed.NO_DUPLICATES) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullExpressionValue(barcodes, (String)"barcodes");
                    Iterable $this$mapNotNull$iv = barcodes;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Barcode barcode = (Barcode)element$iv$iv;
                        boolean bl2 = false;
                        if (barcode.getRawValue() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List newScannedBarcodes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                    if (Intrinsics.areEqual((Object)newScannedBarcodes, (Object)MobileScanner.access$getLastScanned$p(this.this$0))) {
                        return;
                    }
                    if (!((Collection)newScannedBarcodes).isEmpty()) {
                        MobileScanner.access$setLastScanned$p(this.this$0, newScannedBarcodes);
                    }
                }
                List barcodeMap = new ArrayList<E>();
                for (Barcode barcode : barcodes) {
                    if (this.this$0.getScanWindow() != null) {
                        List<Float> list = this.this$0.getScanWindow();
                        Intrinsics.checkNotNull(list);
                        Intrinsics.checkNotNullExpressionValue((Object)barcode, (String)"barcode");
                        ImageProxy imageProxy = this.$imageProxy;
                        Intrinsics.checkNotNullExpressionValue((Object)imageProxy, (String)"imageProxy");
                        boolean match = MobileScanner.access$isBarcodeInScanWindow(this.this$0, list, barcode, imageProxy);
                        if (!match) continue;
                        barcodeMap.add(MobileScannerUtilitiesKt.getData(barcode));
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)barcode, (String)"barcode");
                    barcodeMap.add(MobileScannerUtilitiesKt.getData(barcode));
                }
                if (!((Collection)barcodeMap).isEmpty()) {
                    if (MobileScanner.access$getReturnImage$p(this.this$0)) {
                        Bitmap bitmap = Bitmap.createBitmap((int)this.$mediaImage.getWidth(), (int)this.$mediaImage.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Context context = MobileScanner.access$getActivity$p(this.this$0).getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                        YuvToRgbConverter imageFormat = new YuvToRgbConverter(context);
                        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                        imageFormat.yuvToRgb(this.$mediaImage, bitmap);
                        Camera camera = MobileScanner.access$getCamera$p(this.this$0);
                        Bitmap bmResult = MobileScanner.access$rotateBitmap(this.this$0, bitmap, camera != null && (camera = camera.getCameraInfo()) != null ? (float)camera.getSensorRotationDegrees() : 90.0f);
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        bmResult.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                        byte[] byteArray = stream.toByteArray();
                        int bmWidth = bmResult.getWidth();
                        int bmHeight = bmResult.getHeight();
                        bmResult.recycle();
                        MobileScanner.access$getMobileScannerCallback$p(this.this$0).invoke((Object)barcodeMap, (Object)byteArray, (Object)bmWidth, (Object)bmHeight);
                    } else {
                        MobileScanner.access$getMobileScannerCallback$p(this.this$0).invoke((Object)barcodeMap, null, null, null);
                    }
                }
            }
        }, arg_0)).addOnFailureListener(arg_0 -> MobileScanner.captureOutput$lambda$4$lambda$1(this$0, arg_0)).addOnCompleteListener(arg_0 -> MobileScanner.captureOutput$lambda$4$lambda$2(imageProxy, arg_0));
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> MobileScanner.captureOutput$lambda$4$lambda$3(this$0), this$0.detectionTimeout);
        }
    }

    private static final void start$lambda$10$lambda$6$lambda$5(SurfaceRequest.Result it) {
    }

    private static final void start$lambda$10$lambda$6(MobileScanner this$0, Executor $executor, SurfaceRequest request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this$0.isStopped()) {
            return;
        }
        TextureRegistry.SurfaceTextureEntry surfaceTextureEntry = this$0.textureEntry;
        Intrinsics.checkNotNull((Object)surfaceTextureEntry);
        SurfaceTexture surfaceTexture = surfaceTextureEntry.surfaceTexture();
        Intrinsics.checkNotNullExpressionValue((Object)surfaceTexture, (String)"textureEntry!!.surfaceTexture()");
        SurfaceTexture texture = surfaceTexture;
        texture.setDefaultBufferSize(request.getResolution().getWidth(), request.getResolution().getHeight());
        Surface surface = new Surface(texture);
        request.provideSurface(surface, $executor, MobileScanner::start$lambda$10$lambda$6$lambda$5);
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$10(MobileScanner this$0, ListenableFuture $cameraProviderFuture, Function1 $mobileScannerErrorCallback, Size $cameraResolution, boolean $newCameraResolutionSelector, CameraSelector $cameraPosition, Function1 $mobileScannerStartedCallback, Executor $executor, boolean $torch, Function1 $torchStateCallback, Function1 $zoomScaleStateCallback) {
        UseCase[] useCaseArray;
        void $this$start_u24lambda_u2410_u24lambda_u247;
        Preview preview;
        Integer numberOfCameras;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraProviderFuture, (String)"$cameraProviderFuture");
        Intrinsics.checkNotNullParameter((Object)$mobileScannerErrorCallback, (String)"$mobileScannerErrorCallback");
        Intrinsics.checkNotNullParameter((Object)$cameraPosition, (String)"$cameraPosition");
        Intrinsics.checkNotNullParameter((Object)$mobileScannerStartedCallback, (String)"$mobileScannerStartedCallback");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$torchStateCallback, (String)"$torchStateCallback");
        Intrinsics.checkNotNullParameter((Object)$zoomScaleStateCallback, (String)"$zoomScaleStateCallback");
        this$0.cameraProvider = (ProcessCameraProvider)$cameraProviderFuture.get();
        Object object = this$0.cameraProvider;
        Integer n = object != null && (object = object.getAvailableCameraInfos()) != null ? Integer.valueOf(object.size()) : (numberOfCameras = null);
        if (this$0.cameraProvider == null) {
            $mobileScannerErrorCallback.invoke((Object)new CameraError());
            return;
        }
        ProcessCameraProvider processCameraProvider = this$0.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        this$0.textureEntry = this$0.textureRegistry.createSurfaceTexture();
        Preview.SurfaceProvider surfaceProvider = arg_0 -> MobileScanner.start$lambda$10$lambda$6(this$0, $executor, arg_0);
        Preview.Builder previewBuilder = new Preview.Builder();
        Preview preview2 = preview = previewBuilder.build();
        MobileScanner mobileScanner = this$0;
        boolean bl = false;
        $this$start_u24lambda_u2410_u24lambda_u247.setSurfaceProvider(surfaceProvider);
        mobileScanner.preview = preview;
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder().setBackpressureStrategy(0);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n              \u2026TRATEGY_KEEP_ONLY_LATEST)");
        ImageAnalysis.Builder analysisBuilder = builder;
        Object object2 = this$0.activity.getApplicationContext().getSystemService("display");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
        DisplayManager displayManager = (DisplayManager)object2;
        if ($cameraResolution != null) {
            if ($newCameraResolutionSelector) {
                ResolutionSelector.Builder selectorBuilder = new ResolutionSelector.Builder();
                selectorBuilder.setResolutionStrategy(new ResolutionStrategy($cameraResolution, 1));
                analysisBuilder.setResolutionSelector(selectorBuilder.build()).build();
            } else {
                analysisBuilder.setTargetResolution(this$0.getResolution($cameraResolution));
            }
            if (this$0.displayListener == null) {
                this$0.displayListener = new DisplayManager.DisplayListener($newCameraResolutionSelector, $cameraResolution, analysisBuilder, this$0){
                    final /* synthetic */ boolean $newCameraResolutionSelector;
                    final /* synthetic */ Size $cameraResolution;
                    final /* synthetic */ ImageAnalysis.Builder $analysisBuilder;
                    final /* synthetic */ MobileScanner this$0;
                    {
                        this.$newCameraResolutionSelector = $newCameraResolutionSelector;
                        this.$cameraResolution = $cameraResolution;
                        this.$analysisBuilder = $analysisBuilder;
                        this.this$0 = $receiver;
                    }

                    public void onDisplayAdded(int displayId) {
                    }

                    public void onDisplayRemoved(int displayId) {
                    }

                    public void onDisplayChanged(int displayId) {
                        if (this.$newCameraResolutionSelector) {
                            ResolutionSelector.Builder selectorBuilder = new ResolutionSelector.Builder();
                            selectorBuilder.setResolutionStrategy(new ResolutionStrategy(this.$cameraResolution, 1));
                            this.$analysisBuilder.setResolutionSelector(selectorBuilder.build()).build();
                        } else {
                            this.$analysisBuilder.setTargetResolution(MobileScanner.access$getResolution(this.this$0, this.$cameraResolution));
                        }
                    }
                };
                displayManager.registerDisplayListener(this$0.displayListener, null);
            }
        }
        UseCase[] $this$start_u24lambda_u2410_u24lambda_u248 = useCaseArray = analysisBuilder.build();
        boolean bl2 = false;
        $this$start_u24lambda_u2410_u24lambda_u248.setAnalyzer($executor, this$0.captureOutput);
        Intrinsics.checkNotNullExpressionValue((Object)useCaseArray, (String)"analysisBuilder.build().\u2026xecutor, captureOutput) }");
        UseCase[] analysis = useCaseArray;
        try {
            Camera camera;
            ProcessCameraProvider processCameraProvider2 = this$0.cameraProvider;
            if (processCameraProvider2 != null) {
                Activity activity = this$0.activity;
                Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
                useCaseArray = new UseCase[]{this$0.preview, analysis};
                camera = processCameraProvider2.bindToLifecycle((LifecycleOwner)activity, $cameraPosition, useCaseArray);
            } else {
                camera = null;
            }
            this$0.camera = camera;
        }
        catch (Exception exception) {
            $mobileScannerErrorCallback.invoke((Object)new NoCamera());
            return;
        }
        Camera camera = this$0.camera;
        if (camera != null) {
            Camera it = camera;
            boolean bl3 = false;
            LiveData liveData = it.getCameraInfo().getTorchState();
            Activity activity = this$0.activity;
            Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
            Function1 function1 = (Function1)new Function1<Integer, Unit>((Function1<? super Integer, Unit>)$torchStateCallback){
                final /* synthetic */ Function1<Integer, Unit> $torchStateCallback;
                {
                    this.$torchStateCallback = $torchStateCallback;
                    super(1);
                }

                public final void invoke(Integer state) {
                    Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
                    this.$torchStateCallback.invoke((Object)state);
                }
            };
            liveData.observe((LifecycleOwner)activity, new Observer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void onChanged(Object value) {
                    this.function.invoke(value);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            function1 = (Function1)new Function1<ZoomState, Unit>((Function1<? super Double, Unit>)$zoomScaleStateCallback){
                final /* synthetic */ Function1<Double, Unit> $zoomScaleStateCallback;
                {
                    this.$zoomScaleStateCallback = $zoomScaleStateCallback;
                    super(1);
                }

                public final void invoke(ZoomState state) {
                    this.$zoomScaleStateCallback.invoke((Object)state.getLinearZoom());
                }
            };
            it.getCameraInfo().getZoomState().observe((LifecycleOwner)this$0.activity, new /* invalid duplicate definition of identical inner class */);
            if (it.getCameraInfo().hasFlashUnit()) {
                it.getCameraControl().enableTorch($torch);
            }
        }
        ResolutionInfo resolutionInfo = analysis.getResolutionInfo();
        Intrinsics.checkNotNull((Object)resolutionInfo);
        Size size = resolutionInfo.getResolution();
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"analysis.resolutionInfo!!.resolution");
        Size resolution = size;
        double width = resolution.getWidth();
        double height = resolution.getHeight();
        Camera camera2 = this$0.camera;
        boolean portrait = (camera2 != null && (camera2 = camera2.getCameraInfo()) != null ? camera2.getSensorRotationDegrees() : 0) % 180 == 0;
        double d = portrait ? width : height;
        double d2 = portrait ? height : width;
        Camera camera3 = this$0.camera;
        boolean bl4 = camera3 != null && (camera3 = camera3.getCameraInfo()) != null ? camera3.hasFlashUnit() : false;
        TextureRegistry.SurfaceTextureEntry surfaceTextureEntry = this$0.textureEntry;
        Intrinsics.checkNotNull((Object)surfaceTextureEntry);
        Integer n2 = numberOfCameras;
        $mobileScannerStartedCallback.invoke((Object)new MobileScannerStartParameters(d, d2, bl4, surfaceTextureEntry.id(), n2 != null ? n2 : 0));
    }

    private static final void analyzeImage$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void analyzeImage$lambda$12(MobileScanner this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Function1<String, Unit> function1 = this$0.mobileScannerErrorCallback;
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.toString();
        }
        function1.invoke((Object)string);
    }

    public static final /* synthetic */ DetectionSpeed access$getDetectionSpeed$p(MobileScanner $this) {
        return $this.detectionSpeed;
    }

    public static final /* synthetic */ List access$getLastScanned$p(MobileScanner $this) {
        return $this.lastScanned;
    }

    public static final /* synthetic */ void access$setLastScanned$p(MobileScanner $this, List list) {
        $this.lastScanned = list;
    }

    public static final /* synthetic */ boolean access$isBarcodeInScanWindow(MobileScanner $this, List scanWindow, Barcode barcode, ImageProxy inputImage) {
        return $this.isBarcodeInScanWindow(scanWindow, barcode, inputImage);
    }

    public static final /* synthetic */ boolean access$getReturnImage$p(MobileScanner $this) {
        return $this.returnImage;
    }

    public static final /* synthetic */ Activity access$getActivity$p(MobileScanner $this) {
        return $this.activity;
    }

    public static final /* synthetic */ Bitmap access$rotateBitmap(MobileScanner $this, Bitmap bitmap, float degrees) {
        return $this.rotateBitmap(bitmap, degrees);
    }

    public static final /* synthetic */ Camera access$getCamera$p(MobileScanner $this) {
        return $this.camera;
    }

    public static final /* synthetic */ Function4 access$getMobileScannerCallback$p(MobileScanner $this) {
        return $this.mobileScannerCallback;
    }

    public static final /* synthetic */ Size access$getResolution(MobileScanner $this, Size cameraResolution) {
        return $this.getResolution(cameraResolution);
    }
}

