/*
 * Decompiled with CFR 0.152.
 */
package com.nb.nb_utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0014\u001a\u00020\u0012H\u0016J\u001c\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/nb/nb_utils/NbUtilsPlugin;", "Lio/flutter/embedding/engine/plugins/FlutterPlugin;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "()V", "appContext", "Landroid/content/Context;", "channel", "Lio/flutter/plugin/common/MethodChannel;", "getLongVersionCode", "", "info", "Landroid/content/pm/PackageInfo;", "getMaterialYouColours", "", "", "onAttachedToEngine", "", "flutterPluginBinding", "Lio/flutter/embedding/engine/plugins/FlutterPlugin$FlutterPluginBinding;", "onDetachedFromEngine", "binding", "onMethodCall", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "Lio/flutter/plugin/common/MethodChannel$Result;", "packageInfo", "", "nb_utils_release"})
@SourceDebugExtension(value={"SMAP\nNbUtilsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NbUtilsPlugin.kt\ncom/nb/nb_utils/NbUtilsPlugin\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n125#2:173\n152#2,3:174\n*S KotlinDebug\n*F\n+ 1 NbUtilsPlugin.kt\ncom/nb/nb_utils/NbUtilsPlugin\n*L\n160#1:173\n160#1:174,3\n*E\n"})
public final class NbUtilsPlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    private MethodChannel channel;
    @Nullable
    private Context appContext;

    public void onAttachedToEngine(@NonNull @NotNull FlutterPlugin.FlutterPluginBinding flutterPluginBinding) {
        Intrinsics.checkNotNullParameter((Object)flutterPluginBinding, (String)"flutterPluginBinding");
        this.channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "nb_utils");
        MethodChannel methodChannel = this.channel;
        if (methodChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
            methodChannel = null;
        }
        methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.appContext = flutterPluginBinding.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onMethodCall(@NonNull @NotNull MethodCall call, @NonNull @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = call.method;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1196932856: {
                    if (!string.equals("materialYouColors")) break;
                    n = 1;
                    break;
                }
                case -800923529: {
                    if (!string.equals("isAndroid12Above")) break;
                    n = 2;
                    break;
                }
                case 1385449135: {
                    if (!string.equals("getPlatformVersion")) break;
                    n = 3;
                    break;
                }
                case 908622356: {
                    if (!string.equals("packageInfo")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    result.success((Object)("Android " + Build.VERSION.RELEASE));
                    return;
                }
                case 2: {
                    result.success((Object)(Build.VERSION.SDK_INT >= 31 ? 1 : 0));
                    return;
                }
                case 1: {
                    result.success(this.getMaterialYouColours());
                    return;
                }
                case 4: {
                    result.success(this.packageInfo());
                    return;
                }
            }
        }
        result.notImplemented();
    }

    private final Map<String, Object> packageInfo() {
        String string;
        PackageInfo packageInfo;
        Context context = this.appContext;
        Intrinsics.checkNotNull((Object)context);
        PackageManager packageManager = context.getPackageManager();
        if (Build.VERSION.SDK_INT >= 33) {
            Context context2 = this.appContext;
            Intrinsics.checkNotNull((Object)context2);
            PackageInfo packageInfo2 = packageManager.getPackageInfo(context2.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
            packageInfo = packageInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"{\n            packageMan\u2026nfoFlags.of(0))\n        }");
        } else {
            Context context3 = this.appContext;
            Intrinsics.checkNotNull((Object)context3);
            PackageInfo packageInfo3 = packageManager.getPackageInfo(context3.getPackageName(), 0);
            packageInfo = packageInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo3, (String)"{\n            @Suppress(\u2026packageName, 0)\n        }");
        }
        PackageInfo packageInfo4 = packageInfo;
        String appName = "";
        ApplicationInfo applicationInfo = packageInfo4.applicationInfo;
        int stringId = applicationInfo.labelRes;
        if (stringId == 0) {
            string = ((Object)applicationInfo.nonLocalizedLabel).toString();
        } else {
            Context context4 = this.appContext;
            Intrinsics.checkNotNull((Object)context4);
            String string2 = context4.getString(stringId);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            appContext\u2026tring(stringId)\n        }");
        }
        appName = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appName", (Object)appName), TuplesKt.to((Object)"packageName", (Object)packageInfo4.packageName), TuplesKt.to((Object)"versionName", (Object)packageInfo4.versionName), TuplesKt.to((Object)"versionCode", (Object)String.valueOf(this.getLongVersionCode(packageInfo4))), TuplesKt.to((Object)"androidSDKVersion", (Object)Build.VERSION.SDK_INT)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final long getLongVersionCode(PackageInfo info) {
        return Build.VERSION.SDK_INT >= 28 ? info.getLongVersionCode() : (long)info.versionCode;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getMaterialYouColours() {
        void $this$mapTo$iv$iv;
        if (Build.VERSION.SDK_INT < 31) {
            return null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"system_accent1_0", (Object)17170487), TuplesKt.to((Object)"system_accent1_10", (Object)17170488), TuplesKt.to((Object)"system_accent1_50", (Object)17170489), TuplesKt.to((Object)"system_accent1_100", (Object)17170490), TuplesKt.to((Object)"system_accent1_200", (Object)17170491), TuplesKt.to((Object)"system_accent1_300", (Object)17170492), TuplesKt.to((Object)"system_accent1_400", (Object)17170493), TuplesKt.to((Object)"system_accent1_500", (Object)17170494), TuplesKt.to((Object)"system_accent1_600", (Object)17170495), TuplesKt.to((Object)"system_accent1_700", (Object)17170496), TuplesKt.to((Object)"system_accent1_800", (Object)17170497), TuplesKt.to((Object)"system_accent1_900", (Object)17170498), TuplesKt.to((Object)"system_accent1_1000", (Object)17170499), TuplesKt.to((Object)"system_accent2_0", (Object)17170500), TuplesKt.to((Object)"system_accent2_10", (Object)17170501), TuplesKt.to((Object)"system_accent2_50", (Object)17170502), TuplesKt.to((Object)"system_accent2_100", (Object)17170503), TuplesKt.to((Object)"system_accent2_200", (Object)17170504), TuplesKt.to((Object)"system_accent2_300", (Object)17170505), TuplesKt.to((Object)"system_accent2_400", (Object)17170506), TuplesKt.to((Object)"system_accent2_500", (Object)17170507), TuplesKt.to((Object)"system_accent2_600", (Object)17170508), TuplesKt.to((Object)"system_accent2_700", (Object)17170509), TuplesKt.to((Object)"system_accent2_800", (Object)17170510), TuplesKt.to((Object)"system_accent2_900", (Object)17170511), TuplesKt.to((Object)"system_accent2_1000", (Object)17170512), TuplesKt.to((Object)"system_accent3_0", (Object)17170513), TuplesKt.to((Object)"system_accent3_10", (Object)17170514), TuplesKt.to((Object)"system_accent3_50", (Object)17170515), TuplesKt.to((Object)"system_accent3_100", (Object)17170516), TuplesKt.to((Object)"system_accent3_200", (Object)17170517), TuplesKt.to((Object)"system_accent3_300", (Object)17170518), TuplesKt.to((Object)"system_accent3_400", (Object)17170519), TuplesKt.to((Object)"system_accent3_500", (Object)17170520), TuplesKt.to((Object)"system_accent3_600", (Object)17170521), TuplesKt.to((Object)"system_accent3_700", (Object)17170522), TuplesKt.to((Object)"system_accent3_800", (Object)17170523), TuplesKt.to((Object)"system_accent3_900", (Object)17170524), TuplesKt.to((Object)"system_accent3_1000", (Object)17170525), TuplesKt.to((Object)"system_neutral1_0", (Object)17170461), TuplesKt.to((Object)"system_neutral1_10", (Object)17170462), TuplesKt.to((Object)"system_neutral1_50", (Object)17170463), TuplesKt.to((Object)"system_neutral1_100", (Object)17170464), TuplesKt.to((Object)"system_neutral1_200", (Object)17170465), TuplesKt.to((Object)"system_neutral1_300", (Object)17170466), TuplesKt.to((Object)"system_neutral1_400", (Object)17170467), TuplesKt.to((Object)"system_neutral1_500", (Object)17170468), TuplesKt.to((Object)"system_neutral1_600", (Object)17170469), TuplesKt.to((Object)"system_neutral1_700", (Object)17170470), TuplesKt.to((Object)"system_neutral1_800", (Object)17170471), TuplesKt.to((Object)"system_neutral1_900", (Object)17170472), TuplesKt.to((Object)"system_neutral1_1000", (Object)17170473), TuplesKt.to((Object)"system_neutral2_0", (Object)17170474), TuplesKt.to((Object)"system_neutral2_10", (Object)17170475), TuplesKt.to((Object)"system_neutral2_50", (Object)17170476), TuplesKt.to((Object)"system_neutral2_100", (Object)17170477), TuplesKt.to((Object)"system_neutral2_200", (Object)17170478), TuplesKt.to((Object)"system_neutral2_300", (Object)17170479), TuplesKt.to((Object)"system_neutral2_400", (Object)17170480), TuplesKt.to((Object)"system_neutral2_500", (Object)17170481), TuplesKt.to((Object)"system_neutral2_600", (Object)17170482), TuplesKt.to((Object)"system_neutral2_700", (Object)17170483), TuplesKt.to((Object)"system_neutral2_800", (Object)17170484), TuplesKt.to((Object)"system_neutral2_900", (Object)17170485), TuplesKt.to((Object)"system_neutral2_1000", (Object)17170486)};
        Map $this$map$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            int id = ((Number)entry.getValue()).intValue();
            Context context = this.appContext;
            Intrinsics.checkNotNull((Object)context);
            Resources resources = context.getResources();
            Context context2 = this.appContext;
            Intrinsics.checkNotNull((Object)context2);
            int color = ResourcesCompat.getColor((Resources)resources, (int)id, (Resources.Theme)context2.getTheme());
            String colorHex = Integer.toHexString(color);
            collection.add(TuplesKt.to((Object)name, (Object)colorHex));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public void onDetachedFromEngine(@NonNull @NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        MethodChannel methodChannel = this.channel;
        if (methodChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
            methodChannel = null;
        }
        methodChannel.setMethodCallHandler(null);
    }
}

