/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.sharedpreferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.sharedpreferences.Messages;
import io.flutter.plugins.sharedpreferences.SharedPreferencesListEncoder;
import io.flutter.plugins.sharedpreferences.StringListObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LegacySharedPreferencesPlugin
implements FlutterPlugin,
Messages.SharedPreferencesApi {
    private static final String TAG = "SharedPreferencesPlugin";
    private static final String SHARED_PREFERENCES_NAME = "FlutterSharedPreferences";
    private static final String LIST_IDENTIFIER = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu";
    private static final String JSON_LIST_IDENTIFIER = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu!";
    private static final String BIG_INTEGER_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBCaWdJbnRlZ2Vy";
    private static final String DOUBLE_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBEb3VibGUu";
    private SharedPreferences preferences;
    private final SharedPreferencesListEncoder listEncoder;

    public LegacySharedPreferencesPlugin() {
        this(new ListEncoder());
    }

    @VisibleForTesting
    LegacySharedPreferencesPlugin(@NonNull SharedPreferencesListEncoder listEncoder) {
        this.listEncoder = listEncoder;
    }

    private void setUp(@NonNull BinaryMessenger messenger, @NonNull Context context) {
        this.preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        try {
            Messages.SharedPreferencesApi.setUp(messenger, this);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Received exception while setting up SharedPreferencesPlugin", (Throwable)ex);
        }
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.setUp(binding.getBinaryMessenger(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        Messages.SharedPreferencesApi.setUp(binding.getBinaryMessenger(), null);
    }

    @Override
    @NonNull
    public Boolean setBool(@NonNull String key, @NonNull Boolean value) {
        return this.preferences.edit().putBoolean(key, value.booleanValue()).commit();
    }

    @Override
    @NonNull
    public Boolean setString(@NonNull String key, @NonNull String value) {
        if (value.startsWith(LIST_IDENTIFIER) || value.startsWith(BIG_INTEGER_PREFIX) || value.startsWith(DOUBLE_PREFIX)) {
            throw new RuntimeException("StorageError: This string cannot be stored as it clashes with special identifier prefixes");
        }
        return this.preferences.edit().putString(key, value).commit();
    }

    @Override
    @NonNull
    public Boolean setInt(@NonNull String key, @NonNull Long value) {
        return this.preferences.edit().putLong(key, value.longValue()).commit();
    }

    @Override
    @NonNull
    public Boolean setDouble(@NonNull String key, @NonNull Double value) {
        String doubleValueStr = Double.toString(value);
        return this.preferences.edit().putString(key, DOUBLE_PREFIX + doubleValueStr).commit();
    }

    @Override
    @NonNull
    public Boolean remove(@NonNull String key) {
        return this.preferences.edit().remove(key).commit();
    }

    @Override
    @NonNull
    public Boolean setEncodedStringList(@NonNull String key, @NonNull String value) throws RuntimeException {
        return this.preferences.edit().putString(key, value).commit();
    }

    @Override
    @Deprecated
    @NonNull
    public Boolean setDeprecatedStringList(@NonNull String key, @NonNull List<String> value) throws RuntimeException {
        return this.preferences.edit().putString(key, LIST_IDENTIFIER + this.listEncoder.encode(value)).commit();
    }

    @Override
    @NonNull
    public Map<String, Object> getAll(@NonNull String prefix, @Nullable List<String> allowList) throws RuntimeException {
        HashSet<String> allowSet = allowList == null ? null : new HashSet<String>(allowList);
        return this.getAllPrefs(prefix, allowSet);
    }

    @Override
    @NonNull
    public Boolean clear(@NonNull String prefix, @Nullable List<String> allowList) throws RuntimeException {
        SharedPreferences.Editor clearEditor = this.preferences.edit();
        Map allPrefs = this.preferences.getAll();
        ArrayList<String> filteredPrefs = new ArrayList<String>();
        for (String key : allPrefs.keySet()) {
            if (!key.startsWith(prefix) || allowList != null && !allowList.contains(key)) continue;
            filteredPrefs.add(key);
        }
        for (String key : filteredPrefs) {
            clearEditor.remove(key);
        }
        return clearEditor.commit();
    }

    @NonNull
    private Map<String, Object> getAllPrefs(@NonNull String prefix, @Nullable Set<String> allowList) throws RuntimeException {
        Map allPrefs = this.preferences.getAll();
        HashMap<String, Object> filteredPrefs = new HashMap<String, Object>();
        for (String key : allPrefs.keySet()) {
            if (!key.startsWith(prefix) || allowList != null && !allowList.contains(key)) continue;
            filteredPrefs.put(key, this.transformPref(key, Objects.requireNonNull(allPrefs.get(key))));
        }
        return filteredPrefs;
    }

    private Object transformPref(@NonNull String key, @NonNull Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.startsWith(LIST_IDENTIFIER)) {
                if (stringValue.startsWith(JSON_LIST_IDENTIFIER)) {
                    return value;
                }
                return this.listEncoder.decode(stringValue.substring(LIST_IDENTIFIER.length()));
            }
            if (stringValue.startsWith(BIG_INTEGER_PREFIX)) {
                String encoded = stringValue.substring(BIG_INTEGER_PREFIX.length());
                return new BigInteger(encoded, 36);
            }
            if (stringValue.startsWith(DOUBLE_PREFIX)) {
                String doubleStr = stringValue.substring(DOUBLE_PREFIX.length());
                return Double.valueOf(doubleStr);
            }
        } else if (value instanceof Set) {
            ArrayList<String> listValue = new ArrayList<String>((Set)value);
            this.preferences.edit().remove(key).putString(key, LIST_IDENTIFIER + this.listEncoder.encode(listValue)).apply();
            return listValue;
        }
        return value;
    }

    static class ListEncoder
    implements SharedPreferencesListEncoder {
        ListEncoder() {
        }

        @Override
        @NonNull
        public String encode(@NonNull List<String> list) throws RuntimeException {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                stream.writeObject(list);
                stream.flush();
                return Base64.encodeToString((byte[])byteStream.toByteArray(), (int)0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NonNull
        public List<String> decode(@NonNull String listString) throws RuntimeException {
            try {
                StringListObjectInputStream stream = new StringListObjectInputStream(new ByteArrayInputStream(Base64.decode((String)listString, (int)0)));
                return (List)stream.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

