/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;

class DisplayListenerProxy {
    private static final String TAG = "DisplayListenerProxy";
    private ArrayList<DisplayManager.DisplayListener> listenersBeforeWebView;

    DisplayListenerProxy() {
    }

    void onPreWebViewInitialization(DisplayManager displayManager) {
        this.listenersBeforeWebView = DisplayListenerProxy.yoinkDisplayListeners(displayManager);
    }

    void onPostWebViewInitialization(final DisplayManager displayManager) {
        final ArrayList<DisplayManager.DisplayListener> webViewListeners = DisplayListenerProxy.yoinkDisplayListeners(displayManager);
        webViewListeners.removeAll(this.listenersBeforeWebView);
        if (webViewListeners.isEmpty()) {
            return;
        }
        for (DisplayManager.DisplayListener webViewListener : webViewListeners) {
            displayManager.unregisterDisplayListener(webViewListener);
            displayManager.registerDisplayListener(new DisplayManager.DisplayListener(){

                public void onDisplayAdded(int displayId) {
                    for (DisplayManager.DisplayListener webViewListener : webViewListeners) {
                        webViewListener.onDisplayAdded(displayId);
                    }
                }

                public void onDisplayRemoved(int displayId) {
                    for (DisplayManager.DisplayListener webViewListener : webViewListeners) {
                        webViewListener.onDisplayRemoved(displayId);
                    }
                }

                public void onDisplayChanged(int displayId) {
                    if (displayManager.getDisplay(displayId) == null) {
                        return;
                    }
                    for (DisplayManager.DisplayListener webViewListener : webViewListeners) {
                        webViewListener.onDisplayChanged(displayId);
                    }
                }
            }, null);
        }
    }

    private static ArrayList<DisplayManager.DisplayListener> yoinkDisplayListeners(DisplayManager displayManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new ArrayList<DisplayManager.DisplayListener>();
        }
        try {
            Field displayManagerGlobalField = DisplayManager.class.getDeclaredField("mGlobal");
            displayManagerGlobalField.setAccessible(true);
            Object displayManagerGlobal = displayManagerGlobalField.get(displayManager);
            Field displayListenersField = displayManagerGlobal.getClass().getDeclaredField("mDisplayListeners");
            displayListenersField.setAccessible(true);
            ArrayList delegates = (ArrayList)displayListenersField.get(displayManagerGlobal);
            Field listenerField = null;
            ArrayList<DisplayManager.DisplayListener> listeners = new ArrayList<DisplayManager.DisplayListener>();
            for (Object delegate : delegates) {
                if (listenerField == null) {
                    listenerField = delegate.getClass().getField("mListener");
                    listenerField.setAccessible(true);
                }
                DisplayManager.DisplayListener listener = (DisplayManager.DisplayListener)listenerField.get(delegate);
                listeners.add(listener);
            }
            return listeners;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Log.w((String)TAG, (String)("Could not extract WebView's display listeners. " + e));
            return new ArrayList<DisplayManager.DisplayListener>();
        }
    }
}

