/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugins.webviewflutter.AndroidWebkitLibraryPigeonInstanceManager;

class FlutterViewFactory
extends PlatformViewFactory {
    private final AndroidWebkitLibraryPigeonInstanceManager instanceManager;

    FlutterViewFactory(AndroidWebkitLibraryPigeonInstanceManager instanceManager) {
        super((MessageCodec)StandardMessageCodec.INSTANCE);
        this.instanceManager = instanceManager;
    }

    @NonNull
    public PlatformView create(Context context, int viewId, @Nullable Object args) {
        Integer identifier = (Integer)args;
        if (identifier == null) {
            throw new IllegalStateException("An identifier is required to retrieve a View instance.");
        }
        final Object instance = this.instanceManager.getInstance(identifier.intValue());
        if (instance instanceof PlatformView) {
            return (PlatformView)instance;
        }
        if (instance instanceof View) {
            return new PlatformView(){

                public View getView() {
                    return (View)instance;
                }

                public void dispose() {
                }
            };
        }
        throw new IllegalStateException("Unable to find a PlatformView or View instance: " + args + ", " + instance);
    }
}

