/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import androidx.annotation.NonNull;
import dev.fluttercommunity.plus.connectivity.Connectivity;
import dev.fluttercommunity.plus.connectivity.ConnectivityBroadcastReceiver;
import dev.fluttercommunity.plus.connectivity.ConnectivityMethodChannelHandler;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodChannel;

public class ConnectivityPlugin
implements FlutterPlugin {
    private MethodChannel methodChannel;
    private EventChannel eventChannel;
    private ConnectivityBroadcastReceiver receiver;

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.setupChannels(binding.getBinaryMessenger(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.teardownChannels();
    }

    private void setupChannels(BinaryMessenger messenger, Context context) {
        this.methodChannel = new MethodChannel(messenger, "dev.fluttercommunity.plus/connectivity");
        this.eventChannel = new EventChannel(messenger, "dev.fluttercommunity.plus/connectivity_status");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        Connectivity connectivity = new Connectivity(connectivityManager);
        ConnectivityMethodChannelHandler methodChannelHandler = new ConnectivityMethodChannelHandler(connectivity);
        this.receiver = new ConnectivityBroadcastReceiver(context, connectivity);
        this.methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)methodChannelHandler);
        this.eventChannel.setStreamHandler((EventChannel.StreamHandler)this.receiver);
    }

    private void teardownChannels() {
        this.methodChannel.setMethodCallHandler(null);
        this.eventChannel.setStreamHandler(null);
        this.receiver.onCancel(null);
        this.methodChannel = null;
        this.eventChannel = null;
        this.receiver = null;
    }
}

