/*
 * Decompiled with CFR 0.152.
 */
package io.endigo.plugins.pdfviewflutter;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.link.LinkHandler;
import com.github.barteksc.pdfviewer.listener.OnErrorListener;
import com.github.barteksc.pdfviewer.listener.OnPageChangeListener;
import com.github.barteksc.pdfviewer.listener.OnPageErrorListener;
import com.github.barteksc.pdfviewer.listener.OnRenderListener;
import com.github.barteksc.pdfviewer.util.FitPolicy;
import io.endigo.plugins.pdfviewflutter.PDFLinkHandler;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.platform.PlatformView;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FlutterPDFView
implements PlatformView,
MethodChannel.MethodCallHandler {
    private final PDFView pdfView;
    private final MethodChannel methodChannel;
    private final LinkHandler linkHandler;

    FlutterPDFView(Context context, BinaryMessenger messenger, int id, Map<String, Object> params) {
        this.pdfView = new PDFView(context, null);
        boolean preventLinkNavigation = this.getBoolean(params, "preventLinkNavigation");
        this.methodChannel = new MethodChannel(messenger, "plugins.endigo.io/pdfview_" + id);
        this.methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.linkHandler = new PDFLinkHandler(context, this.pdfView, this.methodChannel, preventLinkNavigation);
        PDFView.Configurator config = null;
        if (params.get("filePath") != null) {
            String filePath = (String)params.get("filePath");
            config = this.pdfView.fromUri(this.getURI(filePath));
        } else if (params.get("pdfData") != null) {
            byte[] data = (byte[])params.get("pdfData");
            config = this.pdfView.fromBytes(data);
        }
        Object backgroundColor = params.get("backgroundColor");
        if (backgroundColor != null) {
            int color = ((Number)backgroundColor).intValue();
            this.pdfView.setBackgroundColor(color);
        }
        if (config != null) {
            config.enableSwipe(this.getBoolean(params, "enableSwipe")).swipeHorizontal(this.getBoolean(params, "swipeHorizontal")).password(this.getString(params, "password")).nightMode(this.getBoolean(params, "nightMode")).autoSpacing(this.getBoolean(params, "autoSpacing")).pageFling(this.getBoolean(params, "pageFling")).pageSnap(this.getBoolean(params, "pageSnap")).pageFitPolicy(this.getFitPolicy(params)).enableAnnotationRendering(true).linkHandler(this.linkHandler).enableAntialiasing(false).enableDoubletap(true).defaultPage(this.getInt(params, "defaultPage")).onPageChange(new OnPageChangeListener(){

                public void onPageChanged(int page, int total) {
                    HashMap<String, Integer> args = new HashMap<String, Integer>();
                    args.put("page", page);
                    args.put("total", total);
                    FlutterPDFView.this.methodChannel.invokeMethod("onPageChanged", args);
                }
            }).onError(new OnErrorListener(){

                public void onError(Throwable t) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("error", t.toString());
                    FlutterPDFView.this.methodChannel.invokeMethod("onError", args);
                }
            }).onPageError(new OnPageErrorListener(){

                public void onPageError(int page, Throwable t) {
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put("page", page);
                    args.put("error", t.toString());
                    FlutterPDFView.this.methodChannel.invokeMethod("onPageError", args);
                }
            }).onRender(new OnRenderListener(){

                public void onInitiallyRendered(int pages) {
                    HashMap<String, Integer> args = new HashMap<String, Integer>();
                    args.put("pages", pages);
                    FlutterPDFView.this.methodChannel.invokeMethod("onRender", args);
                }
            }).load();
        }
    }

    public View getView() {
        return this.pdfView;
    }

    public void onMethodCall(MethodCall methodCall, MethodChannel.Result result) {
        switch (methodCall.method) {
            case "pageCount": {
                this.getPageCount(result);
                break;
            }
            case "currentPage": {
                this.getCurrentPage(result);
                break;
            }
            case "setPage": {
                this.setPage(methodCall, result);
                break;
            }
            case "updateSettings": {
                this.updateSettings(methodCall, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void getPageCount(MethodChannel.Result result) {
        result.success((Object)this.pdfView.getPageCount());
    }

    void getCurrentPage(MethodChannel.Result result) {
        result.success((Object)this.pdfView.getCurrentPage());
    }

    void setPage(MethodCall call, MethodChannel.Result result) {
        if (call.argument("page") != null) {
            int page = (Integer)call.argument("page");
            this.pdfView.jumpTo(page);
        }
        result.success((Object)true);
    }

    private void updateSettings(MethodCall methodCall, MethodChannel.Result result) {
        this.applySettings((Map)methodCall.arguments);
        result.success(null);
    }

    private void applySettings(Map<String, Object> settings) {
        Iterator<String> iterator = settings.keySet().iterator();
        block14: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "enableSwipe": {
                    this.pdfView.setSwipeEnabled(this.getBoolean(settings, key));
                    continue block14;
                }
                case "nightMode": {
                    this.pdfView.setNightMode(this.getBoolean(settings, key));
                    continue block14;
                }
                case "pageFling": {
                    this.pdfView.setPageFling(this.getBoolean(settings, key));
                    continue block14;
                }
                case "pageSnap": {
                    this.pdfView.setPageSnap(this.getBoolean(settings, key));
                    continue block14;
                }
                case "preventLinkNavigation": {
                    PDFLinkHandler plh = (PDFLinkHandler)this.linkHandler;
                    plh.setPreventLinkNavigation(this.getBoolean(settings, key));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown PDFView setting: " + key);
        }
    }

    public void dispose() {
        this.methodChannel.setMethodCallHandler(null);
    }

    private boolean getBoolean(Map<String, Object> params, String key) {
        return params.containsKey(key) ? (Boolean)params.get(key) : false;
    }

    private String getString(Map<String, Object> params, String key) {
        return params.containsKey(key) ? (String)params.get(key) : "";
    }

    private int getInt(Map<String, Object> params, String key) {
        return params.containsKey(key) ? (Integer)params.get(key) : 0;
    }

    private FitPolicy getFitPolicy(Map<String, Object> params) {
        String fitPolicy;
        switch (fitPolicy = this.getString(params, "fitPolicy")) {
            case "FitPolicy.WIDTH": {
                return FitPolicy.WIDTH;
            }
            case "FitPolicy.HEIGHT": {
                return FitPolicy.HEIGHT;
            }
        }
        return FitPolicy.BOTH;
    }

    private Uri getURI(String uri) {
        Uri parsed = Uri.parse((String)uri);
        if (parsed.getScheme() == null || parsed.getScheme().isEmpty()) {
            return Uri.fromFile((File)new File(uri));
        }
        return parsed;
    }
}

