/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geocoding.utils;

import android.location.Address;
import com.baseflow.geocoding.utils.AddressLineParser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class AddressMapper {
    public static List<Map<String, Object>> toAddressHashMapList(List<Address> addresses) {
        ArrayList<Map<String, Object>> hashMaps = new ArrayList<Map<String, Object>>(addresses.size());
        for (Address address : addresses) {
            Map<String, Object> hashMap = AddressMapper.toAddressHashMap(address);
            hashMaps.add(hashMap);
        }
        return hashMaps;
    }

    private static Map<String, Object> toAddressHashMap(Address address) {
        HashMap<String, Object> placemark = new HashMap<String, Object>();
        String street = AddressLineParser.getStreet(address.getAddressLine(0));
        placemark.put("name", address.getFeatureName());
        placemark.put("street", street);
        placemark.put("isoCountryCode", address.getCountryCode());
        placemark.put("country", address.getCountryName());
        placemark.put("thoroughfare", address.getThoroughfare());
        placemark.put("subThoroughfare", address.getSubThoroughfare());
        placemark.put("postalCode", address.getPostalCode());
        placemark.put("administrativeArea", address.getAdminArea());
        placemark.put("subAdministrativeArea", address.getSubAdminArea());
        placemark.put("locality", address.getLocality());
        placemark.put("subLocality", address.getSubLocality());
        return placemark;
    }

    public static List<Map<String, Object>> toLocationHashMapList(List<Address> addresses) {
        ArrayList<Map<String, Object>> hashMaps = new ArrayList<Map<String, Object>>(addresses.size());
        for (Address address : addresses) {
            Map<String, Object> hashMap = AddressMapper.toLocationHashmap(address);
            hashMaps.add(hashMap);
        }
        return hashMaps;
    }

    private static Map<String, Object> toLocationHashmap(Address address) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("latitude", address.getLatitude());
        location.put("longitude", address.getLongitude());
        location.put("timestamp", Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis());
        return location;
    }
}

