/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.errors.PermissionUndefinedException;
import com.baseflow.geolocator.location.FlutterLocationServiceListener;
import com.baseflow.geolocator.location.GeolocationManager;
import com.baseflow.geolocator.location.LocationAccuracyManager;
import com.baseflow.geolocator.location.LocationAccuracyStatus;
import com.baseflow.geolocator.location.LocationClient;
import com.baseflow.geolocator.location.LocationMapper;
import com.baseflow.geolocator.location.LocationOptions;
import com.baseflow.geolocator.permission.LocationPermission;
import com.baseflow.geolocator.permission.PermissionManager;
import com.baseflow.geolocator.utils.Utils;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.HashMap;
import java.util.Map;

class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "MethodCallHandlerImpl";
    private final PermissionManager permissionManager;
    private final GeolocationManager geolocationManager;
    private final LocationAccuracyManager locationAccuracyManager;
    @VisibleForTesting
    final Map<String, LocationClient> pendingCurrentPositionLocationClients;
    @Nullable
    private Context context;
    @Nullable
    private Activity activity;
    @Nullable
    private MethodChannel channel;

    MethodCallHandlerImpl(PermissionManager permissionManager, GeolocationManager geolocationManager, LocationAccuracyManager locationAccuracyManager) {
        this.permissionManager = permissionManager;
        this.geolocationManager = geolocationManager;
        this.locationAccuracyManager = locationAccuracyManager;
        this.pendingCurrentPositionLocationClients = new HashMap<String, LocationClient>();
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "checkPermission": {
                this.onCheckPermission(result);
                break;
            }
            case "isLocationServiceEnabled": {
                this.onIsLocationServiceEnabled(result);
                break;
            }
            case "requestPermission": {
                this.onRequestPermission(result);
                break;
            }
            case "getLastKnownPosition": {
                this.onGetLastKnownPosition(call, result);
                break;
            }
            case "getLocationAccuracy": {
                this.getLocationAccuracy(result, this.context);
                break;
            }
            case "getCurrentPosition": {
                this.onGetCurrentPosition(call, result);
                break;
            }
            case "cancelGetCurrentPosition": {
                this.onCancelGetCurrentPosition(call, result);
                break;
            }
            case "openAppSettings": {
                boolean hasOpenedAppSettings = Utils.openAppSettings(this.context);
                result.success((Object)hasOpenedAppSettings);
                break;
            }
            case "openLocationSettings": {
                boolean hasOpenedLocationSettings = Utils.openLocationSettings(this.context);
                result.success((Object)hasOpenedLocationSettings);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void startListening(Context context, BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.w((String)TAG, (String)"Setting a method call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new MethodChannel(messenger, "flutter.baseflow.com/geolocator_android");
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.context = context;
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    private void onCheckPermission(MethodChannel.Result result) {
        try {
            LocationPermission permission2 = this.permissionManager.checkPermissionStatus(this.context);
            result.success((Object)permission2.toInt());
        }
        catch (PermissionUndefinedException e) {
            ErrorCodes errorCode = ErrorCodes.permissionDefinitionsNotFound;
            result.error(errorCode.toString(), errorCode.toDescription(), null);
        }
    }

    private void onIsLocationServiceEnabled(MethodChannel.Result result) {
        this.geolocationManager.isLocationServiceEnabled(this.context, new FlutterLocationServiceListener(result));
    }

    private void onRequestPermission(MethodChannel.Result result) {
        try {
            this.permissionManager.requestPermission(this.activity, permission2 -> result.success((Object)permission2.toInt()), errorCode -> result.error(errorCode.toString(), errorCode.toDescription(), null));
        }
        catch (PermissionUndefinedException e) {
            ErrorCodes errorCode2 = ErrorCodes.permissionDefinitionsNotFound;
            result.error(errorCode2.toString(), errorCode2.toDescription(), null);
        }
    }

    private void getLocationAccuracy(MethodChannel.Result result, Context context) {
        LocationAccuracyStatus status = this.locationAccuracyManager.getLocationAccuracy(context, (ErrorCodes errorCode) -> result.error(errorCode.toString(), errorCode.toDescription(), null));
        if (status != null) {
            result.success((Object)status.ordinal());
        }
    }

    private void onGetLastKnownPosition(MethodCall call, MethodChannel.Result result) {
        try {
            if (!this.permissionManager.hasPermission(this.context)) {
                result.error(ErrorCodes.permissionDenied.toString(), ErrorCodes.permissionDenied.toDescription(), null);
                return;
            }
        }
        catch (PermissionUndefinedException e) {
            result.error(ErrorCodes.permissionDefinitionsNotFound.toString(), ErrorCodes.permissionDefinitionsNotFound.toDescription(), null);
            return;
        }
        Boolean forceLocationManager = (Boolean)call.argument("forceLocationManager");
        this.geolocationManager.getLastKnownPosition(this.context, forceLocationManager != null && forceLocationManager != false, location -> result.success(LocationMapper.toHashMap(location)), errorCode -> result.error(errorCode.toString(), errorCode.toDescription(), null));
    }

    private void onGetCurrentPosition(MethodCall call, MethodChannel.Result result) {
        try {
            if (!this.permissionManager.hasPermission(this.context)) {
                result.error(ErrorCodes.permissionDenied.toString(), ErrorCodes.permissionDenied.toDescription(), null);
                return;
            }
        }
        catch (PermissionUndefinedException e) {
            result.error(ErrorCodes.permissionDefinitionsNotFound.toString(), ErrorCodes.permissionDefinitionsNotFound.toDescription(), null);
            return;
        }
        Map map = (Map)call.arguments;
        boolean forceLocationManager = false;
        if (map.get("forceLocationManager") != null) {
            forceLocationManager = (Boolean)map.get("forceLocationManager");
        }
        LocationOptions locationOptions = LocationOptions.parseArguments(map);
        String requestId = (String)map.get("requestId");
        boolean[] replySubmitted = new boolean[]{false};
        LocationClient locationClient = this.geolocationManager.createLocationClient(this.context, forceLocationManager, locationOptions);
        this.pendingCurrentPositionLocationClients.put(requestId, locationClient);
        this.geolocationManager.startPositionUpdates(locationClient, this.activity, location -> {
            if (replySubmitted[0]) {
                return;
            }
            replySubmitted[0] = true;
            this.geolocationManager.stopPositionUpdates(locationClient);
            this.pendingCurrentPositionLocationClients.remove(requestId);
            result.success(LocationMapper.toHashMap(location));
        }, errorCode -> {
            if (replySubmitted[0]) {
                return;
            }
            replySubmitted[0] = true;
            this.geolocationManager.stopPositionUpdates(locationClient);
            this.pendingCurrentPositionLocationClients.remove(requestId);
            result.error(errorCode.toString(), errorCode.toDescription(), null);
        });
    }

    private void onCancelGetCurrentPosition(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments;
        String requestId = (String)arguments.get("requestId");
        LocationClient locationClient = this.pendingCurrentPositionLocationClients.get(requestId);
        if (locationClient != null) {
            locationClient.stopPositionUpdates();
        }
        this.pendingCurrentPositionLocationClients.remove(requestId);
        result.success(null);
    }
}

