/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.permission;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.baseflow.geolocator.errors.ErrorCallback;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.errors.PermissionUndefinedException;
import com.baseflow.geolocator.permission.LocationPermission;
import com.baseflow.geolocator.permission.PermissionResultCallback;
import com.baseflow.geolocator.permission.PermissionUtils;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionManager
implements PluginRegistry.RequestPermissionsResultListener {
    private static final int PERMISSION_REQUEST_CODE = 109;
    private static PermissionManager permissionManagerInstance = null;
    @Nullable
    private Activity activity;
    @Nullable
    private ErrorCallback errorCallback;
    @Nullable
    private PermissionResultCallback resultCallback;

    private PermissionManager() {
    }

    public static synchronized PermissionManager getInstance() {
        if (permissionManagerInstance == null) {
            permissionManagerInstance = new PermissionManager();
        }
        return permissionManagerInstance;
    }

    public LocationPermission checkPermissionStatus(Context context) throws PermissionUndefinedException {
        List<String> permissions = PermissionManager.getLocationPermissionsFromManifest(context);
        if (Build.VERSION.SDK_INT < 23) {
            return LocationPermission.always;
        }
        int permissionStatus = -1;
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) != 0) continue;
            permissionStatus = 0;
            break;
        }
        if (permissionStatus == -1) {
            return LocationPermission.denied;
        }
        if (Build.VERSION.SDK_INT < 29) {
            return LocationPermission.always;
        }
        boolean wantsBackgroundLocation = PermissionUtils.hasPermissionInManifest(context, "android.permission.ACCESS_BACKGROUND_LOCATION");
        if (!wantsBackgroundLocation) {
            return LocationPermission.whileInUse;
        }
        int permissionStatusBackground = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION");
        if (permissionStatusBackground == 0) {
            return LocationPermission.always;
        }
        return LocationPermission.whileInUse;
    }

    public void requestPermission(Activity activity, PermissionResultCallback resultCallback, ErrorCallback errorCallback) throws PermissionUndefinedException {
        LocationPermission permissionStatus;
        if (activity == null) {
            errorCallback.onError(ErrorCodes.activityMissing);
            return;
        }
        if (Build.VERSION.SDK_INT < 23) {
            resultCallback.onResult(LocationPermission.always);
            return;
        }
        List<String> permissionsToRequest = PermissionManager.getLocationPermissionsFromManifest((Context)activity);
        if (Build.VERSION.SDK_INT >= 29 && PermissionUtils.hasPermissionInManifest((Context)activity, "android.permission.ACCESS_BACKGROUND_LOCATION") && (permissionStatus = this.checkPermissionStatus((Context)activity)) == LocationPermission.whileInUse) {
            permissionsToRequest.add("android.permission.ACCESS_BACKGROUND_LOCATION");
        }
        this.errorCallback = errorCallback;
        this.resultCallback = resultCallback;
        this.activity = activity;
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissionsToRequest.toArray(new String[0]), (int)109);
    }

    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        List<String> requestedPermissions;
        if (requestCode != 109) {
            return false;
        }
        if (this.activity == null) {
            Log.e((String)"Geolocator", (String)"Trying to process permission result without an valid Activity instance");
            if (this.errorCallback != null) {
                this.errorCallback.onError(ErrorCodes.activityMissing);
            }
            return false;
        }
        try {
            requestedPermissions = PermissionManager.getLocationPermissionsFromManifest((Context)this.activity);
        }
        catch (PermissionUndefinedException ex) {
            if (this.errorCallback != null) {
                this.errorCallback.onError(ErrorCodes.permissionDefinitionsNotFound);
            }
            return false;
        }
        if (grantResults.length == 0) {
            Log.i((String)"Geolocator", (String)"The grantResults array is empty. This can happen when the user cancels the permission request");
            return false;
        }
        LocationPermission locationPermission = LocationPermission.denied;
        int grantedResult = -1;
        boolean shouldShowRationale = false;
        boolean permissionsPartOfPermissionsResult = false;
        for (String permission2 : requestedPermissions) {
            int requestedPermissionIndex = PermissionManager.indexOf(permissions, permission2);
            if (requestedPermissionIndex >= 0) {
                permissionsPartOfPermissionsResult = true;
            }
            if (grantResults[requestedPermissionIndex] == 0) {
                grantedResult = 0;
            }
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission2)) continue;
            shouldShowRationale = true;
        }
        if (!permissionsPartOfPermissionsResult) {
            Log.w((String)"Geolocator", (String)"Location permissions not part of permissions send to onRequestPermissionsResult method.");
            return false;
        }
        if (grantedResult == 0) {
            locationPermission = Build.VERSION.SDK_INT < 29 || this.hasBackgroundAccess(permissions, grantResults) ? LocationPermission.always : LocationPermission.whileInUse;
        } else if (!shouldShowRationale) {
            locationPermission = LocationPermission.deniedForever;
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(locationPermission);
        }
        return true;
    }

    @RequiresApi(api=29)
    private boolean hasBackgroundAccess(String[] permissions, int[] grantResults) {
        int backgroundPermissionIndex = PermissionManager.indexOf(permissions, "android.permission.ACCESS_BACKGROUND_LOCATION");
        return backgroundPermissionIndex >= 0 && grantResults[backgroundPermissionIndex] == 0;
    }

    private static <T> int indexOf(T[] arr, T val) {
        return Arrays.asList(arr).indexOf(val);
    }

    private static List<String> getLocationPermissionsFromManifest(Context context) throws PermissionUndefinedException {
        boolean fineLocationPermissionExists = PermissionUtils.hasPermissionInManifest(context, "android.permission.ACCESS_FINE_LOCATION");
        boolean coarseLocationPermissionExists = PermissionUtils.hasPermissionInManifest(context, "android.permission.ACCESS_COARSE_LOCATION");
        if (!fineLocationPermissionExists && !coarseLocationPermissionExists) {
            throw new PermissionUndefinedException();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (fineLocationPermissionExists) {
            permissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (coarseLocationPermissionExists) {
            permissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        return permissions;
    }

    public boolean hasPermission(Context context) throws PermissionUndefinedException {
        LocationPermission locationPermission = this.checkPermissionStatus(context);
        return locationPermission == LocationPermission.whileInUse || locationPermission == LocationPermission.always;
    }
}

