/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Messages {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    @NonNull
    protected static FlutterError createConnectionError(@NonNull String channelName) {
        return new FlutterError("channel-error", "Unable to establish connection on channel: " + channelName + ".", "");
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface MapsInspectorApi {
        @NonNull
        public Boolean areBuildingsEnabled();

        @NonNull
        public Boolean areRotateGesturesEnabled();

        @NonNull
        public Boolean areZoomControlsEnabled();

        @NonNull
        public Boolean areScrollGesturesEnabled();

        @NonNull
        public Boolean areTiltGesturesEnabled();

        @NonNull
        public Boolean areZoomGesturesEnabled();

        @NonNull
        public Boolean isCompassEnabled();

        @Nullable
        public Boolean isLiteModeEnabled();

        @NonNull
        public Boolean isMapToolbarEnabled();

        @NonNull
        public Boolean isMyLocationButtonEnabled();

        @NonNull
        public Boolean isTrafficEnabled();

        @Nullable
        public PlatformTileLayer getTileOverlayInfo(@NonNull String var1);

        @Nullable
        public PlatformGroundOverlay getGroundOverlayInfo(@NonNull String var1);

        @NonNull
        public PlatformZoomRange getZoomRange();

        @NonNull
        public List<PlatformCluster> getClusters(@NonNull String var1);

        @NonNull
        public PlatformCameraPosition getCameraPosition();

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MapsInspectorApi api) {
            MapsInspectorApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MapsInspectorApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areBuildingsEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areBuildingsEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areRotateGesturesEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areRotateGesturesEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areZoomControlsEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areZoomControlsEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areScrollGesturesEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areScrollGesturesEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areTiltGesturesEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areTiltGesturesEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.areZoomGesturesEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.areZoomGesturesEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.isCompassEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.isCompassEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.isLiteModeEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.isLiteModeEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.isMapToolbarEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.isMapToolbarEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.isMyLocationButtonEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.isMyLocationButtonEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.isTrafficEnabled" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.isTrafficEnabled();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.getTileOverlayInfo" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformTileLayer>();
                    ArrayList args = (ArrayList)message;
                    String tileOverlayIdArg = (String)args.get(0);
                    try {
                        PlatformTileLayer output = api.getTileOverlayInfo(tileOverlayIdArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.getGroundOverlayInfo" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformGroundOverlay>();
                    ArrayList args = (ArrayList)message;
                    String groundOverlayIdArg = (String)args.get(0);
                    try {
                        PlatformGroundOverlay output = api.getGroundOverlayInfo(groundOverlayIdArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.getZoomRange" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformZoomRange>();
                    try {
                        PlatformZoomRange output = api.getZoomRange();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.getClusters" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<List<PlatformCluster>>();
                    ArrayList args = (ArrayList)message;
                    String clusterManagerIdArg = (String)args.get(0);
                    try {
                        List<PlatformCluster> output = api.getClusters(clusterManagerIdArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInspectorApi.getCameraPosition" + messageChannelSuffix, MapsInspectorApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformCameraPosition>();
                    try {
                        PlatformCameraPosition output = api.getCameraPosition();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface MapsPlatformViewApi {
        public void createView(@Nullable PlatformMapViewCreationParams var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MapsPlatformViewApi api) {
            MapsPlatformViewApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MapsPlatformViewApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsPlatformViewApi.createView" + messageChannelSuffix, MapsPlatformViewApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformMapViewCreationParams typeArg = (PlatformMapViewCreationParams)args.get(0);
                    try {
                        api.createView(typeArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface MapsInitializerApi {
        public void initializeWithPreferredRenderer(@Nullable PlatformRendererType var1, @NonNull Result<PlatformRendererType> var2);

        public void warmup();

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MapsInitializerApi api) {
            MapsInitializerApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MapsInitializerApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInitializerApi.initializeWithPreferredRenderer" + messageChannelSuffix, MapsInitializerApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PlatformRendererType typeArg = (PlatformRendererType)((Object)((Object)args.get(0)));
                    Result<PlatformRendererType> resultCallback = new Result<PlatformRendererType>(){

                        @Override
                        public void success(PlatformRendererType result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeWithPreferredRenderer(typeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsInitializerApi.warmup" + messageChannelSuffix, MapsInitializerApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.warmup();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static class MapsCallbackApi {
        @NonNull
        private final BinaryMessenger binaryMessenger;
        private final String messageChannelSuffix;

        public MapsCallbackApi(@NonNull BinaryMessenger argBinaryMessenger) {
            this(argBinaryMessenger, "");
        }

        public MapsCallbackApi(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
            this.binaryMessenger = argBinaryMessenger;
            this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
        }

        @NonNull
        static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public void onCameraMoveStarted(@NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onCameraMoveStarted" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(null, channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onCameraMove(@NonNull PlatformCameraPosition cameraPositionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onCameraMove" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<PlatformCameraPosition>(Collections.singletonList(cameraPositionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onCameraIdle(@NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onCameraIdle" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(null, channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onTap(@NonNull PlatformLatLng positionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<PlatformLatLng>(Collections.singletonList(positionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onLongPress(@NonNull PlatformLatLng positionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onLongPress" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<PlatformLatLng>(Collections.singletonList(positionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onMarkerTap(@NonNull String markerIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onMarkerTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(markerIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onMarkerDragStart(@NonNull String markerIdArg, @NonNull PlatformLatLng positionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onMarkerDragStart" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<Object>(Arrays.asList(markerIdArg, positionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onMarkerDrag(@NonNull String markerIdArg, @NonNull PlatformLatLng positionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onMarkerDrag" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<Object>(Arrays.asList(markerIdArg, positionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onMarkerDragEnd(@NonNull String markerIdArg, @NonNull PlatformLatLng positionArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onMarkerDragEnd" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<Object>(Arrays.asList(markerIdArg, positionArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onInfoWindowTap(@NonNull String markerIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onInfoWindowTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(markerIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onCircleTap(@NonNull String circleIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onCircleTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(circleIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onClusterTap(@NonNull PlatformCluster clusterArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onClusterTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<PlatformCluster>(Collections.singletonList(clusterArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onPolygonTap(@NonNull String polygonIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onPolygonTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(polygonIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onPolylineTap(@NonNull String polylineIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onPolylineTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(polylineIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void onGroundOverlayTap(@NonNull String groundOverlayIdArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.onGroundOverlayTap" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(groundOverlayIdArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void getTileOverlayTile(@NonNull String tileOverlayIdArg, @NonNull PlatformPoint locationArg, @NonNull Long zoomArg, @NonNull Result<PlatformTile> result) {
            String channelName = "dev.flutter.pigeon.google_maps_flutter_android.MapsCallbackApi.getTileOverlayTile" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, MapsCallbackApi.getCodec());
            channel.send(new ArrayList<Object>(Arrays.asList(tileOverlayIdArg, locationArg, zoomArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else if (listReply.get(0) == null) {
                        result.error(new FlutterError("null-error", "Flutter api returned null value for non-null return value.", ""));
                    } else {
                        PlatformTile output = (PlatformTile)listReply.get(0);
                        result.success(output);
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }
    }

    public static interface MapsApi {
        public void waitForMap(@NonNull VoidResult var1);

        public void updateMapConfiguration(@NonNull PlatformMapConfiguration var1);

        public void updateCircles(@NonNull List<PlatformCircle> var1, @NonNull List<PlatformCircle> var2, @NonNull List<String> var3);

        public void updateHeatmaps(@NonNull List<PlatformHeatmap> var1, @NonNull List<PlatformHeatmap> var2, @NonNull List<String> var3);

        public void updateClusterManagers(@NonNull List<PlatformClusterManager> var1, @NonNull List<String> var2);

        public void updateMarkers(@NonNull List<PlatformMarker> var1, @NonNull List<PlatformMarker> var2, @NonNull List<String> var3);

        public void updatePolygons(@NonNull List<PlatformPolygon> var1, @NonNull List<PlatformPolygon> var2, @NonNull List<String> var3);

        public void updatePolylines(@NonNull List<PlatformPolyline> var1, @NonNull List<PlatformPolyline> var2, @NonNull List<String> var3);

        public void updateTileOverlays(@NonNull List<PlatformTileOverlay> var1, @NonNull List<PlatformTileOverlay> var2, @NonNull List<String> var3);

        public void updateGroundOverlays(@NonNull List<PlatformGroundOverlay> var1, @NonNull List<PlatformGroundOverlay> var2, @NonNull List<String> var3);

        @NonNull
        public PlatformPoint getScreenCoordinate(@NonNull PlatformLatLng var1);

        @NonNull
        public PlatformLatLng getLatLng(@NonNull PlatformPoint var1);

        @NonNull
        public PlatformLatLngBounds getVisibleRegion();

        public void moveCamera(@NonNull PlatformCameraUpdate var1);

        public void animateCamera(@NonNull PlatformCameraUpdate var1, @Nullable Long var2);

        @NonNull
        public Double getZoomLevel();

        public void showInfoWindow(@NonNull String var1);

        public void hideInfoWindow(@NonNull String var1);

        @NonNull
        public Boolean isInfoWindowShown(@NonNull String var1);

        @NonNull
        public Boolean setStyle(@NonNull String var1);

        @NonNull
        public Boolean didLastStyleSucceed();

        public void clearTileCache(@NonNull String var1);

        public void takeSnapshot(@NonNull Result<byte[]> var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MapsApi api) {
            MapsApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MapsApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.waitForMap" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.waitForMap(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateMapConfiguration" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformMapConfiguration configurationArg = (PlatformMapConfiguration)args.get(0);
                    try {
                        api.updateMapConfiguration(configurationArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateCircles" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updateCircles(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateHeatmaps" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updateHeatmaps(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateClusterManagers" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List idsToRemoveArg = (List)args.get(1);
                    try {
                        api.updateClusterManagers(toAddArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateMarkers" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updateMarkers(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updatePolygons" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updatePolygons(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updatePolylines" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updatePolylines(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateTileOverlays" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updateTileOverlays(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.updateGroundOverlays" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    List toAddArg = (List)args.get(0);
                    List toChangeArg = (List)args.get(1);
                    List idsToRemoveArg = (List)args.get(2);
                    try {
                        api.updateGroundOverlays(toAddArg, toChangeArg, idsToRemoveArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.getScreenCoordinate" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformPoint>();
                    ArrayList args = (ArrayList)message;
                    PlatformLatLng latLngArg = (PlatformLatLng)args.get(0);
                    try {
                        PlatformPoint output = api.getScreenCoordinate(latLngArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.getLatLng" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformLatLng>();
                    ArrayList args = (ArrayList)message;
                    PlatformPoint screenCoordinateArg = (PlatformPoint)args.get(0);
                    try {
                        PlatformLatLng output = api.getLatLng(screenCoordinateArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.getVisibleRegion" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<PlatformLatLngBounds>();
                    try {
                        PlatformLatLngBounds output = api.getVisibleRegion();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.moveCamera" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformCameraUpdate cameraUpdateArg = (PlatformCameraUpdate)args.get(0);
                    try {
                        api.moveCamera(cameraUpdateArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.animateCamera" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformCameraUpdate cameraUpdateArg = (PlatformCameraUpdate)args.get(0);
                    Long durationMillisecondsArg = (Long)args.get(1);
                    try {
                        api.animateCamera(cameraUpdateArg, durationMillisecondsArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.getZoomLevel" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getZoomLevel();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.showInfoWindow" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    String markerIdArg = (String)args.get(0);
                    try {
                        api.showInfoWindow(markerIdArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.hideInfoWindow" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    String markerIdArg = (String)args.get(0);
                    try {
                        api.hideInfoWindow(markerIdArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.isInfoWindowShown" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    ArrayList args = (ArrayList)message;
                    String markerIdArg = (String)args.get(0);
                    try {
                        Boolean output = api.isInfoWindowShown(markerIdArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.setStyle" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    ArrayList args = (ArrayList)message;
                    String styleArg = (String)args.get(0);
                    try {
                        Boolean output = api.setStyle(styleArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.didLastStyleSucceed" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.didLastStyleSucceed();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.clearTileCache" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    String tileOverlayIdArg = (String)args.get(0);
                    try {
                        api.clearTileCache(tileOverlayIdArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.google_maps_flutter_android.MapsApi.takeSnapshot" + messageChannelSuffix, MapsApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<byte[]> resultCallback = new Result<byte[]>(){

                        @Override
                        public void success(byte[] result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.takeSnapshot(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface VoidResult {
        public void success();

        public void error(@NonNull Throwable var1);
    }

    public static interface NullableResult<T> {
        public void success(@Nullable T var1);

        public void error(@NonNull Throwable var1);
    }

    public static interface Result<T> {
        public void success(@NonNull T var1);

        public void error(@NonNull Throwable var1);
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -127: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformMapType.values()[((Long)value).intValue()];
                }
                case -126: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformRendererType.values()[((Long)value).intValue()];
                }
                case -125: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformJointType.values()[((Long)value).intValue()];
                }
                case -124: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformCapType.values()[((Long)value).intValue()];
                }
                case -123: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformPatternItemType.values()[((Long)value).intValue()];
                }
                case -122: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformMapBitmapScaling.values()[((Long)value).intValue()];
                }
                case -121: {
                    return PlatformCameraPosition.fromList((ArrayList)this.readValue(buffer));
                }
                case -120: {
                    return PlatformCameraUpdate.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return PlatformCameraUpdateNewCameraPosition.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return PlatformCameraUpdateNewLatLng.fromList((ArrayList)this.readValue(buffer));
                }
                case -117: {
                    return PlatformCameraUpdateNewLatLngBounds.fromList((ArrayList)this.readValue(buffer));
                }
                case -116: {
                    return PlatformCameraUpdateNewLatLngZoom.fromList((ArrayList)this.readValue(buffer));
                }
                case -115: {
                    return PlatformCameraUpdateScrollBy.fromList((ArrayList)this.readValue(buffer));
                }
                case -114: {
                    return PlatformCameraUpdateZoomBy.fromList((ArrayList)this.readValue(buffer));
                }
                case -113: {
                    return PlatformCameraUpdateZoom.fromList((ArrayList)this.readValue(buffer));
                }
                case -112: {
                    return PlatformCameraUpdateZoomTo.fromList((ArrayList)this.readValue(buffer));
                }
                case -111: {
                    return PlatformCircle.fromList((ArrayList)this.readValue(buffer));
                }
                case -110: {
                    return PlatformHeatmap.fromList((ArrayList)this.readValue(buffer));
                }
                case -109: {
                    return PlatformClusterManager.fromList((ArrayList)this.readValue(buffer));
                }
                case -108: {
                    return PlatformDoublePair.fromList((ArrayList)this.readValue(buffer));
                }
                case -107: {
                    return PlatformInfoWindow.fromList((ArrayList)this.readValue(buffer));
                }
                case -106: {
                    return PlatformMarker.fromList((ArrayList)this.readValue(buffer));
                }
                case -105: {
                    return PlatformPolygon.fromList((ArrayList)this.readValue(buffer));
                }
                case -104: {
                    return PlatformPolyline.fromList((ArrayList)this.readValue(buffer));
                }
                case -103: {
                    return PlatformCap.fromList((ArrayList)this.readValue(buffer));
                }
                case -102: {
                    return PlatformPatternItem.fromList((ArrayList)this.readValue(buffer));
                }
                case -101: {
                    return PlatformTile.fromList((ArrayList)this.readValue(buffer));
                }
                case -100: {
                    return PlatformTileOverlay.fromList((ArrayList)this.readValue(buffer));
                }
                case -99: {
                    return PlatformEdgeInsets.fromList((ArrayList)this.readValue(buffer));
                }
                case -98: {
                    return PlatformLatLng.fromList((ArrayList)this.readValue(buffer));
                }
                case -97: {
                    return PlatformLatLngBounds.fromList((ArrayList)this.readValue(buffer));
                }
                case -96: {
                    return PlatformCluster.fromList((ArrayList)this.readValue(buffer));
                }
                case -95: {
                    return PlatformGroundOverlay.fromList((ArrayList)this.readValue(buffer));
                }
                case -94: {
                    return PlatformCameraTargetBounds.fromList((ArrayList)this.readValue(buffer));
                }
                case -93: {
                    return PlatformMapViewCreationParams.fromList((ArrayList)this.readValue(buffer));
                }
                case -92: {
                    return PlatformMapConfiguration.fromList((ArrayList)this.readValue(buffer));
                }
                case -91: {
                    return PlatformPoint.fromList((ArrayList)this.readValue(buffer));
                }
                case -90: {
                    return PlatformTileLayer.fromList((ArrayList)this.readValue(buffer));
                }
                case -89: {
                    return PlatformZoomRange.fromList((ArrayList)this.readValue(buffer));
                }
                case -88: {
                    return PlatformBitmap.fromList((ArrayList)this.readValue(buffer));
                }
                case -87: {
                    return PlatformBitmapDefaultMarker.fromList((ArrayList)this.readValue(buffer));
                }
                case -86: {
                    return PlatformBitmapBytes.fromList((ArrayList)this.readValue(buffer));
                }
                case -85: {
                    return PlatformBitmapAsset.fromList((ArrayList)this.readValue(buffer));
                }
                case -84: {
                    return PlatformBitmapAssetImage.fromList((ArrayList)this.readValue(buffer));
                }
                case -83: {
                    return PlatformBitmapAssetMap.fromList((ArrayList)this.readValue(buffer));
                }
                case -82: {
                    return PlatformBitmapBytesMap.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PlatformMapType) {
                stream.write(129);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformMapType)((Object)value)).index));
            } else if (value instanceof PlatformRendererType) {
                stream.write(130);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformRendererType)((Object)value)).index));
            } else if (value instanceof PlatformJointType) {
                stream.write(131);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformJointType)((Object)value)).index));
            } else if (value instanceof PlatformCapType) {
                stream.write(132);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformCapType)((Object)value)).index));
            } else if (value instanceof PlatformPatternItemType) {
                stream.write(133);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformPatternItemType)((Object)value)).index));
            } else if (value instanceof PlatformMapBitmapScaling) {
                stream.write(134);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformMapBitmapScaling)((Object)value)).index));
            } else if (value instanceof PlatformCameraPosition) {
                stream.write(135);
                this.writeValue(stream, ((PlatformCameraPosition)value).toList());
            } else if (value instanceof PlatformCameraUpdate) {
                stream.write(136);
                this.writeValue(stream, ((PlatformCameraUpdate)value).toList());
            } else if (value instanceof PlatformCameraUpdateNewCameraPosition) {
                stream.write(137);
                this.writeValue(stream, ((PlatformCameraUpdateNewCameraPosition)value).toList());
            } else if (value instanceof PlatformCameraUpdateNewLatLng) {
                stream.write(138);
                this.writeValue(stream, ((PlatformCameraUpdateNewLatLng)value).toList());
            } else if (value instanceof PlatformCameraUpdateNewLatLngBounds) {
                stream.write(139);
                this.writeValue(stream, ((PlatformCameraUpdateNewLatLngBounds)value).toList());
            } else if (value instanceof PlatformCameraUpdateNewLatLngZoom) {
                stream.write(140);
                this.writeValue(stream, ((PlatformCameraUpdateNewLatLngZoom)value).toList());
            } else if (value instanceof PlatformCameraUpdateScrollBy) {
                stream.write(141);
                this.writeValue(stream, ((PlatformCameraUpdateScrollBy)value).toList());
            } else if (value instanceof PlatformCameraUpdateZoomBy) {
                stream.write(142);
                this.writeValue(stream, ((PlatformCameraUpdateZoomBy)value).toList());
            } else if (value instanceof PlatformCameraUpdateZoom) {
                stream.write(143);
                this.writeValue(stream, ((PlatformCameraUpdateZoom)value).toList());
            } else if (value instanceof PlatformCameraUpdateZoomTo) {
                stream.write(144);
                this.writeValue(stream, ((PlatformCameraUpdateZoomTo)value).toList());
            } else if (value instanceof PlatformCircle) {
                stream.write(145);
                this.writeValue(stream, ((PlatformCircle)value).toList());
            } else if (value instanceof PlatformHeatmap) {
                stream.write(146);
                this.writeValue(stream, ((PlatformHeatmap)value).toList());
            } else if (value instanceof PlatformClusterManager) {
                stream.write(147);
                this.writeValue(stream, ((PlatformClusterManager)value).toList());
            } else if (value instanceof PlatformDoublePair) {
                stream.write(148);
                this.writeValue(stream, ((PlatformDoublePair)value).toList());
            } else if (value instanceof PlatformInfoWindow) {
                stream.write(149);
                this.writeValue(stream, ((PlatformInfoWindow)value).toList());
            } else if (value instanceof PlatformMarker) {
                stream.write(150);
                this.writeValue(stream, ((PlatformMarker)value).toList());
            } else if (value instanceof PlatformPolygon) {
                stream.write(151);
                this.writeValue(stream, ((PlatformPolygon)value).toList());
            } else if (value instanceof PlatformPolyline) {
                stream.write(152);
                this.writeValue(stream, ((PlatformPolyline)value).toList());
            } else if (value instanceof PlatformCap) {
                stream.write(153);
                this.writeValue(stream, ((PlatformCap)value).toList());
            } else if (value instanceof PlatformPatternItem) {
                stream.write(154);
                this.writeValue(stream, ((PlatformPatternItem)value).toList());
            } else if (value instanceof PlatformTile) {
                stream.write(155);
                this.writeValue(stream, ((PlatformTile)value).toList());
            } else if (value instanceof PlatformTileOverlay) {
                stream.write(156);
                this.writeValue(stream, ((PlatformTileOverlay)value).toList());
            } else if (value instanceof PlatformEdgeInsets) {
                stream.write(157);
                this.writeValue(stream, ((PlatformEdgeInsets)value).toList());
            } else if (value instanceof PlatformLatLng) {
                stream.write(158);
                this.writeValue(stream, ((PlatformLatLng)value).toList());
            } else if (value instanceof PlatformLatLngBounds) {
                stream.write(159);
                this.writeValue(stream, ((PlatformLatLngBounds)value).toList());
            } else if (value instanceof PlatformCluster) {
                stream.write(160);
                this.writeValue(stream, ((PlatformCluster)value).toList());
            } else if (value instanceof PlatformGroundOverlay) {
                stream.write(161);
                this.writeValue(stream, ((PlatformGroundOverlay)value).toList());
            } else if (value instanceof PlatformCameraTargetBounds) {
                stream.write(162);
                this.writeValue(stream, ((PlatformCameraTargetBounds)value).toList());
            } else if (value instanceof PlatformMapViewCreationParams) {
                stream.write(163);
                this.writeValue(stream, ((PlatformMapViewCreationParams)value).toList());
            } else if (value instanceof PlatformMapConfiguration) {
                stream.write(164);
                this.writeValue(stream, ((PlatformMapConfiguration)value).toList());
            } else if (value instanceof PlatformPoint) {
                stream.write(165);
                this.writeValue(stream, ((PlatformPoint)value).toList());
            } else if (value instanceof PlatformTileLayer) {
                stream.write(166);
                this.writeValue(stream, ((PlatformTileLayer)value).toList());
            } else if (value instanceof PlatformZoomRange) {
                stream.write(167);
                this.writeValue(stream, ((PlatformZoomRange)value).toList());
            } else if (value instanceof PlatformBitmap) {
                stream.write(168);
                this.writeValue(stream, ((PlatformBitmap)value).toList());
            } else if (value instanceof PlatformBitmapDefaultMarker) {
                stream.write(169);
                this.writeValue(stream, ((PlatformBitmapDefaultMarker)value).toList());
            } else if (value instanceof PlatformBitmapBytes) {
                stream.write(170);
                this.writeValue(stream, ((PlatformBitmapBytes)value).toList());
            } else if (value instanceof PlatformBitmapAsset) {
                stream.write(171);
                this.writeValue(stream, ((PlatformBitmapAsset)value).toList());
            } else if (value instanceof PlatformBitmapAssetImage) {
                stream.write(172);
                this.writeValue(stream, ((PlatformBitmapAssetImage)value).toList());
            } else if (value instanceof PlatformBitmapAssetMap) {
                stream.write(173);
                this.writeValue(stream, ((PlatformBitmapAssetMap)value).toList());
            } else if (value instanceof PlatformBitmapBytesMap) {
                stream.write(174);
                this.writeValue(stream, ((PlatformBitmapBytesMap)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static final class PlatformBitmapBytesMap {
        @NonNull
        private byte[] byteData;
        @NonNull
        private PlatformMapBitmapScaling bitmapScaling;
        @NonNull
        private Double imagePixelRatio;
        @Nullable
        private Double width;
        @Nullable
        private Double height;

        @NonNull
        public byte[] getByteData() {
            return this.byteData;
        }

        public void setByteData(@NonNull byte[] setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"byteData\" is null.");
            }
            this.byteData = setterArg;
        }

        @NonNull
        public PlatformMapBitmapScaling getBitmapScaling() {
            return this.bitmapScaling;
        }

        public void setBitmapScaling(@NonNull PlatformMapBitmapScaling setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bitmapScaling\" is null.");
            }
            this.bitmapScaling = setterArg;
        }

        @NonNull
        public Double getImagePixelRatio() {
            return this.imagePixelRatio;
        }

        public void setImagePixelRatio(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"imagePixelRatio\" is null.");
            }
            this.imagePixelRatio = setterArg;
        }

        @Nullable
        public Double getWidth() {
            return this.width;
        }

        public void setWidth(@Nullable Double setterArg) {
            this.width = setterArg;
        }

        @Nullable
        public Double getHeight() {
            return this.height;
        }

        public void setHeight(@Nullable Double setterArg) {
            this.height = setterArg;
        }

        PlatformBitmapBytesMap() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapBytesMap that = (PlatformBitmapBytesMap)o;
            return Arrays.equals(this.byteData, that.byteData) && this.bitmapScaling.equals((Object)that.bitmapScaling) && this.imagePixelRatio.equals(that.imagePixelRatio) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height);
        }

        public int hashCode() {
            int pigeonVar_result = Objects.hash(new Object[]{this.bitmapScaling, this.imagePixelRatio, this.width, this.height});
            pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(this.byteData);
            return pigeonVar_result;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.byteData);
            toListResult.add((Object)this.bitmapScaling);
            toListResult.add(this.imagePixelRatio);
            toListResult.add(this.width);
            toListResult.add(this.height);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapBytesMap fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapBytesMap pigeonResult = new PlatformBitmapBytesMap();
            Object byteData = pigeonVar_list.get(0);
            pigeonResult.setByteData((byte[])byteData);
            Object bitmapScaling = pigeonVar_list.get(1);
            pigeonResult.setBitmapScaling((PlatformMapBitmapScaling)((Object)bitmapScaling));
            Object imagePixelRatio = pigeonVar_list.get(2);
            pigeonResult.setImagePixelRatio((Double)imagePixelRatio);
            Object width = pigeonVar_list.get(3);
            pigeonResult.setWidth((Double)width);
            Object height = pigeonVar_list.get(4);
            pigeonResult.setHeight((Double)height);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private byte[] byteData;
            @Nullable
            private PlatformMapBitmapScaling bitmapScaling;
            @Nullable
            private Double imagePixelRatio;
            @Nullable
            private Double width;
            @Nullable
            private Double height;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setByteData(@NonNull byte[] setterArg) {
                this.byteData = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBitmapScaling(@NonNull PlatformMapBitmapScaling setterArg) {
                this.bitmapScaling = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setImagePixelRatio(@NonNull Double setterArg) {
                this.imagePixelRatio = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@Nullable Double setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeight(@Nullable Double setterArg) {
                this.height = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapBytesMap build() {
                PlatformBitmapBytesMap pigeonReturn = new PlatformBitmapBytesMap();
                pigeonReturn.setByteData(this.byteData);
                pigeonReturn.setBitmapScaling(this.bitmapScaling);
                pigeonReturn.setImagePixelRatio(this.imagePixelRatio);
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setHeight(this.height);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmapAssetMap {
        @NonNull
        private String assetName;
        @NonNull
        private PlatformMapBitmapScaling bitmapScaling;
        @NonNull
        private Double imagePixelRatio;
        @Nullable
        private Double width;
        @Nullable
        private Double height;

        @NonNull
        public String getAssetName() {
            return this.assetName;
        }

        public void setAssetName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"assetName\" is null.");
            }
            this.assetName = setterArg;
        }

        @NonNull
        public PlatformMapBitmapScaling getBitmapScaling() {
            return this.bitmapScaling;
        }

        public void setBitmapScaling(@NonNull PlatformMapBitmapScaling setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bitmapScaling\" is null.");
            }
            this.bitmapScaling = setterArg;
        }

        @NonNull
        public Double getImagePixelRatio() {
            return this.imagePixelRatio;
        }

        public void setImagePixelRatio(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"imagePixelRatio\" is null.");
            }
            this.imagePixelRatio = setterArg;
        }

        @Nullable
        public Double getWidth() {
            return this.width;
        }

        public void setWidth(@Nullable Double setterArg) {
            this.width = setterArg;
        }

        @Nullable
        public Double getHeight() {
            return this.height;
        }

        public void setHeight(@Nullable Double setterArg) {
            this.height = setterArg;
        }

        PlatformBitmapAssetMap() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapAssetMap that = (PlatformBitmapAssetMap)o;
            return this.assetName.equals(that.assetName) && this.bitmapScaling.equals((Object)that.bitmapScaling) && this.imagePixelRatio.equals(that.imagePixelRatio) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.assetName, this.bitmapScaling, this.imagePixelRatio, this.width, this.height});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.assetName);
            toListResult.add((Object)this.bitmapScaling);
            toListResult.add(this.imagePixelRatio);
            toListResult.add(this.width);
            toListResult.add(this.height);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapAssetMap fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapAssetMap pigeonResult = new PlatformBitmapAssetMap();
            Object assetName = pigeonVar_list.get(0);
            pigeonResult.setAssetName((String)assetName);
            Object bitmapScaling = pigeonVar_list.get(1);
            pigeonResult.setBitmapScaling((PlatformMapBitmapScaling)((Object)bitmapScaling));
            Object imagePixelRatio = pigeonVar_list.get(2);
            pigeonResult.setImagePixelRatio((Double)imagePixelRatio);
            Object width = pigeonVar_list.get(3);
            pigeonResult.setWidth((Double)width);
            Object height = pigeonVar_list.get(4);
            pigeonResult.setHeight((Double)height);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String assetName;
            @Nullable
            private PlatformMapBitmapScaling bitmapScaling;
            @Nullable
            private Double imagePixelRatio;
            @Nullable
            private Double width;
            @Nullable
            private Double height;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAssetName(@NonNull String setterArg) {
                this.assetName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBitmapScaling(@NonNull PlatformMapBitmapScaling setterArg) {
                this.bitmapScaling = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setImagePixelRatio(@NonNull Double setterArg) {
                this.imagePixelRatio = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@Nullable Double setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeight(@Nullable Double setterArg) {
                this.height = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapAssetMap build() {
                PlatformBitmapAssetMap pigeonReturn = new PlatformBitmapAssetMap();
                pigeonReturn.setAssetName(this.assetName);
                pigeonReturn.setBitmapScaling(this.bitmapScaling);
                pigeonReturn.setImagePixelRatio(this.imagePixelRatio);
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setHeight(this.height);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmapAssetImage {
        @NonNull
        private String name;
        @NonNull
        private Double scale;
        @Nullable
        private PlatformDoublePair size;

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        @NonNull
        public Double getScale() {
            return this.scale;
        }

        public void setScale(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"scale\" is null.");
            }
            this.scale = setterArg;
        }

        @Nullable
        public PlatformDoublePair getSize() {
            return this.size;
        }

        public void setSize(@Nullable PlatformDoublePair setterArg) {
            this.size = setterArg;
        }

        PlatformBitmapAssetImage() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapAssetImage that = (PlatformBitmapAssetImage)o;
            return this.name.equals(that.name) && this.scale.equals(that.scale) && Objects.equals(this.size, that.size);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scale, this.size);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.name);
            toListResult.add(this.scale);
            toListResult.add(this.size);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapAssetImage fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapAssetImage pigeonResult = new PlatformBitmapAssetImage();
            Object name = pigeonVar_list.get(0);
            pigeonResult.setName((String)name);
            Object scale = pigeonVar_list.get(1);
            pigeonResult.setScale((Double)scale);
            Object size = pigeonVar_list.get(2);
            pigeonResult.setSize((PlatformDoublePair)size);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private Double scale;
            @Nullable
            private PlatformDoublePair size;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setScale(@NonNull Double setterArg) {
                this.scale = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSize(@Nullable PlatformDoublePair setterArg) {
                this.size = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapAssetImage build() {
                PlatformBitmapAssetImage pigeonReturn = new PlatformBitmapAssetImage();
                pigeonReturn.setName(this.name);
                pigeonReturn.setScale(this.scale);
                pigeonReturn.setSize(this.size);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmapAsset {
        @NonNull
        private String name;
        @Nullable
        private String pkg;

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        @Nullable
        public String getPkg() {
            return this.pkg;
        }

        public void setPkg(@Nullable String setterArg) {
            this.pkg = setterArg;
        }

        PlatformBitmapAsset() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapAsset that = (PlatformBitmapAsset)o;
            return this.name.equals(that.name) && Objects.equals(this.pkg, that.pkg);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.pkg);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.name);
            toListResult.add(this.pkg);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapAsset fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapAsset pigeonResult = new PlatformBitmapAsset();
            Object name = pigeonVar_list.get(0);
            pigeonResult.setName((String)name);
            Object pkg = pigeonVar_list.get(1);
            pigeonResult.setPkg((String)pkg);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private String pkg;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPkg(@Nullable String setterArg) {
                this.pkg = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapAsset build() {
                PlatformBitmapAsset pigeonReturn = new PlatformBitmapAsset();
                pigeonReturn.setName(this.name);
                pigeonReturn.setPkg(this.pkg);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmapBytes {
        @NonNull
        private byte[] byteData;
        @Nullable
        private PlatformDoublePair size;

        @NonNull
        public byte[] getByteData() {
            return this.byteData;
        }

        public void setByteData(@NonNull byte[] setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"byteData\" is null.");
            }
            this.byteData = setterArg;
        }

        @Nullable
        public PlatformDoublePair getSize() {
            return this.size;
        }

        public void setSize(@Nullable PlatformDoublePair setterArg) {
            this.size = setterArg;
        }

        PlatformBitmapBytes() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapBytes that = (PlatformBitmapBytes)o;
            return Arrays.equals(this.byteData, that.byteData) && Objects.equals(this.size, that.size);
        }

        public int hashCode() {
            int pigeonVar_result = Objects.hash(this.size);
            pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(this.byteData);
            return pigeonVar_result;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.byteData);
            toListResult.add(this.size);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapBytes fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapBytes pigeonResult = new PlatformBitmapBytes();
            Object byteData = pigeonVar_list.get(0);
            pigeonResult.setByteData((byte[])byteData);
            Object size = pigeonVar_list.get(1);
            pigeonResult.setSize((PlatformDoublePair)size);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private byte[] byteData;
            @Nullable
            private PlatformDoublePair size;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setByteData(@NonNull byte[] setterArg) {
                this.byteData = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSize(@Nullable PlatformDoublePair setterArg) {
                this.size = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapBytes build() {
                PlatformBitmapBytes pigeonReturn = new PlatformBitmapBytes();
                pigeonReturn.setByteData(this.byteData);
                pigeonReturn.setSize(this.size);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmapDefaultMarker {
        @Nullable
        private Double hue;

        @Nullable
        public Double getHue() {
            return this.hue;
        }

        public void setHue(@Nullable Double setterArg) {
            this.hue = setterArg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmapDefaultMarker that = (PlatformBitmapDefaultMarker)o;
            return Objects.equals(this.hue, that.hue);
        }

        public int hashCode() {
            return Objects.hash(this.hue);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.hue);
            return toListResult;
        }

        @NonNull
        static PlatformBitmapDefaultMarker fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmapDefaultMarker pigeonResult = new PlatformBitmapDefaultMarker();
            Object hue = pigeonVar_list.get(0);
            pigeonResult.setHue((Double)hue);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double hue;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHue(@Nullable Double setterArg) {
                this.hue = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmapDefaultMarker build() {
                PlatformBitmapDefaultMarker pigeonReturn = new PlatformBitmapDefaultMarker();
                pigeonReturn.setHue(this.hue);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformBitmap {
        @NonNull
        private Object bitmap;

        @NonNull
        public Object getBitmap() {
            return this.bitmap;
        }

        public void setBitmap(@NonNull Object setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bitmap\" is null.");
            }
            this.bitmap = setterArg;
        }

        PlatformBitmap() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformBitmap that = (PlatformBitmap)o;
            return this.bitmap.equals(that.bitmap);
        }

        public int hashCode() {
            return Objects.hash(this.bitmap);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.bitmap);
            return toListResult;
        }

        @NonNull
        static PlatformBitmap fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformBitmap pigeonResult = new PlatformBitmap();
            Object bitmap = pigeonVar_list.get(0);
            pigeonResult.setBitmap(bitmap);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Object bitmap;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBitmap(@NonNull Object setterArg) {
                this.bitmap = setterArg;
                return this;
            }

            @NonNull
            public PlatformBitmap build() {
                PlatformBitmap pigeonReturn = new PlatformBitmap();
                pigeonReturn.setBitmap(this.bitmap);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformZoomRange {
        @Nullable
        private Double min;
        @Nullable
        private Double max;

        @Nullable
        public Double getMin() {
            return this.min;
        }

        public void setMin(@Nullable Double setterArg) {
            this.min = setterArg;
        }

        @Nullable
        public Double getMax() {
            return this.max;
        }

        public void setMax(@Nullable Double setterArg) {
            this.max = setterArg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformZoomRange that = (PlatformZoomRange)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.min);
            toListResult.add(this.max);
            return toListResult;
        }

        @NonNull
        static PlatformZoomRange fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformZoomRange pigeonResult = new PlatformZoomRange();
            Object min = pigeonVar_list.get(0);
            pigeonResult.setMin((Double)min);
            Object max = pigeonVar_list.get(1);
            pigeonResult.setMax((Double)max);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double min;
            @Nullable
            private Double max;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMin(@Nullable Double setterArg) {
                this.min = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMax(@Nullable Double setterArg) {
                this.max = setterArg;
                return this;
            }

            @NonNull
            public PlatformZoomRange build() {
                PlatformZoomRange pigeonReturn = new PlatformZoomRange();
                pigeonReturn.setMin(this.min);
                pigeonReturn.setMax(this.max);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformTileLayer {
        @NonNull
        private Boolean visible;
        @NonNull
        private Boolean fadeIn;
        @NonNull
        private Double transparency;
        @NonNull
        private Double zIndex;

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Boolean getFadeIn() {
            return this.fadeIn;
        }

        public void setFadeIn(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"fadeIn\" is null.");
            }
            this.fadeIn = setterArg;
        }

        @NonNull
        public Double getTransparency() {
            return this.transparency;
        }

        public void setTransparency(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"transparency\" is null.");
            }
            this.transparency = setterArg;
        }

        @NonNull
        public Double getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        PlatformTileLayer() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformTileLayer that = (PlatformTileLayer)o;
            return this.visible.equals(that.visible) && this.fadeIn.equals(that.fadeIn) && this.transparency.equals(that.transparency) && this.zIndex.equals(that.zIndex);
        }

        public int hashCode() {
            return Objects.hash(this.visible, this.fadeIn, this.transparency, this.zIndex);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.visible);
            toListResult.add(this.fadeIn);
            toListResult.add(this.transparency);
            toListResult.add(this.zIndex);
            return toListResult;
        }

        @NonNull
        static PlatformTileLayer fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformTileLayer pigeonResult = new PlatformTileLayer();
            Object visible = pigeonVar_list.get(0);
            pigeonResult.setVisible((Boolean)visible);
            Object fadeIn = pigeonVar_list.get(1);
            pigeonResult.setFadeIn((Boolean)fadeIn);
            Object transparency = pigeonVar_list.get(2);
            pigeonResult.setTransparency((Double)transparency);
            Object zIndex = pigeonVar_list.get(3);
            pigeonResult.setZIndex((Double)zIndex);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean visible;
            @Nullable
            private Boolean fadeIn;
            @Nullable
            private Double transparency;
            @Nullable
            private Double zIndex;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFadeIn(@NonNull Boolean setterArg) {
                this.fadeIn = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTransparency(@NonNull Double setterArg) {
                this.transparency = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Double setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @NonNull
            public PlatformTileLayer build() {
                PlatformTileLayer pigeonReturn = new PlatformTileLayer();
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setFadeIn(this.fadeIn);
                pigeonReturn.setTransparency(this.transparency);
                pigeonReturn.setZIndex(this.zIndex);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformPoint {
        @NonNull
        private Long x;
        @NonNull
        private Long y;

        @NonNull
        public Long getX() {
            return this.x;
        }

        public void setX(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"x\" is null.");
            }
            this.x = setterArg;
        }

        @NonNull
        public Long getY() {
            return this.y;
        }

        public void setY(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"y\" is null.");
            }
            this.y = setterArg;
        }

        PlatformPoint() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformPoint that = (PlatformPoint)o;
            return this.x.equals(that.x) && this.y.equals(that.y);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.x);
            toListResult.add(this.y);
            return toListResult;
        }

        @NonNull
        static PlatformPoint fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformPoint pigeonResult = new PlatformPoint();
            Object x = pigeonVar_list.get(0);
            pigeonResult.setX((Long)x);
            Object y = pigeonVar_list.get(1);
            pigeonResult.setY((Long)y);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Long x;
            @Nullable
            private Long y;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setX(@NonNull Long setterArg) {
                this.x = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setY(@NonNull Long setterArg) {
                this.y = setterArg;
                return this;
            }

            @NonNull
            public PlatformPoint build() {
                PlatformPoint pigeonReturn = new PlatformPoint();
                pigeonReturn.setX(this.x);
                pigeonReturn.setY(this.y);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformMapConfiguration {
        @Nullable
        private Boolean compassEnabled;
        @Nullable
        private PlatformCameraTargetBounds cameraTargetBounds;
        @Nullable
        private PlatformMapType mapType;
        @Nullable
        private PlatformZoomRange minMaxZoomPreference;
        @Nullable
        private Boolean mapToolbarEnabled;
        @Nullable
        private Boolean rotateGesturesEnabled;
        @Nullable
        private Boolean scrollGesturesEnabled;
        @Nullable
        private Boolean tiltGesturesEnabled;
        @Nullable
        private Boolean trackCameraPosition;
        @Nullable
        private Boolean zoomControlsEnabled;
        @Nullable
        private Boolean zoomGesturesEnabled;
        @Nullable
        private Boolean myLocationEnabled;
        @Nullable
        private Boolean myLocationButtonEnabled;
        @Nullable
        private PlatformEdgeInsets padding;
        @Nullable
        private Boolean indoorViewEnabled;
        @Nullable
        private Boolean trafficEnabled;
        @Nullable
        private Boolean buildingsEnabled;
        @Nullable
        private Boolean liteModeEnabled;
        @Nullable
        private String cloudMapId;
        @Nullable
        private String style;

        @Nullable
        public Boolean getCompassEnabled() {
            return this.compassEnabled;
        }

        public void setCompassEnabled(@Nullable Boolean setterArg) {
            this.compassEnabled = setterArg;
        }

        @Nullable
        public PlatformCameraTargetBounds getCameraTargetBounds() {
            return this.cameraTargetBounds;
        }

        public void setCameraTargetBounds(@Nullable PlatformCameraTargetBounds setterArg) {
            this.cameraTargetBounds = setterArg;
        }

        @Nullable
        public PlatformMapType getMapType() {
            return this.mapType;
        }

        public void setMapType(@Nullable PlatformMapType setterArg) {
            this.mapType = setterArg;
        }

        @Nullable
        public PlatformZoomRange getMinMaxZoomPreference() {
            return this.minMaxZoomPreference;
        }

        public void setMinMaxZoomPreference(@Nullable PlatformZoomRange setterArg) {
            this.minMaxZoomPreference = setterArg;
        }

        @Nullable
        public Boolean getMapToolbarEnabled() {
            return this.mapToolbarEnabled;
        }

        public void setMapToolbarEnabled(@Nullable Boolean setterArg) {
            this.mapToolbarEnabled = setterArg;
        }

        @Nullable
        public Boolean getRotateGesturesEnabled() {
            return this.rotateGesturesEnabled;
        }

        public void setRotateGesturesEnabled(@Nullable Boolean setterArg) {
            this.rotateGesturesEnabled = setterArg;
        }

        @Nullable
        public Boolean getScrollGesturesEnabled() {
            return this.scrollGesturesEnabled;
        }

        public void setScrollGesturesEnabled(@Nullable Boolean setterArg) {
            this.scrollGesturesEnabled = setterArg;
        }

        @Nullable
        public Boolean getTiltGesturesEnabled() {
            return this.tiltGesturesEnabled;
        }

        public void setTiltGesturesEnabled(@Nullable Boolean setterArg) {
            this.tiltGesturesEnabled = setterArg;
        }

        @Nullable
        public Boolean getTrackCameraPosition() {
            return this.trackCameraPosition;
        }

        public void setTrackCameraPosition(@Nullable Boolean setterArg) {
            this.trackCameraPosition = setterArg;
        }

        @Nullable
        public Boolean getZoomControlsEnabled() {
            return this.zoomControlsEnabled;
        }

        public void setZoomControlsEnabled(@Nullable Boolean setterArg) {
            this.zoomControlsEnabled = setterArg;
        }

        @Nullable
        public Boolean getZoomGesturesEnabled() {
            return this.zoomGesturesEnabled;
        }

        public void setZoomGesturesEnabled(@Nullable Boolean setterArg) {
            this.zoomGesturesEnabled = setterArg;
        }

        @Nullable
        public Boolean getMyLocationEnabled() {
            return this.myLocationEnabled;
        }

        public void setMyLocationEnabled(@Nullable Boolean setterArg) {
            this.myLocationEnabled = setterArg;
        }

        @Nullable
        public Boolean getMyLocationButtonEnabled() {
            return this.myLocationButtonEnabled;
        }

        public void setMyLocationButtonEnabled(@Nullable Boolean setterArg) {
            this.myLocationButtonEnabled = setterArg;
        }

        @Nullable
        public PlatformEdgeInsets getPadding() {
            return this.padding;
        }

        public void setPadding(@Nullable PlatformEdgeInsets setterArg) {
            this.padding = setterArg;
        }

        @Nullable
        public Boolean getIndoorViewEnabled() {
            return this.indoorViewEnabled;
        }

        public void setIndoorViewEnabled(@Nullable Boolean setterArg) {
            this.indoorViewEnabled = setterArg;
        }

        @Nullable
        public Boolean getTrafficEnabled() {
            return this.trafficEnabled;
        }

        public void setTrafficEnabled(@Nullable Boolean setterArg) {
            this.trafficEnabled = setterArg;
        }

        @Nullable
        public Boolean getBuildingsEnabled() {
            return this.buildingsEnabled;
        }

        public void setBuildingsEnabled(@Nullable Boolean setterArg) {
            this.buildingsEnabled = setterArg;
        }

        @Nullable
        public Boolean getLiteModeEnabled() {
            return this.liteModeEnabled;
        }

        public void setLiteModeEnabled(@Nullable Boolean setterArg) {
            this.liteModeEnabled = setterArg;
        }

        @Nullable
        public String getCloudMapId() {
            return this.cloudMapId;
        }

        public void setCloudMapId(@Nullable String setterArg) {
            this.cloudMapId = setterArg;
        }

        @Nullable
        public String getStyle() {
            return this.style;
        }

        public void setStyle(@Nullable String setterArg) {
            this.style = setterArg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformMapConfiguration that = (PlatformMapConfiguration)o;
            return Objects.equals(this.compassEnabled, that.compassEnabled) && Objects.equals(this.cameraTargetBounds, that.cameraTargetBounds) && Objects.equals((Object)this.mapType, (Object)that.mapType) && Objects.equals(this.minMaxZoomPreference, that.minMaxZoomPreference) && Objects.equals(this.mapToolbarEnabled, that.mapToolbarEnabled) && Objects.equals(this.rotateGesturesEnabled, that.rotateGesturesEnabled) && Objects.equals(this.scrollGesturesEnabled, that.scrollGesturesEnabled) && Objects.equals(this.tiltGesturesEnabled, that.tiltGesturesEnabled) && Objects.equals(this.trackCameraPosition, that.trackCameraPosition) && Objects.equals(this.zoomControlsEnabled, that.zoomControlsEnabled) && Objects.equals(this.zoomGesturesEnabled, that.zoomGesturesEnabled) && Objects.equals(this.myLocationEnabled, that.myLocationEnabled) && Objects.equals(this.myLocationButtonEnabled, that.myLocationButtonEnabled) && Objects.equals(this.padding, that.padding) && Objects.equals(this.indoorViewEnabled, that.indoorViewEnabled) && Objects.equals(this.trafficEnabled, that.trafficEnabled) && Objects.equals(this.buildingsEnabled, that.buildingsEnabled) && Objects.equals(this.liteModeEnabled, that.liteModeEnabled) && Objects.equals(this.cloudMapId, that.cloudMapId) && Objects.equals(this.style, that.style);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.compassEnabled, this.cameraTargetBounds, this.mapType, this.minMaxZoomPreference, this.mapToolbarEnabled, this.rotateGesturesEnabled, this.scrollGesturesEnabled, this.tiltGesturesEnabled, this.trackCameraPosition, this.zoomControlsEnabled, this.zoomGesturesEnabled, this.myLocationEnabled, this.myLocationButtonEnabled, this.padding, this.indoorViewEnabled, this.trafficEnabled, this.buildingsEnabled, this.liteModeEnabled, this.cloudMapId, this.style});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(20);
            toListResult.add(this.compassEnabled);
            toListResult.add(this.cameraTargetBounds);
            toListResult.add((Object)this.mapType);
            toListResult.add(this.minMaxZoomPreference);
            toListResult.add(this.mapToolbarEnabled);
            toListResult.add(this.rotateGesturesEnabled);
            toListResult.add(this.scrollGesturesEnabled);
            toListResult.add(this.tiltGesturesEnabled);
            toListResult.add(this.trackCameraPosition);
            toListResult.add(this.zoomControlsEnabled);
            toListResult.add(this.zoomGesturesEnabled);
            toListResult.add(this.myLocationEnabled);
            toListResult.add(this.myLocationButtonEnabled);
            toListResult.add(this.padding);
            toListResult.add(this.indoorViewEnabled);
            toListResult.add(this.trafficEnabled);
            toListResult.add(this.buildingsEnabled);
            toListResult.add(this.liteModeEnabled);
            toListResult.add(this.cloudMapId);
            toListResult.add(this.style);
            return toListResult;
        }

        @NonNull
        static PlatformMapConfiguration fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformMapConfiguration pigeonResult = new PlatformMapConfiguration();
            Object compassEnabled = pigeonVar_list.get(0);
            pigeonResult.setCompassEnabled((Boolean)compassEnabled);
            Object cameraTargetBounds = pigeonVar_list.get(1);
            pigeonResult.setCameraTargetBounds((PlatformCameraTargetBounds)cameraTargetBounds);
            Object mapType = pigeonVar_list.get(2);
            pigeonResult.setMapType((PlatformMapType)((Object)mapType));
            Object minMaxZoomPreference = pigeonVar_list.get(3);
            pigeonResult.setMinMaxZoomPreference((PlatformZoomRange)minMaxZoomPreference);
            Object mapToolbarEnabled = pigeonVar_list.get(4);
            pigeonResult.setMapToolbarEnabled((Boolean)mapToolbarEnabled);
            Object rotateGesturesEnabled = pigeonVar_list.get(5);
            pigeonResult.setRotateGesturesEnabled((Boolean)rotateGesturesEnabled);
            Object scrollGesturesEnabled = pigeonVar_list.get(6);
            pigeonResult.setScrollGesturesEnabled((Boolean)scrollGesturesEnabled);
            Object tiltGesturesEnabled = pigeonVar_list.get(7);
            pigeonResult.setTiltGesturesEnabled((Boolean)tiltGesturesEnabled);
            Object trackCameraPosition = pigeonVar_list.get(8);
            pigeonResult.setTrackCameraPosition((Boolean)trackCameraPosition);
            Object zoomControlsEnabled = pigeonVar_list.get(9);
            pigeonResult.setZoomControlsEnabled((Boolean)zoomControlsEnabled);
            Object zoomGesturesEnabled = pigeonVar_list.get(10);
            pigeonResult.setZoomGesturesEnabled((Boolean)zoomGesturesEnabled);
            Object myLocationEnabled = pigeonVar_list.get(11);
            pigeonResult.setMyLocationEnabled((Boolean)myLocationEnabled);
            Object myLocationButtonEnabled = pigeonVar_list.get(12);
            pigeonResult.setMyLocationButtonEnabled((Boolean)myLocationButtonEnabled);
            Object padding = pigeonVar_list.get(13);
            pigeonResult.setPadding((PlatformEdgeInsets)padding);
            Object indoorViewEnabled = pigeonVar_list.get(14);
            pigeonResult.setIndoorViewEnabled((Boolean)indoorViewEnabled);
            Object trafficEnabled = pigeonVar_list.get(15);
            pigeonResult.setTrafficEnabled((Boolean)trafficEnabled);
            Object buildingsEnabled = pigeonVar_list.get(16);
            pigeonResult.setBuildingsEnabled((Boolean)buildingsEnabled);
            Object liteModeEnabled = pigeonVar_list.get(17);
            pigeonResult.setLiteModeEnabled((Boolean)liteModeEnabled);
            Object cloudMapId = pigeonVar_list.get(18);
            pigeonResult.setCloudMapId((String)cloudMapId);
            Object style = pigeonVar_list.get(19);
            pigeonResult.setStyle((String)style);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean compassEnabled;
            @Nullable
            private PlatformCameraTargetBounds cameraTargetBounds;
            @Nullable
            private PlatformMapType mapType;
            @Nullable
            private PlatformZoomRange minMaxZoomPreference;
            @Nullable
            private Boolean mapToolbarEnabled;
            @Nullable
            private Boolean rotateGesturesEnabled;
            @Nullable
            private Boolean scrollGesturesEnabled;
            @Nullable
            private Boolean tiltGesturesEnabled;
            @Nullable
            private Boolean trackCameraPosition;
            @Nullable
            private Boolean zoomControlsEnabled;
            @Nullable
            private Boolean zoomGesturesEnabled;
            @Nullable
            private Boolean myLocationEnabled;
            @Nullable
            private Boolean myLocationButtonEnabled;
            @Nullable
            private PlatformEdgeInsets padding;
            @Nullable
            private Boolean indoorViewEnabled;
            @Nullable
            private Boolean trafficEnabled;
            @Nullable
            private Boolean buildingsEnabled;
            @Nullable
            private Boolean liteModeEnabled;
            @Nullable
            private String cloudMapId;
            @Nullable
            private String style;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCompassEnabled(@Nullable Boolean setterArg) {
                this.compassEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCameraTargetBounds(@Nullable PlatformCameraTargetBounds setterArg) {
                this.cameraTargetBounds = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMapType(@Nullable PlatformMapType setterArg) {
                this.mapType = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMinMaxZoomPreference(@Nullable PlatformZoomRange setterArg) {
                this.minMaxZoomPreference = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMapToolbarEnabled(@Nullable Boolean setterArg) {
                this.mapToolbarEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRotateGesturesEnabled(@Nullable Boolean setterArg) {
                this.rotateGesturesEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setScrollGesturesEnabled(@Nullable Boolean setterArg) {
                this.scrollGesturesEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTiltGesturesEnabled(@Nullable Boolean setterArg) {
                this.tiltGesturesEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTrackCameraPosition(@Nullable Boolean setterArg) {
                this.trackCameraPosition = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZoomControlsEnabled(@Nullable Boolean setterArg) {
                this.zoomControlsEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZoomGesturesEnabled(@Nullable Boolean setterArg) {
                this.zoomGesturesEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMyLocationEnabled(@Nullable Boolean setterArg) {
                this.myLocationEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMyLocationButtonEnabled(@Nullable Boolean setterArg) {
                this.myLocationButtonEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPadding(@Nullable PlatformEdgeInsets setterArg) {
                this.padding = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIndoorViewEnabled(@Nullable Boolean setterArg) {
                this.indoorViewEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTrafficEnabled(@Nullable Boolean setterArg) {
                this.trafficEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBuildingsEnabled(@Nullable Boolean setterArg) {
                this.buildingsEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLiteModeEnabled(@Nullable Boolean setterArg) {
                this.liteModeEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCloudMapId(@Nullable String setterArg) {
                this.cloudMapId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStyle(@Nullable String setterArg) {
                this.style = setterArg;
                return this;
            }

            @NonNull
            public PlatformMapConfiguration build() {
                PlatformMapConfiguration pigeonReturn = new PlatformMapConfiguration();
                pigeonReturn.setCompassEnabled(this.compassEnabled);
                pigeonReturn.setCameraTargetBounds(this.cameraTargetBounds);
                pigeonReturn.setMapType(this.mapType);
                pigeonReturn.setMinMaxZoomPreference(this.minMaxZoomPreference);
                pigeonReturn.setMapToolbarEnabled(this.mapToolbarEnabled);
                pigeonReturn.setRotateGesturesEnabled(this.rotateGesturesEnabled);
                pigeonReturn.setScrollGesturesEnabled(this.scrollGesturesEnabled);
                pigeonReturn.setTiltGesturesEnabled(this.tiltGesturesEnabled);
                pigeonReturn.setTrackCameraPosition(this.trackCameraPosition);
                pigeonReturn.setZoomControlsEnabled(this.zoomControlsEnabled);
                pigeonReturn.setZoomGesturesEnabled(this.zoomGesturesEnabled);
                pigeonReturn.setMyLocationEnabled(this.myLocationEnabled);
                pigeonReturn.setMyLocationButtonEnabled(this.myLocationButtonEnabled);
                pigeonReturn.setPadding(this.padding);
                pigeonReturn.setIndoorViewEnabled(this.indoorViewEnabled);
                pigeonReturn.setTrafficEnabled(this.trafficEnabled);
                pigeonReturn.setBuildingsEnabled(this.buildingsEnabled);
                pigeonReturn.setLiteModeEnabled(this.liteModeEnabled);
                pigeonReturn.setCloudMapId(this.cloudMapId);
                pigeonReturn.setStyle(this.style);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformMapViewCreationParams {
        @NonNull
        private PlatformCameraPosition initialCameraPosition;
        @NonNull
        private PlatformMapConfiguration mapConfiguration;
        @NonNull
        private List<PlatformCircle> initialCircles;
        @NonNull
        private List<PlatformMarker> initialMarkers;
        @NonNull
        private List<PlatformPolygon> initialPolygons;
        @NonNull
        private List<PlatformPolyline> initialPolylines;
        @NonNull
        private List<PlatformHeatmap> initialHeatmaps;
        @NonNull
        private List<PlatformTileOverlay> initialTileOverlays;
        @NonNull
        private List<PlatformClusterManager> initialClusterManagers;
        @NonNull
        private List<PlatformGroundOverlay> initialGroundOverlays;

        @NonNull
        public PlatformCameraPosition getInitialCameraPosition() {
            return this.initialCameraPosition;
        }

        public void setInitialCameraPosition(@NonNull PlatformCameraPosition setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialCameraPosition\" is null.");
            }
            this.initialCameraPosition = setterArg;
        }

        @NonNull
        public PlatformMapConfiguration getMapConfiguration() {
            return this.mapConfiguration;
        }

        public void setMapConfiguration(@NonNull PlatformMapConfiguration setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"mapConfiguration\" is null.");
            }
            this.mapConfiguration = setterArg;
        }

        @NonNull
        public List<PlatformCircle> getInitialCircles() {
            return this.initialCircles;
        }

        public void setInitialCircles(@NonNull List<PlatformCircle> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialCircles\" is null.");
            }
            this.initialCircles = setterArg;
        }

        @NonNull
        public List<PlatformMarker> getInitialMarkers() {
            return this.initialMarkers;
        }

        public void setInitialMarkers(@NonNull List<PlatformMarker> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialMarkers\" is null.");
            }
            this.initialMarkers = setterArg;
        }

        @NonNull
        public List<PlatformPolygon> getInitialPolygons() {
            return this.initialPolygons;
        }

        public void setInitialPolygons(@NonNull List<PlatformPolygon> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialPolygons\" is null.");
            }
            this.initialPolygons = setterArg;
        }

        @NonNull
        public List<PlatformPolyline> getInitialPolylines() {
            return this.initialPolylines;
        }

        public void setInitialPolylines(@NonNull List<PlatformPolyline> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialPolylines\" is null.");
            }
            this.initialPolylines = setterArg;
        }

        @NonNull
        public List<PlatformHeatmap> getInitialHeatmaps() {
            return this.initialHeatmaps;
        }

        public void setInitialHeatmaps(@NonNull List<PlatformHeatmap> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialHeatmaps\" is null.");
            }
            this.initialHeatmaps = setterArg;
        }

        @NonNull
        public List<PlatformTileOverlay> getInitialTileOverlays() {
            return this.initialTileOverlays;
        }

        public void setInitialTileOverlays(@NonNull List<PlatformTileOverlay> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialTileOverlays\" is null.");
            }
            this.initialTileOverlays = setterArg;
        }

        @NonNull
        public List<PlatformClusterManager> getInitialClusterManagers() {
            return this.initialClusterManagers;
        }

        public void setInitialClusterManagers(@NonNull List<PlatformClusterManager> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialClusterManagers\" is null.");
            }
            this.initialClusterManagers = setterArg;
        }

        @NonNull
        public List<PlatformGroundOverlay> getInitialGroundOverlays() {
            return this.initialGroundOverlays;
        }

        public void setInitialGroundOverlays(@NonNull List<PlatformGroundOverlay> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"initialGroundOverlays\" is null.");
            }
            this.initialGroundOverlays = setterArg;
        }

        PlatformMapViewCreationParams() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformMapViewCreationParams that = (PlatformMapViewCreationParams)o;
            return this.initialCameraPosition.equals(that.initialCameraPosition) && this.mapConfiguration.equals(that.mapConfiguration) && this.initialCircles.equals(that.initialCircles) && this.initialMarkers.equals(that.initialMarkers) && this.initialPolygons.equals(that.initialPolygons) && this.initialPolylines.equals(that.initialPolylines) && this.initialHeatmaps.equals(that.initialHeatmaps) && this.initialTileOverlays.equals(that.initialTileOverlays) && this.initialClusterManagers.equals(that.initialClusterManagers) && this.initialGroundOverlays.equals(that.initialGroundOverlays);
        }

        public int hashCode() {
            return Objects.hash(this.initialCameraPosition, this.mapConfiguration, this.initialCircles, this.initialMarkers, this.initialPolygons, this.initialPolylines, this.initialHeatmaps, this.initialTileOverlays, this.initialClusterManagers, this.initialGroundOverlays);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(10);
            toListResult.add(this.initialCameraPosition);
            toListResult.add(this.mapConfiguration);
            toListResult.add(this.initialCircles);
            toListResult.add(this.initialMarkers);
            toListResult.add(this.initialPolygons);
            toListResult.add(this.initialPolylines);
            toListResult.add(this.initialHeatmaps);
            toListResult.add(this.initialTileOverlays);
            toListResult.add(this.initialClusterManagers);
            toListResult.add(this.initialGroundOverlays);
            return toListResult;
        }

        @NonNull
        static PlatformMapViewCreationParams fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformMapViewCreationParams pigeonResult = new PlatformMapViewCreationParams();
            Object initialCameraPosition = pigeonVar_list.get(0);
            pigeonResult.setInitialCameraPosition((PlatformCameraPosition)initialCameraPosition);
            Object mapConfiguration = pigeonVar_list.get(1);
            pigeonResult.setMapConfiguration((PlatformMapConfiguration)mapConfiguration);
            Object initialCircles = pigeonVar_list.get(2);
            pigeonResult.setInitialCircles((List)initialCircles);
            Object initialMarkers = pigeonVar_list.get(3);
            pigeonResult.setInitialMarkers((List)initialMarkers);
            Object initialPolygons = pigeonVar_list.get(4);
            pigeonResult.setInitialPolygons((List)initialPolygons);
            Object initialPolylines = pigeonVar_list.get(5);
            pigeonResult.setInitialPolylines((List)initialPolylines);
            Object initialHeatmaps = pigeonVar_list.get(6);
            pigeonResult.setInitialHeatmaps((List)initialHeatmaps);
            Object initialTileOverlays = pigeonVar_list.get(7);
            pigeonResult.setInitialTileOverlays((List)initialTileOverlays);
            Object initialClusterManagers = pigeonVar_list.get(8);
            pigeonResult.setInitialClusterManagers((List)initialClusterManagers);
            Object initialGroundOverlays = pigeonVar_list.get(9);
            pigeonResult.setInitialGroundOverlays((List)initialGroundOverlays);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformCameraPosition initialCameraPosition;
            @Nullable
            private PlatformMapConfiguration mapConfiguration;
            @Nullable
            private List<PlatformCircle> initialCircles;
            @Nullable
            private List<PlatformMarker> initialMarkers;
            @Nullable
            private List<PlatformPolygon> initialPolygons;
            @Nullable
            private List<PlatformPolyline> initialPolylines;
            @Nullable
            private List<PlatformHeatmap> initialHeatmaps;
            @Nullable
            private List<PlatformTileOverlay> initialTileOverlays;
            @Nullable
            private List<PlatformClusterManager> initialClusterManagers;
            @Nullable
            private List<PlatformGroundOverlay> initialGroundOverlays;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialCameraPosition(@NonNull PlatformCameraPosition setterArg) {
                this.initialCameraPosition = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMapConfiguration(@NonNull PlatformMapConfiguration setterArg) {
                this.mapConfiguration = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialCircles(@NonNull List<PlatformCircle> setterArg) {
                this.initialCircles = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialMarkers(@NonNull List<PlatformMarker> setterArg) {
                this.initialMarkers = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialPolygons(@NonNull List<PlatformPolygon> setterArg) {
                this.initialPolygons = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialPolylines(@NonNull List<PlatformPolyline> setterArg) {
                this.initialPolylines = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialHeatmaps(@NonNull List<PlatformHeatmap> setterArg) {
                this.initialHeatmaps = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialTileOverlays(@NonNull List<PlatformTileOverlay> setterArg) {
                this.initialTileOverlays = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialClusterManagers(@NonNull List<PlatformClusterManager> setterArg) {
                this.initialClusterManagers = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInitialGroundOverlays(@NonNull List<PlatformGroundOverlay> setterArg) {
                this.initialGroundOverlays = setterArg;
                return this;
            }

            @NonNull
            public PlatformMapViewCreationParams build() {
                PlatformMapViewCreationParams pigeonReturn = new PlatformMapViewCreationParams();
                pigeonReturn.setInitialCameraPosition(this.initialCameraPosition);
                pigeonReturn.setMapConfiguration(this.mapConfiguration);
                pigeonReturn.setInitialCircles(this.initialCircles);
                pigeonReturn.setInitialMarkers(this.initialMarkers);
                pigeonReturn.setInitialPolygons(this.initialPolygons);
                pigeonReturn.setInitialPolylines(this.initialPolylines);
                pigeonReturn.setInitialHeatmaps(this.initialHeatmaps);
                pigeonReturn.setInitialTileOverlays(this.initialTileOverlays);
                pigeonReturn.setInitialClusterManagers(this.initialClusterManagers);
                pigeonReturn.setInitialGroundOverlays(this.initialGroundOverlays);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraTargetBounds {
        @Nullable
        private PlatformLatLngBounds bounds;

        @Nullable
        public PlatformLatLngBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(@Nullable PlatformLatLngBounds setterArg) {
            this.bounds = setterArg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraTargetBounds that = (PlatformCameraTargetBounds)o;
            return Objects.equals(this.bounds, that.bounds);
        }

        public int hashCode() {
            return Objects.hash(this.bounds);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.bounds);
            return toListResult;
        }

        @NonNull
        static PlatformCameraTargetBounds fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraTargetBounds pigeonResult = new PlatformCameraTargetBounds();
            Object bounds = pigeonVar_list.get(0);
            pigeonResult.setBounds((PlatformLatLngBounds)bounds);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformLatLngBounds bounds;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBounds(@Nullable PlatformLatLngBounds setterArg) {
                this.bounds = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraTargetBounds build() {
                PlatformCameraTargetBounds pigeonReturn = new PlatformCameraTargetBounds();
                pigeonReturn.setBounds(this.bounds);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformGroundOverlay {
        @NonNull
        private String groundOverlayId;
        @NonNull
        private PlatformBitmap image;
        @Nullable
        private PlatformLatLng position;
        @Nullable
        private PlatformLatLngBounds bounds;
        @Nullable
        private Double width;
        @Nullable
        private Double height;
        @Nullable
        private PlatformDoublePair anchor;
        @NonNull
        private Double transparency;
        @NonNull
        private Double bearing;
        @NonNull
        private Long zIndex;
        @NonNull
        private Boolean visible;
        @NonNull
        private Boolean clickable;

        @NonNull
        public String getGroundOverlayId() {
            return this.groundOverlayId;
        }

        public void setGroundOverlayId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"groundOverlayId\" is null.");
            }
            this.groundOverlayId = setterArg;
        }

        @NonNull
        public PlatformBitmap getImage() {
            return this.image;
        }

        public void setImage(@NonNull PlatformBitmap setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"image\" is null.");
            }
            this.image = setterArg;
        }

        @Nullable
        public PlatformLatLng getPosition() {
            return this.position;
        }

        public void setPosition(@Nullable PlatformLatLng setterArg) {
            this.position = setterArg;
        }

        @Nullable
        public PlatformLatLngBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(@Nullable PlatformLatLngBounds setterArg) {
            this.bounds = setterArg;
        }

        @Nullable
        public Double getWidth() {
            return this.width;
        }

        public void setWidth(@Nullable Double setterArg) {
            this.width = setterArg;
        }

        @Nullable
        public Double getHeight() {
            return this.height;
        }

        public void setHeight(@Nullable Double setterArg) {
            this.height = setterArg;
        }

        @Nullable
        public PlatformDoublePair getAnchor() {
            return this.anchor;
        }

        public void setAnchor(@Nullable PlatformDoublePair setterArg) {
            this.anchor = setterArg;
        }

        @NonNull
        public Double getTransparency() {
            return this.transparency;
        }

        public void setTransparency(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"transparency\" is null.");
            }
            this.transparency = setterArg;
        }

        @NonNull
        public Double getBearing() {
            return this.bearing;
        }

        public void setBearing(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bearing\" is null.");
            }
            this.bearing = setterArg;
        }

        @NonNull
        public Long getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Boolean getClickable() {
            return this.clickable;
        }

        public void setClickable(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"clickable\" is null.");
            }
            this.clickable = setterArg;
        }

        PlatformGroundOverlay() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformGroundOverlay that = (PlatformGroundOverlay)o;
            return this.groundOverlayId.equals(that.groundOverlayId) && this.image.equals(that.image) && Objects.equals(this.position, that.position) && Objects.equals(this.bounds, that.bounds) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.anchor, that.anchor) && this.transparency.equals(that.transparency) && this.bearing.equals(that.bearing) && this.zIndex.equals(that.zIndex) && this.visible.equals(that.visible) && this.clickable.equals(that.clickable);
        }

        public int hashCode() {
            return Objects.hash(this.groundOverlayId, this.image, this.position, this.bounds, this.width, this.height, this.anchor, this.transparency, this.bearing, this.zIndex, this.visible, this.clickable);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(12);
            toListResult.add(this.groundOverlayId);
            toListResult.add(this.image);
            toListResult.add(this.position);
            toListResult.add(this.bounds);
            toListResult.add(this.width);
            toListResult.add(this.height);
            toListResult.add(this.anchor);
            toListResult.add(this.transparency);
            toListResult.add(this.bearing);
            toListResult.add(this.zIndex);
            toListResult.add(this.visible);
            toListResult.add(this.clickable);
            return toListResult;
        }

        @NonNull
        static PlatformGroundOverlay fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformGroundOverlay pigeonResult = new PlatformGroundOverlay();
            Object groundOverlayId = pigeonVar_list.get(0);
            pigeonResult.setGroundOverlayId((String)groundOverlayId);
            Object image = pigeonVar_list.get(1);
            pigeonResult.setImage((PlatformBitmap)image);
            Object position = pigeonVar_list.get(2);
            pigeonResult.setPosition((PlatformLatLng)position);
            Object bounds = pigeonVar_list.get(3);
            pigeonResult.setBounds((PlatformLatLngBounds)bounds);
            Object width = pigeonVar_list.get(4);
            pigeonResult.setWidth((Double)width);
            Object height = pigeonVar_list.get(5);
            pigeonResult.setHeight((Double)height);
            Object anchor = pigeonVar_list.get(6);
            pigeonResult.setAnchor((PlatformDoublePair)anchor);
            Object transparency = pigeonVar_list.get(7);
            pigeonResult.setTransparency((Double)transparency);
            Object bearing = pigeonVar_list.get(8);
            pigeonResult.setBearing((Double)bearing);
            Object zIndex = pigeonVar_list.get(9);
            pigeonResult.setZIndex((Long)zIndex);
            Object visible = pigeonVar_list.get(10);
            pigeonResult.setVisible((Boolean)visible);
            Object clickable = pigeonVar_list.get(11);
            pigeonResult.setClickable((Boolean)clickable);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String groundOverlayId;
            @Nullable
            private PlatformBitmap image;
            @Nullable
            private PlatformLatLng position;
            @Nullable
            private PlatformLatLngBounds bounds;
            @Nullable
            private Double width;
            @Nullable
            private Double height;
            @Nullable
            private PlatformDoublePair anchor;
            @Nullable
            private Double transparency;
            @Nullable
            private Double bearing;
            @Nullable
            private Long zIndex;
            @Nullable
            private Boolean visible;
            @Nullable
            private Boolean clickable;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setGroundOverlayId(@NonNull String setterArg) {
                this.groundOverlayId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setImage(@NonNull PlatformBitmap setterArg) {
                this.image = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPosition(@Nullable PlatformLatLng setterArg) {
                this.position = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBounds(@Nullable PlatformLatLngBounds setterArg) {
                this.bounds = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@Nullable Double setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeight(@Nullable Double setterArg) {
                this.height = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAnchor(@Nullable PlatformDoublePair setterArg) {
                this.anchor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTransparency(@NonNull Double setterArg) {
                this.transparency = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBearing(@NonNull Double setterArg) {
                this.bearing = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Long setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setClickable(@NonNull Boolean setterArg) {
                this.clickable = setterArg;
                return this;
            }

            @NonNull
            public PlatformGroundOverlay build() {
                PlatformGroundOverlay pigeonReturn = new PlatformGroundOverlay();
                pigeonReturn.setGroundOverlayId(this.groundOverlayId);
                pigeonReturn.setImage(this.image);
                pigeonReturn.setPosition(this.position);
                pigeonReturn.setBounds(this.bounds);
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setHeight(this.height);
                pigeonReturn.setAnchor(this.anchor);
                pigeonReturn.setTransparency(this.transparency);
                pigeonReturn.setBearing(this.bearing);
                pigeonReturn.setZIndex(this.zIndex);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setClickable(this.clickable);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCluster {
        @NonNull
        private String clusterManagerId;
        @NonNull
        private PlatformLatLng position;
        @NonNull
        private PlatformLatLngBounds bounds;
        @NonNull
        private List<String> markerIds;

        @NonNull
        public String getClusterManagerId() {
            return this.clusterManagerId;
        }

        public void setClusterManagerId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"clusterManagerId\" is null.");
            }
            this.clusterManagerId = setterArg;
        }

        @NonNull
        public PlatformLatLng getPosition() {
            return this.position;
        }

        public void setPosition(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"position\" is null.");
            }
            this.position = setterArg;
        }

        @NonNull
        public PlatformLatLngBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(@NonNull PlatformLatLngBounds setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bounds\" is null.");
            }
            this.bounds = setterArg;
        }

        @NonNull
        public List<String> getMarkerIds() {
            return this.markerIds;
        }

        public void setMarkerIds(@NonNull List<String> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"markerIds\" is null.");
            }
            this.markerIds = setterArg;
        }

        PlatformCluster() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCluster that = (PlatformCluster)o;
            return this.clusterManagerId.equals(that.clusterManagerId) && this.position.equals(that.position) && this.bounds.equals(that.bounds) && this.markerIds.equals(that.markerIds);
        }

        public int hashCode() {
            return Objects.hash(this.clusterManagerId, this.position, this.bounds, this.markerIds);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.clusterManagerId);
            toListResult.add(this.position);
            toListResult.add(this.bounds);
            toListResult.add(this.markerIds);
            return toListResult;
        }

        @NonNull
        static PlatformCluster fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCluster pigeonResult = new PlatformCluster();
            Object clusterManagerId = pigeonVar_list.get(0);
            pigeonResult.setClusterManagerId((String)clusterManagerId);
            Object position = pigeonVar_list.get(1);
            pigeonResult.setPosition((PlatformLatLng)position);
            Object bounds = pigeonVar_list.get(2);
            pigeonResult.setBounds((PlatformLatLngBounds)bounds);
            Object markerIds = pigeonVar_list.get(3);
            pigeonResult.setMarkerIds((List)markerIds);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String clusterManagerId;
            @Nullable
            private PlatformLatLng position;
            @Nullable
            private PlatformLatLngBounds bounds;
            @Nullable
            private List<String> markerIds;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setClusterManagerId(@NonNull String setterArg) {
                this.clusterManagerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPosition(@NonNull PlatformLatLng setterArg) {
                this.position = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBounds(@NonNull PlatformLatLngBounds setterArg) {
                this.bounds = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMarkerIds(@NonNull List<String> setterArg) {
                this.markerIds = setterArg;
                return this;
            }

            @NonNull
            public PlatformCluster build() {
                PlatformCluster pigeonReturn = new PlatformCluster();
                pigeonReturn.setClusterManagerId(this.clusterManagerId);
                pigeonReturn.setPosition(this.position);
                pigeonReturn.setBounds(this.bounds);
                pigeonReturn.setMarkerIds(this.markerIds);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformLatLngBounds {
        @NonNull
        private PlatformLatLng northeast;
        @NonNull
        private PlatformLatLng southwest;

        @NonNull
        public PlatformLatLng getNortheast() {
            return this.northeast;
        }

        public void setNortheast(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"northeast\" is null.");
            }
            this.northeast = setterArg;
        }

        @NonNull
        public PlatformLatLng getSouthwest() {
            return this.southwest;
        }

        public void setSouthwest(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"southwest\" is null.");
            }
            this.southwest = setterArg;
        }

        PlatformLatLngBounds() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformLatLngBounds that = (PlatformLatLngBounds)o;
            return this.northeast.equals(that.northeast) && this.southwest.equals(that.southwest);
        }

        public int hashCode() {
            return Objects.hash(this.northeast, this.southwest);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.northeast);
            toListResult.add(this.southwest);
            return toListResult;
        }

        @NonNull
        static PlatformLatLngBounds fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformLatLngBounds pigeonResult = new PlatformLatLngBounds();
            Object northeast = pigeonVar_list.get(0);
            pigeonResult.setNortheast((PlatformLatLng)northeast);
            Object southwest = pigeonVar_list.get(1);
            pigeonResult.setSouthwest((PlatformLatLng)southwest);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformLatLng northeast;
            @Nullable
            private PlatformLatLng southwest;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setNortheast(@NonNull PlatformLatLng setterArg) {
                this.northeast = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSouthwest(@NonNull PlatformLatLng setterArg) {
                this.southwest = setterArg;
                return this;
            }

            @NonNull
            public PlatformLatLngBounds build() {
                PlatformLatLngBounds pigeonReturn = new PlatformLatLngBounds();
                pigeonReturn.setNortheast(this.northeast);
                pigeonReturn.setSouthwest(this.southwest);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformLatLng {
        @NonNull
        private Double latitude;
        @NonNull
        private Double longitude;

        @NonNull
        public Double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"latitude\" is null.");
            }
            this.latitude = setterArg;
        }

        @NonNull
        public Double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"longitude\" is null.");
            }
            this.longitude = setterArg;
        }

        PlatformLatLng() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformLatLng that = (PlatformLatLng)o;
            return this.latitude.equals(that.latitude) && this.longitude.equals(that.longitude);
        }

        public int hashCode() {
            return Objects.hash(this.latitude, this.longitude);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.latitude);
            toListResult.add(this.longitude);
            return toListResult;
        }

        @NonNull
        static PlatformLatLng fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformLatLng pigeonResult = new PlatformLatLng();
            Object latitude = pigeonVar_list.get(0);
            pigeonResult.setLatitude((Double)latitude);
            Object longitude = pigeonVar_list.get(1);
            pigeonResult.setLongitude((Double)longitude);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double latitude;
            @Nullable
            private Double longitude;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLatitude(@NonNull Double setterArg) {
                this.latitude = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLongitude(@NonNull Double setterArg) {
                this.longitude = setterArg;
                return this;
            }

            @NonNull
            public PlatformLatLng build() {
                PlatformLatLng pigeonReturn = new PlatformLatLng();
                pigeonReturn.setLatitude(this.latitude);
                pigeonReturn.setLongitude(this.longitude);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformEdgeInsets {
        @NonNull
        private Double top;
        @NonNull
        private Double bottom;
        @NonNull
        private Double left;
        @NonNull
        private Double right;

        @NonNull
        public Double getTop() {
            return this.top;
        }

        public void setTop(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"top\" is null.");
            }
            this.top = setterArg;
        }

        @NonNull
        public Double getBottom() {
            return this.bottom;
        }

        public void setBottom(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bottom\" is null.");
            }
            this.bottom = setterArg;
        }

        @NonNull
        public Double getLeft() {
            return this.left;
        }

        public void setLeft(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"left\" is null.");
            }
            this.left = setterArg;
        }

        @NonNull
        public Double getRight() {
            return this.right;
        }

        public void setRight(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"right\" is null.");
            }
            this.right = setterArg;
        }

        PlatformEdgeInsets() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformEdgeInsets that = (PlatformEdgeInsets)o;
            return this.top.equals(that.top) && this.bottom.equals(that.bottom) && this.left.equals(that.left) && this.right.equals(that.right);
        }

        public int hashCode() {
            return Objects.hash(this.top, this.bottom, this.left, this.right);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.top);
            toListResult.add(this.bottom);
            toListResult.add(this.left);
            toListResult.add(this.right);
            return toListResult;
        }

        @NonNull
        static PlatformEdgeInsets fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformEdgeInsets pigeonResult = new PlatformEdgeInsets();
            Object top = pigeonVar_list.get(0);
            pigeonResult.setTop((Double)top);
            Object bottom = pigeonVar_list.get(1);
            pigeonResult.setBottom((Double)bottom);
            Object left = pigeonVar_list.get(2);
            pigeonResult.setLeft((Double)left);
            Object right = pigeonVar_list.get(3);
            pigeonResult.setRight((Double)right);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double top;
            @Nullable
            private Double bottom;
            @Nullable
            private Double left;
            @Nullable
            private Double right;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTop(@NonNull Double setterArg) {
                this.top = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBottom(@NonNull Double setterArg) {
                this.bottom = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLeft(@NonNull Double setterArg) {
                this.left = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRight(@NonNull Double setterArg) {
                this.right = setterArg;
                return this;
            }

            @NonNull
            public PlatformEdgeInsets build() {
                PlatformEdgeInsets pigeonReturn = new PlatformEdgeInsets();
                pigeonReturn.setTop(this.top);
                pigeonReturn.setBottom(this.bottom);
                pigeonReturn.setLeft(this.left);
                pigeonReturn.setRight(this.right);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformTileOverlay {
        @NonNull
        private String tileOverlayId;
        @NonNull
        private Boolean fadeIn;
        @NonNull
        private Double transparency;
        @NonNull
        private Long zIndex;
        @NonNull
        private Boolean visible;
        @NonNull
        private Long tileSize;

        @NonNull
        public String getTileOverlayId() {
            return this.tileOverlayId;
        }

        public void setTileOverlayId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"tileOverlayId\" is null.");
            }
            this.tileOverlayId = setterArg;
        }

        @NonNull
        public Boolean getFadeIn() {
            return this.fadeIn;
        }

        public void setFadeIn(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"fadeIn\" is null.");
            }
            this.fadeIn = setterArg;
        }

        @NonNull
        public Double getTransparency() {
            return this.transparency;
        }

        public void setTransparency(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"transparency\" is null.");
            }
            this.transparency = setterArg;
        }

        @NonNull
        public Long getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Long getTileSize() {
            return this.tileSize;
        }

        public void setTileSize(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"tileSize\" is null.");
            }
            this.tileSize = setterArg;
        }

        PlatformTileOverlay() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformTileOverlay that = (PlatformTileOverlay)o;
            return this.tileOverlayId.equals(that.tileOverlayId) && this.fadeIn.equals(that.fadeIn) && this.transparency.equals(that.transparency) && this.zIndex.equals(that.zIndex) && this.visible.equals(that.visible) && this.tileSize.equals(that.tileSize);
        }

        public int hashCode() {
            return Objects.hash(this.tileOverlayId, this.fadeIn, this.transparency, this.zIndex, this.visible, this.tileSize);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(6);
            toListResult.add(this.tileOverlayId);
            toListResult.add(this.fadeIn);
            toListResult.add(this.transparency);
            toListResult.add(this.zIndex);
            toListResult.add(this.visible);
            toListResult.add(this.tileSize);
            return toListResult;
        }

        @NonNull
        static PlatformTileOverlay fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformTileOverlay pigeonResult = new PlatformTileOverlay();
            Object tileOverlayId = pigeonVar_list.get(0);
            pigeonResult.setTileOverlayId((String)tileOverlayId);
            Object fadeIn = pigeonVar_list.get(1);
            pigeonResult.setFadeIn((Boolean)fadeIn);
            Object transparency = pigeonVar_list.get(2);
            pigeonResult.setTransparency((Double)transparency);
            Object zIndex = pigeonVar_list.get(3);
            pigeonResult.setZIndex((Long)zIndex);
            Object visible = pigeonVar_list.get(4);
            pigeonResult.setVisible((Boolean)visible);
            Object tileSize = pigeonVar_list.get(5);
            pigeonResult.setTileSize((Long)tileSize);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String tileOverlayId;
            @Nullable
            private Boolean fadeIn;
            @Nullable
            private Double transparency;
            @Nullable
            private Long zIndex;
            @Nullable
            private Boolean visible;
            @Nullable
            private Long tileSize;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTileOverlayId(@NonNull String setterArg) {
                this.tileOverlayId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFadeIn(@NonNull Boolean setterArg) {
                this.fadeIn = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTransparency(@NonNull Double setterArg) {
                this.transparency = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Long setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTileSize(@NonNull Long setterArg) {
                this.tileSize = setterArg;
                return this;
            }

            @NonNull
            public PlatformTileOverlay build() {
                PlatformTileOverlay pigeonReturn = new PlatformTileOverlay();
                pigeonReturn.setTileOverlayId(this.tileOverlayId);
                pigeonReturn.setFadeIn(this.fadeIn);
                pigeonReturn.setTransparency(this.transparency);
                pigeonReturn.setZIndex(this.zIndex);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setTileSize(this.tileSize);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformTile {
        @NonNull
        private Long width;
        @NonNull
        private Long height;
        @Nullable
        private byte[] data;

        @NonNull
        public Long getWidth() {
            return this.width;
        }

        public void setWidth(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"width\" is null.");
            }
            this.width = setterArg;
        }

        @NonNull
        public Long getHeight() {
            return this.height;
        }

        public void setHeight(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"height\" is null.");
            }
            this.height = setterArg;
        }

        @Nullable
        public byte[] getData() {
            return this.data;
        }

        public void setData(@Nullable byte[] setterArg) {
            this.data = setterArg;
        }

        PlatformTile() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformTile that = (PlatformTile)o;
            return this.width.equals(that.width) && this.height.equals(that.height) && Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            int pigeonVar_result = Objects.hash(this.width, this.height);
            pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(this.data);
            return pigeonVar_result;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.width);
            toListResult.add(this.height);
            toListResult.add(this.data);
            return toListResult;
        }

        @NonNull
        static PlatformTile fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformTile pigeonResult = new PlatformTile();
            Object width = pigeonVar_list.get(0);
            pigeonResult.setWidth((Long)width);
            Object height = pigeonVar_list.get(1);
            pigeonResult.setHeight((Long)height);
            Object data = pigeonVar_list.get(2);
            pigeonResult.setData((byte[])data);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Long width;
            @Nullable
            private Long height;
            @Nullable
            private byte[] data;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@NonNull Long setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeight(@NonNull Long setterArg) {
                this.height = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setData(@Nullable byte[] setterArg) {
                this.data = setterArg;
                return this;
            }

            @NonNull
            public PlatformTile build() {
                PlatformTile pigeonReturn = new PlatformTile();
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setHeight(this.height);
                pigeonReturn.setData(this.data);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformPatternItem {
        @NonNull
        private PlatformPatternItemType type;
        @Nullable
        private Double length;

        @NonNull
        public PlatformPatternItemType getType() {
            return this.type;
        }

        public void setType(@NonNull PlatformPatternItemType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public Double getLength() {
            return this.length;
        }

        public void setLength(@Nullable Double setterArg) {
            this.length = setterArg;
        }

        PlatformPatternItem() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformPatternItem that = (PlatformPatternItem)o;
            return this.type.equals((Object)that.type) && Objects.equals(this.length, that.length);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.length});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add((Object)this.type);
            toListResult.add(this.length);
            return toListResult;
        }

        @NonNull
        static PlatformPatternItem fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformPatternItem pigeonResult = new PlatformPatternItem();
            Object type = pigeonVar_list.get(0);
            pigeonResult.setType((PlatformPatternItemType)((Object)type));
            Object length = pigeonVar_list.get(1);
            pigeonResult.setLength((Double)length);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformPatternItemType type;
            @Nullable
            private Double length;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setType(@NonNull PlatformPatternItemType setterArg) {
                this.type = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLength(@Nullable Double setterArg) {
                this.length = setterArg;
                return this;
            }

            @NonNull
            public PlatformPatternItem build() {
                PlatformPatternItem pigeonReturn = new PlatformPatternItem();
                pigeonReturn.setType(this.type);
                pigeonReturn.setLength(this.length);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCap {
        @NonNull
        private PlatformCapType type;
        @Nullable
        private PlatformBitmap bitmapDescriptor;
        @Nullable
        private Double refWidth;

        @NonNull
        public PlatformCapType getType() {
            return this.type;
        }

        public void setType(@NonNull PlatformCapType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public PlatformBitmap getBitmapDescriptor() {
            return this.bitmapDescriptor;
        }

        public void setBitmapDescriptor(@Nullable PlatformBitmap setterArg) {
            this.bitmapDescriptor = setterArg;
        }

        @Nullable
        public Double getRefWidth() {
            return this.refWidth;
        }

        public void setRefWidth(@Nullable Double setterArg) {
            this.refWidth = setterArg;
        }

        PlatformCap() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCap that = (PlatformCap)o;
            return this.type.equals((Object)that.type) && Objects.equals(this.bitmapDescriptor, that.bitmapDescriptor) && Objects.equals(this.refWidth, that.refWidth);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.bitmapDescriptor, this.refWidth});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add((Object)this.type);
            toListResult.add(this.bitmapDescriptor);
            toListResult.add(this.refWidth);
            return toListResult;
        }

        @NonNull
        static PlatformCap fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCap pigeonResult = new PlatformCap();
            Object type = pigeonVar_list.get(0);
            pigeonResult.setType((PlatformCapType)((Object)type));
            Object bitmapDescriptor = pigeonVar_list.get(1);
            pigeonResult.setBitmapDescriptor((PlatformBitmap)bitmapDescriptor);
            Object refWidth = pigeonVar_list.get(2);
            pigeonResult.setRefWidth((Double)refWidth);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformCapType type;
            @Nullable
            private PlatformBitmap bitmapDescriptor;
            @Nullable
            private Double refWidth;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setType(@NonNull PlatformCapType setterArg) {
                this.type = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBitmapDescriptor(@Nullable PlatformBitmap setterArg) {
                this.bitmapDescriptor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRefWidth(@Nullable Double setterArg) {
                this.refWidth = setterArg;
                return this;
            }

            @NonNull
            public PlatformCap build() {
                PlatformCap pigeonReturn = new PlatformCap();
                pigeonReturn.setType(this.type);
                pigeonReturn.setBitmapDescriptor(this.bitmapDescriptor);
                pigeonReturn.setRefWidth(this.refWidth);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformPolyline {
        @NonNull
        private String polylineId;
        @NonNull
        private Boolean consumesTapEvents;
        @NonNull
        private Long color;
        @NonNull
        private Boolean geodesic;
        @NonNull
        private PlatformJointType jointType;
        @NonNull
        private List<PlatformPatternItem> patterns;
        @NonNull
        private List<PlatformLatLng> points;
        @NonNull
        private PlatformCap startCap;
        @NonNull
        private PlatformCap endCap;
        @NonNull
        private Boolean visible;
        @NonNull
        private Long width;
        @NonNull
        private Long zIndex;

        @NonNull
        public String getPolylineId() {
            return this.polylineId;
        }

        public void setPolylineId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"polylineId\" is null.");
            }
            this.polylineId = setterArg;
        }

        @NonNull
        public Boolean getConsumesTapEvents() {
            return this.consumesTapEvents;
        }

        public void setConsumesTapEvents(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"consumesTapEvents\" is null.");
            }
            this.consumesTapEvents = setterArg;
        }

        @NonNull
        public Long getColor() {
            return this.color;
        }

        public void setColor(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"color\" is null.");
            }
            this.color = setterArg;
        }

        @NonNull
        public Boolean getGeodesic() {
            return this.geodesic;
        }

        public void setGeodesic(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"geodesic\" is null.");
            }
            this.geodesic = setterArg;
        }

        @NonNull
        public PlatformJointType getJointType() {
            return this.jointType;
        }

        public void setJointType(@NonNull PlatformJointType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"jointType\" is null.");
            }
            this.jointType = setterArg;
        }

        @NonNull
        public List<PlatformPatternItem> getPatterns() {
            return this.patterns;
        }

        public void setPatterns(@NonNull List<PlatformPatternItem> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"patterns\" is null.");
            }
            this.patterns = setterArg;
        }

        @NonNull
        public List<PlatformLatLng> getPoints() {
            return this.points;
        }

        public void setPoints(@NonNull List<PlatformLatLng> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"points\" is null.");
            }
            this.points = setterArg;
        }

        @NonNull
        public PlatformCap getStartCap() {
            return this.startCap;
        }

        public void setStartCap(@NonNull PlatformCap setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"startCap\" is null.");
            }
            this.startCap = setterArg;
        }

        @NonNull
        public PlatformCap getEndCap() {
            return this.endCap;
        }

        public void setEndCap(@NonNull PlatformCap setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"endCap\" is null.");
            }
            this.endCap = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Long getWidth() {
            return this.width;
        }

        public void setWidth(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"width\" is null.");
            }
            this.width = setterArg;
        }

        @NonNull
        public Long getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        PlatformPolyline() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformPolyline that = (PlatformPolyline)o;
            return this.polylineId.equals(that.polylineId) && this.consumesTapEvents.equals(that.consumesTapEvents) && this.color.equals(that.color) && this.geodesic.equals(that.geodesic) && this.jointType.equals((Object)that.jointType) && this.patterns.equals(that.patterns) && this.points.equals(that.points) && this.startCap.equals(that.startCap) && this.endCap.equals(that.endCap) && this.visible.equals(that.visible) && this.width.equals(that.width) && this.zIndex.equals(that.zIndex);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.polylineId, this.consumesTapEvents, this.color, this.geodesic, this.jointType, this.patterns, this.points, this.startCap, this.endCap, this.visible, this.width, this.zIndex});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(12);
            toListResult.add(this.polylineId);
            toListResult.add(this.consumesTapEvents);
            toListResult.add(this.color);
            toListResult.add(this.geodesic);
            toListResult.add((Object)this.jointType);
            toListResult.add(this.patterns);
            toListResult.add(this.points);
            toListResult.add(this.startCap);
            toListResult.add(this.endCap);
            toListResult.add(this.visible);
            toListResult.add(this.width);
            toListResult.add(this.zIndex);
            return toListResult;
        }

        @NonNull
        static PlatformPolyline fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformPolyline pigeonResult = new PlatformPolyline();
            Object polylineId = pigeonVar_list.get(0);
            pigeonResult.setPolylineId((String)polylineId);
            Object consumesTapEvents = pigeonVar_list.get(1);
            pigeonResult.setConsumesTapEvents((Boolean)consumesTapEvents);
            Object color = pigeonVar_list.get(2);
            pigeonResult.setColor((Long)color);
            Object geodesic = pigeonVar_list.get(3);
            pigeonResult.setGeodesic((Boolean)geodesic);
            Object jointType = pigeonVar_list.get(4);
            pigeonResult.setJointType((PlatformJointType)((Object)jointType));
            Object patterns = pigeonVar_list.get(5);
            pigeonResult.setPatterns((List)patterns);
            Object points = pigeonVar_list.get(6);
            pigeonResult.setPoints((List)points);
            Object startCap = pigeonVar_list.get(7);
            pigeonResult.setStartCap((PlatformCap)startCap);
            Object endCap = pigeonVar_list.get(8);
            pigeonResult.setEndCap((PlatformCap)endCap);
            Object visible = pigeonVar_list.get(9);
            pigeonResult.setVisible((Boolean)visible);
            Object width = pigeonVar_list.get(10);
            pigeonResult.setWidth((Long)width);
            Object zIndex = pigeonVar_list.get(11);
            pigeonResult.setZIndex((Long)zIndex);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String polylineId;
            @Nullable
            private Boolean consumesTapEvents;
            @Nullable
            private Long color;
            @Nullable
            private Boolean geodesic;
            @Nullable
            private PlatformJointType jointType;
            @Nullable
            private List<PlatformPatternItem> patterns;
            @Nullable
            private List<PlatformLatLng> points;
            @Nullable
            private PlatformCap startCap;
            @Nullable
            private PlatformCap endCap;
            @Nullable
            private Boolean visible;
            @Nullable
            private Long width;
            @Nullable
            private Long zIndex;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPolylineId(@NonNull String setterArg) {
                this.polylineId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setConsumesTapEvents(@NonNull Boolean setterArg) {
                this.consumesTapEvents = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setColor(@NonNull Long setterArg) {
                this.color = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setGeodesic(@NonNull Boolean setterArg) {
                this.geodesic = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setJointType(@NonNull PlatformJointType setterArg) {
                this.jointType = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPatterns(@NonNull List<PlatformPatternItem> setterArg) {
                this.patterns = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPoints(@NonNull List<PlatformLatLng> setterArg) {
                this.points = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStartCap(@NonNull PlatformCap setterArg) {
                this.startCap = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEndCap(@NonNull PlatformCap setterArg) {
                this.endCap = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@NonNull Long setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Long setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @NonNull
            public PlatformPolyline build() {
                PlatformPolyline pigeonReturn = new PlatformPolyline();
                pigeonReturn.setPolylineId(this.polylineId);
                pigeonReturn.setConsumesTapEvents(this.consumesTapEvents);
                pigeonReturn.setColor(this.color);
                pigeonReturn.setGeodesic(this.geodesic);
                pigeonReturn.setJointType(this.jointType);
                pigeonReturn.setPatterns(this.patterns);
                pigeonReturn.setPoints(this.points);
                pigeonReturn.setStartCap(this.startCap);
                pigeonReturn.setEndCap(this.endCap);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setZIndex(this.zIndex);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformPolygon {
        @NonNull
        private String polygonId;
        @NonNull
        private Boolean consumesTapEvents;
        @NonNull
        private Long fillColor;
        @NonNull
        private Boolean geodesic;
        @NonNull
        private List<PlatformLatLng> points;
        @NonNull
        private List<List<PlatformLatLng>> holes;
        @NonNull
        private Boolean visible;
        @NonNull
        private Long strokeColor;
        @NonNull
        private Long strokeWidth;
        @NonNull
        private Long zIndex;

        @NonNull
        public String getPolygonId() {
            return this.polygonId;
        }

        public void setPolygonId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"polygonId\" is null.");
            }
            this.polygonId = setterArg;
        }

        @NonNull
        public Boolean getConsumesTapEvents() {
            return this.consumesTapEvents;
        }

        public void setConsumesTapEvents(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"consumesTapEvents\" is null.");
            }
            this.consumesTapEvents = setterArg;
        }

        @NonNull
        public Long getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"fillColor\" is null.");
            }
            this.fillColor = setterArg;
        }

        @NonNull
        public Boolean getGeodesic() {
            return this.geodesic;
        }

        public void setGeodesic(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"geodesic\" is null.");
            }
            this.geodesic = setterArg;
        }

        @NonNull
        public List<PlatformLatLng> getPoints() {
            return this.points;
        }

        public void setPoints(@NonNull List<PlatformLatLng> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"points\" is null.");
            }
            this.points = setterArg;
        }

        @NonNull
        public List<List<PlatformLatLng>> getHoles() {
            return this.holes;
        }

        public void setHoles(@NonNull List<List<PlatformLatLng>> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"holes\" is null.");
            }
            this.holes = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Long getStrokeColor() {
            return this.strokeColor;
        }

        public void setStrokeColor(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"strokeColor\" is null.");
            }
            this.strokeColor = setterArg;
        }

        @NonNull
        public Long getStrokeWidth() {
            return this.strokeWidth;
        }

        public void setStrokeWidth(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"strokeWidth\" is null.");
            }
            this.strokeWidth = setterArg;
        }

        @NonNull
        public Long getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        PlatformPolygon() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformPolygon that = (PlatformPolygon)o;
            return this.polygonId.equals(that.polygonId) && this.consumesTapEvents.equals(that.consumesTapEvents) && this.fillColor.equals(that.fillColor) && this.geodesic.equals(that.geodesic) && this.points.equals(that.points) && this.holes.equals(that.holes) && this.visible.equals(that.visible) && this.strokeColor.equals(that.strokeColor) && this.strokeWidth.equals(that.strokeWidth) && this.zIndex.equals(that.zIndex);
        }

        public int hashCode() {
            return Objects.hash(this.polygonId, this.consumesTapEvents, this.fillColor, this.geodesic, this.points, this.holes, this.visible, this.strokeColor, this.strokeWidth, this.zIndex);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(10);
            toListResult.add(this.polygonId);
            toListResult.add(this.consumesTapEvents);
            toListResult.add(this.fillColor);
            toListResult.add(this.geodesic);
            toListResult.add(this.points);
            toListResult.add(this.holes);
            toListResult.add(this.visible);
            toListResult.add(this.strokeColor);
            toListResult.add(this.strokeWidth);
            toListResult.add(this.zIndex);
            return toListResult;
        }

        @NonNull
        static PlatformPolygon fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformPolygon pigeonResult = new PlatformPolygon();
            Object polygonId = pigeonVar_list.get(0);
            pigeonResult.setPolygonId((String)polygonId);
            Object consumesTapEvents = pigeonVar_list.get(1);
            pigeonResult.setConsumesTapEvents((Boolean)consumesTapEvents);
            Object fillColor = pigeonVar_list.get(2);
            pigeonResult.setFillColor((Long)fillColor);
            Object geodesic = pigeonVar_list.get(3);
            pigeonResult.setGeodesic((Boolean)geodesic);
            Object points = pigeonVar_list.get(4);
            pigeonResult.setPoints((List)points);
            Object holes = pigeonVar_list.get(5);
            pigeonResult.setHoles((List)holes);
            Object visible = pigeonVar_list.get(6);
            pigeonResult.setVisible((Boolean)visible);
            Object strokeColor = pigeonVar_list.get(7);
            pigeonResult.setStrokeColor((Long)strokeColor);
            Object strokeWidth = pigeonVar_list.get(8);
            pigeonResult.setStrokeWidth((Long)strokeWidth);
            Object zIndex = pigeonVar_list.get(9);
            pigeonResult.setZIndex((Long)zIndex);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String polygonId;
            @Nullable
            private Boolean consumesTapEvents;
            @Nullable
            private Long fillColor;
            @Nullable
            private Boolean geodesic;
            @Nullable
            private List<PlatformLatLng> points;
            @Nullable
            private List<List<PlatformLatLng>> holes;
            @Nullable
            private Boolean visible;
            @Nullable
            private Long strokeColor;
            @Nullable
            private Long strokeWidth;
            @Nullable
            private Long zIndex;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPolygonId(@NonNull String setterArg) {
                this.polygonId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setConsumesTapEvents(@NonNull Boolean setterArg) {
                this.consumesTapEvents = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFillColor(@NonNull Long setterArg) {
                this.fillColor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setGeodesic(@NonNull Boolean setterArg) {
                this.geodesic = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPoints(@NonNull List<PlatformLatLng> setterArg) {
                this.points = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHoles(@NonNull List<List<PlatformLatLng>> setterArg) {
                this.holes = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStrokeColor(@NonNull Long setterArg) {
                this.strokeColor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStrokeWidth(@NonNull Long setterArg) {
                this.strokeWidth = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Long setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @NonNull
            public PlatformPolygon build() {
                PlatformPolygon pigeonReturn = new PlatformPolygon();
                pigeonReturn.setPolygonId(this.polygonId);
                pigeonReturn.setConsumesTapEvents(this.consumesTapEvents);
                pigeonReturn.setFillColor(this.fillColor);
                pigeonReturn.setGeodesic(this.geodesic);
                pigeonReturn.setPoints(this.points);
                pigeonReturn.setHoles(this.holes);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setStrokeColor(this.strokeColor);
                pigeonReturn.setStrokeWidth(this.strokeWidth);
                pigeonReturn.setZIndex(this.zIndex);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformMarker {
        @NonNull
        private Double alpha;
        @NonNull
        private PlatformDoublePair anchor;
        @NonNull
        private Boolean consumeTapEvents;
        @NonNull
        private Boolean draggable;
        @NonNull
        private Boolean flat;
        @NonNull
        private PlatformBitmap icon;
        @NonNull
        private PlatformInfoWindow infoWindow;
        @NonNull
        private PlatformLatLng position;
        @NonNull
        private Double rotation;
        @NonNull
        private Boolean visible;
        @NonNull
        private Double zIndex;
        @NonNull
        private String markerId;
        @Nullable
        private String clusterManagerId;

        @NonNull
        public Double getAlpha() {
            return this.alpha;
        }

        public void setAlpha(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"alpha\" is null.");
            }
            this.alpha = setterArg;
        }

        @NonNull
        public PlatformDoublePair getAnchor() {
            return this.anchor;
        }

        public void setAnchor(@NonNull PlatformDoublePair setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"anchor\" is null.");
            }
            this.anchor = setterArg;
        }

        @NonNull
        public Boolean getConsumeTapEvents() {
            return this.consumeTapEvents;
        }

        public void setConsumeTapEvents(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"consumeTapEvents\" is null.");
            }
            this.consumeTapEvents = setterArg;
        }

        @NonNull
        public Boolean getDraggable() {
            return this.draggable;
        }

        public void setDraggable(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"draggable\" is null.");
            }
            this.draggable = setterArg;
        }

        @NonNull
        public Boolean getFlat() {
            return this.flat;
        }

        public void setFlat(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"flat\" is null.");
            }
            this.flat = setterArg;
        }

        @NonNull
        public PlatformBitmap getIcon() {
            return this.icon;
        }

        public void setIcon(@NonNull PlatformBitmap setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"icon\" is null.");
            }
            this.icon = setterArg;
        }

        @NonNull
        public PlatformInfoWindow getInfoWindow() {
            return this.infoWindow;
        }

        public void setInfoWindow(@NonNull PlatformInfoWindow setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"infoWindow\" is null.");
            }
            this.infoWindow = setterArg;
        }

        @NonNull
        public PlatformLatLng getPosition() {
            return this.position;
        }

        public void setPosition(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"position\" is null.");
            }
            this.position = setterArg;
        }

        @NonNull
        public Double getRotation() {
            return this.rotation;
        }

        public void setRotation(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"rotation\" is null.");
            }
            this.rotation = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Double getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        @NonNull
        public String getMarkerId() {
            return this.markerId;
        }

        public void setMarkerId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"markerId\" is null.");
            }
            this.markerId = setterArg;
        }

        @Nullable
        public String getClusterManagerId() {
            return this.clusterManagerId;
        }

        public void setClusterManagerId(@Nullable String setterArg) {
            this.clusterManagerId = setterArg;
        }

        PlatformMarker() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformMarker that = (PlatformMarker)o;
            return this.alpha.equals(that.alpha) && this.anchor.equals(that.anchor) && this.consumeTapEvents.equals(that.consumeTapEvents) && this.draggable.equals(that.draggable) && this.flat.equals(that.flat) && this.icon.equals(that.icon) && this.infoWindow.equals(that.infoWindow) && this.position.equals(that.position) && this.rotation.equals(that.rotation) && this.visible.equals(that.visible) && this.zIndex.equals(that.zIndex) && this.markerId.equals(that.markerId) && Objects.equals(this.clusterManagerId, that.clusterManagerId);
        }

        public int hashCode() {
            return Objects.hash(this.alpha, this.anchor, this.consumeTapEvents, this.draggable, this.flat, this.icon, this.infoWindow, this.position, this.rotation, this.visible, this.zIndex, this.markerId, this.clusterManagerId);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(13);
            toListResult.add(this.alpha);
            toListResult.add(this.anchor);
            toListResult.add(this.consumeTapEvents);
            toListResult.add(this.draggable);
            toListResult.add(this.flat);
            toListResult.add(this.icon);
            toListResult.add(this.infoWindow);
            toListResult.add(this.position);
            toListResult.add(this.rotation);
            toListResult.add(this.visible);
            toListResult.add(this.zIndex);
            toListResult.add(this.markerId);
            toListResult.add(this.clusterManagerId);
            return toListResult;
        }

        @NonNull
        static PlatformMarker fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformMarker pigeonResult = new PlatformMarker();
            Object alpha = pigeonVar_list.get(0);
            pigeonResult.setAlpha((Double)alpha);
            Object anchor = pigeonVar_list.get(1);
            pigeonResult.setAnchor((PlatformDoublePair)anchor);
            Object consumeTapEvents = pigeonVar_list.get(2);
            pigeonResult.setConsumeTapEvents((Boolean)consumeTapEvents);
            Object draggable = pigeonVar_list.get(3);
            pigeonResult.setDraggable((Boolean)draggable);
            Object flat = pigeonVar_list.get(4);
            pigeonResult.setFlat((Boolean)flat);
            Object icon = pigeonVar_list.get(5);
            pigeonResult.setIcon((PlatformBitmap)icon);
            Object infoWindow = pigeonVar_list.get(6);
            pigeonResult.setInfoWindow((PlatformInfoWindow)infoWindow);
            Object position = pigeonVar_list.get(7);
            pigeonResult.setPosition((PlatformLatLng)position);
            Object rotation = pigeonVar_list.get(8);
            pigeonResult.setRotation((Double)rotation);
            Object visible = pigeonVar_list.get(9);
            pigeonResult.setVisible((Boolean)visible);
            Object zIndex = pigeonVar_list.get(10);
            pigeonResult.setZIndex((Double)zIndex);
            Object markerId = pigeonVar_list.get(11);
            pigeonResult.setMarkerId((String)markerId);
            Object clusterManagerId = pigeonVar_list.get(12);
            pigeonResult.setClusterManagerId((String)clusterManagerId);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double alpha;
            @Nullable
            private PlatformDoublePair anchor;
            @Nullable
            private Boolean consumeTapEvents;
            @Nullable
            private Boolean draggable;
            @Nullable
            private Boolean flat;
            @Nullable
            private PlatformBitmap icon;
            @Nullable
            private PlatformInfoWindow infoWindow;
            @Nullable
            private PlatformLatLng position;
            @Nullable
            private Double rotation;
            @Nullable
            private Boolean visible;
            @Nullable
            private Double zIndex;
            @Nullable
            private String markerId;
            @Nullable
            private String clusterManagerId;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAlpha(@NonNull Double setterArg) {
                this.alpha = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAnchor(@NonNull PlatformDoublePair setterArg) {
                this.anchor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setConsumeTapEvents(@NonNull Boolean setterArg) {
                this.consumeTapEvents = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDraggable(@NonNull Boolean setterArg) {
                this.draggable = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFlat(@NonNull Boolean setterArg) {
                this.flat = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIcon(@NonNull PlatformBitmap setterArg) {
                this.icon = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setInfoWindow(@NonNull PlatformInfoWindow setterArg) {
                this.infoWindow = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPosition(@NonNull PlatformLatLng setterArg) {
                this.position = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRotation(@NonNull Double setterArg) {
                this.rotation = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Double setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMarkerId(@NonNull String setterArg) {
                this.markerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setClusterManagerId(@Nullable String setterArg) {
                this.clusterManagerId = setterArg;
                return this;
            }

            @NonNull
            public PlatformMarker build() {
                PlatformMarker pigeonReturn = new PlatformMarker();
                pigeonReturn.setAlpha(this.alpha);
                pigeonReturn.setAnchor(this.anchor);
                pigeonReturn.setConsumeTapEvents(this.consumeTapEvents);
                pigeonReturn.setDraggable(this.draggable);
                pigeonReturn.setFlat(this.flat);
                pigeonReturn.setIcon(this.icon);
                pigeonReturn.setInfoWindow(this.infoWindow);
                pigeonReturn.setPosition(this.position);
                pigeonReturn.setRotation(this.rotation);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setZIndex(this.zIndex);
                pigeonReturn.setMarkerId(this.markerId);
                pigeonReturn.setClusterManagerId(this.clusterManagerId);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformInfoWindow {
        @Nullable
        private String title;
        @Nullable
        private String snippet;
        @NonNull
        private PlatformDoublePair anchor;

        @Nullable
        public String getTitle() {
            return this.title;
        }

        public void setTitle(@Nullable String setterArg) {
            this.title = setterArg;
        }

        @Nullable
        public String getSnippet() {
            return this.snippet;
        }

        public void setSnippet(@Nullable String setterArg) {
            this.snippet = setterArg;
        }

        @NonNull
        public PlatformDoublePair getAnchor() {
            return this.anchor;
        }

        public void setAnchor(@NonNull PlatformDoublePair setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"anchor\" is null.");
            }
            this.anchor = setterArg;
        }

        PlatformInfoWindow() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformInfoWindow that = (PlatformInfoWindow)o;
            return Objects.equals(this.title, that.title) && Objects.equals(this.snippet, that.snippet) && this.anchor.equals(that.anchor);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.snippet, this.anchor);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.title);
            toListResult.add(this.snippet);
            toListResult.add(this.anchor);
            return toListResult;
        }

        @NonNull
        static PlatformInfoWindow fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformInfoWindow pigeonResult = new PlatformInfoWindow();
            Object title = pigeonVar_list.get(0);
            pigeonResult.setTitle((String)title);
            Object snippet = pigeonVar_list.get(1);
            pigeonResult.setSnippet((String)snippet);
            Object anchor = pigeonVar_list.get(2);
            pigeonResult.setAnchor((PlatformDoublePair)anchor);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String title;
            @Nullable
            private String snippet;
            @Nullable
            private PlatformDoublePair anchor;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTitle(@Nullable String setterArg) {
                this.title = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSnippet(@Nullable String setterArg) {
                this.snippet = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAnchor(@NonNull PlatformDoublePair setterArg) {
                this.anchor = setterArg;
                return this;
            }

            @NonNull
            public PlatformInfoWindow build() {
                PlatformInfoWindow pigeonReturn = new PlatformInfoWindow();
                pigeonReturn.setTitle(this.title);
                pigeonReturn.setSnippet(this.snippet);
                pigeonReturn.setAnchor(this.anchor);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformDoublePair {
        @NonNull
        private Double x;
        @NonNull
        private Double y;

        @NonNull
        public Double getX() {
            return this.x;
        }

        public void setX(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"x\" is null.");
            }
            this.x = setterArg;
        }

        @NonNull
        public Double getY() {
            return this.y;
        }

        public void setY(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"y\" is null.");
            }
            this.y = setterArg;
        }

        PlatformDoublePair() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformDoublePair that = (PlatformDoublePair)o;
            return this.x.equals(that.x) && this.y.equals(that.y);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.x);
            toListResult.add(this.y);
            return toListResult;
        }

        @NonNull
        static PlatformDoublePair fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformDoublePair pigeonResult = new PlatformDoublePair();
            Object x = pigeonVar_list.get(0);
            pigeonResult.setX((Double)x);
            Object y = pigeonVar_list.get(1);
            pigeonResult.setY((Double)y);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double x;
            @Nullable
            private Double y;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setX(@NonNull Double setterArg) {
                this.x = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setY(@NonNull Double setterArg) {
                this.y = setterArg;
                return this;
            }

            @NonNull
            public PlatformDoublePair build() {
                PlatformDoublePair pigeonReturn = new PlatformDoublePair();
                pigeonReturn.setX(this.x);
                pigeonReturn.setY(this.y);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformClusterManager {
        @NonNull
        private String identifier;

        @NonNull
        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"identifier\" is null.");
            }
            this.identifier = setterArg;
        }

        PlatformClusterManager() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformClusterManager that = (PlatformClusterManager)o;
            return this.identifier.equals(that.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.identifier);
            return toListResult;
        }

        @NonNull
        static PlatformClusterManager fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformClusterManager pigeonResult = new PlatformClusterManager();
            Object identifier = pigeonVar_list.get(0);
            pigeonResult.setIdentifier((String)identifier);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String identifier;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIdentifier(@NonNull String setterArg) {
                this.identifier = setterArg;
                return this;
            }

            @NonNull
            public PlatformClusterManager build() {
                PlatformClusterManager pigeonReturn = new PlatformClusterManager();
                pigeonReturn.setIdentifier(this.identifier);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformHeatmap {
        @NonNull
        private Map<String, Object> json;

        @NonNull
        public Map<String, Object> getJson() {
            return this.json;
        }

        public void setJson(@NonNull Map<String, Object> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"json\" is null.");
            }
            this.json = setterArg;
        }

        PlatformHeatmap() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformHeatmap that = (PlatformHeatmap)o;
            return this.json.equals(that.json);
        }

        public int hashCode() {
            return Objects.hash(this.json);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.json);
            return toListResult;
        }

        @NonNull
        static PlatformHeatmap fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformHeatmap pigeonResult = new PlatformHeatmap();
            Object json = pigeonVar_list.get(0);
            pigeonResult.setJson((Map)json);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Map<String, Object> json;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setJson(@NonNull Map<String, Object> setterArg) {
                this.json = setterArg;
                return this;
            }

            @NonNull
            public PlatformHeatmap build() {
                PlatformHeatmap pigeonReturn = new PlatformHeatmap();
                pigeonReturn.setJson(this.json);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCircle {
        @NonNull
        private Boolean consumeTapEvents;
        @NonNull
        private Long fillColor;
        @NonNull
        private Long strokeColor;
        @NonNull
        private Boolean visible;
        @NonNull
        private Long strokeWidth;
        @NonNull
        private Double zIndex;
        @NonNull
        private PlatformLatLng center;
        @NonNull
        private Double radius;
        @NonNull
        private String circleId;

        @NonNull
        public Boolean getConsumeTapEvents() {
            return this.consumeTapEvents;
        }

        public void setConsumeTapEvents(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"consumeTapEvents\" is null.");
            }
            this.consumeTapEvents = setterArg;
        }

        @NonNull
        public Long getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"fillColor\" is null.");
            }
            this.fillColor = setterArg;
        }

        @NonNull
        public Long getStrokeColor() {
            return this.strokeColor;
        }

        public void setStrokeColor(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"strokeColor\" is null.");
            }
            this.strokeColor = setterArg;
        }

        @NonNull
        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"visible\" is null.");
            }
            this.visible = setterArg;
        }

        @NonNull
        public Long getStrokeWidth() {
            return this.strokeWidth;
        }

        public void setStrokeWidth(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"strokeWidth\" is null.");
            }
            this.strokeWidth = setterArg;
        }

        @NonNull
        public Double getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zIndex\" is null.");
            }
            this.zIndex = setterArg;
        }

        @NonNull
        public PlatformLatLng getCenter() {
            return this.center;
        }

        public void setCenter(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"center\" is null.");
            }
            this.center = setterArg;
        }

        @NonNull
        public Double getRadius() {
            return this.radius;
        }

        public void setRadius(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"radius\" is null.");
            }
            this.radius = setterArg;
        }

        @NonNull
        public String getCircleId() {
            return this.circleId;
        }

        public void setCircleId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"circleId\" is null.");
            }
            this.circleId = setterArg;
        }

        PlatformCircle() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCircle that = (PlatformCircle)o;
            return this.consumeTapEvents.equals(that.consumeTapEvents) && this.fillColor.equals(that.fillColor) && this.strokeColor.equals(that.strokeColor) && this.visible.equals(that.visible) && this.strokeWidth.equals(that.strokeWidth) && this.zIndex.equals(that.zIndex) && this.center.equals(that.center) && this.radius.equals(that.radius) && this.circleId.equals(that.circleId);
        }

        public int hashCode() {
            return Objects.hash(this.consumeTapEvents, this.fillColor, this.strokeColor, this.visible, this.strokeWidth, this.zIndex, this.center, this.radius, this.circleId);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(9);
            toListResult.add(this.consumeTapEvents);
            toListResult.add(this.fillColor);
            toListResult.add(this.strokeColor);
            toListResult.add(this.visible);
            toListResult.add(this.strokeWidth);
            toListResult.add(this.zIndex);
            toListResult.add(this.center);
            toListResult.add(this.radius);
            toListResult.add(this.circleId);
            return toListResult;
        }

        @NonNull
        static PlatformCircle fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCircle pigeonResult = new PlatformCircle();
            Object consumeTapEvents = pigeonVar_list.get(0);
            pigeonResult.setConsumeTapEvents((Boolean)consumeTapEvents);
            Object fillColor = pigeonVar_list.get(1);
            pigeonResult.setFillColor((Long)fillColor);
            Object strokeColor = pigeonVar_list.get(2);
            pigeonResult.setStrokeColor((Long)strokeColor);
            Object visible = pigeonVar_list.get(3);
            pigeonResult.setVisible((Boolean)visible);
            Object strokeWidth = pigeonVar_list.get(4);
            pigeonResult.setStrokeWidth((Long)strokeWidth);
            Object zIndex = pigeonVar_list.get(5);
            pigeonResult.setZIndex((Double)zIndex);
            Object center = pigeonVar_list.get(6);
            pigeonResult.setCenter((PlatformLatLng)center);
            Object radius = pigeonVar_list.get(7);
            pigeonResult.setRadius((Double)radius);
            Object circleId = pigeonVar_list.get(8);
            pigeonResult.setCircleId((String)circleId);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean consumeTapEvents;
            @Nullable
            private Long fillColor;
            @Nullable
            private Long strokeColor;
            @Nullable
            private Boolean visible;
            @Nullable
            private Long strokeWidth;
            @Nullable
            private Double zIndex;
            @Nullable
            private PlatformLatLng center;
            @Nullable
            private Double radius;
            @Nullable
            private String circleId;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setConsumeTapEvents(@NonNull Boolean setterArg) {
                this.consumeTapEvents = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFillColor(@NonNull Long setterArg) {
                this.fillColor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStrokeColor(@NonNull Long setterArg) {
                this.strokeColor = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVisible(@NonNull Boolean setterArg) {
                this.visible = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStrokeWidth(@NonNull Long setterArg) {
                this.strokeWidth = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZIndex(@NonNull Double setterArg) {
                this.zIndex = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCenter(@NonNull PlatformLatLng setterArg) {
                this.center = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRadius(@NonNull Double setterArg) {
                this.radius = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCircleId(@NonNull String setterArg) {
                this.circleId = setterArg;
                return this;
            }

            @NonNull
            public PlatformCircle build() {
                PlatformCircle pigeonReturn = new PlatformCircle();
                pigeonReturn.setConsumeTapEvents(this.consumeTapEvents);
                pigeonReturn.setFillColor(this.fillColor);
                pigeonReturn.setStrokeColor(this.strokeColor);
                pigeonReturn.setVisible(this.visible);
                pigeonReturn.setStrokeWidth(this.strokeWidth);
                pigeonReturn.setZIndex(this.zIndex);
                pigeonReturn.setCenter(this.center);
                pigeonReturn.setRadius(this.radius);
                pigeonReturn.setCircleId(this.circleId);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateZoomTo {
        @NonNull
        private Double zoom;

        @NonNull
        public Double getZoom() {
            return this.zoom;
        }

        public void setZoom(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zoom\" is null.");
            }
            this.zoom = setterArg;
        }

        PlatformCameraUpdateZoomTo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateZoomTo that = (PlatformCameraUpdateZoomTo)o;
            return this.zoom.equals(that.zoom);
        }

        public int hashCode() {
            return Objects.hash(this.zoom);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.zoom);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateZoomTo fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateZoomTo pigeonResult = new PlatformCameraUpdateZoomTo();
            Object zoom = pigeonVar_list.get(0);
            pigeonResult.setZoom((Double)zoom);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double zoom;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZoom(@NonNull Double setterArg) {
                this.zoom = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateZoomTo build() {
                PlatformCameraUpdateZoomTo pigeonReturn = new PlatformCameraUpdateZoomTo();
                pigeonReturn.setZoom(this.zoom);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateZoom {
        @NonNull
        private Boolean out;

        @NonNull
        public Boolean getOut() {
            return this.out;
        }

        public void setOut(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"out\" is null.");
            }
            this.out = setterArg;
        }

        PlatformCameraUpdateZoom() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateZoom that = (PlatformCameraUpdateZoom)o;
            return this.out.equals(that.out);
        }

        public int hashCode() {
            return Objects.hash(this.out);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.out);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateZoom fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateZoom pigeonResult = new PlatformCameraUpdateZoom();
            Object out = pigeonVar_list.get(0);
            pigeonResult.setOut((Boolean)out);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean out;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setOut(@NonNull Boolean setterArg) {
                this.out = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateZoom build() {
                PlatformCameraUpdateZoom pigeonReturn = new PlatformCameraUpdateZoom();
                pigeonReturn.setOut(this.out);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateZoomBy {
        @NonNull
        private Double amount;
        @Nullable
        private PlatformDoublePair focus;

        @NonNull
        public Double getAmount() {
            return this.amount;
        }

        public void setAmount(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"amount\" is null.");
            }
            this.amount = setterArg;
        }

        @Nullable
        public PlatformDoublePair getFocus() {
            return this.focus;
        }

        public void setFocus(@Nullable PlatformDoublePair setterArg) {
            this.focus = setterArg;
        }

        PlatformCameraUpdateZoomBy() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateZoomBy that = (PlatformCameraUpdateZoomBy)o;
            return this.amount.equals(that.amount) && Objects.equals(this.focus, that.focus);
        }

        public int hashCode() {
            return Objects.hash(this.amount, this.focus);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.amount);
            toListResult.add(this.focus);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateZoomBy fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateZoomBy pigeonResult = new PlatformCameraUpdateZoomBy();
            Object amount = pigeonVar_list.get(0);
            pigeonResult.setAmount((Double)amount);
            Object focus = pigeonVar_list.get(1);
            pigeonResult.setFocus((PlatformDoublePair)focus);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double amount;
            @Nullable
            private PlatformDoublePair focus;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAmount(@NonNull Double setterArg) {
                this.amount = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFocus(@Nullable PlatformDoublePair setterArg) {
                this.focus = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateZoomBy build() {
                PlatformCameraUpdateZoomBy pigeonReturn = new PlatformCameraUpdateZoomBy();
                pigeonReturn.setAmount(this.amount);
                pigeonReturn.setFocus(this.focus);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateScrollBy {
        @NonNull
        private Double dx;
        @NonNull
        private Double dy;

        @NonNull
        public Double getDx() {
            return this.dx;
        }

        public void setDx(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"dx\" is null.");
            }
            this.dx = setterArg;
        }

        @NonNull
        public Double getDy() {
            return this.dy;
        }

        public void setDy(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"dy\" is null.");
            }
            this.dy = setterArg;
        }

        PlatformCameraUpdateScrollBy() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateScrollBy that = (PlatformCameraUpdateScrollBy)o;
            return this.dx.equals(that.dx) && this.dy.equals(that.dy);
        }

        public int hashCode() {
            return Objects.hash(this.dx, this.dy);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.dx);
            toListResult.add(this.dy);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateScrollBy fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateScrollBy pigeonResult = new PlatformCameraUpdateScrollBy();
            Object dx = pigeonVar_list.get(0);
            pigeonResult.setDx((Double)dx);
            Object dy = pigeonVar_list.get(1);
            pigeonResult.setDy((Double)dy);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double dx;
            @Nullable
            private Double dy;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDx(@NonNull Double setterArg) {
                this.dx = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDy(@NonNull Double setterArg) {
                this.dy = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateScrollBy build() {
                PlatformCameraUpdateScrollBy pigeonReturn = new PlatformCameraUpdateScrollBy();
                pigeonReturn.setDx(this.dx);
                pigeonReturn.setDy(this.dy);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateNewLatLngZoom {
        @NonNull
        private PlatformLatLng latLng;
        @NonNull
        private Double zoom;

        @NonNull
        public PlatformLatLng getLatLng() {
            return this.latLng;
        }

        public void setLatLng(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"latLng\" is null.");
            }
            this.latLng = setterArg;
        }

        @NonNull
        public Double getZoom() {
            return this.zoom;
        }

        public void setZoom(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zoom\" is null.");
            }
            this.zoom = setterArg;
        }

        PlatformCameraUpdateNewLatLngZoom() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateNewLatLngZoom that = (PlatformCameraUpdateNewLatLngZoom)o;
            return this.latLng.equals(that.latLng) && this.zoom.equals(that.zoom);
        }

        public int hashCode() {
            return Objects.hash(this.latLng, this.zoom);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.latLng);
            toListResult.add(this.zoom);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateNewLatLngZoom fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateNewLatLngZoom pigeonResult = new PlatformCameraUpdateNewLatLngZoom();
            Object latLng = pigeonVar_list.get(0);
            pigeonResult.setLatLng((PlatformLatLng)latLng);
            Object zoom = pigeonVar_list.get(1);
            pigeonResult.setZoom((Double)zoom);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformLatLng latLng;
            @Nullable
            private Double zoom;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLatLng(@NonNull PlatformLatLng setterArg) {
                this.latLng = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZoom(@NonNull Double setterArg) {
                this.zoom = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateNewLatLngZoom build() {
                PlatformCameraUpdateNewLatLngZoom pigeonReturn = new PlatformCameraUpdateNewLatLngZoom();
                pigeonReturn.setLatLng(this.latLng);
                pigeonReturn.setZoom(this.zoom);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateNewLatLngBounds {
        @NonNull
        private PlatformLatLngBounds bounds;
        @NonNull
        private Double padding;

        @NonNull
        public PlatformLatLngBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(@NonNull PlatformLatLngBounds setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bounds\" is null.");
            }
            this.bounds = setterArg;
        }

        @NonNull
        public Double getPadding() {
            return this.padding;
        }

        public void setPadding(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"padding\" is null.");
            }
            this.padding = setterArg;
        }

        PlatformCameraUpdateNewLatLngBounds() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateNewLatLngBounds that = (PlatformCameraUpdateNewLatLngBounds)o;
            return this.bounds.equals(that.bounds) && this.padding.equals(that.padding);
        }

        public int hashCode() {
            return Objects.hash(this.bounds, this.padding);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.bounds);
            toListResult.add(this.padding);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateNewLatLngBounds fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateNewLatLngBounds pigeonResult = new PlatformCameraUpdateNewLatLngBounds();
            Object bounds = pigeonVar_list.get(0);
            pigeonResult.setBounds((PlatformLatLngBounds)bounds);
            Object padding = pigeonVar_list.get(1);
            pigeonResult.setPadding((Double)padding);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformLatLngBounds bounds;
            @Nullable
            private Double padding;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBounds(@NonNull PlatformLatLngBounds setterArg) {
                this.bounds = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPadding(@NonNull Double setterArg) {
                this.padding = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateNewLatLngBounds build() {
                PlatformCameraUpdateNewLatLngBounds pigeonReturn = new PlatformCameraUpdateNewLatLngBounds();
                pigeonReturn.setBounds(this.bounds);
                pigeonReturn.setPadding(this.padding);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateNewLatLng {
        @NonNull
        private PlatformLatLng latLng;

        @NonNull
        public PlatformLatLng getLatLng() {
            return this.latLng;
        }

        public void setLatLng(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"latLng\" is null.");
            }
            this.latLng = setterArg;
        }

        PlatformCameraUpdateNewLatLng() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateNewLatLng that = (PlatformCameraUpdateNewLatLng)o;
            return this.latLng.equals(that.latLng);
        }

        public int hashCode() {
            return Objects.hash(this.latLng);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.latLng);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateNewLatLng fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateNewLatLng pigeonResult = new PlatformCameraUpdateNewLatLng();
            Object latLng = pigeonVar_list.get(0);
            pigeonResult.setLatLng((PlatformLatLng)latLng);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformLatLng latLng;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLatLng(@NonNull PlatformLatLng setterArg) {
                this.latLng = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateNewLatLng build() {
                PlatformCameraUpdateNewLatLng pigeonReturn = new PlatformCameraUpdateNewLatLng();
                pigeonReturn.setLatLng(this.latLng);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdateNewCameraPosition {
        @NonNull
        private PlatformCameraPosition cameraPosition;

        @NonNull
        public PlatformCameraPosition getCameraPosition() {
            return this.cameraPosition;
        }

        public void setCameraPosition(@NonNull PlatformCameraPosition setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"cameraPosition\" is null.");
            }
            this.cameraPosition = setterArg;
        }

        PlatformCameraUpdateNewCameraPosition() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdateNewCameraPosition that = (PlatformCameraUpdateNewCameraPosition)o;
            return this.cameraPosition.equals(that.cameraPosition);
        }

        public int hashCode() {
            return Objects.hash(this.cameraPosition);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.cameraPosition);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdateNewCameraPosition fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdateNewCameraPosition pigeonResult = new PlatformCameraUpdateNewCameraPosition();
            Object cameraPosition = pigeonVar_list.get(0);
            pigeonResult.setCameraPosition((PlatformCameraPosition)cameraPosition);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformCameraPosition cameraPosition;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCameraPosition(@NonNull PlatformCameraPosition setterArg) {
                this.cameraPosition = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdateNewCameraPosition build() {
                PlatformCameraUpdateNewCameraPosition pigeonReturn = new PlatformCameraUpdateNewCameraPosition();
                pigeonReturn.setCameraPosition(this.cameraPosition);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraUpdate {
        @NonNull
        private Object cameraUpdate;

        @NonNull
        public Object getCameraUpdate() {
            return this.cameraUpdate;
        }

        public void setCameraUpdate(@NonNull Object setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"cameraUpdate\" is null.");
            }
            this.cameraUpdate = setterArg;
        }

        PlatformCameraUpdate() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraUpdate that = (PlatformCameraUpdate)o;
            return this.cameraUpdate.equals(that.cameraUpdate);
        }

        public int hashCode() {
            return Objects.hash(this.cameraUpdate);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.cameraUpdate);
            return toListResult;
        }

        @NonNull
        static PlatformCameraUpdate fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraUpdate pigeonResult = new PlatformCameraUpdate();
            Object cameraUpdate = pigeonVar_list.get(0);
            pigeonResult.setCameraUpdate(cameraUpdate);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Object cameraUpdate;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCameraUpdate(@NonNull Object setterArg) {
                this.cameraUpdate = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraUpdate build() {
                PlatformCameraUpdate pigeonReturn = new PlatformCameraUpdate();
                pigeonReturn.setCameraUpdate(this.cameraUpdate);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraPosition {
        @NonNull
        private Double bearing;
        @NonNull
        private PlatformLatLng target;
        @NonNull
        private Double tilt;
        @NonNull
        private Double zoom;

        @NonNull
        public Double getBearing() {
            return this.bearing;
        }

        public void setBearing(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bearing\" is null.");
            }
            this.bearing = setterArg;
        }

        @NonNull
        public PlatformLatLng getTarget() {
            return this.target;
        }

        public void setTarget(@NonNull PlatformLatLng setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"target\" is null.");
            }
            this.target = setterArg;
        }

        @NonNull
        public Double getTilt() {
            return this.tilt;
        }

        public void setTilt(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"tilt\" is null.");
            }
            this.tilt = setterArg;
        }

        @NonNull
        public Double getZoom() {
            return this.zoom;
        }

        public void setZoom(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"zoom\" is null.");
            }
            this.zoom = setterArg;
        }

        PlatformCameraPosition() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraPosition that = (PlatformCameraPosition)o;
            return this.bearing.equals(that.bearing) && this.target.equals(that.target) && this.tilt.equals(that.tilt) && this.zoom.equals(that.zoom);
        }

        public int hashCode() {
            return Objects.hash(this.bearing, this.target, this.tilt, this.zoom);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.bearing);
            toListResult.add(this.target);
            toListResult.add(this.tilt);
            toListResult.add(this.zoom);
            return toListResult;
        }

        @NonNull
        static PlatformCameraPosition fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraPosition pigeonResult = new PlatformCameraPosition();
            Object bearing = pigeonVar_list.get(0);
            pigeonResult.setBearing((Double)bearing);
            Object target = pigeonVar_list.get(1);
            pigeonResult.setTarget((PlatformLatLng)target);
            Object tilt = pigeonVar_list.get(2);
            pigeonResult.setTilt((Double)tilt);
            Object zoom = pigeonVar_list.get(3);
            pigeonResult.setZoom((Double)zoom);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double bearing;
            @Nullable
            private PlatformLatLng target;
            @Nullable
            private Double tilt;
            @Nullable
            private Double zoom;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setBearing(@NonNull Double setterArg) {
                this.bearing = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTarget(@NonNull PlatformLatLng setterArg) {
                this.target = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTilt(@NonNull Double setterArg) {
                this.tilt = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setZoom(@NonNull Double setterArg) {
                this.zoom = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraPosition build() {
                PlatformCameraPosition pigeonReturn = new PlatformCameraPosition();
                pigeonReturn.setBearing(this.bearing);
                pigeonReturn.setTarget(this.target);
                pigeonReturn.setTilt(this.tilt);
                pigeonReturn.setZoom(this.zoom);
                return pigeonReturn;
            }
        }
    }

    public static enum PlatformMapBitmapScaling {
        AUTO(0),
        NONE(1);

        final int index;

        private PlatformMapBitmapScaling(int index) {
            this.index = index;
        }
    }

    public static enum PlatformPatternItemType {
        DOT(0),
        DASH(1),
        GAP(2);

        final int index;

        private PlatformPatternItemType(int index) {
            this.index = index;
        }
    }

    public static enum PlatformCapType {
        BUTT_CAP(0),
        ROUND_CAP(1),
        SQUARE_CAP(2),
        CUSTOM_CAP(3);

        final int index;

        private PlatformCapType(int index) {
            this.index = index;
        }
    }

    public static enum PlatformJointType {
        MITERED(0),
        BEVEL(1),
        ROUND(2);

        final int index;

        private PlatformJointType(int index) {
            this.index = index;
        }
    }

    public static enum PlatformRendererType {
        LEGACY(0),
        LATEST(1);

        final int index;

        private PlatformRendererType(int index) {
            this.index = index;
        }
    }

    public static enum PlatformMapType {
        NONE(0),
        NORMAL(1),
        SATELLITE(2),
        TERRAIN(3),
        HYBRID(4);

        final int index;

        private PlatformMapType(int index) {
            this.index = index;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

