/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.lyokone.location.NotificationOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/lyokone/location/BackgroundNotification;", "", "context", "Landroid/content/Context;", "channelId", "", "notificationId", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;I)V", "options", "Lcom/lyokone/location/NotificationOptions;", "builder", "Landroidx/core/app/NotificationCompat$Builder;", "getDrawableId", "iconName", "buildBringToFrontIntent", "Landroid/app/PendingIntent;", "updateChannel", "", "channelName", "updateNotification", "notify", "", "updateOptions", "isVisible", "build", "Landroid/app/Notification;", "location_debug"})
public final class BackgroundNotification {
    @NotNull
    private final Context context;
    @NotNull
    private final String channelId;
    private final int notificationId;
    @NotNull
    private NotificationOptions options;
    @NotNull
    private NotificationCompat.Builder builder;

    public BackgroundNotification(@NotNull Context context, @NotNull String channelId, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.context = context;
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.options = new NotificationOptions(null, null, null, null, null, null, false, 127, null);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.channelId).setPriority(1);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setPriority(...)");
        this.builder = builder;
        this.updateNotification(this.options, false);
    }

    private final int getDrawableId(String iconName) {
        return this.context.getResources().getIdentifier(iconName, "drawable", this.context.getPackageName());
    }

    private final PendingIntent buildBringToFrontIntent() {
        Intent intent;
        Intent intent2 = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
        Intent intent3 = intent2 != null && (intent = intent2.setPackage(null)) != null ? intent.setFlags(0x10200000) : null;
        return intent3 != null ? PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent3, (int)0x4000000) : null;
    }

    private final void updateChannel(String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel;
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(...)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            NotificationChannel $this$updateChannel_u24lambda_u240 = notificationChannel = new NotificationChannel(this.channelId, (CharSequence)channelName, 0);
            boolean bl = false;
            $this$updateChannel_u24lambda_u240.setLockscreenVisibility(0);
            NotificationChannel channel = notificationChannel;
            notificationManager.createNotificationChannel(channel);
        }
    }

    private final void updateNotification(NotificationOptions options, boolean notify) {
        NotificationCompat.Builder builder;
        NotificationCompat.Builder builder2;
        NotificationCompat.Builder builder3;
        int it = this.getDrawableId(options.getIconName());
        boolean bl = false;
        int iconId = it != 0 ? it : this.getDrawableId("navigation_empty_icon");
        NotificationCompat.Builder builder4 = this.builder.setContentTitle((CharSequence)options.getTitle()).setSmallIcon(iconId).setContentText((CharSequence)options.getSubtitle()).setSubText((CharSequence)options.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setSubText(...)");
        this.builder = builder4;
        if (options.getColor() != null) {
            builder3 = this.builder.setColor(options.getColor().intValue()).setColorized(true);
            Intrinsics.checkNotNull((Object)builder3);
            builder2 = builder3;
        } else {
            builder3 = this.builder.setColor(0).setColorized(false);
            Intrinsics.checkNotNull((Object)builder3);
            builder2 = this.builder = builder3;
        }
        if (options.getOnTapBringToFront()) {
            builder3 = this.builder.setContentIntent(this.buildBringToFrontIntent());
            Intrinsics.checkNotNull((Object)builder3);
            builder = builder3;
        } else {
            builder3 = this.builder.setContentIntent(null);
            Intrinsics.checkNotNull((Object)builder3);
            builder = this.builder = builder3;
        }
        if (notify) {
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(...)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            notificationManager.notify(this.notificationId, this.builder.build());
        }
    }

    public final void updateOptions(@NotNull NotificationOptions options, boolean isVisible) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!Intrinsics.areEqual((Object)options.getChannelName(), (Object)this.options.getChannelName())) {
            this.updateChannel(options.getChannelName());
        }
        this.updateNotification(options, isVisible);
        this.options = options;
    }

    @NotNull
    public final Notification build() {
        this.updateChannel(this.options.getChannelName());
        Notification notification = this.builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"build(...)");
        return notification;
    }
}

