/*
 * Decompiled with CFR 0.152.
 */
package dev.steenbakker.mobile_scanner;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.media.Image;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ExperimentalLensFacing;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SurfaceOrientedMeteringPointFactory;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import dev.steenbakker.mobile_scanner.AlreadyPaused;
import dev.steenbakker.mobile_scanner.AlreadyStarted;
import dev.steenbakker.mobile_scanner.AlreadyStopped;
import dev.steenbakker.mobile_scanner.CameraError;
import dev.steenbakker.mobile_scanner.DeviceOrientationListener;
import dev.steenbakker.mobile_scanner.MobileScannerUtilitiesKt;
import dev.steenbakker.mobile_scanner.NoCamera;
import dev.steenbakker.mobile_scanner.ZoomNotInRange;
import dev.steenbakker.mobile_scanner.ZoomWhenStopped;
import dev.steenbakker.mobile_scanner.objects.DetectionSpeed;
import dev.steenbakker.mobile_scanner.objects.MobileScannerStartParameters;
import dev.steenbakker.mobile_scanner.utils.BitmapExtensionKt;
import dev.steenbakker.mobile_scanner.utils.DeviceOrientationExtensionKt;
import io.flutter.view.TextureRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ~2\u00020\u0001:\u0001~B\u00ed\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012~\u0010\u0006\u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u0007j\u0002`\u0014\u0012%\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012%\b\u0002\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010G\u001a\u00020H2\u0006\u0010)\u001a\u00020*H\u0007J\u0019\u0010I\u001a\u0004\u0018\u00010\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0003\u00a2\u0006\u0002\u0010JJ&\u0010K\u001a\u00020.2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\b2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0007J\u00f7\u0001\u0010P\u001a\u00020\u00132\b\u0010Q\u001a\u0004\u0018\u00010\u001c2\u0006\u0010?\u001a\u00020.2\u0006\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020.2\u0006\u0010;\u001a\u00020<2%\u0010T\u001a!\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`V2%\u0010W\u001a!\u0012\u0013\u0012\u00110X\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(Y\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`Z2%\u0010[\u001a!\u0012\u0013\u0012\u00110\\\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(]\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`^2%\u0010\u0015\u001a!\u0012\u0017\u0012\u00150_j\u0002`a\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(`\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010=\u001a\u00020>2\b\u0010b\u001a\u0004\u0018\u00010c2\u0006\u0010:\u001a\u00020.2\b\u0010d\u001a\u0004\u0018\u00010XH\u0007\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\u00020\u00132\b\b\u0002\u0010g\u001a\u00020.J\u0010\u0010h\u001a\u00020\u00132\b\b\u0002\u0010g\u001a\u00020.J\b\u0010i\u001a\u00020\u0013H\u0002J\b\u0010j\u001a\u00020\u0013H\u0002J\b\u0010k\u001a\u00020.H\u0002J\u0006\u0010l\u001a\u00020\u0013Jz\u0010m\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020n2\b\u0010o\u001a\u0004\u0018\u00010\u001c29\u0010p\u001a5\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`q2%\u0010r\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(s\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`tJ\u000e\u0010u\u001a\u00020\u00132\u0006\u0010v\u001a\u00020XJ\u000e\u0010w\u001a\u00020\u00132\u0006\u0010x\u001a\u00020XJ\u0006\u0010y\u001a\u00020\u0013J\u0016\u0010z\u001a\u00020\u00132\u0006\u0010{\u001a\u0002052\u0006\u0010|\u001a\u000205J\u0006\u0010}\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010\u0006\u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u0007j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\n 3*\u0004\u0018\u00010202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010:\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010A\u001a\u00020B8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bC\u0010D\u001a\u0004\bE\u0010F\u00a8\u0006\u007f"}, d2={"Ldev/steenbakker/mobile_scanner/MobileScanner;", "", "activity", "Landroid/app/Activity;", "textureRegistry", "Lio/flutter/view/TextureRegistry;", "mobileScannerCallback", "Lkotlin/Function4;", "", "", "", "Lkotlin/ParameterName;", "name", "barcodes", "", "image", "", "width", "height", "", "Ldev/steenbakker/mobile_scanner/MobileScannerCallback;", "mobileScannerErrorCallback", "Lkotlin/Function1;", "error", "Ldev/steenbakker/mobile_scanner/MobileScannerErrorCallback;", "deviceOrientationListener", "Ldev/steenbakker/mobile_scanner/DeviceOrientationListener;", "barcodeScannerFactory", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "options", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "<init>", "(Landroid/app/Activity;Lio/flutter/view/TextureRegistry;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function1;Ldev/steenbakker/mobile_scanner/DeviceOrientationListener;Lkotlin/jvm/functions/Function1;)V", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "camera", "Landroidx/camera/core/Camera;", "cameraSelector", "Landroidx/camera/core/CameraSelector;", "preview", "Landroidx/camera/core/Preview;", "surfaceProducer", "Lio/flutter/view/TextureRegistry$SurfaceProducer;", "scanner", "lastScanned", "scannerTimeout", "", "displayListener", "Landroid/hardware/display/DisplayManager$DisplayListener;", "analysisExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "scanWindow", "", "getScanWindow", "()Ljava/util/List;", "setScanWindow", "(Ljava/util/List;)V", "invertImage", "detectionSpeed", "Ldev/steenbakker/mobile_scanner/objects/DetectionSpeed;", "detectionTimeout", "", "returnImage", "isPaused", "captureOutput", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "getCaptureOutput$annotations", "()V", "getCaptureOutput", "()Landroidx/camera/core/ImageAnalysis$Analyzer;", "createSurfaceProvider", "Landroidx/camera/core/Preview$SurfaceProvider;", "getCameraLensFacing", "(Landroidx/camera/core/Camera;)Ljava/lang/Integer;", "isBarcodeInScanWindow", "barcode", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "inputImage", "Landroidx/camera/core/ImageProxy;", "start", "barcodeScannerOptions", "cameraPosition", "torch", "torchStateCallback", "state", "Ldev/steenbakker/mobile_scanner/TorchStateCallback;", "zoomScaleStateCallback", "", "zoomScale", "Ldev/steenbakker/mobile_scanner/ZoomScaleStateCallback;", "mobileScannerStartedCallback", "Ldev/steenbakker/mobile_scanner/objects/MobileScannerStartParameters;", "parameters", "Ldev/steenbakker/mobile_scanner/MobileScannerStartedCallback;", "Ljava/lang/Exception;", "exception", "Lkotlin/Exception;", "cameraResolutionWanted", "Landroid/util/Size;", "initialZoom", "(Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;ZLandroidx/camera/core/CameraSelector;ZLdev/steenbakker/mobile_scanner/objects/DetectionSpeed;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;JLandroid/util/Size;ZLjava/lang/Double;)V", "pause", "force", "stop", "pauseCamera", "releaseCamera", "isStopped", "toggleTorch", "analyzeImage", "Landroid/net/Uri;", "scannerOptions", "onSuccess", "Ldev/steenbakker/mobile_scanner/AnalyzerSuccessCallback;", "onError", "message", "Ldev/steenbakker/mobile_scanner/AnalyzerErrorCallback;", "setScale", "scale", "setZoomRatio", "zoomRatio", "resetScale", "setFocus", "x", "y", "dispose", "Companion", "mobile_scanner_debug"})
@SourceDebugExtension(value={"SMAP\nMobileScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileScanner.kt\ndev/steenbakker/mobile_scanner/MobileScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,727:1\n1617#2,9:728\n1869#2:737\n1870#2:739\n1626#2:740\n1563#2:742\n1634#2,3:743\n1#3:738\n1#3:741\n*S KotlinDebug\n*F\n+ 1 MobileScanner.kt\ndev/steenbakker/mobile_scanner/MobileScanner\n*L\n141#1:728,9\n141#1:737\n141#1:739\n141#1:740\n667#1:742\n667#1:743,3\n141#1:738\n*E\n"})
public final class MobileScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final TextureRegistry textureRegistry;
    @NotNull
    private final Function4<List<? extends Map<String, ? extends Object>>, byte[], Integer, Integer, Unit> mobileScannerCallback;
    @NotNull
    private final Function1<String, Unit> mobileScannerErrorCallback;
    @NotNull
    private final DeviceOrientationListener deviceOrientationListener;
    @NotNull
    private final Function1<BarcodeScannerOptions, BarcodeScanner> barcodeScannerFactory;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    @Nullable
    private Camera camera;
    @Nullable
    private CameraSelector cameraSelector;
    @Nullable
    private Preview preview;
    @Nullable
    private TextureRegistry.SurfaceProducer surfaceProducer;
    @Nullable
    private BarcodeScanner scanner;
    @Nullable
    private List<String> lastScanned;
    private boolean scannerTimeout;
    @Nullable
    private DisplayManager.DisplayListener displayListener;
    private ExecutorService analysisExecutor;
    @Nullable
    private List<Float> scanWindow;
    private boolean invertImage;
    @NotNull
    private DetectionSpeed detectionSpeed;
    private long detectionTimeout;
    private boolean returnImage;
    private boolean isPaused;
    @NotNull
    private final ImageAnalysis.Analyzer captureOutput;

    public MobileScanner(@NotNull Activity activity, @NotNull TextureRegistry textureRegistry, @NotNull Function4<? super List<? extends Map<String, ? extends Object>>, ? super byte[], ? super Integer, ? super Integer, Unit> mobileScannerCallback, @NotNull Function1<? super String, Unit> mobileScannerErrorCallback, @NotNull DeviceOrientationListener deviceOrientationListener, @NotNull Function1<? super BarcodeScannerOptions, ? extends BarcodeScanner> barcodeScannerFactory) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)textureRegistry, (String)"textureRegistry");
        Intrinsics.checkNotNullParameter(mobileScannerCallback, (String)"mobileScannerCallback");
        Intrinsics.checkNotNullParameter(mobileScannerErrorCallback, (String)"mobileScannerErrorCallback");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceOrientationListener), (String)"deviceOrientationListener");
        Intrinsics.checkNotNullParameter(barcodeScannerFactory, (String)"barcodeScannerFactory");
        this.activity = activity;
        this.textureRegistry = textureRegistry;
        this.mobileScannerCallback = mobileScannerCallback;
        this.mobileScannerErrorCallback = mobileScannerErrorCallback;
        this.deviceOrientationListener = deviceOrientationListener;
        this.barcodeScannerFactory = barcodeScannerFactory;
        MobileScanner.Companion.configureCameraProcessProvider();
        this.analysisExecutor = Executors.newSingleThreadExecutor();
        this.detectionSpeed = DetectionSpeed.NO_DUPLICATES;
        this.detectionTimeout = 250L;
        this.captureOutput = arg_0 -> MobileScanner.captureOutput$lambda$0(this, arg_0);
    }

    public /* synthetic */ MobileScanner(Activity activity, TextureRegistry textureRegistry, Function4 function4, Function1 function1, DeviceOrientationListener deviceOrientationListener, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function12 = (Function1)new Function1<BarcodeScannerOptions, BarcodeScanner>((Object)Companion){

                public final BarcodeScanner invoke(BarcodeScannerOptions p0) {
                    return ((Companion)this.receiver).defaultBarcodeScannerFactory(p0);
                }
            };
        }
        this(activity, textureRegistry, (Function4<? super List<? extends Map<String, ? extends Object>>, ? super byte[], ? super Integer, ? super Integer, Unit>)function4, (Function1<? super String, Unit>)function1, deviceOrientationListener, (Function1<? super BarcodeScannerOptions, ? extends BarcodeScanner>)function12);
    }

    @Nullable
    public final List<Float> getScanWindow() {
        return this.scanWindow;
    }

    public final void setScanWindow(@Nullable List<Float> list) {
        this.scanWindow = list;
    }

    @NotNull
    public final ImageAnalysis.Analyzer getCaptureOutput() {
        return this.captureOutput;
    }

    @ExperimentalGetImage
    public static /* synthetic */ void getCaptureOutput$annotations() {
    }

    @VisibleForTesting
    @NotNull
    public final Preview.SurfaceProvider createSurfaceProvider(@NotNull TextureRegistry.SurfaceProducer surfaceProducer) {
        Intrinsics.checkNotNullParameter((Object)surfaceProducer, (String)"surfaceProducer");
        return arg_0 -> MobileScanner.createSurfaceProvider$lambda$0(this, surfaceProducer, arg_0);
    }

    @ExperimentalLensFacing
    private final Integer getCameraLensFacing(Camera camera) {
        Integer n;
        Integer n2;
        Camera camera2 = camera;
        Integer n3 = n2 = camera2 != null && (camera2 = camera2.getCameraInfo()) != null ? Integer.valueOf(camera2.getLensFacing()) : null;
        int n4 = 1;
        if (n3 != null && n3 == n4) {
            n = 1;
        } else {
            Integer n5 = n2;
            if (n5 != null && n5 == 0) {
                n = 0;
            } else {
                Integer n6 = n2;
                n4 = 2;
                if (n6 != null && n6 == n4) {
                    n = 2;
                } else {
                    Integer n7 = n2;
                    n4 = -1;
                    n = n7 != null && n7 == n4 ? null : null;
                }
            }
        }
        return n;
    }

    @VisibleForTesting
    public final boolean isBarcodeInScanWindow(@NotNull List<Float> scanWindow, @NotNull Barcode barcode, @NotNull ImageProxy inputImage) {
        Intrinsics.checkNotNullParameter(scanWindow, (String)"scanWindow");
        Intrinsics.checkNotNullParameter((Object)barcode, (String)"barcode");
        Intrinsics.checkNotNullParameter((Object)inputImage, (String)"inputImage");
        Rect rect = barcode.getBoundingBox();
        if (rect == null) {
            return false;
        }
        Rect barcodeBoundingBox = rect;
        try {
            int imageWidth = inputImage.getHeight();
            int imageHeight = inputImage.getWidth();
            int left = MathKt.roundToInt((float)(((Number)scanWindow.get(0)).floatValue() * (float)imageWidth));
            int top = MathKt.roundToInt((float)(((Number)scanWindow.get(1)).floatValue() * (float)imageHeight));
            int right = MathKt.roundToInt((float)(((Number)scanWindow.get(2)).floatValue() * (float)imageWidth));
            int bottom = MathKt.roundToInt((float)(((Number)scanWindow.get(3)).floatValue() * (float)imageHeight));
            Rect scaledScanWindow = new Rect(left, top, right, bottom);
            return scaledScanWindow.contains(barcodeBoundingBox);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @ExperimentalLensFacing
    @ExperimentalGetImage
    public final void start(@Nullable BarcodeScannerOptions barcodeScannerOptions, boolean returnImage, @NotNull CameraSelector cameraPosition, boolean torch, @NotNull DetectionSpeed detectionSpeed, @NotNull Function1<? super Integer, Unit> torchStateCallback, @NotNull Function1<? super Double, Unit> zoomScaleStateCallback, @NotNull Function1<? super MobileScannerStartParameters, Unit> mobileScannerStartedCallback, @NotNull Function1<? super Exception, Unit> mobileScannerErrorCallback, long detectionTimeout, @Nullable Size cameraResolutionWanted, boolean invertImage, @Nullable Double initialZoom) {
        Intrinsics.checkNotNullParameter((Object)cameraPosition, (String)"cameraPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)detectionSpeed), (String)"detectionSpeed");
        Intrinsics.checkNotNullParameter(torchStateCallback, (String)"torchStateCallback");
        Intrinsics.checkNotNullParameter(zoomScaleStateCallback, (String)"zoomScaleStateCallback");
        Intrinsics.checkNotNullParameter(mobileScannerStartedCallback, (String)"mobileScannerStartedCallback");
        Intrinsics.checkNotNullParameter(mobileScannerErrorCallback, (String)"mobileScannerErrorCallback");
        this.detectionSpeed = detectionSpeed;
        this.detectionTimeout = detectionTimeout;
        this.returnImage = returnImage;
        this.invertImage = invertImage;
        Camera camera = this.camera;
        if ((camera != null ? camera.getCameraInfo() : null) != null && this.preview != null && this.surfaceProducer != null && !this.isPaused) {
            mobileScannerErrorCallback.invoke((Object)new AlreadyStarted());
            return;
        }
        this.lastScanned = null;
        this.scanner = (BarcodeScanner)this.barcodeScannerFactory.invoke((Object)barcodeScannerOptions);
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.Companion.getInstance((Context)this.activity);
        Executor executor = ContextCompat.getMainExecutor((Context)((Context)this.activity));
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getMainExecutor(...)");
        Executor mainExecutor = executor;
        cameraProviderFuture.addListener(() -> MobileScanner.start$lambda$0(this, cameraProviderFuture, mobileScannerErrorCallback, cameraResolutionWanted, cameraPosition, mobileScannerStartedCallback, torch, initialZoom, torchStateCallback, zoomScaleStateCallback), mainExecutor);
    }

    public final void pause(boolean force) {
        if (!force) {
            if (this.isPaused) {
                throw new AlreadyPaused();
            }
            if (this.isStopped()) {
                throw new AlreadyStopped();
            }
        }
        this.deviceOrientationListener.stop();
        this.pauseCamera();
    }

    public static /* synthetic */ void pause$default(MobileScanner mobileScanner, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mobileScanner.pause(bl);
    }

    public final void stop(boolean force) {
        if (!force && !this.isPaused && this.isStopped()) {
            throw new AlreadyStopped();
        }
        this.deviceOrientationListener.stop();
        this.releaseCamera();
    }

    public static /* synthetic */ void stop$default(MobileScanner mobileScanner, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mobileScanner.stop(bl);
    }

    private final void pauseCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        this.isPaused = true;
    }

    private final void releaseCamera() {
        if (this.displayListener != null) {
            Object object = this.activity.getApplicationContext().getSystemService("display");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
            DisplayManager displayManager = (DisplayManager)object;
            displayManager.unregisterDisplayListener(this.displayListener);
            this.displayListener = null;
        }
        Activity activity = this.activity;
        Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
        LifecycleOwner owner = (LifecycleOwner)activity;
        Camera camera = this.camera;
        if (camera != null && (camera = camera.getCameraInfo()) != null) {
            Camera it = camera;
            boolean bl = false;
            it.getTorchState().removeObservers(owner);
            it.getZoomState().removeObservers(owner);
            it.getCameraState().removeObservers(owner);
        }
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        TextureRegistry.SurfaceProducer surfaceProducer = this.surfaceProducer;
        if (surfaceProducer != null) {
            surfaceProducer.release();
        }
        this.surfaceProducer = null;
        BarcodeScanner barcodeScanner = this.scanner;
        if (barcodeScanner != null) {
            barcodeScanner.close();
        }
        this.scanner = null;
        this.lastScanned = null;
        this.analysisExecutor.shutdown();
        this.analysisExecutor = Executors.newSingleThreadExecutor();
    }

    private final boolean isStopped() {
        return this.camera == null && this.preview == null;
    }

    public final void toggleTorch() {
        block0: {
            Integer n;
            Camera it;
            block1: {
                Camera camera = this.camera;
                if (camera == null) break block0;
                it = camera;
                boolean bl = false;
                if (!it.getCameraInfo().hasFlashUnit()) break block0;
                Integer n2 = n = (Integer)it.getCameraInfo().getTorchState().getValue();
                if (n2 == null || n2 != 0) break block1;
                it.getCameraControl().enableTorch(true);
                break block0;
            }
            Integer n3 = n;
            int n4 = 1;
            if (n3 == null || n3 != n4) break block0;
            it.getCameraControl().enableTorch(false);
        }
    }

    public final void analyzeImage(@NotNull Uri image, @Nullable BarcodeScannerOptions scannerOptions, @NotNull Function1<? super List<? extends Map<String, ? extends Object>>, Unit> onSuccess, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        InputImage inputImage = null;
        try {
            InputImage inputImage2 = InputImage.fromFilePath((Context)((Context)this.activity), (Uri)image);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage2, (String)"fromFilePath(...)");
            inputImage = inputImage2;
        }
        catch (IOException iOException) {
            onError.invoke((Object)"The provided file is not an image.");
            return;
        }
        BarcodeScanner barcodeScanner = (BarcodeScanner)this.barcodeScannerFactory.invoke((Object)scannerOptions);
        barcodeScanner.process(inputImage).addOnSuccessListener(arg_0 -> MobileScanner.analyzeImage$lambda$1(arg_0 -> MobileScanner.analyzeImage$lambda$0(onSuccess, arg_0), arg_0)).addOnFailureListener(arg_0 -> MobileScanner.analyzeImage$lambda$2(onError, arg_0)).addOnCompleteListener(arg_0 -> MobileScanner.analyzeImage$lambda$3(barcodeScanner, arg_0));
    }

    public final void setScale(double scale) {
        block2: {
            if (scale > 1.0 || scale < 0.0) {
                throw new ZoomNotInRange();
            }
            if (this.camera == null) {
                throw new ZoomWhenStopped();
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block2;
            camera.setLinearZoom((float)scale);
        }
    }

    public final void setZoomRatio(double zoomRatio) {
        block1: {
            if (this.camera == null) {
                throw new ZoomWhenStopped();
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block1;
            camera.setZoomRatio((float)zoomRatio);
        }
    }

    public final void resetScale() {
        block1: {
            if (this.camera == null) {
                throw new ZoomWhenStopped();
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block1;
            camera.setZoomRatio(1.0f);
        }
    }

    public final void setFocus(float x, float y) {
        Camera cam;
        block5: {
            block4: {
                Camera camera = this.camera;
                if (camera == null) {
                    throw new ZoomWhenStopped();
                }
                cam = camera;
                boolean bl = 0.0f <= x ? x <= 1.0f : false;
                if (!bl) break block4;
                if (0.0f <= y ? y <= 1.0f : false) break block5;
            }
            throw new IllegalArgumentException("Focus coordinates must be between 0.0 and 1.0");
        }
        MeteringPointFactory factory = (MeteringPointFactory)new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f);
        MeteringPoint meteringPoint = factory.createPoint(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
        MeteringPoint afPoint = meteringPoint;
        FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(afPoint, 1).build();
        Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
        FocusMeteringAction action = focusMeteringAction;
        cam.getCameraControl().startFocusAndMetering(action);
    }

    public final void dispose() {
        if (this.isStopped()) {
            return;
        }
        MobileScanner.stop$default(this, false, 1, null);
    }

    private static final void captureOutput$lambda$0(MobileScanner this$0, ImageProxy imageProxy) {
        InputImage inputImage;
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Image image = imageProxy.getImage();
        if (image == null) {
            return;
        }
        Image mediaImage = image;
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL && this$0.scannerTimeout) {
            imageProxy.close();
            return;
        }
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL) {
            this$0.scannerTimeout = true;
        }
        Ref.ObjectRef invertedBitmap = new Ref.ObjectRef();
        if (this$0.invertImage) {
            Bitmap bitmap = imageProxy.toBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"toBitmap(...)");
            Bitmap bitmap2 = bitmap;
            invertedBitmap.element = BitmapExtensionKt.invertBitmapColors(bitmap2);
            bitmap2.recycle();
            inputImage = InputImage.fromBitmap((Bitmap)((Bitmap)invertedBitmap.element), (int)imageProxy.getImageInfo().getRotationDegrees());
        } else {
            inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
        }
        InputImage inputImage2 = inputImage;
        Intrinsics.checkNotNull((Object)inputImage2);
        InputImage inputImage3 = inputImage2;
        BarcodeScanner barcodeScanner = this$0.scanner;
        if (barcodeScanner != null) {
            BarcodeScanner it = barcodeScanner;
            boolean bl = false;
            it.process(inputImage3).addOnSuccessListener(arg_0 -> MobileScanner.captureOutput$lambda$0$0$1(arg_0 -> MobileScanner.captureOutput$lambda$0$0$0(this$0, imageProxy, inputImage3, invertedBitmap, arg_0), arg_0)).addOnFailureListener(arg_0 -> MobileScanner.captureOutput$lambda$0$0$2(this$0, arg_0));
        }
        if (this$0.detectionSpeed == DetectionSpeed.NORMAL) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> MobileScanner.captureOutput$lambda$0$1(this$0), this$0.detectionTimeout);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit captureOutput$lambda$0$0$0(MobileScanner this$0, ImageProxy $imageProxy, InputImage $inputImage, Ref.ObjectRef $invertedBitmap, List barcodes) {
        boolean portrait;
        if (this$0.detectionSpeed == DetectionSpeed.NO_DUPLICATES) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNull((Object)barcodes);
            Iterable $this$mapNotNull$iv = barcodes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Barcode barcode = (Barcode)element$iv$iv;
                boolean bl2 = false;
                if (barcode.getRawValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newScannedBarcodes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (Intrinsics.areEqual((Object)newScannedBarcodes, this$0.lastScanned)) {
                $imageProxy.close();
                return Unit.INSTANCE;
            }
            if (!((Collection)newScannedBarcodes).isEmpty()) {
                this$0.lastScanned = newScannedBarcodes;
            }
        }
        List barcodeMap = new ArrayList();
        for (Barcode barcode : barcodes) {
            if (this$0.scanWindow == null) {
                Intrinsics.checkNotNull((Object)barcode);
                barcodeMap.add(MobileScannerUtilitiesKt.getData(barcode));
                continue;
            }
            List<Float> list = this$0.scanWindow;
            Intrinsics.checkNotNull(list);
            Intrinsics.checkNotNull((Object)barcode);
            Intrinsics.checkNotNull((Object)$imageProxy);
            if (!this$0.isBarcodeInScanWindow(list, barcode, $imageProxy)) continue;
            barcodeMap.add(MobileScannerUtilitiesKt.getData(barcode));
        }
        if (barcodeMap.isEmpty()) {
            $imageProxy.close();
            return Unit.INSTANCE;
        }
        Camera camera = this$0.camera;
        boolean bl = portrait = (camera != null && (camera = camera.getCameraInfo()) != null ? camera.getSensorRotationDegrees() : 0) % 180 == 0;
        if (!this$0.returnImage) {
            this$0.mobileScannerCallback.invoke((Object)barcodeMap, null, (Object)(portrait ? $inputImage.getWidth() : $inputImage.getHeight()), (Object)(portrait ? $inputImage.getHeight() : $inputImage.getWidth()));
            Bitmap bitmap = (Bitmap)$invertedBitmap.element;
            if (bitmap != null) {
                bitmap.recycle();
            }
            $imageProxy.close();
            return Unit.INSTANCE;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<Bitmap>)$invertedBitmap, $imageProxy, this$0, (List<Map<String, Object>>)barcodeMap, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<Bitmap> $invertedBitmap;
            final /* synthetic */ ImageProxy $imageProxy;
            final /* synthetic */ MobileScanner this$0;
            final /* synthetic */ List<Map<String, Object>> $barcodeMap;
            {
                this.$invertedBitmap = $invertedBitmap;
                this.$imageProxy = $imageProxy;
                this.this$0 = $receiver;
                this.$barcodeMap = $barcodeMap;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Bitmap bitmap = (Bitmap)this.$invertedBitmap.element;
                        if (bitmap == null) {
                            Bitmap bitmap2 = this.$imageProxy.toBitmap();
                            bitmap = bitmap2;
                            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"toBitmap(...)");
                        }
                        Bitmap baseBitmap = bitmap;
                        Camera camera = MobileScanner.access$getCamera$p(this.this$0);
                        Bitmap rotatedBitmap = BitmapExtensionKt.rotateBitmap(baseBitmap, camera != null && (camera = camera.getCameraInfo()) != null ? camera.getSensorRotationDegrees() : 90);
                        if (MobileScanner.access$getInvertImage$p(this.this$0)) {
                            Bitmap revertedBitmap = BitmapExtensionKt.invertBitmapColors(rotatedBitmap);
                            rotatedBitmap.recycle();
                            rotatedBitmap = revertedBitmap;
                        }
                        if (!Intrinsics.areEqual((Object)baseBitmap, (Object)rotatedBitmap)) {
                            baseBitmap.recycle();
                        }
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        rotatedBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)stream);
                        byte[] byteArray = stream.toByteArray();
                        int bmWidth = rotatedBitmap.getWidth();
                        int bmHeight = rotatedBitmap.getHeight();
                        MobileScanner.access$getMobileScannerCallback$p(this.this$0).invoke(this.$barcodeMap, (Object)byteArray, (Object)Boxing.boxInt((int)bmWidth), (Object)Boxing.boxInt((int)bmHeight));
                        rotatedBitmap.recycle();
                        this.$imageProxy.close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void captureOutput$lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void captureOutput$lambda$0$0$2(MobileScanner this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Function1<String, Unit> function1 = this$0.mobileScannerErrorCallback;
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.toString();
        }
        function1.invoke((Object)string);
    }

    private static final void captureOutput$lambda$0$1(MobileScanner this$0) {
        this$0.scannerTimeout = false;
    }

    private static final void createSurfaceProvider$lambda$0(MobileScanner this$0, TextureRegistry.SurfaceProducer $surfaceProducer, SurfaceRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        MobileScanner $this$createSurfaceProvider_u24lambda_u240_u240 = this$0;
        boolean bl = false;
        $surfaceProducer.setCallback(new TextureRegistry.SurfaceProducer.Callback(request){
            final /* synthetic */ SurfaceRequest $request;
            {
                this.$request = $request;
            }

            public void onSurfaceAvailable() {
            }

            public void onSurfaceCleanup() {
                this.$request.invalidate();
            }
        });
        $surfaceProducer.setSize(request.getResolution().getWidth(), request.getResolution().getHeight());
        Surface surface = $surfaceProducer.getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        Surface surface2 = surface;
        request.provideSurface(surface2, (Executor)Executors.newSingleThreadExecutor(), arg_0 -> MobileScanner.createSurfaceProvider$lambda$0$0$0(surface2, arg_0));
    }

    private static final void createSurfaceProvider$lambda$0$0$0(Surface $surface, SurfaceRequest.Result it) {
        $surface.release();
        int resultCode = it.getResultCode();
        switch (resultCode) {
            default: 
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$0(MobileScanner this$0, ListenableFuture $cameraProviderFuture, Function1 $mobileScannerErrorCallback, Size $cameraResolutionWanted, CameraSelector $cameraPosition, Function1 $mobileScannerStartedCallback, boolean $torch, Double $initialZoom, Function1 $torchStateCallback, Function1 $zoomScaleStateCallback) {
        UseCase[] useCaseArray;
        void $this$start_u24lambda_u240_u240;
        Preview preview;
        TextureRegistry.SurfaceProducer surfaceProducer;
        Integer numberOfCameras;
        this$0.cameraProvider = (ProcessCameraProvider)$cameraProviderFuture.get();
        Object object = this$0.cameraProvider;
        Integer n = object != null && (object = object.getAvailableCameraInfos()) != null ? Integer.valueOf(object.size()) : (numberOfCameras = null);
        if (this$0.cameraProvider == null) {
            $mobileScannerErrorCallback.invoke((Object)new CameraError());
            return;
        }
        ProcessCameraProvider processCameraProvider = this$0.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        if ((surfaceProducer = this$0.surfaceProducer) == null) {
            TextureRegistry.SurfaceProducer surfaceProducer2 = this$0.textureRegistry.createSurfaceProducer();
            surfaceProducer = surfaceProducer2;
            Intrinsics.checkNotNullExpressionValue((Object)surfaceProducer2, (String)"createSurfaceProducer(...)");
        }
        TextureRegistry.SurfaceProducer surfaceProducer3 = this$0.surfaceProducer = surfaceProducer;
        Intrinsics.checkNotNull((Object)surfaceProducer3);
        Preview.SurfaceProvider surfaceProvider = this$0.createSurfaceProvider(surfaceProducer3);
        Preview.Builder previewBuilder = new Preview.Builder();
        Preview preview2 = preview = previewBuilder.build();
        MobileScanner mobileScanner = this$0;
        boolean bl = false;
        $this$start_u24lambda_u240_u240.setSurfaceProvider(surfaceProvider);
        mobileScanner.preview = preview;
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder().setBackpressureStrategy(0).setOutputImageFormat(1);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setOutputImageFormat(...)");
        ImageAnalysis.Builder analysisBuilder = builder;
        Object object2 = this$0.activity.getApplicationContext().getSystemService("display");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
        DisplayManager displayManager = (DisplayManager)object2;
        Size size = $cameraResolutionWanted;
        if (size == null) {
            size = new Size(1920, 1080);
        }
        Size cameraResolution = size;
        ResolutionSelector.Builder selectorBuilder = new ResolutionSelector.Builder();
        selectorBuilder.setResolutionStrategy(new ResolutionStrategy(cameraResolution, 1));
        analysisBuilder.setResolutionSelector(selectorBuilder.build()).build();
        if (this$0.displayListener == null) {
            this$0.displayListener = new DisplayManager.DisplayListener(cameraResolution, analysisBuilder){
                final /* synthetic */ Size $cameraResolution;
                final /* synthetic */ ImageAnalysis.Builder $analysisBuilder;
                {
                    this.$cameraResolution = $cameraResolution;
                    this.$analysisBuilder = $analysisBuilder;
                }

                public void onDisplayAdded(int displayId) {
                }

                public void onDisplayRemoved(int displayId) {
                }

                public void onDisplayChanged(int displayId) {
                    ResolutionSelector.Builder builder = new ResolutionSelector.Builder().setResolutionStrategy(new ResolutionStrategy(this.$cameraResolution, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setResolutionStrategy(...)");
                    ResolutionSelector.Builder selector = builder;
                    this.$analysisBuilder.setResolutionSelector(selector.build()).build();
                }
            };
            displayManager.registerDisplayListener(this$0.displayListener, null);
        }
        UseCase[] $this$start_u24lambda_u240_u241 = useCaseArray = analysisBuilder.build();
        boolean bl2 = false;
        $this$start_u24lambda_u240_u241.setAnalyzer((Executor)this$0.analysisExecutor, this$0.captureOutput);
        Intrinsics.checkNotNullExpressionValue((Object)useCaseArray, (String)"apply(...)");
        UseCase[] analysis = useCaseArray;
        try {
            Camera camera;
            ProcessCameraProvider processCameraProvider2 = this$0.cameraProvider;
            if (processCameraProvider2 != null) {
                Activity activity = this$0.activity;
                Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
                useCaseArray = new UseCase[]{this$0.preview, analysis};
                camera = processCameraProvider2.bindToLifecycle((LifecycleOwner)activity, $cameraPosition, useCaseArray);
            } else {
                camera = null;
            }
            this$0.camera = camera;
            this$0.cameraSelector = $cameraPosition;
        }
        catch (Exception exception) {
            $mobileScannerErrorCallback.invoke((Object)new NoCamera());
            return;
        }
        Camera camera = this$0.camera;
        if (camera != null) {
            Camera it = camera;
            boolean bl3 = false;
            LiveData liveData = it.getCameraInfo().getTorchState();
            Activity activity = this$0.activity;
            Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
            Function1 function1 = arg_0 -> MobileScanner.start$lambda$0$2$0($torchStateCallback, arg_0);
            liveData.observe((LifecycleOwner)activity, new Observer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void onChanged(Object value) {
                    this.function.invoke(value);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            });
            function1 = arg_0 -> MobileScanner.start$lambda$0$2$1($zoomScaleStateCallback, arg_0);
            it.getCameraInfo().getZoomState().observe((LifecycleOwner)this$0.activity, new /* invalid duplicate definition of identical inner class */);
            if (it.getCameraInfo().hasFlashUnit()) {
                it.getCameraControl().enableTorch($torch);
            }
            if ($initialZoom != null) {
                try {
                    double d = $initialZoom;
                    ListenableFuture listenableFuture = (0.0 <= d ? d <= 1.0 : false) ? it.getCameraControl().setLinearZoom((float)$initialZoom.doubleValue()) : it.getCameraControl().setZoomRatio((float)$initialZoom.doubleValue());
                }
                catch (Exception e) {
                    $mobileScannerErrorCallback.invoke((Object)new ZoomNotInRange());
                    return;
                }
            }
        }
        ResolutionInfo resolutionInfo = analysis.getResolutionInfo();
        Intrinsics.checkNotNull((Object)resolutionInfo);
        Size size2 = resolutionInfo.getResolution();
        Intrinsics.checkNotNullExpressionValue((Object)size2, (String)"getResolution(...)");
        Size resolution = size2;
        double width = resolution.getWidth();
        double height = resolution.getHeight();
        Camera camera2 = this$0.camera;
        int sensorRotationDegrees = camera2 != null && (camera2 = camera2.getCameraInfo()) != null ? camera2.getSensorRotationDegrees() : 0;
        boolean portrait = sensorRotationDegrees % 180 == 0;
        Integer cameraDirection = this$0.getCameraLensFacing(this$0.camera);
        int currentTorchState = 0;
        currentTorchState = -1;
        Camera camera3 = this$0.camera;
        if (camera3 != null && (camera3 = camera3.getCameraInfo()) != null) {
            Camera it = camera3;
            boolean bl4 = false;
            if (it.hasFlashUnit()) {
                Integer n2 = (Integer)it.getTorchState().getValue();
                currentTorchState = n2 != null ? n2 : -1;
            }
        }
        this$0.deviceOrientationListener.start();
        double d = portrait ? width : height;
        double d2 = portrait ? height : width;
        String string = DeviceOrientationExtensionKt.serialize(this$0.deviceOrientationListener.getOrientation());
        TextureRegistry.SurfaceProducer surfaceProducer4 = this$0.surfaceProducer;
        Intrinsics.checkNotNull((Object)surfaceProducer4);
        boolean bl5 = surfaceProducer4.handlesCropAndRotation();
        TextureRegistry.SurfaceProducer surfaceProducer5 = this$0.surfaceProducer;
        Intrinsics.checkNotNull((Object)surfaceProducer5);
        Integer n3 = numberOfCameras;
        $mobileScannerStartedCallback.invoke((Object)new MobileScannerStartParameters(d, d2, string, sensorRotationDegrees, bl5, currentTorchState, surfaceProducer5.id(), n3 != null ? n3 : 0, cameraDirection));
    }

    private static final Unit start$lambda$0$2$0(Function1 $torchStateCallback, Integer state) {
        Intrinsics.checkNotNull((Object)state);
        $torchStateCallback.invoke((Object)state);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$0$2$1(Function1 $zoomScaleStateCallback, ZoomState state) {
        $zoomScaleStateCallback.invoke((Object)state.getLinearZoom());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit analyzeImage$lambda$0(Function1 $onSuccess, List barcodes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)barcodes);
        Iterable $this$map$iv = barcodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void barcode;
            Barcode barcode2 = (Barcode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)barcode);
            collection.add(MobileScannerUtilitiesKt.getData((Barcode)barcode));
        }
        List barcodeMap = (List)destination$iv$iv;
        $onSuccess.invoke((Object)barcodeMap);
        return Unit.INSTANCE;
    }

    private static final void analyzeImage$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void analyzeImage$lambda$2(Function1 $onError, Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.toString();
        }
        $onError.invoke((Object)string);
    }

    private static final void analyzeImage$lambda$3(BarcodeScanner $barcodeScanner, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $barcodeScanner.close();
    }

    public static final /* synthetic */ Camera access$getCamera$p(MobileScanner $this) {
        return $this.camera;
    }

    public static final /* synthetic */ boolean access$getInvertImage$p(MobileScanner $this) {
        return $this.invertImage;
    }

    public static final /* synthetic */ Function4 access$getMobileScannerCallback$p(MobileScanner $this) {
        return $this.mobileScannerCallback;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Ldev/steenbakker/mobile_scanner/MobileScanner$Companion;", "", "<init>", "()V", "configureCameraProcessProvider", "", "defaultBarcodeScannerFactory", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "options", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "mobile_scanner_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final void configureCameraProcessProvider() {
            try {
                CameraXConfig.Builder builder;
                CameraXConfig.Builder $this$configureCameraProcessProvider_u24lambda_u240 = builder = CameraXConfig.Builder.fromConfig((CameraXConfig)Camera2Config.defaultConfig());
                boolean bl = false;
                $this$configureCameraProcessProvider_u24lambda_u240.setMinimumLoggingLevel(6);
                CameraXConfig.Builder builder2 = builder;
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
                CameraXConfig.Builder config = builder2;
                CameraXConfig cameraXConfig = config.build();
                Intrinsics.checkNotNullExpressionValue((Object)cameraXConfig, (String)"build(...)");
                ProcessCameraProvider.Companion.configureInstance(cameraXConfig);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @NotNull
        public final BarcodeScanner defaultBarcodeScannerFactory(@Nullable BarcodeScannerOptions options) {
            BarcodeScanner barcodeScanner;
            BarcodeScannerOptions barcodeScannerOptions = options;
            if (barcodeScannerOptions == null) {
                BarcodeScanner barcodeScanner2 = BarcodeScanning.getClient();
                barcodeScanner = barcodeScanner2;
                Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner2, (String)"getClient(...)");
            } else {
                BarcodeScanner barcodeScanner3 = BarcodeScanning.getClient((BarcodeScannerOptions)barcodeScannerOptions);
                barcodeScanner = barcodeScanner3;
                Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner3, (String)"getClient(...)");
            }
            return barcodeScanner;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

