/*
 * Decompiled with CFR 0.152.
 */
package dev.steenbakker.mobile_scanner;

import android.app.Activity;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Size;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ExperimentalLensFacing;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import dev.steenbakker.mobile_scanner.AlreadyPaused;
import dev.steenbakker.mobile_scanner.AlreadyStarted;
import dev.steenbakker.mobile_scanner.AlreadyStopped;
import dev.steenbakker.mobile_scanner.BarcodeHandler;
import dev.steenbakker.mobile_scanner.CameraError;
import dev.steenbakker.mobile_scanner.DeviceOrientationListener;
import dev.steenbakker.mobile_scanner.MobileScanner;
import dev.steenbakker.mobile_scanner.MobileScannerPermissions;
import dev.steenbakker.mobile_scanner.NoCamera;
import dev.steenbakker.mobile_scanner.ZoomNotInRange;
import dev.steenbakker.mobile_scanner.ZoomWhenStopped;
import dev.steenbakker.mobile_scanner.objects.BarcodeFormats;
import dev.steenbakker.mobile_scanner.objects.DetectionSpeed;
import dev.steenbakker.mobile_scanner.objects.MobileScannerStartParameters;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.view.TextureRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0017J\u0018\u0010?\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0003J\u0018\u0010@\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0018\u0010A\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0018\u0010B\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0010\u0010C\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0018\u0010D\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0018\u0010J\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\"\u0010K\u001a\u0004\u0018\u00010L2\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u00192\u0006\u0010N\u001a\u00020FH\u0002J\b\u0010O\u001a\u00020HH\u0002J\u0018\u0010P\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0012\u001a!\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\u0018\u001a5\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a0\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010 \u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a0\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(%\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\r0!j\u0002`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010(\u001a!\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\r0\u000bj\u0002`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u00101\u001a!\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\r0\u000bj\u0002`3X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u00104\u001a!\u0012\u0013\u0012\u001105\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020\r0\u000bj\u0002`7X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Ldev/steenbakker/mobile_scanner/MobileScannerHandler;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "activity", "Landroid/app/Activity;", "barcodeHandler", "Ldev/steenbakker/mobile_scanner/BarcodeHandler;", "binaryMessenger", "Lio/flutter/plugin/common/BinaryMessenger;", "permissions", "Ldev/steenbakker/mobile_scanner/MobileScannerPermissions;", "addPermissionListener", "Lkotlin/Function1;", "Lio/flutter/plugin/common/PluginRegistry$RequestPermissionsResultListener;", "", "textureRegistry", "Lio/flutter/view/TextureRegistry;", "<init>", "(Landroid/app/Activity;Ldev/steenbakker/mobile_scanner/BarcodeHandler;Lio/flutter/plugin/common/BinaryMessenger;Ldev/steenbakker/mobile_scanner/MobileScannerPermissions;Lkotlin/jvm/functions/Function1;Lio/flutter/view/TextureRegistry;)V", "analyzeImageErrorCallback", "", "Lkotlin/ParameterName;", "name", "message", "Ldev/steenbakker/mobile_scanner/AnalyzerErrorCallback;", "analyzeImageSuccessCallback", "", "", "", "barcodes", "Ldev/steenbakker/mobile_scanner/AnalyzerSuccessCallback;", "analyzerResult", "Lio/flutter/plugin/common/MethodChannel$Result;", "callback", "Lkotlin/Function4;", "", "image", "", "width", "height", "Ldev/steenbakker/mobile_scanner/MobileScannerCallback;", "errorCallback", "error", "Ldev/steenbakker/mobile_scanner/MobileScannerErrorCallback;", "methodChannel", "Lio/flutter/plugin/common/MethodChannel;", "deviceOrientationChannel", "Lio/flutter/plugin/common/EventChannel;", "mobileScanner", "Ldev/steenbakker/mobile_scanner/MobileScanner;", "torchStateCallback", "state", "Ldev/steenbakker/mobile_scanner/TorchStateCallback;", "zoomScaleStateCallback", "", "zoomScale", "Ldev/steenbakker/mobile_scanner/ZoomScaleStateCallback;", "dispose", "activityPluginBinding", "Lio/flutter/embedding/engine/plugins/activity/ActivityPluginBinding;", "onMethodCall", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "start", "pause", "stop", "analyzeImage", "toggleTorch", "setScale", "setZoomRatio", "", "scale", "", "resetScale", "updateScanWindow", "buildBarcodeScannerOptions", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "formats", "autoZoom", "getMaxZoomRatio", "setFocus", "mobile_scanner_debug"})
public final class MobileScannerHandler
implements MethodChannel.MethodCallHandler {
    @NotNull
    private final Activity activity;
    @NotNull
    private final BarcodeHandler barcodeHandler;
    @NotNull
    private final MobileScannerPermissions permissions;
    @NotNull
    private final Function1<PluginRegistry.RequestPermissionsResultListener, Unit> addPermissionListener;
    @NotNull
    private final Function1<String, Unit> analyzeImageErrorCallback;
    @NotNull
    private final Function1<List<? extends Map<String, ? extends Object>>, Unit> analyzeImageSuccessCallback;
    @Nullable
    private MethodChannel.Result analyzerResult;
    @NotNull
    private final Function4<List<? extends Map<String, ? extends Object>>, byte[], Integer, Integer, Unit> callback;
    @NotNull
    private final Function1<String, Unit> errorCallback;
    @Nullable
    private MethodChannel methodChannel;
    @Nullable
    private EventChannel deviceOrientationChannel;
    @Nullable
    private MobileScanner mobileScanner;
    @NotNull
    private final Function1<Integer, Unit> torchStateCallback;
    @NotNull
    private final Function1<Double, Unit> zoomScaleStateCallback;

    public MobileScannerHandler(@NotNull Activity activity, @NotNull BarcodeHandler barcodeHandler, @NotNull BinaryMessenger binaryMessenger, @NotNull MobileScannerPermissions permissions, @NotNull Function1<? super PluginRegistry.RequestPermissionsResultListener, Unit> addPermissionListener, @NotNull TextureRegistry textureRegistry) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)barcodeHandler, (String)"barcodeHandler");
        Intrinsics.checkNotNullParameter((Object)binaryMessenger, (String)"binaryMessenger");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(addPermissionListener, (String)"addPermissionListener");
        Intrinsics.checkNotNullParameter((Object)textureRegistry, (String)"textureRegistry");
        this.activity = activity;
        this.barcodeHandler = barcodeHandler;
        this.permissions = permissions;
        this.addPermissionListener = addPermissionListener;
        this.analyzeImageErrorCallback = arg_0 -> MobileScannerHandler.analyzeImageErrorCallback$lambda$0(this, arg_0);
        this.analyzeImageSuccessCallback = arg_0 -> MobileScannerHandler.analyzeImageSuccessCallback$lambda$0(this, arg_0);
        this.callback = (arg_0, arg_1, arg_2, arg_3) -> MobileScannerHandler.callback$lambda$0(this, arg_0, arg_1, arg_2, arg_3);
        this.errorCallback = arg_0 -> MobileScannerHandler.errorCallback$lambda$0(this, arg_0);
        this.torchStateCallback = arg_0 -> MobileScannerHandler.torchStateCallback$lambda$0(this, arg_0);
        this.zoomScaleStateCallback = arg_0 -> MobileScannerHandler.zoomScaleStateCallback$lambda$0(this, arg_0);
        MethodChannel methodChannel = this.methodChannel = new MethodChannel(binaryMessenger, "dev.steenbakker.mobile_scanner/scanner/method");
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        DeviceOrientationListener deviceOrientationListener = new DeviceOrientationListener(this.activity);
        EventChannel eventChannel = this.deviceOrientationChannel = new EventChannel(binaryMessenger, "dev.steenbakker.mobile_scanner/scanner/deviceOrientation");
        Intrinsics.checkNotNull((Object)eventChannel);
        eventChannel.setStreamHandler((EventChannel.StreamHandler)deviceOrientationListener);
        this.mobileScanner = new MobileScanner(this.activity, textureRegistry, this.callback, this.errorCallback, deviceOrientationListener, null, 32, null);
    }

    public final void dispose(@NotNull ActivityPluginBinding activityPluginBinding) {
        Intrinsics.checkNotNullParameter((Object)activityPluginBinding, (String)"activityPluginBinding");
        MethodChannel methodChannel = this.methodChannel;
        if (methodChannel != null) {
            methodChannel.setMethodCallHandler(null);
        }
        this.methodChannel = null;
        EventChannel eventChannel = this.deviceOrientationChannel;
        if (eventChannel != null) {
            eventChannel.setStreamHandler(null);
        }
        this.deviceOrientationChannel = null;
        this.barcodeHandler.dispose();
        MobileScanner mobileScanner = this.mobileScanner;
        if (mobileScanner != null) {
            mobileScanner.dispose();
        }
        this.mobileScanner = null;
        PluginRegistry.RequestPermissionsResultListener listener = this.permissions.getPermissionListener();
        if (listener != null) {
            activityPluginBinding.removeRequestPermissionsResultListener(listener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExperimentalLensFacing
    @ExperimentalGetImage
    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = call.method;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1095692943: {
                    if (!string.equals("request")) break;
                    n = 1;
                    break;
                }
                case -655811320: {
                    if (!string.equals("toggleTorch")) break;
                    n = 2;
                    break;
                }
                case 16698223: {
                    if (!string.equals("analyzeImage")) break;
                    n = 3;
                    break;
                }
                case 3540994: {
                    if (!string.equals("stop")) break;
                    n = 4;
                    break;
                }
                case 1403963912: {
                    if (!string.equals("setScale")) break;
                    n = 5;
                    break;
                }
                case 2023844470: {
                    if (!string.equals("updateScanWindow")) break;
                    n = 6;
                    break;
                }
                case 109757538: {
                    if (!string.equals("start")) break;
                    n = 7;
                    break;
                }
                case -1688013509: {
                    if (!string.equals("resetScale")) break;
                    n = 8;
                    break;
                }
                case 109757585: {
                    if (!string.equals("state")) break;
                    n = 9;
                    break;
                }
                case 1392317846: {
                    if (!string.equals("setFocus")) break;
                    n = 10;
                    break;
                }
                case 106440182: {
                    if (!string.equals("pause")) break;
                    n = 11;
                    break;
                }
            }
            switch (n) {
                case 9: {
                    result.success((Object)this.permissions.hasCameraPermission(this.activity));
                    return;
                }
                case 1: {
                    this.permissions.requestPermission(this.activity, this.addPermissionListener, new MobileScannerPermissions.ResultCallback(result){
                        final /* synthetic */ MethodChannel.Result $result;
                        {
                            this.$result = $result;
                        }

                        public void onResult(String errorCode) {
                            String string = errorCode;
                            if (string == null) {
                                this.$result.success((Object)true);
                            } else if (Intrinsics.areEqual((Object)string, (Object)"MOBILE_SCANNER_CAMERA_PERMISSION_DENIED")) {
                                this.$result.success((Object)false);
                            } else if (Intrinsics.areEqual((Object)string, (Object)"MOBILE_SCANNER_CAMERA_PERMISSION_REQUEST_PENDING")) {
                                this.$result.error("MOBILE_SCANNER_CAMERA_PERMISSION_REQUEST_PENDING", "Another request is ongoing and multiple requests cannot be handled at once.", null);
                            } else {
                                this.$result.error("MOBILE_SCANNER_GENERIC_ERROR", "An unknown error occurred.", null);
                            }
                        }
                    });
                    return;
                }
                case 7: {
                    this.start(call, result);
                    return;
                }
                case 11: {
                    this.pause(call, result);
                    return;
                }
                case 4: {
                    this.stop(call, result);
                    return;
                }
                case 2: {
                    this.toggleTorch(result);
                    return;
                }
                case 3: {
                    this.analyzeImage(call, result);
                    return;
                }
                case 5: {
                    this.setScale(call, result);
                    return;
                }
                case 8: {
                    this.resetScale(result);
                    return;
                }
                case 6: {
                    this.updateScanWindow(call, result);
                    return;
                }
                case 10: {
                    this.setFocus(call, result);
                    return;
                }
            }
        }
        result.notImplemented();
    }

    @ExperimentalLensFacing
    @ExperimentalGetImage
    private final void start(MethodCall call, MethodChannel.Result result) {
        Boolean bl = (Boolean)call.argument("torch");
        boolean torch = bl != null ? bl : false;
        Integer n = (Integer)call.argument("facing");
        int facing = n != null ? n : 0;
        List formats = (List)call.argument("formats");
        Boolean bl2 = (Boolean)call.argument("returnImage");
        boolean returnImage = bl2 != null ? bl2 : false;
        Integer n2 = (Integer)call.argument("speed");
        int speed = n2 != null ? n2 : 1;
        Integer n3 = (Integer)call.argument("timeout");
        int timeout = n3 != null ? n3 : 250;
        List cameraResolutionValues = (List)call.argument("cameraResolution");
        Boolean bl3 = (Boolean)call.argument("autoZoom");
        boolean autoZoom = bl3 != null ? bl3 : false;
        Size cameraResolution = cameraResolutionValues != null ? new Size(((Number)cameraResolutionValues.get(0)).intValue(), ((Number)cameraResolutionValues.get(1)).intValue()) : null;
        Boolean bl4 = (Boolean)call.argument("invertImage");
        boolean invertImage = bl4 != null ? bl4 : false;
        Double initialZoom = (Double)call.argument("initialZoom");
        BarcodeScannerOptions barcodeScannerOptions = this.buildBarcodeScannerOptions(formats, autoZoom);
        CameraSelector cameraSelector = facing == 0 ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
        Intrinsics.checkNotNull((Object)cameraSelector);
        CameraSelector position = cameraSelector;
        DetectionSpeed detectionSpeed = switch (speed) {
            case 0 -> DetectionSpeed.NO_DUPLICATES;
            case 1 -> DetectionSpeed.NORMAL;
            default -> DetectionSpeed.UNRESTRICTED;
        };
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        mobileScanner.start(barcodeScannerOptions, returnImage, position, torch, detectionSpeed, this.torchStateCallback, this.zoomScaleStateCallback, (Function1<? super MobileScannerStartParameters, Unit>)((Function1)arg_0 -> MobileScannerHandler.start$lambda$0(result, arg_0)), (Function1<? super Exception, Unit>)((Function1)arg_0 -> MobileScannerHandler.start$lambda$1(result, arg_0)), timeout, cameraResolution, invertImage, initialZoom);
    }

    private final void pause(MethodCall call, MethodChannel.Result result) {
        Boolean bl = (Boolean)call.argument("force");
        boolean force = bl != null ? bl : false;
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.pause(force);
            result.success(null);
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof AlreadyPaused || exception instanceof AlreadyStopped) {
                result.success(null);
            }
            throw e;
        }
    }

    private final void stop(MethodCall call, MethodChannel.Result result) {
        Boolean bl = (Boolean)call.argument("force");
        boolean force = bl != null ? bl : false;
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.stop(force);
            result.success(null);
        }
        catch (AlreadyStopped e) {
            result.success(null);
        }
    }

    private final void analyzeImage(MethodCall call, MethodChannel.Result result) {
        this.analyzerResult = result;
        List formats = (List)call.argument("formats");
        Object object = call.argument("filePath");
        Intrinsics.checkNotNull((Object)object);
        String filePath = (String)object;
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        Uri uri = Uri.fromFile((File)new File(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(...)");
        mobileScanner.analyzeImage(uri, this.buildBarcodeScannerOptions(formats, false), this.analyzeImageSuccessCallback, this.analyzeImageErrorCallback);
    }

    private final void toggleTorch(MethodChannel.Result result) {
        MobileScanner mobileScanner = this.mobileScanner;
        if (mobileScanner != null) {
            mobileScanner.toggleTorch();
        }
        result.success(null);
    }

    private final void setScale(MethodCall call, MethodChannel.Result result) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            Object object = call.arguments;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            mobileScanner.setScale((Double)object);
            result.success(null);
        }
        catch (ZoomWhenStopped e) {
            result.error("MOBILE_SCANNER_SET_SCALE_WHEN_STOPPED_ERROR", "The zoom scale cannot be changed when the camera is stopped.", null);
        }
        catch (ZoomNotInRange e) {
            result.error("MOBILE_SCANNER_GENERIC_ERROR", "The zoom scale should be between 0 and 1 (both inclusive)", null);
        }
    }

    private final boolean setZoomRatio(float scale) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.setZoomRatio(scale);
            return true;
        }
        catch (ZoomWhenStopped zoomWhenStopped) {
            return false;
        }
    }

    private final void resetScale(MethodChannel.Result result) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.resetScale();
            result.success(null);
        }
        catch (ZoomWhenStopped e) {
            result.error("MOBILE_SCANNER_SET_SCALE_WHEN_STOPPED_ERROR", "The zoom scale cannot be changed when the camera is stopped.", null);
        }
    }

    private final void updateScanWindow(MethodCall call, MethodChannel.Result result) {
        MobileScanner mobileScanner = this.mobileScanner;
        if (mobileScanner != null) {
            mobileScanner.setScanWindow((List)call.argument("rect"));
        }
        result.success(null);
    }

    private final BarcodeScannerOptions buildBarcodeScannerOptions(List<Integer> formats, boolean autoZoom) {
        BarcodeScannerOptions.Builder builder = null;
        if (formats == null) {
            builder = new BarcodeScannerOptions.Builder();
        } else {
            List formatsList = new ArrayList();
            Object object = formats.iterator();
            while (object.hasNext()) {
                int formatValue = ((Number)object.next()).intValue();
                formatsList.add(BarcodeFormats.Companion.fromRawValue(formatValue).getIntValue());
            }
            if (formatsList.size() == 1) {
                builder = new BarcodeScannerOptions.Builder().setBarcodeFormats(((Number)CollectionsKt.first((List)formatsList)).intValue(), new int[0]);
            } else {
                object = CollectionsKt.toIntArray((Collection)formatsList.subList(1, formatsList.size()));
                builder = new BarcodeScannerOptions.Builder().setBarcodeFormats(((Number)CollectionsKt.first((List)formatsList)).intValue(), Arrays.copyOf((int[])object, ((Object)object).length));
            }
        }
        if (autoZoom) {
            builder.setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(arg_0 -> MobileScannerHandler.buildBarcodeScannerOptions$lambda$0(this, arg_0)).setMaxSupportedZoomRatio(this.getMaxZoomRatio()).build());
        }
        return builder.build();
    }

    private final float getMaxZoomRatio() {
        Object object = this.activity.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        float maxZoom = 1.0f;
        try {
            String[] stringArray = cameraManager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
            for (String cameraId : stringArray) {
                CameraCharacteristics characteristics;
                Intrinsics.checkNotNullExpressionValue((Object)cameraManager.getCameraCharacteristics(cameraId), (String)"getCameraCharacteristics(...)");
                Float maxZoomRatio = (Float)characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
                if (maxZoomRatio == null || !(maxZoomRatio.floatValue() > maxZoom)) continue;
                maxZoom = maxZoomRatio.floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxZoom;
    }

    private final void setFocus(MethodCall call, MethodChannel.Result result) {
        Float dy;
        Float dx;
        block8: {
            block7: {
                Double d = (Double)call.argument("dx");
                dx = d != null ? Float.valueOf((float)d.doubleValue()) : null;
                Double d2 = (Double)call.argument("dy");
                Float f = dy = d2 != null ? Float.valueOf((float)d2.doubleValue()) : null;
                if (dx == null || dy == null) break block7;
                float f2 = dx.floatValue();
                boolean bl = 0.0f <= f2 ? f2 <= 1.0f : false;
                if (!bl) break block7;
                f2 = dy.floatValue();
                if (0.0f <= f2 ? f2 <= 1.0f : false) break block8;
            }
            result.error("MOBILE_SCANNER_INVALID_FOCUS_POINT", "The focus coordinates are not valid.", null);
            return;
        }
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            if (mobileScanner != null) {
                mobileScanner.setFocus(dx.floatValue(), dy.floatValue());
            }
            result.success(null);
        }
        catch (ZoomWhenStopped e) {
            result.error("MOBILE_SCANNER_GENERIC_ERROR", "Cannot set focus when camera is stopped.", null);
        }
        catch (Exception e) {
            result.error("MOBILE_SCANNER_GENERIC_ERROR", "An unknown error occurred.", (Object)e.getLocalizedMessage());
        }
    }

    private static final Unit analyzeImageErrorCallback$lambda$0(MobileScannerHandler this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new Handler(Looper.getMainLooper()).post(() -> MobileScannerHandler.analyzeImageErrorCallback$lambda$0$0(this$0, it));
        return Unit.INSTANCE;
    }

    private static final void analyzeImageErrorCallback$lambda$0$0(MobileScannerHandler this$0, String $it) {
        MethodChannel.Result result = this$0.analyzerResult;
        if (result != null) {
            result.error("MOBILE_SCANNER_BARCODE_ERROR", $it, null);
        }
        this$0.analyzerResult = null;
    }

    private static final Unit analyzeImageSuccessCallback$lambda$0(MobileScannerHandler this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new Handler(Looper.getMainLooper()).post(() -> MobileScannerHandler.analyzeImageSuccessCallback$lambda$0$0(this$0, it));
        return Unit.INSTANCE;
    }

    private static final void analyzeImageSuccessCallback$lambda$0$0(MobileScannerHandler this$0, List $it) {
        MethodChannel.Result result = this$0.analyzerResult;
        if (result != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"barcode"), TuplesKt.to((Object)"data", (Object)$it)};
            result.success((Object)MapsKt.mapOf((Pair[])pairArray));
        }
        this$0.analyzerResult = null;
    }

    private static final Unit callback$lambda$0(MobileScannerHandler this$0, List barcodes, byte[] image, Integer width, Integer height) {
        Intrinsics.checkNotNullParameter((Object)barcodes, (String)"barcodes");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"name", (Object)"barcode");
        pairArray[1] = TuplesKt.to((Object)"data", (Object)barcodes);
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to((Object)"bytes", (Object)image);
        Integer n = width;
        pairArray2[1] = TuplesKt.to((Object)"width", (Object)(n != null ? Double.valueOf(n.intValue()) : null));
        Integer n2 = height;
        pairArray2[2] = TuplesKt.to((Object)"height", (Object)(n2 != null ? Double.valueOf(n2.intValue()) : null));
        pairArray[2] = TuplesKt.to((Object)"image", (Object)MapsKt.mapOf((Pair[])pairArray2));
        this$0.barcodeHandler.publishEvent(MapsKt.mapOf((Pair[])pairArray));
        return Unit.INSTANCE;
    }

    private static final Unit errorCallback$lambda$0(MobileScannerHandler this$0, String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this$0.barcodeHandler.publishError("MOBILE_SCANNER_BARCODE_ERROR", error, null);
        return Unit.INSTANCE;
    }

    private static final Unit torchStateCallback$lambda$0(MobileScannerHandler this$0, int state) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"torchState"), TuplesKt.to((Object)"data", (Object)state)};
        this$0.barcodeHandler.publishEvent(MapsKt.mapOf((Pair[])pairArray));
        return Unit.INSTANCE;
    }

    private static final Unit zoomScaleStateCallback$lambda$0(MobileScannerHandler this$0, double zoomScale) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"zoomScaleState"), TuplesKt.to((Object)"data", (Object)zoomScale)};
        this$0.barcodeHandler.publishEvent(MapsKt.mapOf((Pair[])pairArray));
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$0(MethodChannel.Result $result, MobileScannerStartParameters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new Handler(Looper.getMainLooper()).post(() -> MobileScannerHandler.start$lambda$0$0($result, it));
        return Unit.INSTANCE;
    }

    private static final void start$lambda$0$0(MethodChannel.Result $result, MobileScannerStartParameters $it) {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"textureId", (Object)$it.getId());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"width", (Object)$it.getWidth()), TuplesKt.to((Object)"height", (Object)$it.getHeight())};
        pairArray[1] = TuplesKt.to((Object)"size", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray[2] = TuplesKt.to((Object)"naturalDeviceOrientation", (Object)$it.getNaturalDeviceOrientation());
        pairArray[3] = TuplesKt.to((Object)"handlesCropAndRotation", (Object)$it.getHandlesCropAndRotation());
        pairArray[4] = TuplesKt.to((Object)"sensorOrientation", (Object)$it.getSensorOrientation());
        pairArray[5] = TuplesKt.to((Object)"currentTorchState", (Object)$it.getCurrentTorchState());
        pairArray[6] = TuplesKt.to((Object)"numberOfCameras", (Object)$it.getNumberOfCameras());
        pairArray[7] = TuplesKt.to((Object)"cameraDirection", (Object)$it.getCameraDirection());
        $result.success((Object)MapsKt.mapOf((Pair[])pairArray));
    }

    private static final Unit start$lambda$1(MethodChannel.Result $result, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new Handler(Looper.getMainLooper()).post(() -> MobileScannerHandler.start$lambda$1$0(it, $result));
        return Unit.INSTANCE;
    }

    private static final void start$lambda$1$0(Exception $it, MethodChannel.Result $result) {
        Exception exception = $it;
        if (exception instanceof AlreadyStarted) {
            $result.error("MOBILE_SCANNER_ALREADY_STARTED_ERROR", "The scanner was already started.", null);
        } else if (exception instanceof CameraError) {
            $result.error("MOBILE_SCANNER_CAMERA_ERROR", "An error occurred when opening the camera.", null);
        } else if (exception instanceof NoCamera) {
            $result.error("MOBILE_SCANNER_NO_CAMERA_ERROR", "No cameras available.", null);
        } else {
            $result.error("MOBILE_SCANNER_GENERIC_ERROR", "An unknown error occurred.", null);
        }
    }

    private static final boolean buildBarcodeScannerOptions$lambda$0(MobileScannerHandler this$0, float it) {
        return this$0.setZoomRatio(it);
    }
}

