/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.sharedpreferences;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Messages {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface SharedPreferencesApi {
        @NonNull
        public Boolean remove(@NonNull String var1);

        @NonNull
        public Boolean setBool(@NonNull String var1, @NonNull Boolean var2);

        @NonNull
        public Boolean setString(@NonNull String var1, @NonNull String var2);

        @NonNull
        public Boolean setInt(@NonNull String var1, @NonNull Long var2);

        @NonNull
        public Boolean setDouble(@NonNull String var1, @NonNull Double var2);

        @NonNull
        public Boolean setEncodedStringList(@NonNull String var1, @NonNull String var2);

        @NonNull
        public Boolean setDeprecatedStringList(@NonNull String var1, @NonNull List<String> var2);

        @NonNull
        public Boolean clear(@NonNull String var1, @Nullable List<String> var2);

        @NonNull
        public Map<String, Object> getAll(@NonNull String var1, @Nullable List<String> var2);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable SharedPreferencesApi api) {
            SharedPreferencesApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable SharedPreferencesApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BinaryMessenger.TaskQueue taskQueue = binaryMessenger.makeBackgroundTaskQueue();
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.remove" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    try {
                        Boolean output = api.remove(keyArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setBool" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    Boolean valueArg = (Boolean)args.get(1);
                    try {
                        Boolean output = api.setBool(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setString" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    String valueArg = (String)args.get(1);
                    try {
                        Boolean output = api.setString(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setInt" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    Long valueArg = (Long)args.get(1);
                    try {
                        Boolean output = api.setInt(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setDouble" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    Double valueArg = (Double)args.get(1);
                    try {
                        Boolean output = api.setDouble(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setEncodedStringList" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    String valueArg = (String)args.get(1);
                    try {
                        Boolean output = api.setEncodedStringList(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.setDeprecatedStringList" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String keyArg = (String)args.get(0);
                    List valueArg = (List)args.get(1);
                    try {
                        Boolean output = api.setDeprecatedStringList(keyArg, valueArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.clear" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String prefixArg = (String)args.get(0);
                    List allowListArg = (List)args.get(1);
                    try {
                        Boolean output = api.clear(prefixArg, allowListArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.shared_preferences_android.SharedPreferencesApi.getAll" + messageChannelSuffix, SharedPreferencesApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String prefixArg = (String)args.get(0);
                    List allowListArg = (List)args.get(1);
                    try {
                        Map<String, Object> output = api.getAll(prefixArg, allowListArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                default: 
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            super.writeValue(stream, value);
        }
    }
}

