/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import com.tekartik.sqflite.Database;
import com.tekartik.sqflite.DatabaseDelegate;
import com.tekartik.sqflite.DatabaseTask;
import com.tekartik.sqflite.DatabaseWorkerPoolImpl;
import com.tekartik.sqflite.SingleDatabaseWorkerPoolImpl;

public interface DatabaseWorkerPool {
    public void start();

    public void quit();

    public void post(DatabaseTask var1);

    default public void post(final Database database, Runnable runnable) {
        DatabaseDelegate delegate = database == null ? null : new DatabaseDelegate(){

            @Override
            public int getDatabaseId() {
                return database.id;
            }

            @Override
            public boolean isInTransaction() {
                return database.isInTransaction();
            }
        };
        this.post(new DatabaseTask(delegate, runnable));
    }

    public static DatabaseWorkerPool create(String name, int numberOfWorkers, int priority) {
        if (numberOfWorkers == 1) {
            return new SingleDatabaseWorkerPoolImpl(name, priority);
        }
        return new DatabaseWorkerPoolImpl(name, numberOfWorkers, priority);
    }
}

