/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WebViewActivity
extends Activity {
    public static final String ACTION_CLOSE = "close action";
    private final BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (WebViewActivity.ACTION_CLOSE.equals(action)) {
                WebViewActivity.this.finish();
            }
        }
    };
    private final WebViewClient webViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            view.loadUrl(request.getUrl().toString());
            return false;
        }
    };
    WebView webview;
    private final IntentFilter closeIntentFilter = new IntentFilter("close action");
    @VisibleForTesting
    static final String URL_EXTRA = "url";
    @VisibleForTesting
    static final String ENABLE_JS_EXTRA = "enableJavaScript";
    @VisibleForTesting
    static final String ENABLE_DOM_EXTRA = "enableDomStorage";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.webview = new WebView((Context)this);
        this.setContentView((View)this.webview);
        Intent intent = this.getIntent();
        String url = intent.getStringExtra(URL_EXTRA);
        boolean enableJavaScript = intent.getBooleanExtra(ENABLE_JS_EXTRA, false);
        boolean enableDomStorage = intent.getBooleanExtra(ENABLE_DOM_EXTRA, false);
        Bundle headersBundle = intent.getBundleExtra("com.android.browser.headers");
        Map<String, String> headersMap = WebViewActivity.extractHeaders(headersBundle);
        this.webview.loadUrl(url, headersMap);
        this.webview.getSettings().setJavaScriptEnabled(enableJavaScript);
        this.webview.getSettings().setDomStorageEnabled(enableDomStorage);
        this.webview.setWebViewClient(this.webViewClient);
        this.webview.getSettings().setSupportMultipleWindows(true);
        this.webview.setWebChromeClient((WebChromeClient)new FlutterWebChromeClient());
        ContextCompat.registerReceiver((Context)this, (BroadcastReceiver)this.broadcastReceiver, (IntentFilter)this.closeIntentFilter, (int)2);
    }

    @VisibleForTesting
    @NonNull
    public static Map<String, String> extractHeaders(@Nullable Bundle headersBundle) {
        if (headersBundle == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String key : headersBundle.keySet()) {
            String value = headersBundle.getString(key);
            headersMap.put(key, value);
        }
        return headersMap;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.broadcastReceiver);
    }

    public boolean onKeyDown(int keyCode, @Nullable KeyEvent event) {
        if (keyCode == 4 && this.webview.canGoBack()) {
            this.webview.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @NonNull
    public static Intent createIntent(@NonNull Context context, @NonNull String url, boolean enableJavaScript, boolean enableDomStorage, @NonNull Bundle headersBundle) {
        return new Intent(context, WebViewActivity.class).putExtra(URL_EXTRA, url).putExtra(ENABLE_JS_EXTRA, enableJavaScript).putExtra(ENABLE_DOM_EXTRA, enableDomStorage).putExtra("com.android.browser.headers", headersBundle);
    }

    class FlutterWebChromeClient
    extends WebChromeClient {
        FlutterWebChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            WebViewClient webViewClient = new WebViewClient(){

                public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
                    WebViewActivity.this.webview.loadUrl(request.getUrl().toString());
                    return true;
                }
            };
            WebView newWebView = new WebView(WebViewActivity.this.webview.getContext());
            newWebView.setWebViewClient(webViewClient);
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(newWebView);
            resultMsg.sendToTarget();
            return true;
        }
    }
}

