/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import io.flutter.plugins.urllauncher.BuildConfig;
import io.flutter.plugins.urllauncher.Messages;
import io.flutter.plugins.urllauncher.WebViewActivity;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

final class UrlLauncher
implements Messages.UrlLauncherApi {
    private static final String TAG = "UrlLauncher";
    @NonNull
    private final Context applicationContext;
    @NonNull
    private final IntentResolver intentResolver;
    @Nullable
    private Activity activity;

    @VisibleForTesting
    UrlLauncher(@NonNull Context context, @NonNull IntentResolver intentResolver) {
        this.applicationContext = context;
        this.intentResolver = intentResolver;
    }

    UrlLauncher(@NonNull Context context) {
        this(context, intent -> {
            ComponentName componentName = intent.resolveActivity(context.getPackageManager());
            return componentName == null ? null : componentName.toShortString();
        });
    }

    void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    @Override
    @NonNull
    public Boolean canLaunchUrl(@NonNull String url) {
        Intent launchIntent = new Intent("android.intent.action.VIEW");
        launchIntent.setData(Uri.parse((String)url));
        String componentName = this.intentResolver.getHandlerComponentName(launchIntent);
        if (BuildConfig.DEBUG) {
            Log.i((String)TAG, (String)("component name for " + url + " is " + componentName));
        }
        if (componentName == null) {
            return false;
        }
        return !"{com.android.fallback/com.android.fallback.Fallback}".equals(componentName);
    }

    @Override
    @NonNull
    public Boolean launchUrl(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Boolean requireNonBrowser) {
        this.ensureActivity();
        assert (this.activity != null);
        Intent launchIntent = new Intent("android.intent.action.VIEW").setData(Uri.parse((String)url)).putExtra("com.android.browser.headers", UrlLauncher.extractBundle(headers));
        if (requireNonBrowser.booleanValue() && Build.VERSION.SDK_INT >= 30) {
            launchIntent.addFlags(1024);
        }
        try {
            this.activity.startActivity(launchIntent);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    @NonNull
    public Boolean openUrlInApp(@NonNull String url, @NonNull Boolean allowCustomTab, @NonNull Messages.WebViewOptions webViewOptions, @NonNull Messages.BrowserOptions browserOptions) {
        Uri uri;
        this.ensureActivity();
        assert (this.activity != null);
        Bundle headersBundle = UrlLauncher.extractBundle(webViewOptions.getHeaders());
        if (allowCustomTab.booleanValue() && !UrlLauncher.containsRestrictedHeader(webViewOptions.getHeaders()) && UrlLauncher.openCustomTab((Context)this.activity, uri = Uri.parse((String)url), headersBundle, browserOptions)) {
            return true;
        }
        Intent launchIntent = WebViewActivity.createIntent((Context)this.activity, url, webViewOptions.getEnableJavaScript(), webViewOptions.getEnableDomStorage(), headersBundle);
        try {
            this.activity.startActivity(launchIntent);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public void closeWebView() {
        this.applicationContext.sendBroadcast(new Intent("close action"));
    }

    @Override
    @NonNull
    public Boolean supportsCustomTabs() {
        return CustomTabsClient.getPackageName((Context)this.applicationContext, Collections.emptyList()) != null;
    }

    private static boolean openCustomTab(@NonNull Context context, @NonNull Uri uri, @NonNull Bundle headersBundle, @NonNull Messages.BrowserOptions options) {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setShowTitle(options.getShowTitle().booleanValue()).build();
        customTabsIntent.intent.putExtra("com.android.browser.headers", headersBundle);
        try {
            customTabsIntent.launchUrl(context, uri);
        }
        catch (ActivityNotFoundException ex) {
            return false;
        }
        return true;
    }

    private static boolean containsRestrictedHeader(Map<String, String> headersMap) {
        block9: for (String key : headersMap.keySet()) {
            switch (key.toLowerCase(Locale.US)) {
                case "accept": 
                case "accept-language": 
                case "content-language": 
                case "content-type": {
                    continue block9;
                }
            }
            return true;
        }
        return false;
    }

    @NonNull
    private static Bundle extractBundle(Map<String, String> headersMap) {
        Bundle headersBundle = new Bundle();
        for (String key : headersMap.keySet()) {
            String value = headersMap.get(key);
            headersBundle.putString(key, value);
        }
        return headersBundle;
    }

    private void ensureActivity() {
        if (this.activity == null) {
            throw new Messages.FlutterError("NO_ACTIVITY", "Launching a URL requires a foreground activity.", null);
        }
    }

    @VisibleForTesting
    static interface IntentResolver {
        public String getHandlerComponentName(@NonNull Intent var1);
    }
}

