/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.webviewflutter.AndroidWebkitLibraryPigeonProxyApiRegistrar;
import io.flutter.plugins.webviewflutter.CertificateProxyApi;
import io.flutter.plugins.webviewflutter.ClientCertRequestProxyApi;
import io.flutter.plugins.webviewflutter.ConsoleMessageProxyApi;
import io.flutter.plugins.webviewflutter.CookieManagerProxyApi;
import io.flutter.plugins.webviewflutter.CustomViewCallbackProxyApi;
import io.flutter.plugins.webviewflutter.DownloadListenerProxyApi;
import io.flutter.plugins.webviewflutter.FileChooserParamsProxyApi;
import io.flutter.plugins.webviewflutter.FlutterAssetManager;
import io.flutter.plugins.webviewflutter.FlutterAssetManagerProxyApi;
import io.flutter.plugins.webviewflutter.GeolocationPermissionsCallbackProxyApi;
import io.flutter.plugins.webviewflutter.HttpAuthHandlerProxyApi;
import io.flutter.plugins.webviewflutter.JavaScriptChannelProxyApi;
import io.flutter.plugins.webviewflutter.MessageProxyApi;
import io.flutter.plugins.webviewflutter.PermissionRequestProxyApi;
import io.flutter.plugins.webviewflutter.PigeonApiAndroidMessage;
import io.flutter.plugins.webviewflutter.PigeonApiCertificate;
import io.flutter.plugins.webviewflutter.PigeonApiClientCertRequest;
import io.flutter.plugins.webviewflutter.PigeonApiConsoleMessage;
import io.flutter.plugins.webviewflutter.PigeonApiCookieManager;
import io.flutter.plugins.webviewflutter.PigeonApiCustomViewCallback;
import io.flutter.plugins.webviewflutter.PigeonApiDownloadListener;
import io.flutter.plugins.webviewflutter.PigeonApiFileChooserParams;
import io.flutter.plugins.webviewflutter.PigeonApiFlutterAssetManager;
import io.flutter.plugins.webviewflutter.PigeonApiGeolocationPermissionsCallback;
import io.flutter.plugins.webviewflutter.PigeonApiHttpAuthHandler;
import io.flutter.plugins.webviewflutter.PigeonApiJavaScriptChannel;
import io.flutter.plugins.webviewflutter.PigeonApiPermissionRequest;
import io.flutter.plugins.webviewflutter.PigeonApiSslCertificate;
import io.flutter.plugins.webviewflutter.PigeonApiSslCertificateDName;
import io.flutter.plugins.webviewflutter.PigeonApiSslError;
import io.flutter.plugins.webviewflutter.PigeonApiSslErrorHandler;
import io.flutter.plugins.webviewflutter.PigeonApiView;
import io.flutter.plugins.webviewflutter.PigeonApiWebChromeClient;
import io.flutter.plugins.webviewflutter.PigeonApiWebResourceError;
import io.flutter.plugins.webviewflutter.PigeonApiWebResourceErrorCompat;
import io.flutter.plugins.webviewflutter.PigeonApiWebResourceRequest;
import io.flutter.plugins.webviewflutter.PigeonApiWebResourceResponse;
import io.flutter.plugins.webviewflutter.PigeonApiWebSettings;
import io.flutter.plugins.webviewflutter.PigeonApiWebSettingsCompat;
import io.flutter.plugins.webviewflutter.PigeonApiWebStorage;
import io.flutter.plugins.webviewflutter.PigeonApiWebView;
import io.flutter.plugins.webviewflutter.PigeonApiWebViewClient;
import io.flutter.plugins.webviewflutter.PigeonApiWebViewFeature;
import io.flutter.plugins.webviewflutter.PigeonApiWebViewPoint;
import io.flutter.plugins.webviewflutter.SslCertificateDNameProxyApi;
import io.flutter.plugins.webviewflutter.SslCertificateProxyApi;
import io.flutter.plugins.webviewflutter.SslErrorHandlerProxyApi;
import io.flutter.plugins.webviewflutter.SslErrorProxyApi;
import io.flutter.plugins.webviewflutter.ViewProxyApi;
import io.flutter.plugins.webviewflutter.WebChromeClientProxyApi;
import io.flutter.plugins.webviewflutter.WebResourceErrorCompatProxyApi;
import io.flutter.plugins.webviewflutter.WebResourceErrorProxyApi;
import io.flutter.plugins.webviewflutter.WebResourceRequestProxyApi;
import io.flutter.plugins.webviewflutter.WebResourceResponseProxyApi;
import io.flutter.plugins.webviewflutter.WebSettingsCompatProxyApi;
import io.flutter.plugins.webviewflutter.WebSettingsProxyApi;
import io.flutter.plugins.webviewflutter.WebStorageProxyApi;
import io.flutter.plugins.webviewflutter.WebViewClientProxyApi;
import io.flutter.plugins.webviewflutter.WebViewFeatureProxyApi;
import io.flutter.plugins.webviewflutter.WebViewPointProxyApi;
import io.flutter.plugins.webviewflutter.WebViewProxyApi;

public class ProxyApiRegistrar
extends AndroidWebkitLibraryPigeonProxyApiRegistrar {
    @NonNull
    private Context context;
    @NonNull
    private final FlutterAssetManager flutterAssetManager;

    public ProxyApiRegistrar(@NonNull BinaryMessenger binaryMessenger, @NonNull Context context, @NonNull FlutterAssetManager flutterAssetManager) {
        super(binaryMessenger);
        this.context = context;
        this.flutterAssetManager = flutterAssetManager;
    }

    @ChecksSdkIntAtLeast(parameter=0)
    boolean sdkIsAtLeast(int version) {
        return Build.VERSION.SDK_INT >= version;
    }

    void runOnMainThread(Runnable runnable) {
        if (this.context instanceof Activity) {
            ((Activity)this.context).runOnUiThread(runnable);
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    void logError(String tag, Throwable exception) {
        Log.e((String)tag, (String)(exception.getClass().getSimpleName() + ", Message: " + exception.getMessage() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception)));
    }

    @NonNull
    IllegalArgumentException createUnknownEnumException(@NonNull Object enumValue) {
        return new IllegalArgumentException(enumValue + " doesn't represent a native value.");
    }

    @NonNull
    String createUnsupportedVersionMessage(@NonNull String method, @NonNull String versionRequirements) {
        return method + " requires " + versionRequirements + ".";
    }

    @Override
    @NonNull
    public PigeonApiWebResourceRequest getPigeonApiWebResourceRequest() {
        return new WebResourceRequestProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebResourceError getPigeonApiWebResourceError() {
        return new WebResourceErrorProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebResourceErrorCompat getPigeonApiWebResourceErrorCompat() {
        return new WebResourceErrorCompatProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebViewPoint getPigeonApiWebViewPoint() {
        return new WebViewPointProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiConsoleMessage getPigeonApiConsoleMessage() {
        return new ConsoleMessageProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiCookieManager getPigeonApiCookieManager() {
        return new CookieManagerProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebResourceResponse getPigeonApiWebResourceResponse() {
        return new WebResourceResponseProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebView getPigeonApiWebView() {
        return new WebViewProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebSettings getPigeonApiWebSettings() {
        return new WebSettingsProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiJavaScriptChannel getPigeonApiJavaScriptChannel() {
        return new JavaScriptChannelProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebViewClient getPigeonApiWebViewClient() {
        return new WebViewClientProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiDownloadListener getPigeonApiDownloadListener() {
        return new DownloadListenerProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebChromeClient getPigeonApiWebChromeClient() {
        return new WebChromeClientProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiFlutterAssetManager getPigeonApiFlutterAssetManager() {
        return new FlutterAssetManagerProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebStorage getPigeonApiWebStorage() {
        return new WebStorageProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiFileChooserParams getPigeonApiFileChooserParams() {
        return new FileChooserParamsProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiPermissionRequest getPigeonApiPermissionRequest() {
        return new PermissionRequestProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiCustomViewCallback getPigeonApiCustomViewCallback() {
        return new CustomViewCallbackProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiView getPigeonApiView() {
        return new ViewProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiGeolocationPermissionsCallback getPigeonApiGeolocationPermissionsCallback() {
        return new GeolocationPermissionsCallbackProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiHttpAuthHandler getPigeonApiHttpAuthHandler() {
        return new HttpAuthHandlerProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiClientCertRequest getPigeonApiClientCertRequest() {
        return new ClientCertRequestProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiSslErrorHandler getPigeonApiSslErrorHandler() {
        return new SslErrorHandlerProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiSslError getPigeonApiSslError() {
        return new SslErrorProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiSslCertificateDName getPigeonApiSslCertificateDName() {
        return new SslCertificateDNameProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiSslCertificate getPigeonApiSslCertificate() {
        return new SslCertificateProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiAndroidMessage getPigeonApiAndroidMessage() {
        return new MessageProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiCertificate getPigeonApiCertificate() {
        return new CertificateProxyApi(this);
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public void setContext(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    public FlutterAssetManager getFlutterAssetManager() {
        return this.flutterAssetManager;
    }

    @Override
    @NonNull
    public PigeonApiWebViewFeature getPigeonApiWebViewFeature() {
        return new WebViewFeatureProxyApi(this);
    }

    @Override
    @NonNull
    public PigeonApiWebSettingsCompat getPigeonApiWebSettingsCompat() {
        return new WebSettingsCompatProxyApi(this);
    }
}

