/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.net.http.SslCertificate;
import android.net.http.SslError;
import androidx.annotation.NonNull;
import io.flutter.plugins.webviewflutter.PigeonApiSslError;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import io.flutter.plugins.webviewflutter.SslErrorType;

class SslErrorProxyApi
extends PigeonApiSslError {
    SslErrorProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    @Override
    @NonNull
    public SslCertificate certificate(@NonNull SslError pigeon_instance) {
        return pigeon_instance.getCertificate();
    }

    @Override
    @NonNull
    public String url(@NonNull SslError pigeon_instance) {
        return pigeon_instance.getUrl();
    }

    @Override
    @NonNull
    public SslErrorType getPrimaryError(@NonNull SslError pigeon_instance) {
        switch (pigeon_instance.getPrimaryError()) {
            case 4: {
                return SslErrorType.DATE_INVALID;
            }
            case 1: {
                return SslErrorType.EXPIRED;
            }
            case 2: {
                return SslErrorType.ID_MISMATCH;
            }
            case 5: {
                return SslErrorType.INVALID;
            }
            case 0: {
                return SslErrorType.NOT_YET_VALID;
            }
            case 3: {
                return SslErrorType.UNTRUSTED;
            }
        }
        return SslErrorType.UNKNOWN;
    }

    @Override
    public boolean hasError(@NonNull SslError pigeon_instance, @NonNull SslErrorType error) {
        int nativeError = -1;
        switch (error) {
            case DATE_INVALID: {
                nativeError = 4;
                break;
            }
            case EXPIRED: {
                nativeError = 1;
                break;
            }
            case ID_MISMATCH: {
                nativeError = 2;
                break;
            }
            case INVALID: {
                nativeError = 5;
                break;
            }
            case NOT_YET_VALID: {
                nativeError = 0;
                break;
            }
            case UNTRUSTED: {
                nativeError = 3;
                break;
            }
            case UNKNOWN: {
                throw this.getPigeonRegistrar().createUnknownEnumException((Object)error);
            }
        }
        return pigeon_instance.hasError(nativeError);
    }
}

