/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.net.http.SslCertificate;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugins.webviewflutter.PigeonApiSslCertificate;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import java.security.cert.X509Certificate;
import java.util.Date;

class SslCertificateProxyApi
extends PigeonApiSslCertificate {
    SslCertificateProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    @Override
    @Nullable
    public SslCertificate.DName getIssuedBy(@NonNull SslCertificate pigeon_instance) {
        return pigeon_instance.getIssuedBy();
    }

    @Override
    @Nullable
    public SslCertificate.DName getIssuedTo(@NonNull SslCertificate pigeon_instance) {
        return pigeon_instance.getIssuedTo();
    }

    @Override
    @Nullable
    public Long getValidNotAfterMsSinceEpoch(@NonNull SslCertificate pigeon_instance) {
        Date date = pigeon_instance.getValidNotAfterDate();
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    @Override
    @Nullable
    public Long getValidNotBeforeMsSinceEpoch(@NonNull SslCertificate pigeon_instance) {
        Date date = pigeon_instance.getValidNotBeforeDate();
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    @Override
    @Nullable
    public X509Certificate getX509Certificate(@NonNull SslCertificate pigeon_instance) {
        if (this.getPigeonRegistrar().sdkIsAtLeast(29)) {
            return pigeon_instance.getX509Certificate();
        }
        Log.d((String)"SslCertificateProxyApi", (String)this.getPigeonRegistrar().createUnsupportedVersionMessage("SslCertificate.getX509Certificate", "Build.VERSION_CODES.Q"));
        return null;
    }
}

