/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.net.Uri;
import android.os.Message;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugins.webviewflutter.PigeonApiWebChromeClient;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import io.flutter.plugins.webviewflutter.ResultCompat;
import java.util.List;
import java.util.Objects;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class WebChromeClientProxyApi
extends PigeonApiWebChromeClient {
    public WebChromeClientProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public WebChromeClientImpl pigeon_defaultConstructor() {
        return new WebChromeClientImpl(this);
    }

    @Override
    public void setSynchronousReturnValueForOnShowFileChooser(@NonNull WebChromeClientImpl pigeon_instance, boolean value) {
        pigeon_instance.setReturnValueForOnShowFileChooser(value);
    }

    @Override
    public void setSynchronousReturnValueForOnConsoleMessage(@NonNull WebChromeClientImpl pigeon_instance, boolean value) {
        pigeon_instance.setReturnValueForOnConsoleMessage(value);
    }

    @Override
    public void setSynchronousReturnValueForOnJsAlert(@NonNull WebChromeClientImpl pigeon_instance, boolean value) {
        pigeon_instance.setReturnValueForOnJsAlert(value);
    }

    @Override
    public void setSynchronousReturnValueForOnJsConfirm(@NonNull WebChromeClientImpl pigeon_instance, boolean value) {
        pigeon_instance.setReturnValueForOnJsConfirm(value);
    }

    @Override
    public void setSynchronousReturnValueForOnJsPrompt(@NonNull WebChromeClientImpl pigeon_instance, boolean value) {
        pigeon_instance.setReturnValueForOnJsPrompt(value);
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    public static class WebChromeClientImpl
    extends SecureWebChromeClient {
        private static final String TAG = "WebChromeClientImpl";
        private final WebChromeClientProxyApi api;
        private boolean returnValueForOnShowFileChooser = false;
        private boolean returnValueForOnConsoleMessage = false;
        private boolean returnValueForOnJsAlert = false;
        private boolean returnValueForOnJsConfirm = false;
        private boolean returnValueForOnJsPrompt = false;

        public WebChromeClientImpl(@NonNull WebChromeClientProxyApi api) {
            this.api = api;
        }

        public void onProgressChanged(@NonNull WebView view, int progress) {
            this.api.onProgressChanged(this, view, progress, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            this.api.onShowCustomView(this, view, callback, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public void onHideCustomView() {
            this.api.onHideCustomView(this, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public void onGeolocationPermissionsShowPrompt(@NonNull String origin, @NonNull GeolocationPermissions.Callback callback) {
            this.api.onGeolocationPermissionsShowPrompt(this, origin, callback, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public void onGeolocationPermissionsHidePrompt() {
            this.api.onGeolocationPermissionsHidePrompt(this, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public boolean onShowFileChooser(@NonNull WebView webView, @NonNull ValueCallback<Uri[]> filePathCallback, @NonNull WebChromeClient.FileChooserParams fileChooserParams) {
            boolean currentReturnValueForOnShowFileChooser = this.returnValueForOnShowFileChooser;
            this.api.onShowFileChooser(this, webView, fileChooserParams, ResultCompat.asCompatCallback(reply -> {
                if (reply.isFailure()) {
                    this.api.getPigeonRegistrar().logError(TAG, Objects.requireNonNull(reply.exceptionOrNull()));
                    return null;
                }
                List value = Objects.requireNonNull((List)reply.getOrNull());
                if (currentReturnValueForOnShowFileChooser) {
                    Uri[] filePaths = new Uri[value.size()];
                    for (int i = 0; i < value.size(); ++i) {
                        filePaths[i] = Uri.parse((String)((String)value.get(i)));
                    }
                    filePathCallback.onReceiveValue((Object)filePaths);
                }
                return null;
            }));
            return currentReturnValueForOnShowFileChooser;
        }

        public void onPermissionRequest(@NonNull PermissionRequest request) {
            this.api.onPermissionRequest(this, request, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            this.api.onConsoleMessage(this, consoleMessage, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null));
            return this.returnValueForOnConsoleMessage;
        }

        public void setReturnValueForOnShowFileChooser(boolean value) {
            this.returnValueForOnShowFileChooser = value;
        }

        public void setReturnValueForOnConsoleMessage(boolean value) {
            this.returnValueForOnConsoleMessage = value;
        }

        public void setReturnValueForOnJsAlert(boolean value) {
            this.returnValueForOnJsAlert = value;
        }

        public void setReturnValueForOnJsConfirm(boolean value) {
            this.returnValueForOnJsConfirm = value;
        }

        public void setReturnValueForOnJsPrompt(boolean value) {
            this.returnValueForOnJsPrompt = value;
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            if (this.returnValueForOnJsAlert) {
                this.api.onJsAlert(this, view, url, message, ResultCompat.asCompatCallback(reply -> {
                    if (reply.isFailure()) {
                        this.api.getPigeonRegistrar().logError(TAG, Objects.requireNonNull(reply.exceptionOrNull()));
                        return null;
                    }
                    result.confirm();
                    return null;
                }));
                return true;
            }
            return false;
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            if (this.returnValueForOnJsConfirm) {
                this.api.onJsConfirm(this, view, url, message, ResultCompat.asCompatCallback(reply -> {
                    if (reply.isFailure()) {
                        this.api.getPigeonRegistrar().logError(TAG, Objects.requireNonNull(reply.exceptionOrNull()));
                        return null;
                    }
                    if (Boolean.TRUE.equals(reply.getOrNull())) {
                        result.confirm();
                    } else {
                        result.cancel();
                    }
                    return null;
                }));
                return true;
            }
            return false;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            if (this.returnValueForOnJsPrompt) {
                this.api.onJsPrompt(this, view, url, message, defaultValue, ResultCompat.asCompatCallback(reply -> {
                    if (reply.isFailure()) {
                        this.api.getPigeonRegistrar().logError(TAG, Objects.requireNonNull(reply.exceptionOrNull()));
                        return null;
                    }
                    String inputMessage = (String)reply.getOrNull();
                    if (inputMessage != null) {
                        result.confirm(inputMessage);
                    } else {
                        result.cancel();
                    }
                    return null;
                }));
                return true;
            }
            return false;
        }
    }

    public static class SecureWebChromeClient
    extends WebChromeClient {
        @Nullable
        WebViewClient webViewClient;

        public boolean onCreateWindow(@NonNull WebView view, boolean isDialog, boolean isUserGesture, @NonNull Message resultMsg) {
            return this.onCreateWindow(view, resultMsg, new WebView(view.getContext()));
        }

        @VisibleForTesting
        boolean onCreateWindow(final @NonNull WebView view, @NonNull Message resultMsg, @Nullable WebView onCreateWindowWebView) {
            if (this.webViewClient == null) {
                return false;
            }
            WebViewClient windowWebViewClient = new WebViewClient(){

                public boolean shouldOverrideUrlLoading(@NonNull WebView windowWebView, @NonNull WebResourceRequest request) {
                    if (!webViewClient.shouldOverrideUrlLoading(view, request)) {
                        view.loadUrl(request.getUrl().toString());
                    }
                    return true;
                }
            };
            if (onCreateWindowWebView == null) {
                onCreateWindowWebView = new WebView(view.getContext());
            }
            onCreateWindowWebView.setWebViewClient(windowWebViewClient);
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(onCreateWindowWebView);
            resultMsg.sendToTarget();
            return true;
        }

        public void setWebViewClient(@NonNull WebViewClient webViewClient) {
            this.webViewClient = webViewClient;
        }
    }
}

