/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugins.webviewflutter.PigeonApiWebViewClient;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class WebViewClientProxyApi
extends PigeonApiWebViewClient {
    public WebViewClientProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public WebViewClient pigeon_defaultConstructor() {
        return new WebViewClientImpl(this);
    }

    @Override
    public void setSynchronousReturnValueForShouldOverrideUrlLoading(@NonNull WebViewClient pigeon_instance, boolean value) {
        if (!(pigeon_instance instanceof WebViewClientImpl)) {
            throw new IllegalStateException("This WebViewClient doesn't support setting the returnValueForShouldOverrideUrlLoading.");
        }
        ((WebViewClientImpl)pigeon_instance).setReturnValueForShouldOverrideUrlLoading(value);
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    public static class WebViewClientImpl
    extends WebViewClient {
        private final WebViewClientProxyApi api;
        private boolean returnValueForShouldOverrideUrlLoading = false;

        public WebViewClientImpl(@NonNull WebViewClientProxyApi api) {
            this.api = api;
        }

        public void onPageStarted(@NonNull WebView view, @NonNull String url, @NonNull Bitmap favicon) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageStarted(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onPageFinished(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageFinished(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceResponse response) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpError(this, view, request, response, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedRequestError(this, view, request, error, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.requestLoading(this, view, request, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
            return request.isForMainFrame() && this.returnValueForShouldOverrideUrlLoading;
        }

        public void doUpdateVisitedHistory(@NonNull WebView view, @NonNull String url, boolean isReload) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.doUpdateVisitedHistory(this, view, url, isReload, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpAuthRequest(@NonNull WebView view, @NonNull HttpAuthHandler handler, @NonNull String host, @NonNull String realm) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpAuthRequest(this, view, handler, host, realm, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onFormResubmission(@NonNull WebView view, @NonNull Message dontResend, @NonNull Message resend) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onFormResubmission(this, view, dontResend, resend, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onLoadResource(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onLoadResource(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onPageCommitVisible(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageCommitVisible(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedClientCertRequest(@NonNull WebView view, @NonNull ClientCertRequest request) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedClientCertRequest(this, view, request, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedLoginRequest(@NonNull WebView view, @NonNull String realm, @Nullable String account, @NonNull String args) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedLoginRequest(this, view, realm, account, args, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedSslError(@NonNull WebView view, @NonNull SslErrorHandler handler, @NonNull SslError error) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedSslError(this, view, handler, error, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onScaleChanged(@NonNull WebView view, float oldScale, float newScale) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onScaleChanged(this, view, oldScale, newScale, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onUnhandledKeyEvent(@NonNull WebView view, @NonNull KeyEvent event) {
        }

        public void setReturnValueForShouldOverrideUrlLoading(boolean value) {
            this.returnValueForShouldOverrideUrlLoading = value;
        }
    }
}

