/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.annotation.SuppressLint;
import android.hardware.display.DisplayManager;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.android.FlutterView;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugins.webviewflutter.DisplayListenerProxy;
import io.flutter.plugins.webviewflutter.JavaScriptChannel;
import io.flutter.plugins.webviewflutter.PigeonApiWebView;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import io.flutter.plugins.webviewflutter.ResultCompat;
import io.flutter.plugins.webviewflutter.WebChromeClientProxyApi;
import java.util.Map;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class WebViewProxyApi
extends PigeonApiWebView {
    public WebViewProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public WebView pigeon_defaultConstructor() {
        DisplayListenerProxy displayListenerProxy = new DisplayListenerProxy();
        DisplayManager displayManager = (DisplayManager)this.getPigeonRegistrar().getContext().getSystemService("display");
        displayListenerProxy.onPreWebViewInitialization(displayManager);
        WebViewPlatformView webView = new WebViewPlatformView(this);
        displayListenerProxy.onPostWebViewInitialization(displayManager);
        return webView;
    }

    @Override
    @NonNull
    public WebSettings settings(@NonNull WebView pigeon_instance) {
        return pigeon_instance.getSettings();
    }

    @Override
    public void loadData(@NonNull WebView pigeon_instance, @NonNull String data, @Nullable String mimeType, @Nullable String encoding) {
        pigeon_instance.loadData(data, mimeType, encoding);
    }

    @Override
    public void loadDataWithBaseUrl(@NonNull WebView pigeon_instance, @Nullable String baseUrl, @NonNull String data, @Nullable String mimeType, @Nullable String encoding, @Nullable String historyUrl) {
        pigeon_instance.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    @Override
    public void loadUrl(@NonNull WebView pigeon_instance, @NonNull String url, @NonNull Map<String, String> headers) {
        pigeon_instance.loadUrl(url, headers);
    }

    @Override
    public void postUrl(@NonNull WebView pigeon_instance, @NonNull String url, @NonNull byte[] data) {
        pigeon_instance.postUrl(url, data);
    }

    @Override
    @Nullable
    public String getUrl(@NonNull WebView pigeon_instance) {
        return pigeon_instance.getUrl();
    }

    @Override
    public boolean canGoBack(@NonNull WebView pigeon_instance) {
        return pigeon_instance.canGoBack();
    }

    @Override
    public boolean canGoForward(@NonNull WebView pigeon_instance) {
        return pigeon_instance.canGoForward();
    }

    @Override
    public void goBack(@NonNull WebView pigeon_instance) {
        pigeon_instance.goBack();
    }

    @Override
    public void goForward(@NonNull WebView pigeon_instance) {
        pigeon_instance.goForward();
    }

    @Override
    public void reload(@NonNull WebView pigeon_instance) {
        pigeon_instance.reload();
    }

    @Override
    public void clearCache(@NonNull WebView pigeon_instance, boolean includeDiskFiles) {
        pigeon_instance.clearCache(includeDiskFiles);
    }

    @Override
    public void evaluateJavascript(@NonNull WebView pigeon_instance, @NonNull String javascriptString, @NonNull Function1<? super Result<String>, Unit> callback) {
        pigeon_instance.evaluateJavascript(javascriptString, result -> ResultCompat.success(result, callback));
    }

    @Override
    @Nullable
    public String getTitle(@NonNull WebView pigeon_instance) {
        return pigeon_instance.getTitle();
    }

    @Override
    public void setWebContentsDebuggingEnabled(boolean enabled) {
        WebView.setWebContentsDebuggingEnabled((boolean)enabled);
    }

    @Override
    public void setWebViewClient(@NonNull WebView pigeon_instance, @Nullable WebViewClient client) {
        pigeon_instance.setWebViewClient(client);
    }

    @Override
    @SuppressLint(value={"JavascriptInterface"})
    public void addJavaScriptChannel(@NonNull WebView pigeon_instance, @NonNull JavaScriptChannel channel) {
        pigeon_instance.addJavascriptInterface((Object)channel, channel.javaScriptChannelName);
    }

    @Override
    public void removeJavaScriptChannel(@NonNull WebView pigeon_instance, @NonNull String channel) {
        pigeon_instance.removeJavascriptInterface(channel);
    }

    @Override
    public void setDownloadListener(@NonNull WebView pigeon_instance, @Nullable DownloadListener listener) {
        pigeon_instance.setDownloadListener(listener);
    }

    @Override
    public void setWebChromeClient(@NonNull WebView pigeon_instance, @Nullable WebChromeClientProxyApi.WebChromeClientImpl client) {
        pigeon_instance.setWebChromeClient((WebChromeClient)client);
    }

    @Override
    public void setBackgroundColor(@NonNull WebView pigeon_instance, long color) {
        pigeon_instance.setBackgroundColor((int)color);
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    @Override
    public void destroy(@NonNull WebView pigeon_instance) {
        pigeon_instance.destroy();
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class WebViewPlatformView
    extends WebView
    implements PlatformView {
        private final WebViewProxyApi api;
        private WebViewClient currentWebViewClient;
        private WebChromeClientProxyApi.SecureWebChromeClient currentWebChromeClient;

        WebViewPlatformView(@NonNull WebViewProxyApi api) {
            super(api.getPigeonRegistrar().getContext());
            this.api = api;
            this.currentWebViewClient = new WebViewClient();
            this.currentWebChromeClient = new WebChromeClientProxyApi.SecureWebChromeClient();
            this.setWebViewClient(this.currentWebViewClient);
            this.setWebChromeClient(this.currentWebChromeClient);
        }

        @Nullable
        public View getView() {
            return this;
        }

        public void dispose() {
        }

        protected void onAttachedToWindow() {
            FlutterView flutterView;
            super.onAttachedToWindow();
            if (this.api.getPigeonRegistrar().sdkIsAtLeast(26) && (flutterView = this.tryFindFlutterView()) != null) {
                flutterView.setImportantForAutofill(1);
            }
        }

        private FlutterView tryFindFlutterView() {
            WebViewPlatformView currentView = this;
            while (currentView.getParent() != null) {
                if (!((currentView = currentView.getParent()) instanceof FlutterView)) continue;
                return (FlutterView)currentView;
            }
            return null;
        }

        public void setWebViewClient(@NonNull WebViewClient webViewClient) {
            super.setWebViewClient(webViewClient);
            this.currentWebViewClient = webViewClient;
            this.currentWebChromeClient.setWebViewClient(webViewClient);
        }

        public void setWebChromeClient(@Nullable WebChromeClient client) {
            super.setWebChromeClient(client);
            if (!(client instanceof WebChromeClientProxyApi.SecureWebChromeClient)) {
                throw new AssertionError((Object)"Client must be a SecureWebChromeClient.");
            }
            this.currentWebChromeClient = (WebChromeClientProxyApi.SecureWebChromeClient)client;
            this.currentWebChromeClient.setWebViewClient(this.currentWebViewClient);
        }

        @Nullable
        public WebChromeClient getWebChromeClient() {
            return this.currentWebChromeClient;
        }

        protected void onScrollChanged(int left, int top, int oldLeft, int oldTop) {
            super.onScrollChanged(left, top, oldLeft, oldTop);
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onScrollChanged(this, left, top, oldLeft, oldTop, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }
    }
}

