/*
 * Decompiled with CFR 0.152.
 */
package com.ryanheise.audio_session;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MicrophoneInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioFocusRequestCompat;
import androidx.media.AudioManagerCompat;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidAudioManager
implements MethodChannel.MethodCallHandler {
    private static Singleton singleton;
    BinaryMessenger messenger;
    MethodChannel channel;

    public AndroidAudioManager(@NonNull Context applicationContext, @NonNull BinaryMessenger messenger) {
        if (singleton == null) {
            singleton = new Singleton(applicationContext);
        }
        this.messenger = messenger;
        this.channel = new MethodChannel(messenger, "com.ryanheise.android_audio_manager");
        singleton.add(this);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        try {
            List args = (List)call.arguments;
            switch (call.method) {
                case "requestAudioFocus": {
                    result.success((Object)singleton.requestAudioFocus(args));
                    break;
                }
                case "abandonAudioFocus": {
                    result.success((Object)singleton.abandonAudioFocus());
                    break;
                }
                case "dispatchMediaKeyEvent": {
                    result.success(singleton.dispatchMediaKeyEvent((Map)args.get(0)));
                    break;
                }
                case "isVolumeFixed": {
                    result.success(singleton.isVolumeFixed());
                    break;
                }
                case "adjustStreamVolume": {
                    result.success(singleton.adjustStreamVolume((Integer)args.get(0), (Integer)args.get(1), (Integer)args.get(2)));
                    break;
                }
                case "adjustVolume": {
                    result.success(singleton.adjustVolume((Integer)args.get(0), (Integer)args.get(1)));
                    break;
                }
                case "adjustSuggestedStreamVolume": {
                    result.success(singleton.adjustSuggestedStreamVolume((Integer)args.get(0), (Integer)args.get(1), (Integer)args.get(2)));
                    break;
                }
                case "getRingerMode": {
                    result.success(singleton.getRingerMode());
                    break;
                }
                case "getStreamMaxVolume": {
                    result.success(singleton.getStreamMaxVolume((Integer)args.get(0)));
                    break;
                }
                case "getStreamMinVolume": {
                    result.success(singleton.getStreamMinVolume((Integer)args.get(0)));
                    break;
                }
                case "getStreamVolume": {
                    result.success(singleton.getStreamVolume((Integer)args.get(0)));
                    break;
                }
                case "getStreamVolumeDb": {
                    result.success(singleton.getStreamVolumeDb((Integer)args.get(0), (Integer)args.get(1), (Integer)args.get(2)));
                    break;
                }
                case "setRingerMode": {
                    result.success(singleton.setRingerMode((Integer)args.get(0)));
                    break;
                }
                case "setStreamVolume": {
                    result.success(singleton.setStreamVolume((Integer)args.get(0), (Integer)args.get(1), (Integer)args.get(2)));
                    break;
                }
                case "isStreamMute": {
                    result.success(singleton.isStreamMute((Integer)args.get(0)));
                    break;
                }
                case "getAvailableCommunicationDevices": {
                    result.success(singleton.getAvailableCommunicationDevices());
                    break;
                }
                case "setCommunicationDevice": {
                    result.success((Object)singleton.setCommunicationDevice((Integer)args.get(0)));
                    break;
                }
                case "getCommunicationDevice": {
                    result.success(singleton.getCommunicationDevice());
                    break;
                }
                case "clearCommunicationDevice": {
                    result.success(singleton.clearCommunicationDevice());
                    break;
                }
                case "setSpeakerphoneOn": {
                    result.success(singleton.setSpeakerphoneOn((Boolean)args.get(0)));
                    break;
                }
                case "isSpeakerphoneOn": {
                    result.success(singleton.isSpeakerphoneOn());
                    break;
                }
                case "setAllowedCapturePolicy": {
                    result.success(singleton.setAllowedCapturePolicy((Integer)args.get(0)));
                    break;
                }
                case "getAllowedCapturePolicy": {
                    result.success(singleton.getAllowedCapturePolicy());
                    break;
                }
                case "isBluetoothScoAvailableOffCall": {
                    result.success(singleton.isBluetoothScoAvailableOffCall());
                    break;
                }
                case "startBluetoothSco": {
                    result.success(singleton.startBluetoothSco());
                    break;
                }
                case "stopBluetoothSco": {
                    result.success(singleton.stopBluetoothSco());
                    break;
                }
                case "setBluetoothScoOn": {
                    result.success(singleton.setBluetoothScoOn((Boolean)args.get(0)));
                    break;
                }
                case "isBluetoothScoOn": {
                    result.success(singleton.isBluetoothScoOn());
                    break;
                }
                case "setMicrophoneMute": {
                    result.success(singleton.setMicrophoneMute((Boolean)args.get(0)));
                    break;
                }
                case "isMicrophoneMute": {
                    result.success(singleton.isMicrophoneMute());
                    break;
                }
                case "setMode": {
                    result.success(singleton.setMode((Integer)args.get(0)));
                    break;
                }
                case "getMode": {
                    result.success(singleton.getMode());
                    break;
                }
                case "isMusicActive": {
                    result.success(singleton.isMusicActive());
                    break;
                }
                case "generateAudioSessionId": {
                    result.success(singleton.generateAudioSessionId());
                    break;
                }
                case "setParameters": {
                    result.success(singleton.setParameters((String)args.get(0)));
                    break;
                }
                case "getParameters": {
                    result.success(singleton.getParameters((String)args.get(0)));
                    break;
                }
                case "playSoundEffect": {
                    result.success(singleton.playSoundEffect((Integer)args.get(0), (Double)args.get(1)));
                    break;
                }
                case "loadSoundEffects": {
                    result.success(singleton.loadSoundEffects());
                    break;
                }
                case "unloadSoundEffects": {
                    result.success(singleton.unloadSoundEffects());
                    break;
                }
                case "getProperty": {
                    result.success(singleton.getProperty((String)args.get(0)));
                    break;
                }
                case "getDevices": {
                    result.success(singleton.getDevices((Integer)args.get(0)));
                    break;
                }
                case "getMicrophones": {
                    result.success(singleton.getMicrophones());
                    break;
                }
                case "isHapticPlaybackSupported": {
                    result.success(singleton.isHapticPlaybackSupported());
                    break;
                }
                default: {
                    result.notImplemented();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.error("Error: " + e, null, null);
        }
    }

    public void dispose() {
        this.channel.setMethodCallHandler(null);
        singleton.remove(this);
        if (singleton.isEmpty()) {
            singleton.dispose();
            singleton = null;
        }
        this.channel = null;
        this.messenger = null;
    }

    static void requireApi(int level) {
        if (Build.VERSION.SDK_INT < level) {
            throw new RuntimeException("Requires API level " + level);
        }
    }

    static Map<String, Object> mapOf(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put((String)args[i], args[i + 1]);
        }
        return map;
    }

    static ArrayList<Integer> intArrayToList(int[] a) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < a.length; ++i) {
            list.add(a[i]);
        }
        return list;
    }

    static ArrayList<Double> doubleArrayToList(double[] a) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < a.length; ++i) {
            list.add(a[i]);
        }
        return list;
    }

    @TargetApi(value=28)
    static ArrayList<Double> coordinate3fToList(MicrophoneInfo.Coordinate3F coordinate) {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(Double.valueOf(coordinate.x));
        list.add(Double.valueOf(coordinate.y));
        list.add(Double.valueOf(coordinate.z));
        return list;
    }

    static Long getLong(Object o) {
        return o == null || o instanceof Long ? (Long)o : Long.valueOf(((Integer)o).intValue());
    }

    @TargetApi(value=23)
    @NonNull
    public static List<?> encodeAudioDevices(@NonNull AudioDeviceInfo[] devices) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (AudioDeviceInfo device : devices) {
            result.add(AndroidAudioManager.encodeAudioDevice(device));
        }
        return result;
    }

    @TargetApi(value=23)
    @NonNull
    public static Map<String, Object> encodeAudioDevice(@NonNull AudioDeviceInfo device) {
        String address = null;
        if (Build.VERSION.SDK_INT >= 28) {
            address = device.getAddress();
        }
        return AndroidAudioManager.mapOf("id", device.getId(), "productName", device.getProductName(), "address", address, "isSource", device.isSource(), "isSink", device.isSink(), "sampleRates", device.getSampleRates(), "channelMasks", device.getChannelMasks(), "channelIndexMasks", device.getChannelIndexMasks(), "channelCounts", device.getChannelCounts(), "encodings", device.getEncodings(), "type", device.getType());
    }

    private static class Singleton {
        private final Handler handler = new Handler(Looper.getMainLooper());
        private List<AndroidAudioManager> instances = new ArrayList<AndroidAudioManager>();
        private AudioFocusRequestCompat audioFocusRequest;
        private BroadcastReceiver noisyReceiver;
        private BroadcastReceiver scoReceiver;
        private Context applicationContext;
        private AudioManager audioManager;
        private Object audioDeviceCallback;
        private List<AudioDeviceInfo> devices = new ArrayList<AudioDeviceInfo>();

        public Singleton(Context applicationContext) {
            this.applicationContext = applicationContext;
            this.audioManager = (AudioManager)applicationContext.getSystemService("audio");
            if (Build.VERSION.SDK_INT >= 23) {
                this.initAudioDeviceCallback();
            }
        }

        @TargetApi(value=23)
        private void initAudioDeviceCallback() {
            this.audioDeviceCallback = new AudioDeviceCallback(){

                public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                    this.invokeMethod("onAudioDevicesAdded", AndroidAudioManager.encodeAudioDevices(addedDevices));
                }

                public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                    this.invokeMethod("onAudioDevicesRemoved", AndroidAudioManager.encodeAudioDevices(removedDevices));
                }
            };
            this.audioManager.registerAudioDeviceCallback((AudioDeviceCallback)this.audioDeviceCallback, this.handler);
        }

        public void add(AndroidAudioManager manager) {
            this.instances.add(manager);
        }

        public void remove(AndroidAudioManager manager) {
            this.instances.remove(manager);
        }

        public boolean isEmpty() {
            return this.instances.size() == 0;
        }

        public boolean requestAudioFocus(List<?> args) {
            boolean success;
            if (this.audioFocusRequest != null) {
                return true;
            }
            Map request = (Map)args.get(0);
            AudioFocusRequestCompat.Builder builder = new AudioFocusRequestCompat.Builder(((Integer)request.get("gainType")).intValue());
            builder.setOnAudioFocusChangeListener(focusChange -> {
                if (focusChange == -1) {
                    this.abandonAudioFocus();
                }
                this.invokeMethod("onAudioFocusChanged", focusChange);
            });
            if (request.get("audioAttributes") != null) {
                builder.setAudioAttributes(this.decodeAudioAttributes((Map)request.get("audioAttributes")));
            }
            if (request.get("willPauseWhenDucked") != null) {
                builder.setWillPauseWhenDucked(((Boolean)request.get("willPauseWhenDucked")).booleanValue());
            }
            this.audioFocusRequest = builder.build();
            int status = AudioManagerCompat.requestAudioFocus((AudioManager)this.audioManager, (AudioFocusRequestCompat)this.audioFocusRequest);
            boolean bl = success = status == 1;
            if (success) {
                this.registerNoisyReceiver();
                this.registerScoReceiver();
            }
            return success;
        }

        public boolean abandonAudioFocus() {
            if (this.applicationContext == null) {
                return false;
            }
            this.unregisterNoisyReceiver();
            this.unregisterScoReceiver();
            if (this.audioFocusRequest == null) {
                return true;
            }
            int status = AudioManagerCompat.abandonAudioFocusRequest((AudioManager)this.audioManager, (AudioFocusRequestCompat)this.audioFocusRequest);
            this.audioFocusRequest = null;
            return status == 1;
        }

        public Object dispatchMediaKeyEvent(Map<?, ?> rawKeyEvent) {
            KeyEvent keyEvent = new KeyEvent(AndroidAudioManager.getLong(rawKeyEvent.get("downTime")).longValue(), AndroidAudioManager.getLong(rawKeyEvent.get("eventTime")).longValue(), ((Integer)rawKeyEvent.get("action")).intValue(), ((Integer)rawKeyEvent.get("keyCode")).intValue(), ((Integer)rawKeyEvent.get("repeatCount")).intValue(), ((Integer)rawKeyEvent.get("metaState")).intValue(), ((Integer)rawKeyEvent.get("deviceId")).intValue(), ((Integer)rawKeyEvent.get("scanCode")).intValue(), ((Integer)rawKeyEvent.get("flags")).intValue(), ((Integer)rawKeyEvent.get("source")).intValue());
            this.audioManager.dispatchMediaKeyEvent(keyEvent);
            return null;
        }

        @TargetApi(value=21)
        public Object isVolumeFixed() {
            AndroidAudioManager.requireApi(21);
            return this.audioManager.isVolumeFixed();
        }

        public Object adjustStreamVolume(int streamType, int direction, int flags) {
            this.audioManager.adjustStreamVolume(streamType, direction, flags);
            return null;
        }

        public Object adjustVolume(int direction, int flags) {
            this.audioManager.adjustVolume(direction, flags);
            return null;
        }

        public Object adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
            this.audioManager.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags);
            return null;
        }

        public Object getRingerMode() {
            return this.audioManager.getRingerMode();
        }

        public Object getStreamMaxVolume(int streamType) {
            return this.audioManager.getStreamMaxVolume(streamType);
        }

        @TargetApi(value=28)
        public Object getStreamMinVolume(int streamType) {
            AndroidAudioManager.requireApi(28);
            return this.audioManager.getStreamMinVolume(streamType);
        }

        public Object getStreamVolume(int streamType) {
            return this.audioManager.getStreamVolume(streamType);
        }

        @TargetApi(value=28)
        public Object getStreamVolumeDb(int streamType, int index, int deviceType) {
            AndroidAudioManager.requireApi(28);
            return Float.valueOf(this.audioManager.getStreamVolumeDb(streamType, index, deviceType));
        }

        public Object setRingerMode(int ringerMode) {
            this.audioManager.setRingerMode(ringerMode);
            return null;
        }

        public Object setStreamVolume(int streamType, int index, int flags) {
            this.audioManager.setStreamVolume(streamType, index, flags);
            return null;
        }

        @TargetApi(value=23)
        public Object isStreamMute(int streamType) {
            AndroidAudioManager.requireApi(23);
            return this.audioManager.isStreamMute(streamType);
        }

        @TargetApi(value=31)
        public List<Map<String, Object>> getAvailableCommunicationDevices() {
            AndroidAudioManager.requireApi(31);
            this.devices = this.audioManager.getAvailableCommunicationDevices();
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (AudioDeviceInfo device : this.devices) {
                result.add(AndroidAudioManager.encodeAudioDevice(device));
            }
            return result;
        }

        @TargetApi(value=31)
        public boolean setCommunicationDevice(Integer deviceId) {
            AndroidAudioManager.requireApi(31);
            for (AudioDeviceInfo device : this.devices) {
                if (device.getId() != deviceId.intValue()) continue;
                return this.audioManager.setCommunicationDevice(device);
            }
            return false;
        }

        @TargetApi(value=31)
        public Map<String, Object> getCommunicationDevice() {
            AndroidAudioManager.requireApi(31);
            return AndroidAudioManager.encodeAudioDevice(this.audioManager.getCommunicationDevice());
        }

        @TargetApi(value=31)
        public Object clearCommunicationDevice() {
            AndroidAudioManager.requireApi(31);
            this.audioManager.clearCommunicationDevice();
            return null;
        }

        public Object setSpeakerphoneOn(boolean enabled) {
            this.audioManager.setSpeakerphoneOn(enabled);
            return null;
        }

        public Object isSpeakerphoneOn() {
            return this.audioManager.isSpeakerphoneOn();
        }

        @TargetApi(value=29)
        public Object setAllowedCapturePolicy(int capturePolicy) {
            AndroidAudioManager.requireApi(29);
            this.audioManager.setAllowedCapturePolicy(capturePolicy);
            return null;
        }

        @TargetApi(value=29)
        public Object getAllowedCapturePolicy() {
            AndroidAudioManager.requireApi(29);
            return this.audioManager.getAllowedCapturePolicy();
        }

        public Object isBluetoothScoAvailableOffCall() {
            return this.audioManager.isBluetoothScoAvailableOffCall();
        }

        public Object startBluetoothSco() {
            this.audioManager.startBluetoothSco();
            return null;
        }

        public Object stopBluetoothSco() {
            this.audioManager.stopBluetoothSco();
            return null;
        }

        public Object setBluetoothScoOn(boolean enabled) {
            this.audioManager.setBluetoothScoOn(enabled);
            return null;
        }

        public Object isBluetoothScoOn() {
            return this.audioManager.isBluetoothScoOn();
        }

        public Object setMicrophoneMute(boolean enabled) {
            this.audioManager.setMicrophoneMute(enabled);
            return null;
        }

        public Object isMicrophoneMute() {
            return this.audioManager.isMicrophoneMute();
        }

        public Object setMode(int mode) {
            this.audioManager.setMode(mode);
            return null;
        }

        public Object getMode() {
            return this.audioManager.getMode();
        }

        public Object isMusicActive() {
            return this.audioManager.isMusicActive();
        }

        @TargetApi(value=21)
        public Object generateAudioSessionId() {
            AndroidAudioManager.requireApi(21);
            return this.audioManager.generateAudioSessionId();
        }

        public Object setParameters(String parameters) {
            this.audioManager.setParameters(parameters);
            return null;
        }

        public Object getParameters(String keys) {
            return this.audioManager.getParameters(keys);
        }

        public Object playSoundEffect(int effectType, Double volume) {
            if (volume != null) {
                this.audioManager.playSoundEffect(effectType, (float)volume.doubleValue());
            } else {
                this.audioManager.playSoundEffect(effectType);
            }
            return null;
        }

        public Object loadSoundEffects() {
            this.audioManager.loadSoundEffects();
            return null;
        }

        public Object unloadSoundEffects() {
            this.audioManager.unloadSoundEffects();
            return null;
        }

        public Object getProperty(String arg) {
            return this.audioManager.getProperty(arg);
        }

        @TargetApi(value=23)
        public Object getDevices(int flags) {
            AndroidAudioManager.requireApi(23);
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            AudioDeviceInfo[] devices = this.audioManager.getDevices(flags);
            for (int i = 0; i < devices.length; ++i) {
                AudioDeviceInfo device = devices[i];
                String address = null;
                if (Build.VERSION.SDK_INT >= 28) {
                    address = device.getAddress();
                }
                result.add(AndroidAudioManager.mapOf("id", device.getId(), "productName", device.getProductName(), "address", address, "isSource", device.isSource(), "isSink", device.isSink(), "sampleRates", AndroidAudioManager.intArrayToList(device.getSampleRates()), "channelMasks", AndroidAudioManager.intArrayToList(device.getChannelMasks()), "channelIndexMasks", AndroidAudioManager.intArrayToList(device.getChannelIndexMasks()), "channelCounts", AndroidAudioManager.intArrayToList(device.getChannelCounts()), "encodings", AndroidAudioManager.intArrayToList(device.getEncodings()), "type", device.getType()));
            }
            return result;
        }

        @TargetApi(value=28)
        public Object getMicrophones() throws IOException {
            AndroidAudioManager.requireApi(28);
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            List microphones = this.audioManager.getMicrophones();
            for (MicrophoneInfo microphone : microphones) {
                ArrayList<ArrayList<Double>> frequencyResponse = new ArrayList<ArrayList<Double>>();
                for (Pair pair : microphone.getFrequencyResponse()) {
                    frequencyResponse.add(new ArrayList<Double>(Arrays.asList(((Float)pair.first).floatValue(), ((Float)pair.second).floatValue())));
                }
                ArrayList<ArrayList<Integer>> channelMapping = new ArrayList<ArrayList<Integer>>();
                for (Pair pair : microphone.getChannelMapping()) {
                    channelMapping.add(new ArrayList<Integer>(Arrays.asList((Integer)pair.first, (Integer)pair.second)));
                }
                result.add(AndroidAudioManager.mapOf("description", microphone.getDescription(), "id", microphone.getId(), "type", microphone.getType(), "address", microphone.getAddress(), "location", microphone.getLocation(), "group", microphone.getGroup(), "indexInTheGroup", microphone.getIndexInTheGroup(), "position", AndroidAudioManager.coordinate3fToList(microphone.getPosition()), "orientation", AndroidAudioManager.coordinate3fToList(microphone.getOrientation()), "frequencyResponse", frequencyResponse, "channelMapping", channelMapping, "sensitivity", Float.valueOf(microphone.getSensitivity()), "maxSpl", Float.valueOf(microphone.getMaxSpl()), "minSpl", Float.valueOf(microphone.getMinSpl()), "directionality", microphone.getDirectionality()));
            }
            return result;
        }

        @TargetApi(value=29)
        public Object isHapticPlaybackSupported() {
            AndroidAudioManager.requireApi(29);
            return AudioManager.isHapticPlaybackSupported();
        }

        private void registerNoisyReceiver() {
            if (this.noisyReceiver != null) {
                return;
            }
            this.noisyReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if ("android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                        this.invokeMethod("onBecomingNoisy", new Object[0]);
                    }
                }
            };
            ContextCompat.registerReceiver((Context)this.applicationContext, (BroadcastReceiver)this.noisyReceiver, (IntentFilter)new IntentFilter("android.media.AUDIO_BECOMING_NOISY"), (int)2);
        }

        private void unregisterNoisyReceiver() {
            if (this.noisyReceiver == null || this.applicationContext == null) {
                return;
            }
            this.applicationContext.unregisterReceiver(this.noisyReceiver);
            this.noisyReceiver = null;
        }

        private void registerScoReceiver() {
            if (this.scoReceiver != null) {
                return;
            }
            this.scoReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    this.invokeMethod("onScoAudioStateUpdated", intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1), intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -1));
                }
            };
            ContextCompat.registerReceiver((Context)this.applicationContext, (BroadcastReceiver)this.scoReceiver, (IntentFilter)new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"), (int)2);
        }

        private void unregisterScoReceiver() {
            if (this.scoReceiver == null || this.applicationContext == null) {
                return;
            }
            this.applicationContext.unregisterReceiver(this.scoReceiver);
            this.scoReceiver = null;
        }

        private AudioAttributesCompat decodeAudioAttributes(Map<?, ?> attributes) {
            AudioAttributesCompat.Builder builder = new AudioAttributesCompat.Builder();
            if (attributes.get("contentType") != null) {
                builder.setContentType(((Integer)attributes.get("contentType")).intValue());
            }
            if (attributes.get("flags") != null) {
                builder.setFlags(((Integer)attributes.get("flags")).intValue());
            }
            if (attributes.get("usage") != null) {
                builder.setUsage(((Integer)attributes.get("usage")).intValue());
            }
            return builder.build();
        }

        public void invokeMethod(String method, Object ... args) {
            for (AndroidAudioManager instance : this.instances) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(args));
                instance.channel.invokeMethod(method, list);
            }
        }

        public void dispose() {
            this.abandonAudioFocus();
            if (Build.VERSION.SDK_INT >= 23) {
                this.disposeAudioDeviceCallback();
            }
            this.applicationContext = null;
            this.audioManager = null;
        }

        @TargetApi(value=23)
        private void disposeAudioDeviceCallback() {
            this.audioManager.unregisterAudioDeviceCallback((AudioDeviceCallback)this.audioDeviceCallback);
        }
    }
}

