/*
 * Decompiled with CFR 0.152.
 */
package com.ryanheise.audio_session;

import androidx.annotation.NonNull;
import com.ryanheise.audio_session.AndroidAudioManager;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AudioSessionPlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    private static Map<?, ?> configuration;
    private static List<AudioSessionPlugin> instances;
    private MethodChannel channel;
    private AndroidAudioManager androidAudioManager;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding flutterPluginBinding) {
        BinaryMessenger messenger = flutterPluginBinding.getBinaryMessenger();
        this.channel = new MethodChannel(messenger, "com.ryanheise.audio_session");
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.androidAudioManager = new AndroidAudioManager(flutterPluginBinding.getApplicationContext(), messenger);
        instances.add(this);
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
        this.androidAudioManager.dispose();
        this.androidAudioManager = null;
        instances.remove(this);
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        List args = (List)call.arguments;
        switch (call.method) {
            case "setConfiguration": {
                configuration = (Map)args.get(0);
                result.success(null);
                this.invokeMethod("onConfigurationChanged", configuration);
                break;
            }
            case "getConfiguration": {
                result.success(configuration);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void invokeMethod(String method, Object ... args) {
        for (AudioSessionPlugin instance : instances) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(args));
            instance.channel.invokeMethod(method, list);
        }
    }

    static {
        instances = new ArrayList<AudioSessionPlugin>();
    }
}

