/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.source;

import android.media.MediaPlayer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.player.SoundPoolPlayer;
import xyz.luan.audioplayers.source.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u000fH\u0002J\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lxyz/luan/audioplayers/source/UrlSource;", "Lxyz/luan/audioplayers/source/Source;", "url", "", "isLocal", "", "(Ljava/lang/String;Z)V", "()Z", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "downloadUrl", "", "Ljava/net/URL;", "equals", "other", "", "getAudioPathForSoundPool", "hashCode", "", "loadTempFileFromNetwork", "Ljava/io/File;", "setForMediaPlayer", "", "mediaPlayer", "Landroid/media/MediaPlayer;", "setForSoundPool", "soundPoolPlayer", "Lxyz/luan/audioplayers/player/SoundPoolPlayer;", "toString", "audioplayers_android_release"})
@SourceDebugExtension(value={"SMAP\nUrlSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlSource.kt\nxyz/luan/audioplayers/source/UrlSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class UrlSource
implements Source {
    @NotNull
    private final String url;
    private final boolean isLocal;

    public UrlSource(@NotNull String url, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.isLocal = isLocal;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public void setForMediaPlayer(@NotNull MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)mediaPlayer, (String)"mediaPlayer");
        mediaPlayer.setDataSource(this.url);
    }

    @Override
    public void setForSoundPool(@NotNull SoundPoolPlayer soundPoolPlayer) {
        Intrinsics.checkNotNullParameter((Object)soundPoolPlayer, (String)"soundPoolPlayer");
        soundPoolPlayer.release();
        soundPoolPlayer.setUrlSource(this);
    }

    @NotNull
    public final String getAudioPathForSoundPool() {
        if (this.isLocal) {
            return StringsKt.removePrefix((String)this.url, (CharSequence)"file://");
        }
        String string = this.loadTempFileFromNetwork().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTempFileFromNetwork().absolutePath");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File loadTempFileFromNetwork() {
        URL uRL = URI.create(this.url).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"create(url).toURL()");
        byte[] bytes = this.downloadUrl(uRL);
        File tempFile = File.createTempFile("sound", "");
        Closeable closeable = new FileOutputStream(tempFile);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            it.write(bytes);
            tempFile.deleteOnExit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] downloadUrl(URL url) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            byte[] chunk = new byte[4096];
            while (true) {
                Integer n = stream.read(chunk);
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = it > 0 ? n : null;
                if (n2 == null) {
                    break;
                }
                int bytesRead = n2;
                outputStream.write(chunk, 0, bytesRead);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    public final boolean component2() {
        return this.isLocal;
    }

    @NotNull
    public final UrlSource copy(@NotNull String url, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new UrlSource(url, isLocal);
    }

    public static /* synthetic */ UrlSource copy$default(UrlSource urlSource, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = urlSource.url;
        }
        if ((n & 2) != 0) {
            bl = urlSource.isLocal;
        }
        return urlSource.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "UrlSource(url=" + this.url + ", isLocal=" + this.isLocal + ')';
    }

    public int hashCode() {
        int result = this.url.hashCode();
        int n = this.isLocal ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UrlSource)) {
            return false;
        }
        UrlSource urlSource = (UrlSource)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)urlSource.url)) {
            return false;
        }
        return this.isLocal == urlSource.isLocal;
    }
}

