/*
 * Decompiled with CFR 0.152.
 */
package io.endigo.plugins.pdfviewflutter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.link.LinkHandler;
import com.github.barteksc.pdfviewer.model.LinkTapEvent;
import io.flutter.plugin.common.MethodChannel;

public class PDFLinkHandler
implements LinkHandler {
    PDFView pdfView;
    Context context;
    MethodChannel methodChannel;
    boolean preventLinkNavigation;

    public PDFLinkHandler(Context context, PDFView pdfView, MethodChannel methodChannel, boolean preventLinkNavigation) {
        this.context = context;
        this.pdfView = pdfView;
        this.methodChannel = methodChannel;
        this.preventLinkNavigation = preventLinkNavigation;
    }

    public void handleLinkEvent(LinkTapEvent event) {
        String uri = event.getLink().getUri();
        Integer page = event.getLink().getDestPageIdx();
        if (uri != null && !uri.isEmpty()) {
            this.handleUri(uri);
        } else if (page != null) {
            this.handlePage(page);
        }
    }

    private void handleUri(String uri) {
        if (!this.preventLinkNavigation) {
            Uri parsedUri = Uri.parse((String)uri);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(parsedUri);
            intent.addFlags(0x10000000);
            intent.addFlags(32768);
            if (intent.resolveActivity(this.context.getPackageManager()) != null) {
                this.context.startActivity(intent, null);
            }
        }
        this.onLinkHandler(uri);
    }

    private void handlePage(int page) {
        this.pdfView.jumpTo(page);
    }

    private void onLinkHandler(String uri) {
        this.methodChannel.invokeMethod("onLinkHandler", (Object)uri);
    }

    public void setPreventLinkNavigation(boolean value) {
        this.preventLinkNavigation = value;
    }
}

