/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geocoding;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.baseflow.geocoding.GeocodeListenerAdapter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

class Geocoding {
    private final Context androidContext;
    @Nullable
    private Locale locale;

    Geocoding(Context androidContext) {
        this.androidContext = androidContext;
    }

    void setLocaleIdentifier(@Nullable Locale locale) {
        this.locale = locale;
    }

    boolean isPresent() {
        return Geocoder.isPresent();
    }

    void placemarkFromAddress(String address, GeocodeListenerAdapter callback) {
        Geocoder geocoder = Geocoding.createGeocoder(this.androidContext, this.locale);
        if (Build.VERSION.SDK_INT >= 33) {
            this.getAddressesWithGeocodeListener(geocoder, address, 5, callback);
        } else {
            try {
                List<Address> addresses = this.deprecatedGetFromLocationName(geocoder, address);
                callback.onGeocode(addresses);
            }
            catch (IOException ex) {
                callback.onError(ex.getMessage());
            }
        }
    }

    private List<Address> deprecatedGetFromLocationName(Geocoder geocoder, String address) throws IOException {
        return geocoder.getFromLocationName(address, 5);
    }

    @RequiresApi(api=33)
    private void getAddressesWithGeocodeListener(Geocoder geocoder, String address, int maxResults, final GeocodeListenerAdapter callback) {
        geocoder.getFromLocationName(address, maxResults, new Geocoder.GeocodeListener(){

            public void onGeocode(List<Address> geocodedAddresses) {
                callback.onGeocode(geocodedAddresses);
            }

            public void onError(@Nullable String errorMessage) {
                callback.onError(errorMessage);
            }
        });
    }

    void placemarkFromCoordinates(double latitude, double longitude, GeocodeListenerAdapter callback) {
        Geocoder geocoder = Geocoding.createGeocoder(this.androidContext, this.locale);
        if (Build.VERSION.SDK_INT >= 33) {
            this.getLocationWithGeocodeListener(geocoder, latitude, longitude, 5, callback);
        } else {
            try {
                List<Address> addresses = this.deprecatedGetFromLocation(geocoder, latitude, longitude);
                callback.onGeocode(addresses);
            }
            catch (IOException ex) {
                callback.onError(ex.getMessage());
            }
        }
    }

    private List<Address> deprecatedGetFromLocation(Geocoder geocoder, double latitude, double longitude) throws IOException {
        return geocoder.getFromLocation(latitude, longitude, 5);
    }

    @RequiresApi(api=33)
    private void getLocationWithGeocodeListener(Geocoder geocoder, double latitude, double longitude, int maxResults, final GeocodeListenerAdapter callback) {
        geocoder.getFromLocation(latitude, longitude, maxResults, new Geocoder.GeocodeListener(){

            public void onGeocode(List<Address> geocodedAddresses) {
                callback.onGeocode(geocodedAddresses);
            }

            public void onError(@Nullable String errorMessage) {
                callback.onError(errorMessage);
            }
        });
    }

    private static Geocoder createGeocoder(Context androidContext, @Nullable Locale locale) {
        return locale != null ? new Geocoder(androidContext, locale) : new Geocoder(androidContext);
    }
}

