/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baseflow.geolocator.GeolocatorLocationService;
import com.baseflow.geolocator.LocationServiceHandlerImpl;
import com.baseflow.geolocator.MethodCallHandlerImpl;
import com.baseflow.geolocator.StreamHandlerImpl;
import com.baseflow.geolocator.location.GeolocationManager;
import com.baseflow.geolocator.location.LocationAccuracyManager;
import com.baseflow.geolocator.permission.PermissionManager;
import io.flutter.Log;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.PluginRegistry;

public class GeolocatorPlugin
implements FlutterPlugin,
ActivityAware {
    private static final String TAG = "FlutterGeolocator";
    private final PermissionManager permissionManager;
    private final GeolocationManager geolocationManager;
    private final LocationAccuracyManager locationAccuracyManager;
    @Nullable
    private GeolocatorLocationService foregroundLocationService;
    @Nullable
    private MethodCallHandlerImpl methodCallHandler;
    @Nullable
    private StreamHandlerImpl streamHandler;
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d((String)GeolocatorPlugin.TAG, (String)"Geolocator foreground service connected");
            if (service instanceof GeolocatorLocationService.LocalBinder) {
                GeolocatorPlugin.this.initialize(((GeolocatorLocationService.LocalBinder)service).getLocationService());
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)GeolocatorPlugin.TAG, (String)"Geolocator foreground service disconnected");
            if (GeolocatorPlugin.this.foregroundLocationService != null) {
                GeolocatorPlugin.this.foregroundLocationService.setActivity(null);
                GeolocatorPlugin.this.foregroundLocationService = null;
            }
        }
    };
    @Nullable
    private LocationServiceHandlerImpl locationServiceHandler;
    @Nullable
    private ActivityPluginBinding pluginBinding;

    public GeolocatorPlugin() {
        this.permissionManager = PermissionManager.getInstance();
        this.geolocationManager = GeolocationManager.getInstance();
        this.locationAccuracyManager = LocationAccuracyManager.getInstance();
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding flutterPluginBinding) {
        this.methodCallHandler = new MethodCallHandlerImpl(this.permissionManager, this.geolocationManager, this.locationAccuracyManager);
        this.methodCallHandler.startListening(flutterPluginBinding.getApplicationContext(), flutterPluginBinding.getBinaryMessenger());
        this.streamHandler = new StreamHandlerImpl(this.permissionManager, this.geolocationManager);
        this.streamHandler.startListening(flutterPluginBinding.getApplicationContext(), flutterPluginBinding.getBinaryMessenger());
        this.locationServiceHandler = new LocationServiceHandlerImpl();
        this.locationServiceHandler.setContext(flutterPluginBinding.getApplicationContext());
        this.locationServiceHandler.startListening(flutterPluginBinding.getApplicationContext(), flutterPluginBinding.getBinaryMessenger());
        this.bindForegroundService(flutterPluginBinding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.unbindForegroundService(binding.getApplicationContext());
        this.dispose();
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        Log.d((String)TAG, (String)"Attaching Geolocator to activity");
        this.pluginBinding = binding;
        this.registerListeners();
        if (this.methodCallHandler != null) {
            this.methodCallHandler.setActivity(binding.getActivity());
        }
        if (this.streamHandler != null) {
            this.streamHandler.setActivity(binding.getActivity());
        }
        if (this.foregroundLocationService != null) {
            this.foregroundLocationService.setActivity(this.pluginBinding.getActivity());
        }
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }

    public void onDetachedFromActivity() {
        Log.d((String)TAG, (String)"Detaching Geolocator from activity");
        this.deregisterListeners();
        if (this.methodCallHandler != null) {
            this.methodCallHandler.setActivity(null);
        }
        if (this.streamHandler != null) {
            this.streamHandler.setActivity(null);
        }
        if (this.foregroundLocationService != null) {
            this.foregroundLocationService.setActivity(null);
        }
        if (this.pluginBinding != null) {
            this.pluginBinding = null;
        }
    }

    private void registerListeners() {
        if (this.pluginBinding != null) {
            this.pluginBinding.addActivityResultListener((PluginRegistry.ActivityResultListener)this.geolocationManager);
            this.pluginBinding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this.permissionManager);
        }
    }

    private void deregisterListeners() {
        if (this.pluginBinding != null) {
            this.pluginBinding.removeActivityResultListener((PluginRegistry.ActivityResultListener)this.geolocationManager);
            this.pluginBinding.removeRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this.permissionManager);
        }
    }

    private void bindForegroundService(Context context) {
        context.bindService(new Intent(context, GeolocatorLocationService.class), this.serviceConnection, 1);
    }

    private void unbindForegroundService(Context context) {
        if (this.foregroundLocationService != null) {
            this.foregroundLocationService.flutterEngineDisconnected();
        }
        context.unbindService(this.serviceConnection);
    }

    private void initialize(GeolocatorLocationService service) {
        Log.d((String)TAG, (String)"Initializing Geolocator services");
        this.foregroundLocationService = service;
        this.foregroundLocationService.setGeolocationManager(this.geolocationManager);
        this.foregroundLocationService.flutterEngineConnected();
        if (this.streamHandler != null) {
            this.streamHandler.setForegroundLocationService(service);
        }
    }

    private void dispose() {
        Log.d((String)TAG, (String)"Disposing Geolocator services");
        if (this.methodCallHandler != null) {
            this.methodCallHandler.stopListening();
            this.methodCallHandler.setActivity(null);
            this.methodCallHandler = null;
        }
        if (this.streamHandler != null) {
            this.streamHandler.stopListening();
            this.streamHandler.setForegroundLocationService(null);
            this.streamHandler = null;
        }
        if (this.locationServiceHandler != null) {
            this.locationServiceHandler.setContext(null);
            this.locationServiceHandler.stopListening();
            this.locationServiceHandler = null;
        }
        if (this.foregroundLocationService != null) {
            this.foregroundLocationService.setActivity(null);
        }
    }
}

